/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.CompareUtils;

public class OOXMLCache {
    private Map<SQLRowAccessor, Map<SQLTable, List<SQLRowAccessor>>> cacheReferent = new HashMap<SQLRowAccessor, Map<SQLTable, List<SQLRowAccessor>>>();
    private Map<String, Map<Integer, SQLRowAccessor>> cacheForeign = new HashMap<String, Map<Integer, SQLRowAccessor>>();

    protected SQLRowAccessor getForeignRow(SQLRowAccessor row, SQLField field) {
        Map<Integer, SQLRowAccessor> c = this.cacheForeign.get(field.getName());
        if (row.getObject(field.getName()) == null) {
            return null;
        }
        int i = row.getInt(field.getName());
        if (c != null && c.get(i) != null) {
            return c.get(i);
        }
        SQLRowAccessor foreign = row.getForeign(field.getName());
        if (c == null) {
            HashMap<Integer, SQLRowAccessor> map = new HashMap<Integer, SQLRowAccessor>();
            map.put(i, foreign);
            this.cacheForeign.put(field.getName(), map);
        } else {
            c.put(i, foreign);
        }
        return foreign;
    }

    protected List<? extends SQLRowAccessor> getReferentRows(List<? extends SQLRowAccessor> row, SQLTable tableForeign) {
        return this.getReferentRows(row, tableForeign, null, null);
    }

    /*
     * WARNING - void declaration
     */
    protected List<? extends SQLRowAccessor> getReferentRows(List<? extends SQLRowAccessor> row, SQLTable tableForeign, String groupBy, final String orderBy) {
        ArrayList<SQLRowAccessor> list;
        Map<SQLTable, List<SQLRowAccessor>> c = this.cacheReferent.get(row.get(0));
        if (c != null && c.get(tableForeign) != null) {
            System.err.println("get referent rows From Cache ");
            return c.get(tableForeign);
        }
        if (row.isEmpty() || row.size() > 0 && row.get(0).isUndefined()) {
            list = new ArrayList<SQLRowAccessor>();
        } else if (row.size() > 0 && (groupBy == null || groupBy.trim().length() == 0)) {
            list = new ArrayList();
            SQLSelect sel = new SQLSelect();
            sel.addSelectStar(tableForeign);
            Where w = null;
            for (SQLRowAccessor sQLRowAccessor : row) {
                if (sQLRowAccessor == null || sQLRowAccessor.isUndefined()) continue;
                w = w == null ? new Where((FieldRef)((SQLField)tableForeign.getForeignKeys(sQLRowAccessor.getTable()).toArray()[0]), "=", sQLRowAccessor.getID()) : w.or(new Where((FieldRef)((SQLField)tableForeign.getForeignKeys(sQLRowAccessor.getTable()).toArray()[0]), "=", sQLRowAccessor.getID()));
            }
            sel.setWhere(w);
            this.addSelectOrder(tableForeign, orderBy, sel);
            System.err.println(sel.asString());
            list.addAll(SQLRowListRSH.execute(sel));
        } else {
            void var9_17;
            void var9_15;
            List<String> params = SQLRow.toList(groupBy);
            SQLSelect sel = new SQLSelect();
            sel.addSelect(tableForeign.getKey());
            boolean bl = false;
            while (var9_15 < params.size()) {
                sel.addSelect(tableForeign.getField(params.get((int)var9_15)));
                ++var9_15;
            }
            Object var9_16 = null;
            for (SQLRowAccessor sQLRowAccessor : row) {
                if (var9_17 == null) {
                    Where where = new Where((FieldRef)((SQLField)tableForeign.getForeignKeys(sQLRowAccessor.getTable()).toArray()[0]), "=", sQLRowAccessor.getID());
                    continue;
                }
                Where where = var9_17.or(new Where((FieldRef)((SQLField)tableForeign.getForeignKeys(sQLRowAccessor.getTable()).toArray()[0]), "=", sQLRowAccessor.getID()));
            }
            sel.setWhere((Where)var9_17);
            this.addSelectOrder(tableForeign, orderBy, sel);
            System.err.println(sel.asString());
            List<SQLRow> list2 = SQLRowListRSH.execute(sel);
            list = new ArrayList();
            HashMap<Integer, SQLRowValues> m = new HashMap<Integer, SQLRowValues>();
            for (SQLRow sqlRow : list2) {
                SQLRowValues rowVals;
                Integer object = sqlRow.getInt(params.get(0));
                if (m.get(object) == null || object == 1) {
                    rowVals = sqlRow.asRowValues();
                    m.put(object, rowVals);
                    list.add(rowVals);
                    continue;
                }
                rowVals = (SQLRowValues)m.get(object);
                this.cumulRows(params, sqlRow, rowVals);
            }
        }
        if (c == null) {
            HashMap<SQLTable, ArrayList<SQLRowAccessor>> map = new HashMap<SQLTable, ArrayList<SQLRowAccessor>>();
            map.put(tableForeign, list);
            this.cacheReferent.put(row.get(0), map);
        } else {
            c.put(tableForeign, list);
        }
        if (orderBy != null && orderBy.trim().length() > 0 && !orderBy.contains(".")) {
            Collections.sort(list, new Comparator<SQLRowAccessor>(){

                @Override
                public int compare(SQLRowAccessor o1, SQLRowAccessor o2) {
                    return CompareUtils.compare(o1.getObject(orderBy), o2.getObject(orderBy));
                }
            });
        }
        return list;
    }

    private void addSelectOrder(SQLTable tableForeign, String orderBy, SQLSelect sel) {
        if (orderBy != null && orderBy.contains(".")) {
            String fieldRefTable = orderBy.substring(0, orderBy.indexOf(46));
            String field = orderBy.substring(orderBy.indexOf(46) + 1, orderBy.length());
            sel.addJoin("LEFT", sel.getAlias(tableForeign).getField(fieldRefTable));
            sel.addFieldOrder(sel.getAlias(tableForeign.getForeignTable(fieldRefTable)).getField(field));
        } else {
            sel.addFieldOrder(tableForeign.getOrderField());
        }
    }

    private void cumulRows(List<String> params, SQLRow sqlRow, SQLRowValues rowVals) {
        int i = 1;
        while (i < params.size()) {
            if (rowVals.getTable().getField(params.get(i)).getType().getJavaType() == String.class) {
                String string = sqlRow.getString(params.get(i));
                if (params.get(i).equalsIgnoreCase("NOM")) {
                    string = String.valueOf(sqlRow.getInt("QTE")) + " x " + string;
                }
                rowVals.put(params.get(i), String.valueOf(rowVals.getString(params.get(i))) + ", " + string);
            } else if (!rowVals.getTable().getField(params.get(i)).isKey()) {
                Long n = rowVals.getLong(params.get(i));
                rowVals.put(params.get(i), n + sqlRow.getLong(params.get(i)));
            }
            ++i;
        }
    }

    public Map<SQLRowAccessor, Map<SQLTable, List<SQLRowAccessor>>> getCacheReferent() {
        return this.cacheReferent;
    }

    public void clearCache() {
        this.cacheReferent.clear();
        this.cacheForeign.clear();
    }
}

