/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.supplier.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;

public class EcheanceFournisseurSQLElement
extends ComptaSQLConfElement {
    public EcheanceFournisseurSQLElement() {
        super("ECHEANCE_FOURNISSEUR", "une \u00e9ch\u00e9ance fournisseur", "\u00e9ch\u00e9ances fournisseurs");
        RowAction.PredicateRowAction actionShowSource = new RowAction.PredicateRowAction(new AbstractAction("Voir la source"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow row = IListe.get(e).fetchSelectedRow();
                MouvementSQLElement.showSource(row.getInt("ID_MOUVEMENT"));
            }
        }, false);
        actionShowSource.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.getRowActions().add(actionShowSource);
        if (UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.MENU)) {
            RowAction actionCancel = new RowAction(new AbstractAction("Annuler la r\u00e9gularisation en comptabilit\u00e9"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer = JOptionPane.showConfirmDialog(null, "Etes vous s\u00fbr de vouloir annuler la r\u00e9gularisation ?");
                    if (answer == 0) {
                        SQLRow row = IListe.get(e).getSelectedRow().asRow();
                        SQLRowValues rowVals = row.createEmptyUpdateRow();
                        rowVals.put("REG_COMPTA", Boolean.FALSE);
                        try {
                            rowVals.commit();
                        }
                        catch (SQLException e1) {
                            ExceptionHandler.handle("Une erreur est survenue lors de l'annulation de la r\u00e9gularisation.", e1);
                        }
                    }
                }
            }, false){

                @Override
                public boolean enabledFor(List<SQLRowValues> selection) {
                    if (selection != null && selection.size() == 1) {
                        SQLRowAccessor row = selection.get(0);
                        return row.getBoolean("REG_COMPTA");
                    }
                    return true;
                }
            };
            this.getRowActions().add(actionCancel);
            RowAction actionRegul = new RowAction(new AbstractAction("R\u00e9gularisation en comptabilit\u00e9"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer;
                    SQLRow row = IListe.get(e).fetchSelectedRow();
                    String price = GestionDevise.currencyToString(row.getLong("MONTANT"));
                    SQLRow rowFournisseur = row.getForeignRow("ID_FOURNISSEUR");
                    String nomFour = rowFournisseur.getString("NOM");
                    String piece = "";
                    SQLRow rowMvt = row.getForeignRow("ID_MOUVEMENT");
                    if (rowMvt != null) {
                        SQLRow rowPiece = rowMvt.getForeignRow("ID_PIECE");
                        piece = rowPiece.getString("NOM");
                    }
                    if ((answer = JOptionPane.showConfirmDialog(null, "Etes vous s\u00fbr de vouloir r\u00e9gulariser l'\u00e9ch\u00e9ance de " + nomFour + " d'un montant de " + price + "\u20ac avec une saisie au kilometre?\nNom de la pi\u00e9ce : " + piece + ".")) == 0) {
                        SQLRowValues rowVals = row.createEmptyUpdateRow();
                        rowVals.put("REG_COMPTA", Boolean.TRUE);
                        try {
                            rowVals.commit();
                        }
                        catch (SQLException e1) {
                            ExceptionHandler.handle("Une erreur est survenue lors de la r\u00e9gularisation.", e1);
                        }
                    }
                }
            }, false){

                @Override
                public boolean enabledFor(List<SQLRowValues> selection) {
                    if (selection != null && selection.size() == 1) {
                        SQLRowAccessor row = selection.get(0);
                        return row.getBoolean("REG_COMPTA") == false;
                    }
                    return true;
                }
            };
            this.getRowActions().add(actionRegul);
        }
    }

    @Override
    public synchronized ListSQLRequest createListRequest() {
        return new ListSQLRequest(this.getTable(), this.getListFields()){

            @Override
            protected void customizeToFetch(SQLRowValues graphToFetch) {
                super.customizeToFetch(graphToFetch);
                graphToFetch.put("REG_COMPTA", null);
                graphToFetch.put("REGLE", null);
            }
        };
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("MONTANT");
        l.add("DATE");
        l.add("ID_MOUVEMENT");
        l.add("ID_FOURNISSEUR");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("ID_FOURNISSEUR");
        l.add("MONTANT");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private DeviseField montant;
            private JDate date;
            private JTextField idMouvement;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.montant = new DeviseField();
                this.date = new JDate();
                this.idMouvement = new JTextField();
                ElementComboBox fournisseur = new ElementComboBox();
                JLabel labelMouvement = new JLabel("Mouvement");
                this.add((Component)labelMouvement, c);
                c.weightx = 1.0;
                ++c.gridx;
                this.add((Component)this.idMouvement, c);
                JLabel labelDate = new JLabel("Date");
                ++c.gridx;
                this.add((Component)labelDate, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.date, c);
                JLabel labelFournisseur = new JLabel("Fournisseur");
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelFournisseur, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 0;
                this.add((Component)fournisseur, c);
                c.gridwidth = 1;
                JLabel labelMontant = new JLabel("Montant");
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelMontant, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.montant, c);
                this.addSQLObject(this.montant, "MONTANT");
                this.addSQLObject(this.date, "DATE");
                this.addRequiredSQLObject(fournisseur, "ID_FOURNISSEUR");
                this.addSQLObject(this.idMouvement, "ID_MOUVEMENT");
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".commitment";
    }
}

