/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.awt.GraphicsEnvironment;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.erp.core.sales.product.model.ProductHelper;
import org.openconcerto.erp.core.supplychain.stock.element.ComposedItemStockUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockItem;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.cc.ITransformer;

public class StockItemsUpdater {
    private final StockLabel label;
    private final List<? extends SQLRowAccessor> items;
    private final TypeStockUpdate type;
    private final boolean createMouvementStock;
    private final SQLRowAccessor rowSource;
    private boolean headless = false;
    List<String> requests = new ArrayList<String>();

    public StockItemsUpdater(StockLabel label, SQLRowAccessor rowSource, List<? extends SQLRowAccessor> items, TypeStockUpdate t) {
        this(label, rowSource, items, t, true);
    }

    public StockItemsUpdater(StockLabel label, SQLRowAccessor rowSource, List<? extends SQLRowAccessor> items, TypeStockUpdate t, boolean createMouvementStock) {
        this.label = label;
        this.items = items;
        this.type = t;
        this.createMouvementStock = createMouvementStock;
        this.rowSource = rowSource;
        this.headless = GraphicsEnvironment.isHeadless();
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public void update() throws SQLException {
        SQLTable stockTable = this.rowSource.getTable().getTable("STOCK");
        if (this.createMouvementStock) {
            this.clearExistingMvt(this.rowSource);
        }
        List<StockItem> stockItems = this.fetch();
        ListMap<SQLRow, SQLRowValues> cmd = new ListMap<SQLRow, SQLRowValues>();
        for (StockItem stockItem : stockItems) {
            if (stockItem.isStockInit()) {
                this.requests.add(stockItem.getUpdateRequest());
            } else {
                SQLRowValues rowVals = new SQLRowValues(stockTable);
                rowVals.put("QTE_REEL", stockItem.getRealQty());
                rowVals.put("QTE_TH", stockItem.getVirtualQty());
                rowVals.put("QTE_LIV_ATTENTE", stockItem.getDeliverQty());
                rowVals.put("QTE_RECEPT_ATTENTE", stockItem.getReceiptQty());
                SQLRowValues rowValsArt = stockItem.getArticle().createEmptyUpdateRow();
                rowValsArt.put("ID_STOCK", (Object)rowVals);
                rowValsArt.commit();
            }
            stockItem.fillCommandeFournisseur(cmd);
        }
        ArrayList<Object> handlers = new ArrayList<Object>(this.requests.size());
        for (String s : this.requests) {
            handlers.add(null);
        }
        SQLUtils.executeMultiple(stockTable.getDBSystemRoot(), this.requests, handlers);
        DBRoot root = this.rowSource.getTable().getDBRoot();
        if (root.contains("ARTICLE_ELEMENT")) {
            ComposedItemStockUpdater comp = new ComposedItemStockUpdater(root, stockItems);
            comp.update();
        }
        if (!this.headless && cmd.size() > 0) {
            String msg = "Les articles suivants sont inf\u00e9rieurs au stock minimum : \n";
            for (SQLRow row : cmd.keySet()) {
                for (SQLRowValues rowVals : (List)cmd.get(row)) {
                    msg = String.valueOf(msg) + rowVals.getString("CODE") + " " + rowVals.getString("NOM") + "\n";
                }
            }
            final String msgFinal = msg;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, msgFinal, "Alerte de stock minimum", 2);
                }
            });
        }
    }

    private void clearExistingMvt(SQLRowAccessor rowSource) throws RTInterruptedException, SQLException {
        ArrayList<String> multipleRequests = new ArrayList<String>();
        final SQLTable table = this.rowSource.getTable().getTable("MOUVEMENT_STOCK");
        SQLRowValues rowVals = new SQLRowValues(table);
        rowVals.put("QTE", null);
        rowVals.put("REEL", null);
        SQLRowValues rowValsArt = new SQLRowValues(this.rowSource.getTable().getTable("ARTICLE"));
        SQLRowValues rowValsStock = new SQLRowValues(this.rowSource.getTable().getTable("STOCK"));
        rowValsStock.put("QTE_REEL", null);
        rowValsStock.put("QTE_TH", null);
        rowValsStock.put("QTE_RECEPT_ATTENTE", null);
        rowValsStock.put("QTE_LIV_ATTENTE", null);
        rowValsArt.put("ID_STOCK", (Object)rowValsStock);
        rowVals.put("ID_ARTICLE", (Object)rowValsArt);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where((FieldRef)table.getField("SOURCE"), "=", (Object)StockItemsUpdater.this.rowSource.getTable().getName());
                w = w.and(new Where((FieldRef)table.getField("IDSOURCE"), "=", StockItemsUpdater.this.rowSource.getID()));
                input.setWhere(w);
                return input;
            }
        });
        List<SQLRowValues> result = fetcher.fetch();
        for (SQLRowValues sqlRowValues : result) {
            StockItem item = new StockItem(sqlRowValues.getForeign("ID_ARTICLE"));
            StockItem.TypeStockMouvement t = sqlRowValues.getBoolean("REEL") != false ? StockItem.TypeStockMouvement.REEL : StockItem.TypeStockMouvement.THEORIQUE;
            item.updateQty(sqlRowValues.getFloat("QTE"), t, true);
            String req = "UPDATE " + sqlRowValues.getTable().getSQLName().quote() + " SET \"ARCHIVE\"=1 WHERE \"ID\"=" + sqlRowValues.getID();
            multipleRequests.add(req);
            multipleRequests.add(item.getUpdateRequest());
        }
        ArrayList<Object> handlers = new ArrayList<Object>(multipleRequests.size());
        for (String s : multipleRequests) {
            handlers.add(null);
        }
        SQLUtils.executeMultiple(table.getDBSystemRoot(), multipleRequests, handlers);
    }

    private void fillProductComponent(List<ProductComponent> productComponents, int qte, int index, int level) {
        if (level > 0) {
            int i = index;
            while (i < this.items.size()) {
                SQLRowAccessor rNext;
                SQLRowAccessor r = this.items.get(i);
                if (r.getTable().contains("NIVEAU") && i + 1 < this.items.size() && (rNext = this.items.get(i + 1)).getInt("NIVEAU") > r.getInt("NIVEAU")) {
                    this.fillProductComponent(productComponents, qte * r.getInt("QTE"), i + 1, rNext.getInt("NIVEAU"));
                } else if (!(r.getTable().contains("NIVEAU") && r.getInt("NIVEAU") != level || r.isForeignEmpty("ID_ARTICLE"))) {
                    productComponents.add(ProductComponent.createFrom(r, qte));
                }
                ++i;
            }
        }
    }

    private List<StockItem> fetch() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<StockItem> stockItems = new ArrayList<StockItem>(this.items.size());
        String mvtStockTableQuoted = this.rowSource.getTable().getTable("MOUVEMENT_STOCK").getSQLName().quote();
        ArrayList<ProductComponent> productComponents = new ArrayList<ProductComponent>();
        this.fillProductComponent(productComponents, 1, 0, 1);
        ProductHelper helper = new ProductHelper(this.rowSource.getTable().getDBRoot());
        List<ProductComponent> boms = helper.getChildWithQtyFrom(productComponents);
        for (ProductComponent productComp : boms) {
            String mvtStockQuery;
            if (!productComp.getProduct().getBoolean("GESTION_STOCK").booleanValue()) continue;
            StockItem stockItem = new StockItem(productComp.getProduct());
            double qteFinal = productComp.getQty().doubleValue();
            if (!this.type.isEntry()) {
                qteFinal = -qteFinal;
            }
            stockItem.updateQty(qteFinal, this.type.getType());
            stockItems.add(stockItem);
            if (!this.createMouvementStock) continue;
            if (this.type.getType() == StockItem.TypeStockMouvement.REEL || this.type.getType() == StockItem.TypeStockMouvement.REEL_THEORIQUE) {
                mvtStockQuery = "INSERT INTO " + mvtStockTableQuoted + " (\"QTE\",\"DATE\",\"ID_ARTICLE\",\"SOURCE\",\"IDSOURCE\",\"NOM\",\"REEL\",\"ORDRE\") VALUES(" + qteFinal + ",'" + dateFormat.format(this.rowSource.getDate("DATE").getTime()) + "'," + productComp.getProduct().getID() + ",'" + this.rowSource.getTable().getName() + "'," + this.rowSource.getID() + ",'" + this.label.getLabel(this.rowSource, productComp.getProduct()) + "',true, (SELECT (MAX(\"ORDRE\")+1) FROM " + mvtStockTableQuoted + "))";
                this.requests.add(mvtStockQuery);
            }
            if (this.type.getType() != StockItem.TypeStockMouvement.THEORIQUE && this.type.getType() != StockItem.TypeStockMouvement.REEL_THEORIQUE) continue;
            mvtStockQuery = "INSERT INTO " + mvtStockTableQuoted + " (\"QTE\",\"DATE\",\"ID_ARTICLE\",\"SOURCE\",\"IDSOURCE\",\"NOM\",\"REEL\",\"ORDRE\") VALUES(" + qteFinal + ",'" + dateFormat.format(this.rowSource.getDate("DATE").getTime()) + "'," + productComp.getProduct().getID() + ",'" + this.rowSource.getTable().getName() + "'," + this.rowSource.getID() + ",'" + this.label.getLabel(this.rowSource, productComp.getProduct()) + "',false, (SELECT (MAX(\"ORDRE\")+1) FROM " + mvtStockTableQuoted + "))";
            this.requests.add(mvtStockQuery);
        }
        return stockItems;
    }

    public static enum TypeStockUpdate {
        VIRTUAL_RECEPT(true, StockItem.TypeStockMouvement.THEORIQUE),
        REAL_RECEPT(true, StockItem.TypeStockMouvement.REEL),
        VIRTUAL_DELIVER(false, StockItem.TypeStockMouvement.THEORIQUE),
        REAL_DELIVER(false, StockItem.TypeStockMouvement.REEL),
        REAL_VIRTUAL_RECEPT(true, StockItem.TypeStockMouvement.REEL_THEORIQUE),
        REAL_VIRTUAL_DELIVER(false, StockItem.TypeStockMouvement.REEL_THEORIQUE);

        private final boolean entry;
        private final StockItem.TypeStockMouvement type;

        private TypeStockUpdate(boolean entry, StockItem.TypeStockMouvement type) {
            this.entry = entry;
            this.type = type;
        }

        public boolean isEntry() {
            return this.entry;
        }

        public StockItem.TypeStockMouvement getType() {
            return this.type;
        }
    }
}

