/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.supplychain.order.component.CommandeSQLComponent;
import org.openconcerto.erp.core.supplychain.supplier.component.MouvementStockSQLComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;

public class MouvementStockSQLElement
extends ComptaSQLConfElement {
    private final SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");

    public MouvementStockSQLElement() {
        super("MOUVEMENT_STOCK", "un mouvement de stock", "mouvements de stock");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("NOM");
        l.add("ID_ARTICLE");
        l.add("QTE");
        l.add("REEL");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("QTE");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new MouvementStockSQLComponent(this);
    }

    @Override
    protected void archive(SQLRow row, boolean cutLinks) throws SQLException {
        super.archive(row, cutLinks);
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        super.archive(trees, cutLinks);
        this.updateStock(trees.getRows(), true);
    }

    public ListMap<SQLRow, SQLRowValues> updateStock(Collection<SQLRow> rowsMvt, boolean archive) {
        ListMap<SQLRow, SQLRowValues> map = new ListMap<SQLRow, SQLRowValues>();
        SQLTable tableCmdElt = Configuration.getInstance().getBase().getTable("COMMANDE_ELEMENT");
        for (SQLRow rowMvtStock : rowsMvt) {
            int idArticle;
            SQLRow row;
            float qteNvlle;
            float qteNvlleEnAttenteExp;
            float qteNvlleEnAttenteRecept;
            SQLRowValues rowVals;
            float qteMvt;
            float qte;
            SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
            SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(sqlTableArticle);
            SQLElement eltStock = Configuration.getInstance().getDirectory().getElement("STOCK");
            SQLRow rowArticle = rowMvtStock.getForeignRow("ID_ARTICLE");
            SQLRow rowStock = rowArticle.getForeignRow("ID_STOCK");
            if (rowMvtStock.getBoolean("REEL").booleanValue()) {
                qte = rowStock.getFloat("QTE_REEL");
                qteMvt = rowMvtStock.getFloat("QTE");
                rowVals = new SQLRowValues(eltStock.getTable());
                qteNvlleEnAttenteRecept = rowStock.getFloat("QTE_RECEPT_ATTENTE");
                qteNvlleEnAttenteExp = rowStock.getFloat("QTE_LIV_ATTENTE");
                if (archive) {
                    qteNvlle = qte - qteMvt;
                    if (qteMvt > 0.0f) {
                        qteNvlleEnAttenteRecept += qteMvt;
                    } else {
                        qteNvlleEnAttenteExp -= qteMvt;
                    }
                } else {
                    qteNvlle = qte + qteMvt;
                    if (qteMvt > 0.0f) {
                        qteNvlleEnAttenteRecept -= qteMvt;
                    } else {
                        qteNvlleEnAttenteExp += qteMvt;
                    }
                }
                rowVals.put("QTE_REEL", Float.valueOf(qteNvlle));
                rowVals.put("QTE_RECEPT_ATTENTE", Float.valueOf(qteNvlleEnAttenteRecept));
                rowVals.put("QTE_LIV_ATTENTE", Float.valueOf(qteNvlleEnAttenteExp));
                try {
                    if (rowStock.getID() <= 1) {
                        row = rowVals.insert();
                        SQLRowValues rowValsArt = new SQLRowValues(eltArticle.getTable());
                        rowValsArt.put("ID_STOCK", row.getID());
                        idArticle = rowArticle.getID();
                        if (idArticle > 1) {
                            rowValsArt.update(idArticle);
                        }
                    } else {
                        rowVals.update(rowStock.getID());
                    }
                }
                catch (SQLException e) {
                    ExceptionHandler.handle("Erreur lors de la mise \u00e0 jour du stock pour l'article " + rowArticle.getString("CODE"));
                }
                SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
                boolean gestionStockMin = prefs.getBoolean("ArticleStockMin", true);
                if (archive || !rowArticle.getTable().getFieldsName().contains("QTE_MIN") || !gestionStockMin || rowArticle.getObject("QTE_MIN") == null || !(qteNvlle < (float)rowArticle.getInt("QTE_MIN"))) continue;
                SQLInjector inj = SQLInjector.getInjector(rowArticle.getTable(), tableCmdElt);
                SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticle));
                rowValsElt.put("ID_STYLE", 2);
                SQLRow unite = rowArticle.getForeign("ID_UNITE_VENTE");
                float qteElt = (float)rowArticle.getInt("QTE_MIN") - qteNvlle;
                if (unite.isUndefined() || unite.getBoolean("A_LA_PIECE").booleanValue()) {
                    rowValsElt.put("QTE", Math.round(qteElt));
                    rowValsElt.put("QTE_UNITAIRE", BigDecimal.ONE);
                } else {
                    rowValsElt.put("QTE", 1);
                    rowValsElt.put("QTE_UNITAIRE", new BigDecimal(qteElt));
                }
                rowValsElt.put("ID_TAXE", rowValsElt.getObject("ID_TAXE"));
                rowValsElt.put("T_POIDS", Float.valueOf((float)rowValsElt.getLong("POIDS") * qteElt));
                rowValsElt.put("T_PA_HT", Float.valueOf((float)rowValsElt.getLong("PA_HT") * qteElt));
                rowValsElt.put("T_PA_TTC", (double)rowValsElt.getLong("T_PA_HT") * ((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0));
                map.add(rowArticle.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
                continue;
            }
            qte = rowStock.getFloat("QTE_TH");
            qteMvt = rowMvtStock.getFloat("QTE");
            rowVals = new SQLRowValues(eltStock.getTable());
            qteNvlleEnAttenteRecept = rowStock.getFloat("QTE_RECEPT_ATTENTE");
            qteNvlleEnAttenteExp = rowStock.getFloat("QTE_LIV_ATTENTE");
            if (archive) {
                qteNvlle = qte - qteMvt;
                if (qteMvt > 0.0f) {
                    qteNvlleEnAttenteRecept -= qteMvt;
                } else {
                    qteNvlleEnAttenteExp += qteMvt;
                }
            } else {
                qteNvlle = qte + qteMvt;
                if (qteMvt > 0.0f) {
                    qteNvlleEnAttenteRecept += qteMvt;
                } else {
                    qteNvlleEnAttenteExp -= qteMvt;
                }
            }
            rowVals.put("QTE_TH", Float.valueOf(qteNvlle));
            rowVals.put("QTE_RECEPT_ATTENTE", Float.valueOf(qteNvlleEnAttenteRecept));
            rowVals.put("QTE_LIV_ATTENTE", Float.valueOf(qteNvlleEnAttenteExp));
            try {
                if (rowStock.getID() <= 1) {
                    row = rowVals.insert();
                    SQLRowValues rowValsArt = new SQLRowValues(eltArticle.getTable());
                    rowValsArt.put("ID_STOCK", row.getID());
                    idArticle = rowArticle.getID();
                    if (idArticle <= 1) continue;
                    rowValsArt.update(idArticle);
                    continue;
                }
                rowVals.update(rowStock.getID());
            }
            catch (SQLException e) {
                ExceptionHandler.handle("Erreur lors de la mise \u00e0 jour du stock pour l'article " + rowArticle.getString("CODE"));
            }
        }
        return map;
    }

    public static void createCommandeF(ListMap<SQLRow, SQLRowValues> col, SQLRow rowDevise) {
        MouvementStockSQLElement.createCommandeF(col, rowDevise, "");
    }

    public static void createCommandeF(ListMap<SQLRow, SQLRowValues> col, final SQLRow rowDevise, final String ref) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be called outside of EDT");
        }
        if (col.size() > 0) {
            final SQLElement commande = Configuration.getInstance().getDirectory().getElement("COMMANDE");
            for (final Map.Entry e : col.entrySet()) {
                final SQLRow fournisseur = (SQLRow)e.getKey();
                SQLSelect sel = new SQLSelect();
                sel.addSelectStar(commande.getTable());
                Where w = new Where((FieldRef)commande.getTable().getField("EN_COURS"), "=", (Object)Boolean.TRUE);
                w = w.and(new Where((FieldRef)commande.getTable().getField("ID_FOURNISSEUR"), "=", fournisseur.getID()));
                sel.setWhere(w);
                final List rowsCmd = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommandeSQLComponent cmp;
                        EditFrame frame;
                        SQLRow commandeExistante = null;
                        if (rowsCmd != null && rowsCmd.size() > 0) {
                            commandeExistante = (SQLRow)rowsCmd.get(0);
                        }
                        if (commandeExistante != null) {
                            frame = new EditFrame(commande, EditPanel.EditMode.MODIFICATION);
                            cmp = (CommandeSQLComponent)frame.getSQLComponent();
                            cmp.select(commandeExistante);
                        } else {
                            frame = new EditFrame(commande);
                            cmp = (CommandeSQLComponent)frame.getSQLComponent();
                            SQLRowValues rowVals = new SQLRowValues(commande.getTable());
                            SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
                            int idUser = UserManager.getInstance().getCurrentUser().getId();
                            SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
                            if (rowsComm != null) {
                                rowVals.put("ID_COMMERCIAL", rowsComm.getID());
                            }
                            rowVals.put("ID_FOURNISSEUR", fournisseur.getID());
                            if (rowDevise != null) {
                                rowVals.put("ID_DEVISE", rowDevise.getID());
                            }
                            if (commande.getTable().contains("ID_ADRESSE")) {
                                rowVals.put("ID_ADRESSE", null);
                            }
                            rowVals.put("NOM", ref);
                            cmp.select(rowVals);
                            cmp.getRowValuesTable().getRowValuesTableModel().clearRows();
                        }
                        RowValuesTableModel model = cmp.getRowValuesTable().getRowValuesTableModel();
                        for (SQLRowValues rowValsElt : (List)e.getValue()) {
                            SQLRowAccessor rowValsMatch = null;
                            int index = 0;
                            int i = 0;
                            while (i < model.getRowCount()) {
                                SQLRowValues rowValsCmdElt = model.getRowValuesAt(i);
                                if (ReferenceArticleSQLElement.isReferenceEquals(rowValsCmdElt, rowValsElt)) {
                                    rowValsMatch = rowValsCmdElt;
                                    index = i;
                                    break;
                                }
                                ++i;
                            }
                            if (rowValsMatch != null) {
                                int qte = rowValsMatch.getInt("QTE");
                                model.putValue(qte + rowValsElt.getInt("QTE"), index, "QTE");
                                continue;
                            }
                            model.addRow(rowValsElt);
                        }
                        frame.pack();
                        FrameUtil.show(frame);
                    }
                });
            }
        }
    }

    public static final void showSource(final int id) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be called from EDT");
        }
        if (id != 1) {
            SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
            final SQLTable tableMvt = base.getTable("MOUVEMENT_STOCK");
            final String stringTableSource = tableMvt.getRow(id).getString("SOURCE");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditFrame f;
                    if (stringTableSource.trim().length() != 0 && tableMvt.getRow(id).getInt("IDSOURCE") != 1) {
                        f = new EditFrame(Configuration.getInstance().getDirectory().getElement(stringTableSource), EditPanel.READONLY);
                        f.selectionId(tableMvt.getRow(id).getInt("IDSOURCE"));
                    } else {
                        f = new EditFrame(Configuration.getInstance().getDirectory().getElement(tableMvt), EditPanel.READONLY);
                        f.selectionId(id);
                    }
                    f.pack();
                    FrameUtil.show(f);
                }
            });
        } else {
            System.err.println("Aucun mouvement associ\u00e9, impossible de modifier ou d'acc\u00e9der \u00e0 la source de cette ecriture!");
        }
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".transaction";
    }
}

