/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.component;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.MontantPanel;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieAchat;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.preferences.ModeReglementDefautPrefPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class SaisieAchatSQLComponent
extends BaseSQLComponent {
    private JTextField textNumeroFacture;
    private JTextField textNumeroCmd;
    private JTextField textSource;
    private JTextField textIdSource;
    private DeviseField fieldMontantRegle = new DeviseField();
    final ISQLCompteSelector compteSel = new ISQLCompteSelector();
    private JCheckBox checkImmo;
    private MontantPanel montant;
    private ElementComboBox nomFournisseur;
    private ElementComboBox comboAvoir;
    protected ElementSQLObject eltModeRegl;
    private PropertyChangeListener listenerModeReglDefaut = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SQLRow rowFourn = SaisieAchatSQLComponent.this.nomFournisseur.getRequest().getPrimaryTable().getRow(SaisieAchatSQLComponent.this.nomFournisseur.getWantedID());
            if (!SaisieAchatSQLComponent.this.isFilling() && rowFourn != null && !rowFourn.isUndefined()) {
                int idModeRegl;
                SaisieAchatSQLComponent.this.montant.setUE(rowFourn.getBoolean("UE"));
                SQLRow rowCharge = rowFourn.getForeign("ID_COMPTE_PCE_CHARGE");
                if (rowCharge != null && !rowCharge.isUndefined()) {
                    SaisieAchatSQLComponent.this.compteSel.setValue(rowCharge);
                }
                if ((idModeRegl = rowFourn.getInt("ID_MODE_REGLEMENT")) > 1 && SaisieAchatSQLComponent.this.eltModeRegl != null && SaisieAchatSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION) {
                    SQLElement sqlEltModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                    SQLRow rowModeRegl = sqlEltModeRegl.getTable().getRow(idModeRegl);
                    SQLRowValues rowVals = rowModeRegl.createUpdateRow();
                    rowVals.clearPrimaryKeys();
                    SaisieAchatSQLComponent.this.eltModeRegl.setValue(rowVals);
                    System.err.println("Select Mode regl " + idModeRegl);
                }
            }
        }
    };
    final SQLTable tablePrefCompte = this.getTable().getTable("PREFS_COMPTE");

    public SaisieAchatSQLComponent(SQLElement element) {
        super(element);
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.textIdSource = new JTextField();
        this.textSource = new JTextField();
        c.gridwidth = 0;
        c.gridheight = 1;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 0;
        JLabel labelLibelle = new JLabel("Achat de ");
        SQLTextCombo textLibelle = new SQLTextCombo();
        c.weightx = 0.0;
        labelLibelle.setHorizontalAlignment(4);
        this.add((Component)labelLibelle, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        this.add((Component)textLibelle, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 1));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Fournisseur", 4), c);
        ++c.gridx;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.nomFournisseur = new ElementComboBox();
        this.add((Component)this.nomFournisseur, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        c.fill = 2;
        c.gridwidth = 1;
        this.add((Component)new JLabel(this.getLabelFor("ID_COMPTE_PCE"), 4), c);
        c.gridwidth = 0;
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.compteSel, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)new JLabel(this.getLabelFor("NUMERO_FACTURE"), 4), c);
        this.textNumeroFacture = new JTextField(16);
        DefaultGridBagConstraints.lockMinimumSize(this.textNumeroFacture);
        c.gridx = 1;
        c.gridwidth = 1;
        this.add((Component)this.textNumeroFacture, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Date"), c);
        ++c.gridx;
        c.weightx = 1.0;
        JDate dateSaisie = new JDate();
        c.fill = 0;
        this.add((Component)dateSaisie, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.gridwidth = 1;
        this.add((Component)new JLabel(this.getLabelFor("NUMERO_COMMANDE"), 4), c);
        this.textNumeroCmd = new JTextField(16);
        c.gridx = 1;
        c.gridwidth = 1;
        DefaultGridBagConstraints.lockMinimumSize(this.textNumeroCmd);
        this.add((Component)this.textNumeroCmd, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.anchor = 13;
        this.checkImmo = new JCheckBox(this.getLabelFor("IMMO"));
        this.add((Component)this.checkImmo, c);
        c.anchor = 17;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Montant", 4), c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 0;
        this.montant = new MontantPanel();
        this.add((Component)this.montant, c);
        JPanel panelAvoir = new JPanel();
        this.comboAvoir = new ElementComboBox(true);
        this.comboAvoir.setAddIconVisible(false);
        panelAvoir.add(this.comboAvoir);
        panelAvoir.add(new JLabel("Montant \u00e0 r\u00e9gler"));
        panelAvoir.add(this.fieldMontantRegle);
        this.fieldMontantRegle.setEditable(false);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("ID_AVOIR_FOURNISSEUR"), 4), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 0;
        this.add((Component)panelAvoir, c);
        c.gridwidth = 0;
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(10, 2, 1, 2);
        c.fill = 2;
        TitledSeparator sep = new TitledSeparator("Mode de r\u00e8glement");
        this.add((Component)sep, c);
        c.insets = new Insets(2, 2, 1, 2);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        this.addView("ID_MODE_REGLEMENT", "required;notdecorated;noseparator");
        this.eltModeRegl = (ElementSQLObject)this.getView("ID_MODE_REGLEMENT");
        this.add((Component)this.eltModeRegl, c);
        c.gridwidth = 0;
        c.gridx = 0;
        ++c.gridy;
        sep = new TitledSeparator("Informations compl\u00e9mentaires");
        c.insets = new Insets(10, 2, 1, 2);
        this.add((Component)sep, c);
        c.insets = new Insets(2, 2, 1, 2);
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 0;
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        ITextArea textInfos = new ITextArea(4, 4);
        JScrollPane scrollPane = new JScrollPane(textInfos);
        DefaultGridBagConstraints.lockMinimumSize(scrollPane);
        this.add((Component)textInfos, c);
        this.addSQLObject(textInfos, "INFOS");
        this.addRequiredSQLObject(dateSaisie, "DATE");
        this.addRequiredSQLObject(this.nomFournisseur, "ID_FOURNISSEUR");
        this.addRequiredSQLObject(this.montant.getChoixTaxe(), "ID_TAXE");
        this.addRequiredSQLObject(this.montant.getMontantTTC(), "MONTANT_TTC");
        this.addRequiredSQLObject(this.montant.getMontantHT(), "MONTANT_HT");
        this.addRequiredSQLObject(this.montant.getMontantTVA(), "MONTANT_TVA");
        this.addSQLObject(textLibelle, "NOM");
        this.addSQLObject(this.textNumeroFacture, "NUMERO_FACTURE");
        this.addSQLObject(this.textNumeroCmd, "NUMERO_COMMANDE");
        this.addSQLObject(this.textIdSource, "IDSOURCE");
        this.addSQLObject(this.textSource, "SOURCE");
        this.addRequiredSQLObject(this.compteSel, "ID_COMPTE_PCE");
        this.addSQLObject(this.comboAvoir, "ID_AVOIR_FOURNISSEUR");
        this.addSQLObject(this.checkImmo, "IMMO");
        this.montant.setChoixTaxe(TaxeCache.getCache().getFirstTaxe().getID());
        this.nomFournisseur.addModelListener("wantedID", this.listenerModeReglDefaut);
        this.montant.getMontantTTC().getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                SaisieAchatSQLComponent.this.refreshText();
            }
        });
        this.comboAvoir.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SaisieAchatSQLComponent.this.refreshText();
            }
        });
        final SQLTable tableAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_FOURNISSEUR").getTable();
        this.nomFournisseur.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Where w = new Where((FieldRef)tableAvoir.getField("SOLDE"), "=", (Object)Boolean.FALSE);
                if (SaisieAchatSQLComponent.this.nomFournisseur.isEmpty()) {
                    w.and(new Where((FieldRef)SaisieAchatSQLComponent.this.getTable().getBase().getTable("AVOIR_FOURNISSEUR").getField("ID_FOURNISSEUR"), "=", -1));
                } else {
                    w.and(new Where((FieldRef)SaisieAchatSQLComponent.this.getTable().getBase().getTable("AVOIR_FOURNISSEUR").getField("ID_FOURNISSEUR"), "=", (Object)SaisieAchatSQLComponent.this.nomFournisseur.getValue()));
                }
                if (SaisieAchatSQLComponent.this.getSelectedID() > 1) {
                    SQLRow row = SaisieAchatSQLComponent.this.getTable().getRow(SaisieAchatSQLComponent.this.getSelectedID());
                    w = w.or(new Where((FieldRef)SaisieAchatSQLComponent.this.getTable().getBase().getTable("AVOIR_FOURNISSEUR").getKey(), "=", row.getInt("ID_AVOIR_FOURNISSEUR")));
                }
                SaisieAchatSQLComponent.this.comboAvoir.getRequest().setWhere(null);
                SaisieAchatSQLComponent.this.comboAvoir.getRequest().setWhere(w);
                SaisieAchatSQLComponent.this.comboAvoir.fillCombo();
            }
        });
        Where w = new Where((FieldRef)tableAvoir.getField("SOLDE"), "=", (Object)Boolean.FALSE);
        this.comboAvoir.getRequest().setWhere(w);
        this.comboAvoir.fillCombo();
        DefaultGridBagConstraints.lockMinimumSize(this.nomFournisseur);
        DefaultGridBagConstraints.lockMinimumSize(panelAvoir);
        DefaultGridBagConstraints.lockMinimumSize(this.montant);
        DefaultGridBagConstraints.lockMaximumSize(this.montant);
    }

    @Override
    public ValidState getValidState() {
        ValidState result = super.getValidState();
        if (result.isValid() && this.montant.getMontantTTC() != null && this.montant.getMontantTTC().getValue() != null) {
            long l = this.montant.getMontantTTC().getValue();
            if (this.comboAvoir != null && !this.comboAvoir.isEmpty() && this.comboAvoir.getSelectedId() > 1) {
                SQLElement eltAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_FOURNISSEUR");
                SQLRow rowAvoir = eltAvoir.getTable().getRow(this.comboAvoir.getSelectedId());
                l -= ((Number)rowAvoir.getObject("MONTANT_TTC")).longValue();
            }
            if (l < 0L) {
                result = new ValidState(false, "Le montant est n\u00e9gatif");
            }
        }
        return result;
    }

    @Override
    public int insert(SQLRow order) {
        int id = super.insert(order);
        if (this.comboAvoir.getSelectedId() > 1) {
            SQLTable tableAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_FOURNISSEUR").getTable();
            SQLRow rowAvoir = tableAvoir.getRow(this.comboAvoir.getSelectedId());
            SQLRowValues rowVals = rowAvoir.createEmptyUpdateRow();
            rowVals.put("SOLDE", Boolean.TRUE);
            try {
                rowVals.update();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        new GenerationMvtSaisieAchat(this.getTable().getRow(id));
        return id;
    }

    @Override
    public Set<String> getPartialResetNames() {
        HashSet<String> s = new HashSet<String>();
        s.addAll(super.getPartialResetNames());
        s.add("INFOS");
        s.add("NUMERO_FACTURE");
        s.add("NUMERO_COMMANDE");
        s.add("MONTANT_HT");
        return s;
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        if (r != null) {
            int idSeleted;
            System.err.println(r);
            this.montant.calculMontant();
            Object idF = r.getObject("ID_FOURNISSEUR");
            System.err.println("Founisseur " + idF);
            if (idF != null && (idSeleted = Integer.valueOf(idF.toString()).intValue()) > 1) {
                SQLElement fournisseur = Configuration.getInstance().getDirectory().getElement("FOURNISSEUR");
                SQLRow rowFourn = fournisseur.getTable().getRow(idSeleted);
                this.montant.setUE(rowFourn.getBoolean("UE"));
            }
            System.out.println("select id Saisie Achat " + r.getID());
        }
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRow rowPrefsCompte;
        int idCompteAchat;
        SQLRowValues vals = new SQLRowValues(this.getTable());
        try {
            SQLRow r = ModeReglementDefautPrefPanel.getDefaultRow(false);
            SQLElement eltModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
            if (r.getID() > 1) {
                SQLRowValues rowVals = eltModeReglement.createCopy(r, null);
                System.err.println("Primary Keys " + rowVals.getID());
                rowVals.clearPrimaryKeys();
                System.err.println(rowVals.getInt("ID_TYPE_REGLEMENT"));
                vals.put("ID_MODE_REGLEMENT", (Object)rowVals);
            }
        }
        catch (SQLException e) {
            System.err.println("Impossible de s\u00e9lectionner le mode de r\u00e8glement par d\u00e9faut du client.");
            e.printStackTrace();
        }
        if ((idCompteAchat = (rowPrefsCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(this.tablePrefCompte).getRowFromId(2)).getInt("ID_COMPTE_PCE_ACHAT")) <= 1) {
            try {
                idCompteAchat = ComptePCESQLElement.getIdComptePceDefault("Achats");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        vals.put("ID_COMPTE_PCE", idCompteAchat);
        vals.put("ID_TAXE", TaxeCache.getCache().getFirstTaxe().getID());
        return vals;
    }

    @Override
    public void update() {
        if (JOptionPane.showConfirmDialog(this, "Attention en modifiant cette facture, vous supprimerez les ch\u00e9ques et les \u00e9ch\u00e9ances associ\u00e9s. Continuer?", "Modification de facture", 0) == 0) {
            super.update();
            if (this.comboAvoir.getSelectedId() > 1) {
                SQLTable tableAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_FOURNISSEUR").getTable();
                SQLRow rowAvoir = tableAvoir.getRow(this.comboAvoir.getSelectedId());
                SQLRowValues rowVals = rowAvoir.createEmptyUpdateRow();
                rowVals.put("SOLDE", Boolean.TRUE);
                try {
                    rowVals.update();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            SQLRow row = this.getTable().getRow(this.getSelectedID());
            int idMvt = row.getInt("ID_MOUVEMENT");
            System.err.println("__________***************** UPDATE" + idMvt);
            EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
            eltEcr.archiveMouvementProfondeur(idMvt, false);
            new GenerationMvtSaisieAchat(row, idMvt);
        }
    }

    private void refreshText() {
        Long n = this.montant.getMontantTTC().getValue();
        if (this.comboAvoir.getSelectedId() > 1) {
            SQLTable tableAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_FOURNISSEUR").getTable();
            if (n != null) {
                long ttc = n;
                SQLRow rowAvoir = tableAvoir.getRow(this.comboAvoir.getSelectedId());
                long totalAvoir = ((Number)rowAvoir.getObject("MONTANT_TTC")).longValue();
                this.fieldMontantRegle.setValue(ttc - totalAvoir);
            } else {
                this.fieldMontantRegle.setValue(0L);
            }
        } else if (n != null) {
            this.fieldMontantRegle.setValue((long)n);
        } else {
            this.fieldMontantRegle.setValue(0L);
        }
    }

    public final void loadCommande(int id) {
        this.loadFromTable("COMMANDE", id);
    }

    public final void loadBonReception(int id) {
        this.loadFromTable("BON_RECEPTION", id);
    }

    private final void loadFromTable(String tableName, int id) {
        if (id > 1) {
            SQLElement eltCommande = Configuration.getInstance().getDirectory().getElement(tableName);
            SQLInjector injector = SQLInjector.getInjector(eltCommande.getTable(), this.getTable());
            this.select(injector.createRowValuesFrom(id));
        }
    }
}

