/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.element;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.invoice.component.SaisieVenteFactureSQLComponent;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.quote.component.DevisSQLComponent;
import org.openconcerto.erp.core.sales.quote.element.DevisItemSQLElement;
import org.openconcerto.erp.core.sales.quote.report.DevisXmlSheet;
import org.openconcerto.erp.core.sales.quote.ui.QuoteEditGroup;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBoxUtils;
import org.openconcerto.sql.ui.StringWithId;
import org.openconcerto.sql.ui.light.GroupToLightUIConvertor;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.light.ActivationOnSelectionControler;
import org.openconcerto.ui.light.ColumnSpec;
import org.openconcerto.ui.light.ColumnsSpec;
import org.openconcerto.ui.light.CustomEditorProvider;
import org.openconcerto.ui.light.LightControler;
import org.openconcerto.ui.light.LightUIComboElement;
import org.openconcerto.ui.light.LightUIDescriptor;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.ui.light.LightUITextField;
import org.openconcerto.ui.light.Row;
import org.openconcerto.ui.light.TableContent;
import org.openconcerto.ui.light.TableSpec;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.cc.ITransformer;

public class DevisSQLElement
extends ComptaSQLConfElement {
    public static final String TABLENAME = "DEVIS";
    public static final String FACTURE_TAG_RIGHT = "TAG_FACTURE_DEVIS";

    public DevisSQLElement() {
        this("un devis", "devis");
    }

    public DevisSQLElement(String singular, String plural) {
        super(TABLENAME, singular, plural);
        this.getRowActions().addAll(this.getDevisRowActions());
        QuoteEditGroup group = new QuoteEditGroup();
        GlobalMapper.getInstance().map("sales.quote", group);
        this.setDefaultGroup(group);
    }

    private List<RowAction> getDevisRowActions() {
        ArrayList<RowAction> rowsActions = new ArrayList<RowAction>();
        RowAction factureAction = this.getDevis2FactureAction();
        rowsActions.add(factureAction);
        RowAction.PredicateRowAction actionClient = new RowAction.PredicateRowAction(new AbstractAction("D\u00e9tails client"){
            EditFrame edit;
            private SQLElement eltClient;
            {
                this.eltClient = Configuration.getInstance().getDirectory().getElement(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.edit == null) {
                    this.edit = new EditFrame(this.eltClient, EditPanel.EditMode.MODIFICATION);
                }
                this.edit.selectionId(IListe.get(e).getSelectedRow().getForeignID("ID_CLIENT"));
                this.edit.setVisible(true);
            }
        }, false);
        actionClient.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        rowsActions.add(actionClient);
        RowAction actionTransfertCmd = this.getDevis2CmdFournAction();
        rowsActions.add(actionTransfertCmd);
        RowAction commandeAction = this.getDevis2CmdCliAction();
        rowsActions.add(commandeAction);
        RowAction accepteEtCmdAction = this.getAcceptAndCmdClientAction();
        rowsActions.add(accepteEtCmdAction);
        RowAction accepteAction = this.getAcceptAction();
        rowsActions.add(accepteAction);
        RowAction refuseAction = this.getRefuseAction();
        rowsActions.add(refuseAction);
        RowAction cloneAction = this.getCloneAction();
        rowsActions.add(cloneAction);
        MouseSheetXmlListeListener mouseSheetXmlListeListener = new MouseSheetXmlListeListener(DevisXmlSheet.class);
        mouseSheetXmlListeListener.setGenerateHeader(true);
        mouseSheetXmlListeListener.setShowHeader(true);
        rowsActions.addAll(mouseSheetXmlListeListener.getRowActions());
        return rowsActions;
    }

    public static void davBrowse(String s) throws Exception {
        boolean windows = System.getProperty("os.name").startsWith("Windows");
        if (windows) {
            Desktop.getDesktop().browse(new URI(s));
        } else {
            String[] cmdarray = new String[]{"xdg-open", s};
            int res = Runtime.getRuntime().exec(cmdarray).waitFor();
            if (res != 0) {
                throw new IOException("error (" + res + ") executing " + Arrays.asList(cmdarray));
            }
        }
    }

    public RowAction getCloneAction() {
        return new RowAction(new AbstractAction(){
            private EditFrame editFrame;

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues selectedRow = IListe.get(e).getSelectedRow();
                if (this.editFrame == null) {
                    SQLElement eltFact = Configuration.getInstance().getDirectory().getElement(DevisSQLElement.TABLENAME);
                    this.editFrame = new EditFrame(eltFact, EditPanel.CREATION);
                }
                ((DevisSQLComponent)this.editFrame.getSQLComponent()).loadDevisExistant(((SQLRowAccessor)selectedRow).getID());
                this.editFrame.setVisible(true);
            }
        }, true, "sales.quote.clone"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1;
            }
        };
    }

    public RowAction getRefuseAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues rowVals = IListe.get(e).getSelectedRow().asRow().createEmptyUpdateRow();
                rowVals.put("ID_ETAT_DEVIS", 3);
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }, false, "sales.quote.refuse"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 2;
            }
        };
    }

    public RowAction getAcceptAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow selectedRow = IListe.get(e).getSelectedRow().asRow();
                SQLRowValues rowVals = selectedRow.createEmptyUpdateRow();
                rowVals.put("ID_ETAT_DEVIS", 4);
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }, false, "sales.quote.accept"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                int int1;
                return selection != null && selection.size() == 1 && (int1 = selection.get(0).getInt("ID_ETAT_DEVIS")) != 3 && int1 != 4;
            }
        };
    }

    public RowAction getDevis2FactureAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransfertBaseSQLComponent.openTransfertFrame(IListe.get(e).getSelectedRows(), "SAISIE_VENTE_FACTURE");
            }
        }, true, "sales.quote.create.invoice"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                boolean b = selection.size() > 0;
                for (SQLRowAccessor sQLRowAccessor : selection) {
                    b &= sQLRowAccessor.getInt("ID_ETAT_DEVIS") == 4;
                }
                return b;
            }
        };
    }

    public RowAction getDevis2CmdFournAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final SQLRow selectedRow = IListe.get(e).fetchSelectedRow();
                ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        DevisSQLElement.this.transfertCommande(selectedRow);
                    }
                });
            }
        }, false, "sales.quote.create.supplier.order"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 4;
            }
        };
    }

    public RowAction getDevis2CmdCliAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SQLRowValues> copySelectedRows = IListe.get(e).getSelectedRows();
                DevisSQLElement.this.transfertCommandeClient(copySelectedRows);
            }
        }, true, "sales.quote.create.customer.order"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 4;
            }
        };
    }

    public RowAction getAcceptAndCmdClientAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow selectedRow = IListe.get(e).fetchSelectedRow();
                SQLRowValues rowVals = selectedRow.createEmptyUpdateRow();
                rowVals.put("ID_ETAT_DEVIS", 4);
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    ExceptionHandler.handle("Erreur la de la mise \u00e0 jour de l'\u00e9tat du devis!", e1);
                }
                DevisSQLElement.this.transfertCommandeClient(IListe.get(e).getSelectedRows());
            }
        }, false, "sales.quote.accept.create.customer.order"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 2;
            }
        };
    }

    public void transfertCommandeClient(final List<SQLRowValues> copySelectedRows) {
        SwingWorker<Boolean, Object> worker = new SwingWorker<Boolean, Object>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                final SQLTable tableTransfert = DevisSQLElement.this.getTable().getTable("TR_DEVIS");
                SQLRowValues rowVals = new SQLRowValues(tableTransfert);
                rowVals.put("ID_DEVIS", (Object)new SQLRowValues(DevisSQLElement.this.getTable()).put("NUMERO", null));
                rowVals.put("ID_COMMANDE", null);
                rowVals.put("ID", null);
                final ArrayList<Integer> lID = new ArrayList<Integer>();
                for (SQLRowValues sqlRowValues : copySelectedRows) {
                    lID.add(sqlRowValues.getID());
                }
                SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(rowVals);
                fetch.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        Where w = new Where(tableTransfert.getField("ID_DEVIS"), lID);
                        w = w.and(new Where((FieldRef)tableTransfert.getField("ID_COMMANDE_CLIENT"), "IS NOT", (Object)null));
                        input.setWhere(w);
                        return input;
                    }
                });
                List<SQLRowValues> rows = fetch.fetch();
                if (rows != null && rows.size() > 0) {
                    String numero = "";
                    for (SQLRowValues sqlRow : rows) {
                        numero = String.valueOf(numero) + sqlRow.getForeign("ID_DEVIS").getString("NUMERO") + " ,";
                    }
                    numero = numero.substring(0, numero.length() - 2);
                    String label = "Attention ";
                    label = rows.size() > 1 ? String.valueOf(label) + " les devis " + numero + " ont d\u00e9j\u00e0 \u00e9t\u00e9 transf\u00e9r\u00e9 en commande!" : String.valueOf(label) + " le devis " + numero + " a d\u00e9j\u00e0 \u00e9t\u00e9 transf\u00e9r\u00e9 en commande!";
                    int ans = JOptionPane.showConfirmDialog(null, label = String.valueOf(label) + "\n Voulez vous continuer?", "Transfert devis en commande", 0);
                    if (ans == 1) {
                        return Boolean.FALSE;
                    }
                }
                return Boolean.TRUE;
            }

            @Override
            protected void done() {
                try {
                    Boolean b = (Boolean)this.get();
                    if (b != null && b.booleanValue()) {
                        TransfertBaseSQLComponent.openTransfertFrame(copySelectedRows, "COMMANDE_CLIENT");
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Erreur lors du transfert des devis en commande!", e);
                }
                super.done();
            }
        };
        worker.execute();
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        return l;
    }

    private void transfertCommande(final SQLRow row) {
        ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                DevisItemSQLElement elt = (DevisItemSQLElement)Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
                SQLTable tableCmdElt = Configuration.getInstance().getDirectory().getElement("COMMANDE_ELEMENT").getTable();
                SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
                Collection rows = row.getReferentRows(elt.getTable());
                ListMap<SQLRow, SQLRowValues> map = new ListMap<SQLRow, SQLRowValues>();
                SQLRow rowDeviseF = null;
                for (SQLRow sqlRow : rows) {
                    SQLRowValues rowArticle = new SQLRowValues(eltArticle.getTable());
                    for (SQLField field : eltArticle.getTable().getFields()) {
                        if (!sqlRow.getTable().getFieldsName().contains(field.getName())) continue;
                        rowArticle.put(field.getName(), sqlRow.getObject(field.getName()));
                    }
                    int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowArticle, true);
                    SQLRow rowArticleFind = eltArticle.getTable().getRow(idArticle);
                    SQLInjector inj = SQLInjector.getInjector(rowArticle.getTable(), tableCmdElt);
                    SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticleFind));
                    rowValsElt.put("ID_STYLE", sqlRow.getObject("ID_STYLE"));
                    rowValsElt.put("QTE", sqlRow.getObject("QTE"));
                    rowValsElt.put("T_POIDS", rowValsElt.getLong("POIDS") * (long)rowValsElt.getInt("QTE"));
                    rowValsElt.put("T_PA_HT", ((BigDecimal)rowValsElt.getObject("PA_HT")).multiply(new BigDecimal(rowValsElt.getInt("QTE"), DecimalUtils.HIGH_PRECISION)));
                    rowValsElt.put("T_PA_TTC", ((BigDecimal)rowValsElt.getObject("T_PA_HT")).multiply(new BigDecimal((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0), DecimalUtils.HIGH_PRECISION));
                    rowDeviseF = sqlRow.getForeignRow("ID_DEVISE");
                    SQLRow rowDeviseHA = rowArticleFind.getForeignRow("ID_DEVISE_HA");
                    BigDecimal qte = new BigDecimal(rowValsElt.getInt("QTE"));
                    if (rowDeviseF != null && !rowDeviseF.isUndefined()) {
                        if (rowDeviseF.getID() == rowDeviseHA.getID()) {
                            rowValsElt.put("PA_DEVISE", rowArticleFind.getObject("PA_DEVISE"));
                            rowValsElt.put("PA_DEVISE_T", ((BigDecimal)rowArticleFind.getObject("PA_DEVISE")).multiply(qte, DecimalUtils.HIGH_PRECISION));
                            rowValsElt.put("ID_DEVISE", rowDeviseF.getID());
                        } else {
                            BigDecimal taux = (BigDecimal)rowDeviseF.getObject("TAUX");
                            rowValsElt.put("PA_DEVISE", taux.multiply((BigDecimal)rowValsElt.getObject("PA_HT")));
                            rowValsElt.put("PA_DEVISE_T", ((BigDecimal)rowValsElt.getObject("PA_DEVISE")).multiply(qte, DecimalUtils.HIGH_PRECISION));
                            rowValsElt.put("ID_DEVISE", rowDeviseF.getID());
                        }
                    }
                    map.add(rowArticleFind.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
                }
                MouvementStockSQLElement.createCommandeF(map, rowDeviseF);
            }
        });
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        l.add("ID_CLIENT");
        l.add("OBJET");
        l.add("ID_COMMERCIAL");
        l.add("T_HA");
        l.add("T_HT");
        l.add("T_TTC");
        l.add("INFOS");
        if (this.getTable().contains("DUNNING_DATE")) {
            l.add("DUNNING_DATE");
        }
        return l;
    }

    @Override
    public CollectionMap<String, String> getShowAs() {
        CollectionMap<String, String> map = new CollectionMap<String, String>();
        map.put(null, (Object)"NUMERO");
        return map;
    }

    @Override
    public synchronized ListSQLRequest createListRequest() {
        return new ListSQLRequest(this.getTable(), this.getListFields()){

            @Override
            protected void customizeToFetch(SQLRowValues graphToFetch) {
                super.customizeToFetch(graphToFetch);
                graphToFetch.put("ID_ETAT_DEVIS", null);
            }
        };
    }

    @Override
    protected Set<String> getChildren() {
        HashSet<String> set = new HashSet<String>();
        set.add("DEVIS_ELEMENT");
        return set;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> s = new ArrayList<String>(1);
        s.add("ID_ADRESSE");
        return s;
    }

    @Override
    public SQLComponent createComponent() {
        return new DevisSQLComponent(this);
    }

    public void transfertFacture(int devisID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        EditFrame editFactureFrame = new EditFrame(elt);
        editFactureFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        SaisieVenteFactureSQLComponent comp = (SaisieVenteFactureSQLComponent)editFactureFrame.getSQLComponent();
        comp.setDefaults();
        comp.loadDevis(devisID);
        editFactureFrame.pack();
        editFactureFrame.setState(0);
        editFactureFrame.setVisible(true);
    }

    @Override
    public LightUIDescriptor getUIDescriptorForModification(PropsConfiguration configuration, long quoteId) {
        GroupToLightUIConvertor convertor = new GroupToLightUIConvertor(configuration);
        convertor.setCustomEditorProvider("sales.quote.items.list", this.getItemsCustomEditorProvider(configuration, quoteId));
        LightUIDescriptor desc = convertor.convert(this.getGroupForModification());
        return desc;
    }

    @Override
    public LightUIDescriptor getUIDescriptorForCreation(PropsConfiguration configuration) {
        GroupToLightUIConvertor convertor = new GroupToLightUIConvertor(configuration);
        convertor.setCustomEditorProvider("sales.quote.items.list", this.getItemsCustomEditorProvider(configuration, -1L));
        LightUIDescriptor desc = convertor.convert(this.getGroupForCreation());
        return desc;
    }

    CustomEditorProvider getItemsCustomEditorProvider(final PropsConfiguration configuration, final long quoteId) {
        return new CustomEditorProvider(){

            @Override
            public LightUIElement createUIElement(String id) {
                LightUIElement eList = new LightUIElement();
                eList.setId(id);
                eList.setType(4);
                eList.setFillWidth(true);
                ColumnSpec c1 = new ColumnSpec("sales.quote.item.style", StringWithId.class, "Style", new StringWithId(2L, "Normal"), 50, true, new LightUIComboElement("sales.quote.item.style"));
                ColumnSpec c2 = new ColumnSpec("sales.quote.item.code", String.class, "Code", "", 50, true, new LightUITextField("sales.quote.item.code"));
                ColumnSpec c3 = new ColumnSpec("sales.quote.item.label", String.class, "Nom", "", 50, true, new LightUITextField("sales.quote.item.name"));
                ColumnSpec c4 = new ColumnSpec("sales.quote.item.description", String.class, "Descriptif", "", 50, true, new LightUITextField("sales.quote.item.description"));
                ColumnSpec c5 = new ColumnSpec("sales.quote.item.purchase.unit.price", BigDecimal.class, "P.U. Achat HT", new BigDecimal(0), 50, true, new LightUITextField("sales.quote.item.purchase.unit.price"));
                ColumnSpec c6 = new ColumnSpec("sales.quote.item.sales.unit.price", BigDecimal.class, "P.U. Vente HT", new BigDecimal(0), 50, true, new LightUITextField("sales.quote.item.sales.unit.price"));
                ColumnSpec c7 = new ColumnSpec("sales.quote.item.quantity", Integer.class, "Quantit\u00e9", new BigDecimal(1), 50, true, new LightUITextField("sales.quote.item.quantity"));
                ArrayList<ColumnSpec> cols = new ArrayList<ColumnSpec>();
                cols.add(c1);
                cols.add(c2);
                cols.add(c3);
                cols.add(c4);
                cols.add(c5);
                cols.add(c6);
                cols.add(c7);
                ArrayList<String> visibleIds = new ArrayList<String>();
                for (ColumnSpec c : cols) {
                    visibleIds.add(c.getId());
                }
                ColumnsSpec columsSpec = new ColumnsSpec("sales.quote.items", cols, visibleIds, null);
                TableSpec rawContent = new TableSpec();
                rawContent.setColumns(columsSpec);
                if (quoteId > 0L) {
                    SQLTable table = configuration.getDirectory().getElement("DEVIS_ELEMENT").getTable();
                    ArrayList<SQLField> fieldsToFetch = new ArrayList<SQLField>();
                    for (ColumnSpec cs : cols) {
                        String colId = cs.getId();
                        SQLField f = configuration.getFieldMapper().getSQLFieldForItem(colId);
                        if (f != null) {
                            fieldsToFetch.add(f);
                            continue;
                        }
                        throw new IllegalStateException("No field in " + table + " for column id " + colId);
                    }
                    Where where = new Where((FieldRef)table.getKey(), "=", (Object)quoteId);
                    List<SQLRowValues> fetchedRows = ElementComboBoxUtils.fetchRows(configuration, table, fieldsToFetch, where);
                    ArrayList<Row> rows = new ArrayList<Row>();
                    for (SQLRowValues vals : fetchedRows) {
                        Row r = new Row(vals.getID(), cols.size());
                        ArrayList<Object> values = new ArrayList<Object>();
                        for (ColumnSpec cs : cols) {
                            String colId = cs.getId();
                            SQLField f = configuration.getFieldMapper().getSQLFieldForItem(colId);
                            if (f != null) {
                                Object object = vals.getObject(f.getName());
                                System.out.println("DevisSQLElement.getItemsCustomEditorProvider(...).createUIElement()" + f.getName() + ":" + object + ":" + object.getClass().getCanonicalName());
                                if (object instanceof SQLRowValues) {
                                    SQLRowValues sqlRowValues = (SQLRowValues)object;
                                    long rowId = sqlRowValues.getIDNumber().longValue();
                                    List<SQLField> fieldsToExpand = configuration.getShowAs().getFieldExpand(sqlRowValues.getTable());
                                    String strValue = "";
                                    for (SQLField sqlField : fieldsToExpand) {
                                        strValue = String.valueOf(strValue) + sqlRowValues.getObject(sqlField.getName()).toString() + " ";
                                    }
                                    strValue = strValue.trim();
                                    StringWithId str = new StringWithId(rowId, strValue);
                                    object = str;
                                }
                                values.add(object);
                                continue;
                            }
                            throw new IllegalStateException("No field in " + table + " for column id " + colId);
                        }
                        r.setValues(values);
                        rows.add(r);
                    }
                    TableContent tableContent = new TableContent();
                    tableContent.setRows(rows);
                    rawContent.setContent(tableContent);
                }
                eList.setRawContent(rawContent);
                LightUIDescriptor desc = new LightUIDescriptor("sales.quote.items.list");
                desc.setGridWidth(1);
                desc.setFillWidth(true);
                LightUILine toolbarLine = new LightUILine();
                LightUIElement b1 = new LightUIElement();
                b1.setType(23);
                b1.setId("up");
                b1.setGridWidth(1);
                b1.setIcon("up.png");
                desc.addControler(new ActivationOnSelectionControler(id, b1.getId()));
                desc.addControler(new LightControler("up", id, b1.getId()));
                toolbarLine.add(b1);
                LightUIElement b2 = new LightUIElement();
                b2.setType(23);
                b2.setId("down");
                b2.setGridWidth(1);
                b2.setIcon("down.png");
                desc.addControler(new ActivationOnSelectionControler(id, b2.getId()));
                desc.addControler(new LightControler("down", id, b2.getId()));
                toolbarLine.add(b2);
                LightUIElement addButton = this.createButton("add", "Ajouter une ligne");
                desc.addControler(new LightControler("addDefault", id, addButton.getId()));
                toolbarLine.add(addButton);
                LightUIElement insertButton = this.createButton("insert", "Ins\u00e9rer une ligne");
                desc.addControler(new LightControler("insertDefault", id, insertButton.getId()));
                toolbarLine.add(insertButton);
                LightUIElement copyButton = this.createButton("copy", "Dupliquer");
                desc.addControler(new ActivationOnSelectionControler(id, copyButton.getId()));
                desc.addControler(new LightControler("copy", id, copyButton.getId()));
                toolbarLine.add(copyButton);
                LightUIElement removeButton = this.createButton("remove", "Supprimer");
                desc.addControler(new ActivationOnSelectionControler(id, removeButton.getId()));
                desc.addControler(new LightControler("remove", id, removeButton.getId()));
                toolbarLine.add(removeButton);
                desc.addLine(toolbarLine);
                LightUILine listLine = new LightUILine();
                listLine.setWeightY(1);
                listLine.setFillHeight(true);
                listLine.add(eList);
                desc.addLine(listLine);
                return desc;
            }

            LightUIElement createButton(String id, String label) {
                LightUIElement b1 = new LightUIElement();
                b1.setType(23);
                b1.setId(id);
                b1.setGridWidth(1);
                b1.setLabel(label);
                return b1;
            }
        };
    }

    public static enum Month {
        JANVIER("01", "Janvier"),
        FEVRIER("02", "F\u00e9vrier"),
        MARS("03", "Mars"),
        AVRIL("04", "Avril"),
        MAI("05", "Mai"),
        JUIN("06", "Juin"),
        JUILLET("07", "Juillet"),
        AOUT("08", "Ao\u00fbt"),
        SEPTEMBRE("09", "Septembre"),
        OCTOBRE("10", "Octobre"),
        NOVEMBRE("11", "Novembre"),
        DECEMBRE("12", "D\u00e9cembre");

        private String number;
        private String name;

        private Month(String number, String name) {
            this.number = number;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getNumber() {
            return this.number;
        }

        public String getPath() {
            return String.valueOf(this.getNumber()) + "-" + this.getName();
        }
    }
}

