/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.ui;

import java.awt.Component;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.erp.core.finance.accounting.model.Currency;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.utils.GestionDevise;

public class CurrencyWithSymbolRenderer
extends DefaultTableCellRenderer {
    private final FieldPath fieldPath;
    private final CurrencyConverter c;

    private String getSymbol(String currencyCode) {
        return Currency.getSymbol(currencyCode);
    }

    public CurrencyWithSymbolRenderer() {
        this((FieldPath)null);
    }

    public CurrencyWithSymbolRenderer(FieldPath path) {
        this.fieldPath = path;
        this.c = new CurrencyConverter();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            value = GestionDevise.currencyToString((BigDecimal)value);
            if (this.fieldPath == null) {
                value = value + " " + this.getSymbol(this.c.getCompanyCurrencyCode());
            } else if (table instanceof RowValuesTable) {
                RowValuesTableModel model = ((RowValuesTable)table).getRowValuesTableModel();
                SQLRowAccessor rowVals = model.getRowValuesAt(row);
                List<Step> steps = this.fieldPath.getPath().getSteps();
                int i = 0;
                while (i < steps.size()) {
                    Step s = steps.get(i);
                    if (rowVals != null && !rowVals.isUndefined()) {
                        if (!((SQLRowAccessor)rowVals).getFields().contains(s.getSingleField().getName())) {
                            rowVals = null;
                            break;
                        }
                        SQLRowAccessor foreign = ((SQLRowAccessor)rowVals).getForeign(s.getSingleField().getName());
                        rowVals = i == 0 ? foreign.asRow() : foreign;
                    }
                    ++i;
                }
                if (rowVals != null && !rowVals.isUndefined()) {
                    String code = rowVals.getString(this.fieldPath.getFieldName());
                    value = value + " " + this.getSymbol(code);
                }
            }
        }
        this.setHorizontalAlignment(4);
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

