/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.cc.ITransformer;

public class ProductHelper {
    private DBRoot root;

    public ProductHelper(DBRoot root) {
        this.root = root;
    }

    public BigDecimal getUnitCostForQuantity(SQLRowAccessor rArticle, int qty) {
        Collection<? extends SQLRowAccessor> l = rArticle.getReferentRows(rArticle.getTable().getTable("ARTICLE_PRIX_REVIENT"));
        BigDecimal result = null;
        for (SQLRowAccessor sQLRowAccessor : l) {
            if (sQLRowAccessor.getLong("QTE") > (long)qty) break;
            result = sQLRowAccessor.getBigDecimal("PRIX");
        }
        if (result == null) {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    public List<String> getRequiredProperties(int categoryId) {
        SQLTable table = this.root.getTable("FAMILLE_CARACTERISTIQUE");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(table.getField("NOM"));
        sel.setWhere(table.getField("ID_FAMILLE_ARTICLE"), "=", categoryId);
        SQLDataSource src = this.root.getDBSystemRoot().getDataSource();
        return src.executeCol(sel.asString());
    }

    public int getMinQuantityForCostCalculation(int productId) {
        SQLTable costTable = this.root.getTable("ARTICLE_PRIX_REVIENT");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(costTable.getKey());
        sel.addSelect(costTable.getField("ID_ARTICLE"));
        sel.addSelect(costTable.getField("QTE"));
        sel.setWhere(new Where((FieldRef)costTable.getField("ID_ARTICLE"), "=", productId));
        SQLDataSource src = this.root.getDBSystemRoot().getDataSource();
        List l = (List)src.execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        if (l.isEmpty()) {
            return -1;
        }
        int min = Integer.MAX_VALUE;
        for (SQLRow sqlRow : l) {
            int n = sqlRow.getInt("QTE");
            if (n >= min) continue;
            min = n;
        }
        return min;
    }

    public Map<Long, BigDecimal> getUnitCost(Map<Long, Integer> productQties) {
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>();
        SQLTable costTable = this.root.getTable("ARTICLE_PRIX_REVIENT");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(costTable.getKey());
        sel.addSelect(costTable.getField("ID_ARTICLE"));
        sel.addSelect(costTable.getField("QTE"));
        sel.addSelect(costTable.getField("PRIX"));
        sel.addSelect(costTable.getField("DATE"));
        sel.setWhere(new Where((FieldRef)costTable.getField("ID_ARTICLE"), true, productQties.keySet()));
        sel.addFieldOrder(costTable.getField("QTE"));
        sel.addFieldOrder(costTable.getField("DATE"));
        SQLDataSource src = this.root.getDBSystemRoot().getDataSource();
        List l = (List)src.execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        for (SQLRow sqlRow : l) {
            System.out.println(String.valueOf(sqlRow.getID()) + ":" + sqlRow.getAllValues());
        }
        int size = l.size();
        for (Long id : productQties.keySet()) {
            BigDecimal cost = BigDecimal.ZERO;
            int qty = productQties.get(id);
            int i = 0;
            while (i < size) {
                SQLRow row = (SQLRow)l.get(i);
                if (row.getInt("ID_ARTICLE") == id.intValue()) {
                    if (row.getLong("QTE") > (long)qty) {
                        if (cost != null) break;
                        cost = row.getBigDecimal("PRIX");
                        break;
                    }
                    cost = row.getBigDecimal("PRIX");
                }
                ++i;
            }
            if (cost == null) {
                cost = BigDecimal.ZERO;
            }
            result.put(id, cost);
        }
        return result;
    }

    public List<ProductComponent> getChildWithQtyFrom(List<ProductComponent> items) {
        return this.getChildWithQtyFrom(items, new HashSet<Integer>());
    }

    private List<ProductComponent> getChildWithQtyFrom(List<ProductComponent> items, Set<Integer> ancestors) {
        if (this.root.contains("ARTICLE_ELEMENT")) {
            int originalAncestorsSize = ancestors.size();
            ArrayList<ProductComponent> result = new ArrayList<ProductComponent>();
            final ArrayList<Integer> parentsArticleIDs = new ArrayList<Integer>();
            HashMap<Integer, ProductComponent> productCompByID = new HashMap<Integer, ProductComponent>();
            HashMap<Integer, BigDecimal> qtyParent = new HashMap<Integer, BigDecimal>();
            for (ProductComponent p : items) {
                parentsArticleIDs.add(p.getProduct().getID());
                qtyParent.put(p.getProduct().getID(), p.getQty());
            }
            final SQLTable costTable = this.root.getTable("ARTICLE_ELEMENT");
            SQLRowValues rowVals = new SQLRowValues(costTable);
            SQLRowValues stockRowValues = rowVals.putRowValues("ID_ARTICLE").put("ID", null).put("GESTION_STOCK", null).put("CODE", null).put("NOM", null).putRowValues("ID_STOCK");
            stockRowValues.putNulls("QTE_TH", "QTE_RECEPT_ATTENTE", "QTE_REEL", "QTE_LIV_ATTENTE");
            rowVals.putRowValues("ID_ARTICLE_PARENT").put("ID", null);
            rowVals.put("QTE", null);
            rowVals.put("QTE_UNITAIRE", null);
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
            fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    input.setWhere(new Where(costTable.getField("ID_ARTICLE_PARENT"), parentsArticleIDs));
                    return input;
                }
            });
            List<SQLRowValues> childs = fetcher.fetch();
            if (childs.size() > 0) {
                for (SQLRowValues childRowValues : childs) {
                    SQLRowAccessor foreignArticleParent = childRowValues.getForeign("ID_ARTICLE_PARENT");
                    ProductComponent childComponent = ProductComponent.createFrom(childRowValues);
                    if (ancestors.contains(childComponent.getProduct().getID())) continue;
                    ancestors.add(foreignArticleParent.getID());
                    childComponent.setQty(childComponent.getQty().multiply((BigDecimal)qtyParent.get(foreignArticleParent.getID()), DecimalUtils.HIGH_PRECISION));
                    ProductComponent existProduct = (ProductComponent)productCompByID.get(childComponent.getProduct().getID());
                    if (existProduct == null) {
                        result.add(childComponent);
                        productCompByID.put(childComponent.getProduct().getID(), childComponent);
                        continue;
                    }
                    existProduct.addQty(childComponent.getQty());
                }
                List<ProductComponent> bomFromChilds = this.getChildWithQtyFrom(new ArrayList<ProductComponent>(result), ancestors);
                for (ProductComponent s : bomFromChilds) {
                    ProductComponent existProduct = (ProductComponent)productCompByID.get(s.getProduct().getID());
                    if (existProduct == null) {
                        result.add(s);
                        productCompByID.put(s.getProduct().getID(), s);
                        continue;
                    }
                    existProduct.addQty(s.getQty());
                }
            }
            if (originalAncestorsSize == 0) {
                for (ProductComponent p : items) {
                    ProductComponent existProduct = (ProductComponent)productCompByID.get(p.getProduct().getID());
                    if (existProduct == null) {
                        result.add(p);
                        productCompByID.put(p.getProduct().getID(), p);
                        continue;
                    }
                    existProduct.addQty(p.getQty());
                }
            }
            for (Integer anc : ancestors) {
                ProductComponent comp = (ProductComponent)productCompByID.get(anc);
                if (comp == null) continue;
                result.remove(comp);
            }
            return result;
        }
        return items;
    }

    public Map<Long, Integer> getBOM(Long productId) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        SQLTable costTable = this.root.getTable("ARTICLE_ELEMENT");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(costTable.getField("ID_ARTICLE"));
        sel.addSelect(costTable.getField("QTE"));
        sel.setWhere(new Where((FieldRef)costTable.getField("ID_ARTICLE_PARENT"), "=", (Object)productId));
        sel.addFieldOrder(costTable.getField("QTE"));
        SQLDataSource src = this.root.getDBSystemRoot().getDataSource();
        List l = (List)src.execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        int size = l.size();
        int i = 0;
        while (i < size) {
            SQLRow row = (SQLRow)l.get(i);
            long id = row.getLong("ID_ARTICLE");
            Integer qte = (Integer)result.get(id);
            qte = qte == null ? Integer.valueOf(row.getInt("QTE")) : Integer.valueOf(qte + row.getInt("QTE"));
            result.put(id, qte);
            ++i;
        }
        return result;
    }

    public BigDecimal getBomUnitCostForQuantity(int qty, Collection<? extends SQLRowAccessor> rowValuesProductItems) {
        HashMap<Long, Integer> productQties = new HashMap<Long, Integer>();
        int count = rowValuesProductItems.size();
        for (SQLRowAccessor sQLRowAccessor : rowValuesProductItems) {
            if (sQLRowAccessor.getObject("ID_ARTICLE") == null) continue;
            System.out.println("id:" + sQLRowAccessor.getObject("ID_ARTICLE"));
            int n = sQLRowAccessor.getForeignID("ID_ARTICLE");
            int qte = sQLRowAccessor.getInt("QTE") * qty;
            Integer qteForId = (Integer)productQties.get(n);
            if (qteForId == null) {
                productQties.put(Long.valueOf(n), qte);
                continue;
            }
            productQties.put(Long.valueOf(n), qte + qteForId);
        }
        Map<Long, BigDecimal> map = this.getUnitCost(productQties);
        BigDecimal cost = null;
        for (SQLRowAccessor sQLRowAccessor : rowValuesProductItems) {
            if (sQLRowAccessor.getObject("ID_ARTICLE") == null) continue;
            int id = sQLRowAccessor.getForeignID("ID_ARTICLE");
            int qte = sQLRowAccessor.getInt("QTE");
            BigDecimal unitCost = map.get(id);
            BigDecimal lineCost = unitCost.multiply(BigDecimal.valueOf(qte));
            if (cost == null) {
                cost = BigDecimal.ZERO;
            }
            cost = cost.add(lineCost);
        }
        return cost;
    }

    public BigDecimal getUnitCost(int id, int qty) {
        HashMap<Long, Integer> productQties = new HashMap<Long, Integer>();
        productQties.put(Long.valueOf(id), qty);
        Map<Long, BigDecimal> unitCost = this.getUnitCost(productQties);
        System.out.println(">" + unitCost);
        return unitCost.get(id);
    }

    public Date getUnitCostDate(int id, int qty) {
        HashMap<Long, Integer> productQties = new HashMap<Long, Integer>();
        productQties.put(Long.valueOf(id), qty);
        Map<Long, Date> unitCost = this.getUnitCostDate(productQties);
        System.out.println(">" + unitCost);
        return unitCost.get(id);
    }

    private Map<Long, Date> getUnitCostDate(Map<Long, Integer> productQties) {
        HashMap<Long, Date> result = new HashMap<Long, Date>();
        SQLTable costTable = this.root.getTable("ARTICLE_PRIX_REVIENT");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(costTable.getKey());
        sel.addSelect(costTable.getField("ID_ARTICLE"));
        sel.addSelect(costTable.getField("QTE"));
        sel.addSelect(costTable.getField("PRIX"));
        sel.addSelect(costTable.getField("DATE"));
        sel.setWhere(new Where((FieldRef)costTable.getField("ID_ARTICLE"), true, productQties.keySet()));
        sel.addFieldOrder(costTable.getField("QTE"));
        sel.addFieldOrder(costTable.getField("DATE"));
        SQLDataSource src = this.root.getDBSystemRoot().getDataSource();
        List l = (List)src.execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        for (SQLRow sqlRow : l) {
            System.out.println(String.valueOf(sqlRow.getID()) + ":" + sqlRow.getAllValues());
        }
        int size = l.size();
        for (Long id : productQties.keySet()) {
            Calendar cost = null;
            int qty = productQties.get(id);
            int i = 0;
            while (i < size) {
                SQLRow row = (SQLRow)l.get(i);
                if (row.getInt("ID_ARTICLE") == id.intValue()) {
                    if (row.getLong("QTE") > (long)qty) {
                        if (cost != null) break;
                        cost = row.getDate("DATE");
                        break;
                    }
                    cost = row.getDate("DATE");
                }
                ++i;
            }
            if (cost != null) {
                result.put(id, cost.getTime());
                continue;
            }
            result.put(id, new Date());
        }
        return result;
    }
}

