/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.model;

import java.math.BigDecimal;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.DecimalUtils;

public class ProductComponent {
    private final SQLRowAccessor product;
    private BigDecimal qty;

    public ProductComponent(SQLRowAccessor product, BigDecimal qty) {
        this.product = product;
        this.qty = qty;
    }

    public SQLRowAccessor getProduct() {
        return this.product;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public void addQty(BigDecimal b) {
        this.qty = this.qty.add(b);
    }

    public static ProductComponent createFrom(SQLRowAccessor rowVals) {
        return ProductComponent.createFrom(rowVals, 1);
    }

    public static ProductComponent createFrom(SQLRowAccessor rowVals, int qteMultiple) {
        int qte = rowVals.getInt("QTE") * qteMultiple;
        BigDecimal qteUV = rowVals.getBigDecimal("QTE_UNITAIRE");
        BigDecimal qteFinal = qteUV.multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION);
        return new ProductComponent(rowVals.getForeign("ID_ARTICLE"), qteFinal);
    }
}

