/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.component.ReferenceArticleSQLComponent;
import org.openconcerto.erp.generationDoc.gestcomm.FicheArticleXmlSheet;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ListMap;

public class ReferenceArticleSQLElement
extends ComptaSQLConfElement {
    public static final int AU_METRE_LONGUEUR = 2;
    public static final int AU_METRE_CARRE = 3;
    public static final int AU_POID_METRECARRE = 4;
    public static final int A_LA_PIECE = 5;
    public static final int AU_METRE_LARGEUR = 6;
    private static final int PRIX_HA = 1;
    private static final int PRIX_VT = 2;

    public ReferenceArticleSQLElement() {
        super("ARTICLE", "un article", "articles");
        this.getRowActions().addAll(new MouseSheetXmlListeListener(FicheArticleXmlSheet.class).getRowActions());
        RowAction.PredicateRowAction clone = new RowAction.PredicateRowAction((Action)new AbstractAction("Dupliquer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues rowVals = ReferenceArticleSQLElement.this.createCopy(IListe.get(e).getSelectedId());
                ListMap<SQLTable, SQLRow> children = ReferenceArticleSQLElement.this.getChildrenRows(IListe.get(e).getSelectedRow().asRow());
                for (SQLRow child : children.allValues()) {
                    Configuration.getInstance().getDirectory().getElement(child.getTable()).createCopy(child, false, rowVals);
                }
                EditFrame f = new EditFrame(ReferenceArticleSQLElement.this.createComponent(), EditPanel.EditMode.CREATION);
                f.getSQLComponent().select(rowVals);
                FrameUtil.show(f);
            }
        }, true, false);
        clone.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(clone);
    }

    @Override
    protected SQLTableModelSourceOnline createTableSource() {
        SQLTableModelColumn paHTCol;
        SQLTableModelColumn pvTTCCol;
        SQLTableModelColumn pvHTCol;
        SQLTableModelColumn pvHT1Col;
        SQLTableModelSourceOnline source = super.createTableSource();
        source.init();
        SQLTableModelColumn pvHA1Col = source.getColumn(this.getTable().getField("PRIX_METRIQUE_HA_1"));
        if (pvHA1Col != null) {
            pvHA1Col.setRenderer(CURRENCY_RENDERER);
        }
        if ((pvHT1Col = source.getColumn(this.getTable().getField("PRIX_METRIQUE_VT_1"))) != null) {
            pvHT1Col.setRenderer(CURRENCY_RENDERER);
        }
        if ((pvHTCol = source.getColumn(this.getTable().getField("PV_HT"))) != null) {
            pvHTCol.setRenderer(CURRENCY_RENDERER);
        }
        if ((pvTTCCol = source.getColumn(this.getTable().getField("PV_TTC"))) != null) {
            pvTTCCol.setRenderer(CURRENCY_RENDERER);
        }
        if ((paHTCol = source.getColumn(this.getTable().getField("PA_HT"))) != null) {
            paHTCol.setRenderer(CURRENCY_RENDERER);
        }
        return source;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.SHOW_PRODUCT_BAR_CODE, false)) {
            l.add("CODE_BARRE");
        }
        l.add("NOM");
        String articleAdvanced = DefaultNXProps.getInstance().getStringProperty("ArticleModeVenteAvance");
        Boolean bArticleAdvanced = Boolean.valueOf(articleAdvanced);
        if (bArticleAdvanced.booleanValue()) {
            l.add("POIDS");
            l.add("PRIX_METRIQUE_HA_1");
            l.add("PRIX_METRIQUE_VT_1");
        }
        l.add("PA_HT");
        l.add("PV_HT");
        l.add("ID_TAXE");
        l.add("PV_TTC");
        l.add("ID_FAMILLE_ARTICLE");
        l.add("ID_FOURNISSEUR");
        l.add("SKU");
        l.add("ID_STOCK");
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean b = Boolean.valueOf(val);
        if (b != null && b.booleanValue()) {
            l.add("SERVICE");
        }
        return l;
    }

    @Override
    public CollectionMap<String, String> getShowAs() {
        CollectionMap<String, String> res = new CollectionMap<String, String>();
        res.put(null, (Object)"NOM");
        res.put(null, (Object)"ID_FAMILLE_ARTICLE");
        return res;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.SHOW_PRODUCT_BAR_CODE, false)) {
            l.add("CODE_BARRE");
        }
        l.add("NOM");
        return l;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_STOCK");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new ReferenceArticleSQLComponent(this);
    }

    public static BigDecimal getPrixHAFromDetails(SQLRowValues rowVals) {
        return ReferenceArticleSQLElement.getValuePiece(rowVals, 1);
    }

    public static BigDecimal getPrixVTFromDetails(SQLRowValues rowVals) {
        return ReferenceArticleSQLElement.getValuePiece(rowVals, 2);
    }

    public static float getPoidsFromDetails(SQLRowValues rowVals) {
        float valMetrique3;
        float valMetrique2;
        float valMetrique1 = rowVals.getObject("VALEUR_METRIQUE_1") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_1");
        float produit = valMetrique1 * (valMetrique2 = rowVals.getObject("VALEUR_METRIQUE_2") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_2")) * (valMetrique3 = rowVals.getObject("VALEUR_METRIQUE_3") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_3"));
        if (produit > 0.0f) {
            return (float)Math.round(produit * 1000.0f) / 1000.0f;
        }
        if (rowVals.getObject("POIDS") != null) {
            float p = rowVals.getFloat("POIDS");
            return p;
        }
        return 0.0f;
    }

    private static BigDecimal getValuePiece(SQLRowValues rowVals, int value) {
        float valMetrique3;
        if (rowVals.getObject("ID_MODE_VENTE_ARTICLE") == null) {
            throw new IllegalArgumentException("La SQLRowValues ne contient pas ID_MODE_VENTE_ARTICLE");
        }
        int mode = rowVals.getInt("ID_MODE_VENTE_ARTICLE");
        if (mode == 1) {
            mode = 5;
        }
        BigDecimal metrique1HA = rowVals.getObject("PRIX_METRIQUE_HA_1") == null ? BigDecimal.ZERO : (BigDecimal)rowVals.getObject("PRIX_METRIQUE_HA_1");
        BigDecimal metrique1VT = rowVals.getObject("PRIX_METRIQUE_VT_1") == null ? BigDecimal.ZERO : (BigDecimal)rowVals.getObject("PRIX_METRIQUE_VT_1");
        float valMetrique1 = rowVals.getObject("VALEUR_METRIQUE_1") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_1");
        float valMetrique2 = rowVals.getObject("VALEUR_METRIQUE_2") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_2");
        float f = valMetrique3 = rowVals.getObject("VALEUR_METRIQUE_3") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_3");
        if (mode == 3) {
            float surface = valMetrique1 * valMetrique2;
            if (value == 1) {
                return metrique1HA.multiply(BigDecimal.valueOf(surface), DecimalUtils.HIGH_PRECISION);
            }
            return metrique1VT.multiply(BigDecimal.valueOf(surface), DecimalUtils.HIGH_PRECISION);
        }
        if (mode == 6) {
            if (value == 1) {
                return metrique1HA.multiply(BigDecimal.valueOf(valMetrique2), DecimalUtils.HIGH_PRECISION);
            }
            return metrique1VT.multiply(BigDecimal.valueOf(valMetrique2), DecimalUtils.HIGH_PRECISION);
        }
        if (mode == 2) {
            if (value == 1) {
                return metrique1HA.multiply(BigDecimal.valueOf(valMetrique1), DecimalUtils.HIGH_PRECISION);
            }
            return metrique1VT.multiply(BigDecimal.valueOf(valMetrique1), DecimalUtils.HIGH_PRECISION);
        }
        if (mode == 4) {
            float surface = valMetrique1 * valMetrique2;
            float p = surface * valMetrique3;
            if (value == 1) {
                return metrique1HA.multiply(BigDecimal.valueOf(p), DecimalUtils.HIGH_PRECISION);
            }
            return metrique1VT.multiply(BigDecimal.valueOf(p), DecimalUtils.HIGH_PRECISION);
        }
        if (value == 1) {
            if (rowVals.getObject("PA_HT") != null) {
                return (BigDecimal)rowVals.getObject("PA_HT");
            }
            return BigDecimal.ZERO;
        }
        if (rowVals.getObject("PV_HT") != null) {
            return (BigDecimal)rowVals.getObject("PV_HT");
        }
        return BigDecimal.ZERO;
    }

    public static int getIdForCNM(SQLRowValues row, boolean createIfNotExist) {
        return ReferenceArticleSQLElement.getIdFor(row, true, createIfNotExist);
    }

    public static int getIdForCN(SQLRowValues row, boolean createIfNotExist) {
        return ReferenceArticleSQLElement.getIdFor(row, false, createIfNotExist);
    }

    private static int getIdFor(SQLRowValues row, boolean includeMetrique, boolean createIfNotExist) {
        SQLTable tableArt = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(tableArt);
        String req = ReferenceArticleSQLElement.getMatchRequest(row, includeMetrique);
        List result = (List)eltArticle.getTable().getBase().getDataSource().execute(req, new ArrayListHandler());
        if (result != null && result.size() != 0) {
            Object[] tmp = (Object[])result.get(0);
            return ((Number)tmp[0]).intValue();
        }
        if (createIfNotExist && row.getString("CODE") != null && row.getString("CODE").trim().length() > 0 && row.getString("NOM") != null && row.getString("NOM").trim().length() > 0) {
            SQLRowValues vals = new SQLRowValues(row);
            BigDecimal taux = BigDecimal.ONE.add(new BigDecimal(TaxeCache.getCache().getTauxFromId(row.getForeignID("ID_TAXE")).floatValue() / 100.0f));
            vals.put("PV_TTC", vals.getBigDecimal("PV_HT").multiply(taux));
            try {
                int idArticle;
                SQLSelect selMatchingCodeF = new SQLSelect();
                SQLTable table = tableArt.getTable("ARTICLE_FOURNISSEUR");
                selMatchingCodeF.addSelect(table.getKey());
                selMatchingCodeF.addSelect(table.getField("ID_FOURNISSEUR"));
                selMatchingCodeF.addSelect(table.getField("CODE_BARRE"));
                Where wMatchingCodeF = new Where((FieldRef)table.getField("CODE"), "=", (Object)vals.getString("CODE"));
                wMatchingCodeF = wMatchingCodeF.and(new Where((FieldRef)table.getField("NOM"), "=", (Object)vals.getString("NOM")));
                selMatchingCodeF.setWhere(wMatchingCodeF);
                List<SQLRow> l = SQLRowListRSH.execute(selMatchingCodeF, false, false);
                if (l.size() > 0) {
                    SQLRowValues rowVals = l.get(0).asRowValues();
                    vals.put("ID_FOURNISSEUR", rowVals.getObject("ID_FOURNISSEUR"));
                    vals.put("CODE_BARRE", rowVals.getObject("CODE_BARRE"));
                    vals.put("QTE_ACHAT", rowVals.getObject("QTE_ACHAT"));
                    SQLRow rowNew = vals.insert();
                    idArticle = rowNew.getID();
                    rowVals.put("ID_ARTICLE", idArticle);
                    rowVals.commit();
                } else {
                    SQLSelect selMatchingCodeArticle = new SQLSelect();
                    selMatchingCodeArticle.addSelect(tableArt.getKey());
                    Where wMatchingCode = new Where((FieldRef)tableArt.getField("CODE"), "=", (Object)vals.getString("CODE"));
                    wMatchingCode = wMatchingCode.and(new Where((FieldRef)tableArt.getField("NOM"), "=", (Object)vals.getString("NOM")));
                    selMatchingCodeArticle.setWhere(wMatchingCode);
                    List<SQLRow> matchingArticles = SQLRowListRSH.execute(selMatchingCodeArticle, false, false);
                    if (matchingArticles.size() > 0) {
                        idArticle = matchingArticles.get(0).getID();
                    } else {
                        SQLRow rowNew = vals.insert();
                        idArticle = rowNew.getID();
                    }
                }
                return idArticle;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static boolean isArticleForCNExist(SQLRowValues row) {
        return ReferenceArticleSQLElement.isArticleMatchExist(row, false);
    }

    public static boolean isArticleForCNMExist(SQLRowValues row) {
        return ReferenceArticleSQLElement.isArticleMatchExist(row, true);
    }

    private static boolean isArticleMatchExist(SQLRowValues row, boolean includeMetrique) {
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(sqlTableArticle);
        String req = ReferenceArticleSQLElement.getMatchRequest(row, includeMetrique);
        List result = (List)eltArticle.getTable().getBase().getDataSource().execute(req, new ArrayListHandler());
        return result != null && result.size() != 0;
    }

    private static String getMatchRequest(SQLRowValues row, boolean includeMetrique) {
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(sqlTableArticle);
        SQLSelect sel = new SQLSelect(eltArticle.getTable().getBase());
        sel.addSelect(eltArticle.getTable().getField("ID"));
        Where w = new Where((FieldRef)eltArticle.getTable().getField("CODE"), "=", (Object)row.getString("CODE").trim());
        if (includeMetrique) {
            float value1 = ((Number)row.getObject("VALEUR_METRIQUE_1")).floatValue();
            float value2 = ((Number)row.getObject("VALEUR_METRIQUE_2")).floatValue();
            float value3 = ((Number)row.getObject("VALEUR_METRIQUE_3")).floatValue();
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_1"), "<=", (Object)new Float((double)value1 + 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_1"), ">=", (Object)new Float((double)value1 - 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_2"), "<=", (Object)new Float((double)value2 + 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_2"), ">=", (Object)new Float((double)value2 - 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_3"), "<=", (Object)new Float((double)value3 + 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_3"), ">=", (Object)new Float((double)value3 - 1.0E-5)));
        }
        sel.setWhere(w);
        return sel.asString();
    }

    public static boolean isReferenceEquals(SQLRowValues rowVals1, SQLRowValues rowVals2) {
        return rowVals1.getObject("CODE").equals(rowVals2.getObject("CODE")) && rowVals1.getString("VALEUR_METRIQUE_1").equals(rowVals2.getString("VALEUR_METRIQUE_1")) && rowVals1.getString("VALEUR_METRIQUE_2").equals(rowVals2.getString("VALEUR_METRIQUE_2")) && rowVals1.getString("VALEUR_METRIQUE_3").equals(rowVals2.getString("VALEUR_METRIQUE_3"));
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".ref";
    }
}

