/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import org.openconcerto.erp.core.sales.pos.io.DefaultTicketPrinter;

public class ESCSerialPrinter
extends DefaultTicketPrinter {
    private static final int GS = 29;
    private static final int ESC = 27;
    private String port;

    public ESCSerialPrinter(String port) {
        port = port.trim();
        if (port.endsWith(":")) {
            port = port.substring(0, port.length() - 1);
        }
        this.port = port;
    }

    @Override
    public void addToBuffer(String t) {
        this.addToBuffer(t, 0);
    }

    @Override
    public void addToBuffer(String t, int mode) {
        this.strings.add(t);
        this.modes.add(mode);
    }

    @Override
    public synchronized void openDrawer() throws Exception {
        SerialPort serialPort = this.getSerialPort();
        OutputStream out = serialPort.getOutputStream();
        boolean useESCP = false;
        if (useESCP) {
            out.write(27);
            out.write(112);
            out.write(0);
            out.write(100);
            out.write(100);
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            out.write(27);
            out.write(112);
            out.write(1);
            out.write(100);
            out.write(100);
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        out.write(16);
        out.write(20);
        out.write(1);
        out.write(0);
        out.write(2);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        out.write(16);
        out.write(20);
        out.write(1);
        out.write(1);
        out.write(2);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        out.close();
        serialPort.close();
    }

    @Override
    public synchronized void printBuffer() throws Exception {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        bOut.write(27);
        bOut.write(64);
        bOut.write(27);
        bOut.write(82);
        bOut.write(1);
        int size = this.strings.size();
        int i = 0;
        while (i < size) {
            int c;
            int k;
            String string = (String)this.strings.get(i);
            int mode = (Integer)this.modes.get(i);
            if (mode == 10) {
                bOut.write(29);
                bOut.write(72);
                bOut.write(2);
                bOut.write(29);
                bOut.write(119);
                bOut.write(2);
                bOut.write(29);
                bOut.write(104);
                bOut.write(60);
                bOut.write(29);
                bOut.write(107);
                bOut.write(4);
                k = 0;
                while (k < string.length()) {
                    c = string.charAt(k);
                    bOut.write(c);
                    ++k;
                }
                bOut.write(0);
            } else {
                if (mode == 0) {
                    bOut.write(27);
                    bOut.write(33);
                    bOut.write(0);
                } else if (mode == 1) {
                    bOut.write(27);
                    bOut.write(33);
                    bOut.write(8);
                } else if (mode == 2) {
                    bOut.write(29);
                    bOut.write(33);
                    bOut.write(17);
                }
                k = 0;
                while (k < string.length()) {
                    c = string.charAt(k);
                    if (c == 233) {
                        c = 130;
                    } else if (c == 232) {
                        c = 138;
                    } else if (c == 234) {
                        c = 136;
                    } else if (c == 249) {
                        c = 151;
                    } else if (c == 224) {
                        c = 133;
                    } else if (c == 231) {
                        c = 135;
                    } else if (c == 244) {
                        c = 147;
                    }
                    bOut.write(c);
                    ++k;
                }
            }
            bOut.write(10);
            ++i;
        }
        bOut.write(10);
        bOut.write(10);
        bOut.write(10);
        bOut.write(10);
        bOut.write(29);
        bOut.write(86);
        bOut.write(1);
        SerialPort serialPort = this.getSerialPort();
        OutputStream out = serialPort.getOutputStream();
        out.write(bOut.toByteArray());
        out.close();
        serialPort.close();
    }

    private SerialPort getSerialPort() throws Exception {
        if (this.port == null || this.port.length() == 0) {
            throw new IllegalStateException("Invalid serial port name: " + this.port);
        }
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(this.port);
        if (portIdentifier.isCurrentlyOwned()) {
            throw new IllegalAccessError("Port " + this.port + " is currently in use");
        }
        int timeOutMs = 2000;
        CommPort commPort = portIdentifier.open("ESCSerialPrinter", 2000);
        if (!(commPort instanceof SerialPort)) {
            throw new IllegalStateException("Invalid serial port: " + this.port);
        }
        SerialPort serialPort = (SerialPort)commPort;
        serialPort.setSerialPortParams(9600, 8, 1, 0);
        return serialPort;
    }

    public static void main(String[] args) {
        ESCSerialPrinter.listPorts();
        ESCSerialPrinter prt = new ESCSerialPrinter("COM1");
        prt.setPort(ESCSerialPrinter.getSerialPortNames().get(0));
        prt.addToBuffer("ILM INFORMATIQUE", 2);
        prt.addToBuffer("");
        prt.addToBuffer("22 place de la liberation");
        prt.addToBuffer("80100 ABBEVILLE");
        prt.addToBuffer("T\u00e9l: 00 00 00 00 00");
        prt.addToBuffer("Fax: 00 00 00 00 00");
        prt.addToBuffer("");
        SimpleDateFormat df = new SimpleDateFormat("EEEE d MMMM yyyy \u00e0 HH:mm");
        prt.addToBuffer(ESCSerialPrinter.formatRight(45, "Le " + df.format(Calendar.getInstance().getTime())));
        prt.addToBuffer("");
        prt.addToBuffer(String.valueOf(ESCSerialPrinter.formatRight(5, "3")) + " " + ESCSerialPrinter.formatLeft(30, "ILM Informatique") + " " + ESCSerialPrinter.formatRight(8, "3.00"));
        prt.addToBuffer("      =======================================");
        prt.addToBuffer(String.valueOf(ESCSerialPrinter.formatRight(37, "Total")) + ESCSerialPrinter.formatRight(8, "3.00"), 1);
        prt.addToBuffer("");
        prt.addToBuffer("Merci de votre visite, \u00e0 bient\u00f4t.");
        prt.addToBuffer("");
        prt.addToBuffer("01 05042010 00002", 10);
        try {
            prt.printBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPort(String string) {
        this.port = string;
    }

    public static void listPorts() {
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            System.out.println("Port: " + portIdentifier.getName() + " Type: " + ESCSerialPrinter.getPortTypeName(portIdentifier.getPortType()));
        }
    }

    private static List<String> getSerialPortNames() {
        ArrayList<String> r = new ArrayList<String>();
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            System.out.println("Port: " + portIdentifier.getName() + " Type: " + ESCSerialPrinter.getPortTypeName(portIdentifier.getPortType()));
            if (portIdentifier.getPortType() != 1) continue;
            r.add(portIdentifier.getName());
        }
        return r;
    }

    private static String getPortTypeName(int portType) {
        switch (portType) {
            case 3: {
                return "I2C";
            }
            case 2: {
                return "Parallel";
            }
            case 5: {
                return "Raw";
            }
            case 4: {
                return "RS485";
            }
            case 1: {
                return "Serial";
            }
        }
        return "unknown type";
    }
}

