/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.ITextArea;

public class BarcodeReader
implements KeyEventDispatcher {
    public int maxInterKeyDelay = 80;
    private static final int MIN_BARCODE_LENGTH = 2;
    private final List<BarcodeListener> listeners = new ArrayList<BarcodeListener>(1);
    private String value = "";
    private final List<KeyEvent> eve = new ArrayList<KeyEvent>();
    private long firstTime = -1L;
    private Timer timer = null;
    private TimerTask task = null;

    public BarcodeReader(int maxInterKeyDelay) {
        this.maxInterKeyDelay = maxInterKeyDelay;
    }

    public synchronized void removeBarcodeListener(BarcodeListener l) {
        this.listeners.remove(l);
        if (this.listeners.size() == 0) {
            this.stop();
        }
    }

    public synchronized void addBarcodeListener(BarcodeListener l) {
        if (this.timer == null) {
            this.start();
        }
        this.listeners.add(l);
    }

    private void fire(String code) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).barcodeRead(code);
            ++i;
        }
    }

    public void start() {
        this.timer = new Timer(this.getClass().getName(), true);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.task != null) {
            this.task.cancel();
        }
        long t = e.getWhen();
        if (this.firstTime < 0L) {
            this.firstTime = t;
        }
        int key = e.getKeyCode();
        if (t - this.firstTime > (long)this.maxInterKeyDelay && key != 16) {
            this.redispatch();
        }
        char key2 = e.getKeyChar();
        this.eve.add(e);
        if (key != 0 && e.getID() == 402) {
            if (key != 16) {
                if (key2 == '*' || key2 == '$' || key2 == '+' || key2 == '/' || key2 == '%' || key2 == '-' | key2 == ' ') {
                    this.value = String.valueOf(this.value) + key2;
                } else if (key >= 48 && key <= 57 || key >= 65 && key <= 90) {
                    this.value = String.valueOf(this.value) + (char)key;
                } else if (key == 10 && this.value.length() >= 2) {
                    this.value = this.value.trim();
                    this.fire(this.value);
                    this.reset();
                } else {
                    this.redispatch();
                }
            }
            if (this.eve.size() > 0) {
                this.firstTime = t;
                this.task = new TimerTask(){

                    @Override
                    public void run() {
                        BarcodeReader.this.redispatchLater();
                    }
                };
                this.timer.schedule(this.task, this.maxInterKeyDelay);
            }
            assert (this.eve.size() > 0 || this.firstTime == -1L);
        }
        return true;
    }

    private void redispatchLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BarcodeReader.this.redispatch();
            }
        });
    }

    private void redispatch() {
        int i = 0;
        while (i < this.eve.size()) {
            KeyEvent ee = this.eve.get(i);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(ee.getComponent(), ee);
            int j = 0;
            while (j < this.listeners.size()) {
                this.listeners.get(j).keyReceived(ee);
                ++j;
            }
            ++i;
        }
        this.reset();
    }

    private void reset() {
        this.value = "";
        this.eve.clear();
        this.firstTime = -1L;
    }

    public static void main(String[] args) {
        String delay = "80";
        if (args.length > 0) {
            delay = args[0];
        }
        final int d = Integer.parseInt(delay);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("BarCode reader");
                System.out.println("Using inter key delay: " + d);
                JFrame f = new JFrame();
                f.setDefaultCloseOperation(3);
                JPanel panel = new JPanel();
                f.setTitle("Barcode reader test");
                f.setContentPane(panel);
                panel.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel l = new JLabel("BarCode reader output :");
                panel.add((Component)l, c);
                ++c.gridy;
                c.weighty = 1.0;
                c.weightx = 1.0;
                c.fill = 1;
                final ITextArea t1 = new ITextArea();
                panel.add((Component)new JScrollPane(t1), c);
                BarcodeReader reader = new BarcodeReader(d);
                reader.addBarcodeListener(new BarcodeListener(){

                    @Override
                    public void keyReceived(KeyEvent ee) {
                        System.err.println("BarcodeReader keyReceived() : " + ee);
                    }

                    @Override
                    public void barcodeRead(String code) {
                        t1.append("Barcode OK : '" + code + "'\n");
                    }
                });
                f.setSize(new Dimension(640, 480));
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }
        });
    }
}

