/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.account;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.AbstractVenteArticleItemTable;
import org.openconcerto.erp.core.common.ui.Acompte;
import org.openconcerto.erp.core.common.ui.AcompteField;
import org.openconcerto.erp.core.sales.account.VenteFactureSituationSQLComponent;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.erp.core.sales.invoice.ui.FactureSituationItemTable;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.ui.group.Group;
import org.openconcerto.utils.Tuple2;

public class VenteFactureSoldeSQLComponent
extends VenteFactureSituationSQLComponent {
    public static final String ID = "sales.invoice.partial.balance";

    public VenteFactureSoldeSQLComponent(SQLElement element) {
        super(element, (Group)GlobalMapper.getInstance().get(ID));
    }

    @Override
    protected void addViews() {
        super.addViews();
        this.getEditor("sales.invoice.partial.amount").setEnabled(false);
        JCheckBox box = new JCheckBox("Solde");
        box.setSelected(true);
        this.addView(box, "SOLDE");
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, new Date()));
        rowVals.put("SOLDE", Boolean.TRUE);
        return rowVals;
    }

    @Override
    public int insert(SQLRow order) {
        return super.insert(order);
    }

    @Override
    public void importFrom(List<SQLRowValues> rows) {
        super.importFrom(rows);
        AcompteField field = (AcompteField)this.getEditor("sales.invoice.partial.amount");
        Tuple2<Long, Long> t = this.getTotalFacture(rows);
        Acompte a = new Acompte(null, new BigDecimal(t.get0() - t.get1()).movePointLeft(2));
        field.setValue(a);
        FactureSituationItemTable table = (FactureSituationItemTable)this.getEditor("sales.invoice.partial.items.list");
        table.calculPourcentage(a, AbstractVenteArticleItemTable.TypeCalcul.CALCUL_FACTURABLE);
    }

    public Tuple2<Long, Long> getTotalFacture(List<SQLRowValues> context) {
        long totalFacture = 0L;
        long totalCommande = 0L;
        HashSet<SQLRowAccessor> facture = new HashSet<SQLRowAccessor>();
        for (SQLRowAccessor sQLRowAccessor : context) {
            totalFacture += this.getFacture(sQLRowAccessor, facture);
            totalCommande += sQLRowAccessor.getLong("T_HT");
        }
        return Tuple2.create(totalCommande, totalFacture);
    }

    public long getFacture(SQLRowAccessor sqlRowAccessor, Set<SQLRowAccessor> alreadyAdded) {
        Collection<? extends SQLRowAccessor> rows = sqlRowAccessor.getReferentRows(sqlRowAccessor.getTable().getTable("TR_COMMANDE_CLIENT"));
        long l = 0L;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            SQLRowAccessor rowFacture;
            if (sQLRowAccessor.isForeignEmpty("ID_SAISIE_VENTE_FACTURE") || alreadyAdded.contains(rowFacture = sQLRowAccessor.getForeign("ID_SAISIE_VENTE_FACTURE"))) continue;
            alreadyAdded.add(rowFacture);
            l += rowFacture.getLong("T_HT");
        }
        return l;
    }
}

