/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.reports.history.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.ListeGestCommEltPanel;
import org.openconcerto.erp.core.finance.accounting.ui.SuppressionEcrituresPanel;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureElementXmlSheet;
import org.openconcerto.erp.core.sales.quote.ui.EtatDevisRenderer;
import org.openconcerto.erp.generationDoc.AbstractSheetXml;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.users.rights.JListSQLTablePanel;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;

public class ListeHistoriquePanel
extends JPanel {
    private final Vector<IListPanel> vectListePanel = new Vector();
    private Map<Integer, List<TableModelListener>> mapListener = new HashMap<Integer, List<TableModelListener>>();
    private JListSQLTablePanel jListePanel;
    private Map<SQLTable, SQLField> listFieldMap = new HashMap<SQLTable, SQLField>();
    private Map<String, Where> whereList = new HashMap<String, Where>();
    private static Map<SQLElement, Class<? extends AbstractSheetXml>> elementSheet = new HashMap<SQLElement, Class<? extends AbstractSheetXml>>();
    private String undefinedLabel;
    private final ListSelectionListener listListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e != null && e.getValueIsAdjusting()) {
                return;
            }
            int selectIndex = ListeHistoriquePanel.this.jListePanel.getSelectedIndex();
            SQLRowAccessor row = ListeHistoriquePanel.this.jListePanel.getModel().getRowAt(selectIndex);
            if ((row == null || row.isUndefined()) && ListeHistoriquePanel.this.undefinedLabel == null) {
                return;
            }
            int id = -1;
            if (row != null) {
                id = row.getID();
            }
            int i = 0;
            while (i < ListeHistoriquePanel.this.vectListePanel.size()) {
                IListPanel liste = (IListPanel)ListeHistoriquePanel.this.vectListePanel.get(i);
                if (ListeHistoriquePanel.this.mapListener.get(i) != null) {
                    List l = (List)ListeHistoriquePanel.this.mapListener.get(i);
                    for (TableModelListener listener : l) {
                        liste.getListe().getTableModel().removeTableModelListener(listener);
                    }
                }
                Where w = null;
                SQLTable table = liste.getElement().getTable();
                for (String key : ListeHistoriquePanel.this.whereList.keySet()) {
                    Where wTmp = (Where)ListeHistoriquePanel.this.whereList.get(key);
                    if (!liste.getListe().getRequest().getAllFields().containsAll(wTmp.getFields())) continue;
                    w = w == null ? wTmp : w.and(wTmp);
                }
                if (id > 1) {
                    if (ListeHistoriquePanel.this.listFieldMap != null && ListeHistoriquePanel.this.listFieldMap.get(table) != null) {
                        SQLField field = (SQLField)ListeHistoriquePanel.this.listFieldMap.get(table);
                        Where w2 = new Where((FieldRef)field, "=", table.getForeignTable(field.getName()).getKey());
                        w2 = w2.and(new Where((FieldRef)table.getForeignTable(field.getName()).getField("ID_" + ListeHistoriquePanel.this.jListePanel.getModel().getTable().getName()), "=", id));
                        liste.getListe().getRequest().setWhere(w2.and(w));
                    } else if (liste.getElement().getTable().equals(ListeHistoriquePanel.this.jListePanel.getModel().getTable())) {
                        liste.getListe().getRequest().setWhere(new Where((FieldRef)table.getKey(), "=", id).and(w));
                    } else {
                        liste.getListe().getRequest().setWhere(new Where((FieldRef)table.getField("ID_" + ListeHistoriquePanel.this.jListePanel.getModel().getTable().getName()), "=", id).and(w));
                    }
                } else {
                    liste.getListe().getRequest().setWhere(w);
                }
                liste.getListe().setSQLEditable(false);
                ListeHistoriquePanel.this.setRenderer(liste);
                if (ListeHistoriquePanel.this.mapListener.get(i) != null) {
                    List l = (List)ListeHistoriquePanel.this.mapListener.get(i);
                    for (TableModelListener listener : l) {
                        liste.getListe().getTableModel().addTableModelListener(listener);
                        if (elementSheet.get(liste.getElement()) == null) continue;
                        liste.getListe().addIListeActions(new MouseSheetXmlListeListener((Class)elementSheet.get(liste.getElement())).getRowActions());
                    }
                }
                ++i;
            }
        }
    };

    static {
        SQLElementDirectory dir = Configuration.getInstance().getDirectory();
        elementSheet.put(dir.getElement("SAISIE_VENTE_FACTURE_ELEMENT"), VenteFactureElementXmlSheet.class);
    }

    public ListeHistoriquePanel(String title, ComboSQLRequest req, Map<String, List<String>> listTableOnglet, JPanel panelBottom, Map<SQLTable, SQLField> listFieldMap, Where where) {
        this(title, req, listTableOnglet, panelBottom, listFieldMap, "Tous", where);
    }

    public ListeHistoriquePanel(String title, ComboSQLRequest req, Map<String, List<String>> listTableOnglet, JPanel panelBottom, Map<SQLTable, SQLField> listFieldMap, String undefinedLabel, Where where) {
        this(title, req, listTableOnglet, panelBottom, listFieldMap, undefinedLabel, false, where, null);
    }

    public ListeHistoriquePanel(String title, ComboSQLRequest req, Map<String, List<String>> listTableOnglet, JPanel panelBottom, Map<SQLTable, SQLField> listFieldMap, String undefinedLabel, boolean sourceWithOutTransformer, Where where, SQLTableModelSourceOnline tableSource) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 1, 2);
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.listFieldMap = listFieldMap;
        JTabbedPane tabbedPane = new JTabbedPane();
        for (String key : listTableOnglet.keySet()) {
            List<String> listPanelTable = listTableOnglet.get(key);
            JPanel tabbedPanel = new JPanel(new GridBagLayout());
            tabbedPanel.setOpaque(false);
            DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
            c2.fill = 1;
            c2.weightx = 1.0;
            c2.weighty = 1.0;
            c2.gridy = -1;
            int i = 0;
            while (i < listPanelTable.size()) {
                final SQLElement elt = Configuration.getInstance().getDirectory().getElement(listPanelTable.get(i));
                SQLTableModelSourceOnline createTableSource = tableSource == null ? elt.getTableSource(true) : tableSource;
                ListSQLRequest request = createTableSource.getReq();
                if (sourceWithOutTransformer) {
                    request.setSelectTransf(null);
                }
                if (where != null && request.getAllFields().containsAll(where.getFields())) {
                    request.setWhere(where);
                }
                ListeAddPanel liste = elt.getTable().contains("ID_MOUVEMENT") ? new ListeGestCommEltPanel(elt, new IListe(createTableSource), "historique-" + title){

                    @Override
                    protected void handleAction(JButton source, ActionEvent evt) {
                        if (elt.getTable().contains("ID_MOUVEMENT")) {
                            SQLRow row = this.getListe().fetchSelectedRow();
                            if (source == this.buttonModifier) {
                                MouvementSQLElement.showSource(row.getInt("ID_MOUVEMENT"));
                            } else if (source == this.buttonEffacer) {
                                PanelFrame f = new PanelFrame(new SuppressionEcrituresPanel(row.getInt("ID_MOUVEMENT")), "Suppresion d'une pi\u00e8ce");
                                f.setLocationRelativeTo(null);
                                f.setResizable(false);
                                f.setVisible(true);
                            } else {
                                super.handleAction(source, evt);
                            }
                        } else {
                            super.handleAction(source, evt);
                        }
                    }
                } : new ListeAddPanel(elt, new IListe(createTableSource), "historique-" + title){

                    @Override
                    protected void handleAction(JButton source, ActionEvent evt) {
                        if (source == this.buttonAjouter) {
                            SQLTable table;
                            Set<SQLField> fields;
                            int selectIndex = ListeHistoriquePanel.this.jListePanel.getSelectedIndex();
                            SQLRowAccessor row = ListeHistoriquePanel.this.jListePanel.getModel().getRowAt(selectIndex);
                            if (row != null && !row.isUndefined() && (fields = (table = this.getCreateFrame().getSQLComponent().getElement().getTable()).getForeignKeys(ListeHistoriquePanel.this.jListePanel.getModel().getTable())) != null && fields.size() > 0) {
                                SQLRowValues rowVals = new SQLRowValues(table);
                                rowVals.put(((SQLField)fields.toArray()[0]).getName(), row.getID());
                                this.getCreateFrame().getSQLComponent().resetValue();
                                this.getCreateFrame().getSQLComponent().select(rowVals);
                            }
                            FrameUtil.show(this.getCreateFrame());
                        } else {
                            super.handleAction(source, evt);
                        }
                    }
                };
                this.vectListePanel.add(liste);
                this.setRenderer(liste);
                if (elementSheet.get(liste.getElement()) != null) {
                    liste.getListe().addIListeActions(new MouseSheetXmlListeListener(elementSheet.get(liste.getElement())).getRowActions());
                }
                liste.getListe().setSQLEditable(false);
                liste.setOpaque(false);
                liste.setBorder(null);
                liste.getListe().getModel().setHibernateDelay(-1);
                if (listPanelTable.size() > 1) {
                    Font f = UIManager.getFont("TitledBorder.font");
                    f = f.deriveFont(1);
                    Border b = UIManager.getBorder("TitledBorder.border");
                    b = BorderFactory.createLineBorder(Color.BLACK);
                    liste.setBorder(BorderFactory.createTitledBorder(b, elt.getPluralName(), 4, 0, f));
                }
                tabbedPanel.add((Component)liste, c2);
                ++i;
            }
            tabbedPane.add(key, tabbedPanel);
        }
        this.undefinedLabel = undefinedLabel;
        this.jListePanel = new JListSQLTablePanel(req, undefinedLabel);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new GridBagLayout());
        DefaultGridBagConstraints cRight = new DefaultGridBagConstraints();
        cRight.fill = 1;
        cRight.weightx = 1.0;
        cRight.weighty = 1.0;
        rightPanel.add((Component)tabbedPane, cRight);
        if (panelBottom != null) {
            cRight.fill = 2;
            cRight.weightx = 1.0;
            cRight.weighty = 0.0;
            ++cRight.gridy;
            panelBottom.setBorder(BorderFactory.createTitledBorder("R\u00e9capitulatif"));
            rightPanel.add((Component)panelBottom, cRight);
        }
        JSplitPane split = new JSplitPane(1, this.jListePanel, rightPanel);
        split.setBorder(null);
        split.setDividerLocation(275);
        this.add((Component)split, c);
        JButton buttonClose = new JButton("Fermer");
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)buttonClose, c);
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ((JFrame)SwingUtilities.getRoot(ListeHistoriquePanel.this)).dispose();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ListeHistoriquePanel.this.jListePanel.addListSelectionListener(ListeHistoriquePanel.this.listListener);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                ListeHistoriquePanel.this.jListePanel.removeListSelectionListener(ListeHistoriquePanel.this.listListener);
            }
        });
    }

    public void selectIDinJList(int id) {
        this.jListePanel.selectID(id);
    }

    private void setRenderer(IListPanel liste) {
        SQLElement propositionItemElement = Configuration.getInstance().getDirectory().getElement("PROPOSITION_ELEMENT");
        SQLElement devisElement = Configuration.getInstance().getDirectory().getElement("DEVIS");
        JTable table = liste.getListe().getJTable();
        DefaultTableCellRenderer rend = null;
        rend = liste.getElement().getClass() == devisElement.getClass() ? new EtatDevisRenderer() : new DeviseNiceTableCellRenderer();
        int j = 0;
        while (j < table.getColumnCount()) {
            if (rend instanceof EtatDevisRenderer) {
                table.getColumnModel().getColumn(j).setCellRenderer(rend);
            } else if (table.getColumnClass(j) == Long.class || table.getColumnClass(j) == BigInteger.class) {
                table.getColumnModel().getColumn(j).setCellRenderer(rend);
            }
            ++j;
        }
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.jListePanel.addListSelectionListener(l);
        System.out.println("ListeHistoriquePanel.addListSelectionListener()" + this.jListePanel);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.jListePanel.removeListSelectionListener(l);
    }

    public SQLRowAccessor getSelectedRow() {
        return this.jListePanel.getModel().getRowAt(this.jListePanel.getSelectedIndex());
    }

    public void addWhere(String key, Where w) {
        this.whereList.put(key, w);
        this.listListener.valueChanged(null);
    }

    public void removeWhere(String key) {
        this.whereList.remove(key);
        this.listListener.valueChanged(null);
    }

    public void removeAllWhere() {
        for (String key : this.whereList.keySet()) {
            this.whereList.remove(key);
        }
        this.listListener.valueChanged(null);
    }

    public Map<String, Where> getWhere() {
        return this.whereList;
    }

    public List<Integer> getListId(String tableName) {
        IListe liste = this.getIListeFromTableName(tableName);
        List<Integer> listeIds = null;
        if (liste != null) {
            int size = liste.getRowCount();
            listeIds = new ArrayList<Integer>(size);
            int i = 0;
            while (i < size) {
                listeIds.add(liste.idFromIndex(i));
                ++i;
            }
        } else {
            listeIds = Collections.emptyList();
        }
        return listeIds;
    }

    public void removeAllTableListener() {
        this.jListePanel.removeAllTableListener();
        for (Integer i : this.mapListener.keySet()) {
            IListPanel panel = this.vectListePanel.get(i);
            List<TableModelListener> l = this.mapListener.get(i);
            for (TableModelListener tableModelListener : l) {
                TableModel tableModel;
                IListe liste = panel.getListe();
                if (liste == null || (tableModel = liste.getTableModel()) == null) continue;
                tableModel.removeTableModelListener(tableModelListener);
            }
        }
    }

    public void addListenerTable(TableModelListener listener, String tableName) {
        IListe liste = this.getIListeFromTableName(tableName);
        int index = this.getIndexFromTableName(tableName);
        if (liste != null) {
            liste.addListener(listener);
            List<TableModelListener> l = this.mapListener.get(index);
            if (l == null) {
                l = new ArrayList<TableModelListener>();
                this.mapListener.put(index, l);
            }
            l.add(listener);
        }
    }

    public IListe getIListeFromTableName(String tableName) {
        IListPanel liste = this.getIListePanelFromTableName(tableName);
        if (liste == null) {
            return null;
        }
        return liste.getListe();
    }

    public IListPanel getIListePanelFromTableName(String tableName) {
        IListPanel liste = null;
        int size = this.vectListePanel.size();
        int i = 0;
        while (i < size) {
            ITableModel model;
            IListe list;
            IListPanel listeTmp = this.vectListePanel.get(i);
            if (listeTmp != null && (list = listeTmp.getListe()) != null && (model = list.getModel()) != null && model.getTable().getName().equalsIgnoreCase(tableName)) {
                liste = listeTmp;
            }
            ++i;
        }
        return liste;
    }

    private int getIndexFromTableName(String tableName) {
        int size = this.vectListePanel.size();
        int i = 0;
        while (i < size) {
            IListPanel listeTmp = this.vectListePanel.get(i);
            String name = listeTmp.getListe().getModel().getTable().getName();
            if (name.equalsIgnoreCase(tableName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public IListe getListe(int index) {
        return this.vectListePanel.get(index).getListe();
    }

    public void fireListesChanged() {
        int size = this.vectListePanel.size();
        int i = 0;
        while (i < size) {
            IListPanel listeTmp = this.vectListePanel.get(i);
            ITableModel model = listeTmp.getListe().getModel();
            model.fireTableDataChanged();
            model.fireTableStructureChanged();
            ++i;
        }
    }
}

