/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.payment.element.ChequeType;
import org.openconcerto.erp.model.GestionChequesModel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.cc.IPredicate;

abstract class ChequeListPanel
extends ListeAddPanel {
    private GestionChequesModel model;
    private JLabel labelDepot;
    private JLabel labelMontant;
    private JCheckBox checkImpression;
    private JButton boutonValide;

    protected ChequeListPanel(SQLElement elem) {
        super(elem, new IListe(((ChequeType)((Object)elem)).createDepositTableSource()));
        this.setReadWriteButtonsVisible(false);
        this.getListe().setSQLEditable(false);
        this.model = new GestionChequesModel(this.getListe(), (ChequeType)((Object)elem));
        this.model.addSelectionListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ChequeListPanel.this.setLabels();
            }
        });
        this.actionDroitTable();
        this.model.selectionDecaisseAll();
    }

    protected JPanel createBottomPanel() {
        JPanel res = new JPanel();
        res.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.labelDepot = new JLabel(this.getDepositLabel());
        res.add((Component)this.labelDepot, c);
        ++c.gridx;
        JDate dateDepot = new JDate();
        dateDepot.setValue(new Date());
        res.add((Component)dateDepot, c);
        ++c.gridx;
        this.labelMontant = new JLabel("");
        res.add((Component)this.labelMontant, c);
        JButton printPreview = this.createPreviewBtn();
        ++c.gridx;
        if (printPreview != null) {
            printPreview.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChequeListPanel.this.getModel().printPreview();
                }
            });
            res.add((Component)printPreview, c);
        }
        JButton boutonSelectAll = new JButton("S\u00e9lectionner tous les ch\u00e8ques");
        boutonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChequeListPanel.this.getModel().selectionDecaisseAll();
            }
        });
        ++c.gridx;
        res.add((Component)boutonSelectAll, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        if (this.hasPrint()) {
            this.checkImpression = new JCheckBox("Impression du relev\u00e9");
            this.checkImpression.setSelected(true);
            res.add((Component)this.checkImpression, c);
        }
        ++c.gridx;
        JTextComponent text = this.createLabelText();
        if (text != null) {
            c.fill = 0;
            JLabelBold labelLib = new JLabelBold("Libell\u00e9 des \u00e9critures");
            res.add((Component)labelLib, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 2;
            c.gridwidth = 2;
            res.add((Component)text, c);
            c.gridx += c.gridwidth;
            c.weightx = 0.0;
            c.gridwidth = 1;
        } else {
            c.gridx += 3;
        }
        this.boutonValide = this.createSubmitBtn(dateDepot, this.checkImpression, text);
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        res.add((Component)this.boutonValide, c);
        return res;
    }

    protected JButton createPreviewBtn() {
        return null;
    }

    protected boolean hasPrint() {
        return true;
    }

    protected JTextComponent createLabelText() {
        return null;
    }

    protected abstract JButton createSubmitBtn(JDate var1, JCheckBox var2, JTextComponent var3);

    @Override
    protected final void addComponents(Container container, GridBagConstraints c) {
        super.addComponents(container, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        container.add((Component)this.createBottomPanel(), c);
    }

    public final GestionChequesModel getModel() {
        return this.model;
    }

    protected void actionDroitTable() {
        AbstractAction actionSource = new AbstractAction("Voir la source"){
            private EditFrame edit;
            {
                this.edit = null;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow rowCheque = IListe.get(e).fetchSelectedRow();
                int idMouvement = rowCheque.getInt("ID_MOUVEMENT");
                if (idMouvement > 1) {
                    MouvementSQLElement.showSource(idMouvement);
                } else {
                    if (this.edit == null) {
                        this.edit = new EditFrame(ChequeListPanel.this.getElement(), EditFrame.MODIFICATION);
                        this.edit.pack();
                    }
                    this.edit.selectionId(rowCheque.getID());
                    this.edit.setVisible(true);
                }
            }
        };
        this.getListe().addRowAction(actionSource);
        this.getListe().addIListeAction(new RowAction.PredicateRowAction((Action)new AbstractAction("S\u00e9lectionner tout"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChequeListPanel.this.model.selectionDecaisseAll();
            }
        }, false, true).setPredicate(IPredicate.truePredicate()));
        this.getListe().addIListeAction(new RowAction.PredicateRowAction((Action)new AbstractAction("D\u00e9s\u00e9lectionner tout"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChequeListPanel.this.model.deselectionAll();
            }
        }, false, true).setPredicate(IPredicate.truePredicate()));
    }

    protected abstract String getDepositLabel();

    private void setLabels() {
        int nbChq = this.getModel().getNbChequeSelected();
        if (nbChq == 0) {
            this.labelDepot.setText(this.getDepositLabel());
            this.labelMontant.setText("");
            this.boutonValide.setVisible(false);
        } else {
            long montantTot = this.getModel().getMontantTotalSelected();
            this.boutonValide.setVisible(true);
            if (nbChq == 1) {
                this.labelDepot.setText("D\u00e9pot de " + nbChq + " ch\u00e9que, en date du ");
            } else {
                this.labelDepot.setText("D\u00e9pot de " + nbChq + " ch\u00e9ques, en date du ");
            }
            this.labelMontant.setText(", pour un montant total de " + GestionDevise.currencyToString(montantTot) + " \u20ac");
        }
        if (this.hasPrint()) {
            this.checkImpression.setVisible(nbChq > 0);
        }
    }
}

