/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;

public class CompteCloturePreferencePanel
extends DefaultPreferencePanel {
    private ISQLCompteSelector selCompteOuverture;
    private ISQLCompteSelector selCompteFermeture;
    private ISQLCompteSelector selCompteResultat;
    private ISQLCompteSelector selCompteResultatPerte;
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private SQLRowValues rowPrefCompteVals = new SQLRowValues(tablePrefCompte);

    public CompteCloturePreferencePanel() {
        SQLRow rowPrefCompte = tablePrefCompte.getRow(2);
        this.rowPrefCompteVals.loadAbsolutelyAll(rowPrefCompte);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)new JLabel("Compte bilan d'ouverture"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteOuverture = new ISQLCompteSelector();
        this.selCompteOuverture.init();
        this.add((Component)this.selCompteOuverture, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Compte bilan de cl\u00f4ture"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteFermeture = new ISQLCompteSelector();
        this.selCompteFermeture.init();
        this.add((Component)this.selCompteFermeture, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Compte de r\u00e9sultat (b\u00e9n\u00e9fice)"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteResultat = new ISQLCompteSelector();
        this.selCompteResultat.init();
        this.add((Component)this.selCompteResultat, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Compte de r\u00e9sultat (perte)"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteResultatPerte = new ISQLCompteSelector();
        this.selCompteResultatPerte.init();
        this.add((Component)this.selCompteResultatPerte, c);
        JPanel p = new JPanel();
        p.setOpaque(false);
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)p, c);
        this.setValues();
    }

    @Override
    public void storeValues() {
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_BILAN_O", this.selCompteOuverture.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_BILAN_F", this.selCompteFermeture.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_RESULTAT", this.selCompteResultat.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_RESULTAT_PERTE", this.selCompteResultat.getValue());
        try {
            this.rowPrefCompteVals.update();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void restoreToDefaults() {
        try {
            String compte = ComptePCESQLElement.getComptePceDefault("BilanOuverture");
            int value = ComptePCESQLElement.getId(compte);
            this.selCompteOuverture.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("BilanFermeture");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteFermeture.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("Resultat");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteResultat.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("ResultatPerte");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteResultatPerte.setValue(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getTitleName() {
        return "Cl\u00f4ture";
    }

    private void setValues() {
        try {
            SQLRowAccessor rowBilanO = this.rowPrefCompteVals.getForeign("ID_COMPTE_PCE_BILAN_O");
            int value = 1;
            if (rowBilanO == null || rowBilanO.isUndefined()) {
                String compte = ComptePCESQLElement.getComptePceDefault("BilanOuverture");
                value = ComptePCESQLElement.getId(compte);
            } else {
                value = rowBilanO.getID();
            }
            this.selCompteOuverture.setValue(value);
            SQLRowAccessor rowBilanF = this.rowPrefCompteVals.getForeign("ID_COMPTE_PCE_BILAN_F");
            if (rowBilanF == null || rowBilanF.isUndefined()) {
                String compte = ComptePCESQLElement.getComptePceDefault("BilanFermeture");
                value = ComptePCESQLElement.getId(compte);
            } else {
                value = rowBilanF.getID();
            }
            this.selCompteFermeture.setValue(value);
            SQLRowAccessor rowResultat = this.rowPrefCompteVals.getForeign("ID_COMPTE_PCE_RESULTAT");
            if (rowResultat == null || rowResultat.isUndefined()) {
                String compte = ComptePCESQLElement.getComptePceDefault("Resultat");
                value = ComptePCESQLElement.getId(compte);
            } else {
                value = rowResultat.getID();
            }
            this.selCompteResultat.setValue(value);
            SQLRowAccessor rowResultatP = this.rowPrefCompteVals.getForeign("ID_COMPTE_PCE_RESULTAT_PERTE");
            if (rowResultatP == null || rowResultatP.isUndefined()) {
                String compte = ComptePCESQLElement.getComptePceDefault("ResultatPerte");
                value = ComptePCESQLElement.getId(compte);
            } else {
                value = rowResultatP.getID();
            }
            this.selCompteResultatPerte.setValue(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

