/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import org.openconcerto.erp.core.finance.accounting.ui.CompteCellRenderer;
import org.openconcerto.utils.GestionDevise;

public class BalanceCellRenderer
extends CompteCellRenderer {
    private int colNumeroCompte;

    public BalanceCellRenderer(int colNumeroCompte) {
        this.colNumeroCompte = colNumeroCompte;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String numeroCompte = table.getValueAt(row, this.colNumeroCompte).toString().trim();
        String numeroCompteSuiv = null;
        if (row < table.getRowCount() - 1) {
            numeroCompteSuiv = table.getValueAt(row + 1, this.colNumeroCompte).toString().trim();
        }
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!isSelected) {
            int length = numeroCompte.length();
            if (length == 1) {
                this.setBackground(couleurCompteClasse);
                this.setForeground(Color.BLACK);
            } else if (numeroCompteSuiv != null && length < numeroCompteSuiv.length() && numeroCompte.equalsIgnoreCase(numeroCompteSuiv.substring(0, length))) {
                if (length == 2) {
                    this.setBackground(couleurCompte2);
                    this.setForeground(Color.BLACK);
                } else if (length == 3) {
                    this.setBackground(couleurCompte3);
                    this.setForeground(Color.BLACK);
                } else {
                    this.setBackground(couleurCompteRacine);
                    this.setForeground(Color.BLACK);
                }
            } else {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
            }
        }
        if (value != null && value.getClass() == Long.class) {
            this.setText(GestionDevise.currencyToString((Long)value));
        }
        return this;
    }
}

