/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.cc.ITransformer;

public class VentilationAnalytiqueSheetXML
extends AbstractListeSheetXml {
    private static int debutFill;
    private static int endFill;
    protected static final SQLTable tableAssoc;
    protected static final SQLTable tablePoste;
    private static final SQLTable tableEcriture;
    private static final SQLTable tableJournal;
    private static final SQLTable tableMvt;
    private static final SQLTable tableCompte;
    private static final DateFormat dateFormat;
    private static final DateFormat dateFormatEcr;
    private SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
    private Date dateDu;
    private Date dateAu;
    private String compteDeb;
    private String compteEnd;
    private SQLRow rowPoste;
    public static String TEMPLATE_ID;
    public static String TEMPLATE_PROPERTY_NAME;
    Date date;
    private String toDay = dateFormat.format(new Date());
    private int size;

    static {
        tableAssoc = base.getTable("ASSOCIATION_ANALYTIQUE");
        tablePoste = base.getTable("POSTE_ANALYTIQUE");
        tableEcriture = base.getTable("ECRITURE");
        tableJournal = base.getTable("JOURNAL");
        tableMvt = base.getTable("MOUVEMENT");
        tableCompte = base.getTable("COMPTE_PCE");
        dateFormat = DateFormat.getDateInstance(2);
        dateFormatEcr = DateFormat.getDateInstance(3);
        TEMPLATE_ID = "VentilationAnalytique";
        TEMPLATE_PROPERTY_NAME = "LocationJournaux";
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getName() {
        if (this.date == null) {
            this.date = new Date();
        }
        return "VentilationAnalytique" + this.date.getTime();
    }

    @Override
    protected String getStoragePathP() {
        return "Ventilation Analytique";
    }

    public VentilationAnalytiqueSheetXML(Date du, Date au, SQLRow rowPoste) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(au);
        this.printer = PrinterNXProps.getInstance().getStringProperty("JournauxPrinter");
        this.dateAu = au;
        this.dateDu = du;
        this.rowPoste = rowPoste;
    }

    private void makeSousTotal(Map<String, Object> line, Map<Integer, String> style, int pos, long debit, long credit) {
        style.put(pos, "Titre 1");
        line.put("DATE", "");
        line.put("JOURNAL", "");
        line.put("MOUVEMENT", "");
        line.put("LIBELLE", "Sous total");
        line.put("DEBIT", Double.valueOf(GestionDevise.currencyToString(debit, false)));
        line.put("CREDIT", Double.valueOf(GestionDevise.currencyToString(credit, false)));
        line.put("SOLDE", Double.valueOf(GestionDevise.currencyToString(debit - credit, false)));
    }

    @Override
    protected void createListeValues() {
        SQLRowValues vals = new SQLRowValues(tableEcriture);
        vals.put("ID_JOURNAL", null);
        vals.put("ID_COMPTE_PCE", null);
        vals.put("COMPTE_NUMERO", null);
        vals.put("COMPTE_NOM", null);
        vals.put("JOURNAL_CODE", null);
        vals.put("JOURNAL_NOM", null);
        vals.putRowValues("ID_MOUVEMENT").put("NUMERO", null);
        vals.put("CREDIT", null);
        vals.put("DEBIT", null);
        vals.put("DATE", null);
        vals.put("NOM", null);
        SQLRowValues valsAnalytique = new SQLRowValues(tableAssoc);
        valsAnalytique.put("ID_ECRITURE", (Object)vals);
        valsAnalytique.putRowValues("ID_POSTE_ANALYTIQUE").put("NOM", null);
        valsAnalytique.put("POURCENT", null);
        valsAnalytique.put("MONTANT", null);
        valsAnalytique.put("ID_ECRITURE", (Object)vals);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(valsAnalytique);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                Where w = new Where(sel.getJoinFromField(tableAssoc.getField("ID_ECRITURE")).getJoinedTable().getField("DATE"), VentilationAnalytiqueSheetXML.this.dateDu, (Object)VentilationAnalytiqueSheetXML.this.dateAu);
                w = w.and(new Where((FieldRef)tableAssoc.getField("ID_POSTE_ANALYTIQUE"), "=", VentilationAnalytiqueSheetXML.this.rowPoste.getID()));
                sel.setWhere(w);
                sel.addFieldOrder(tableAssoc.getField("ID_POSTE_ANALYTIQUE"));
                sel.addFieldOrder(sel.getJoinFromField(tableAssoc.getField("ID_ECRITURE")).getJoinedTable().getField("COMPTE_NUMERO"));
                return sel;
            }
        });
        List<SQLRowValues> list = fetcher.fetch();
        this.size = list.size();
        long totalDebit = 0L;
        long totalCredit = 0L;
        long sousTotalCredit = 0L;
        long sousTotalDebit = 0L;
        long totalCreditAntC = 0L;
        long totalDebitAntC = 0L;
        long totalCreditAntF = 0L;
        long totalDebitAntF = 0L;
        SQLRowAccessor rowFirstEcr = null;
        int idCptFirstEcr = 1;
        boolean setTitle = true;
        boolean setLine = false;
        boolean setCumuls = true;
        boolean firstEcrCentC = true;
        boolean firstEcrCentF = true;
        String numCptFirstEcr = "";
        String titre3 = "Titre 3";
        ArrayList<HashMap<String, Object>> tableauVals = new ArrayList<HashMap<String, Object>>();
        this.listAllSheetValues.put(0, tableauVals);
        HashMap<Integer, String> style = new HashMap<Integer, String>();
        this.styleAllSheetValues.put(0, style);
        setTitle = true;
        setLine = false;
        int i = 0;
        while (i < this.size) {
            Double doubleZero = Double.valueOf("0");
            SQLRowValues sqlRowValuesAnalytique = list.get(i);
            SQLRowAccessor rowEcr = sqlRowValuesAnalytique.getForeign("ID_ECRITURE");
            int idCpt = rowEcr.getInt("ID_COMPTE_PCE");
            String nomCpt = rowEcr.getString("COMPTE_NOM");
            String numCpt = rowEcr.getString("COMPTE_NUMERO");
            HashMap<String, Object> ooLine = new HashMap<String, Object>();
            tableauVals.add(ooLine);
            if (setTitle) {
                if (!setLine) {
                    style.put(tableauVals.size() - 1, "Titre 1");
                    ooLine.put("DATE", numCpt);
                    ooLine.put("CODE_JOURNAL", nomCpt);
                    ooLine.put("JOURNAL", "");
                    ooLine.put("NUMERO_COMPTE", "");
                    ooLine.put("LIBELLE_COMPTE", "");
                    ooLine.put("NUMERO_MOUVEMENT", "");
                    ooLine.put("LIBELLE", "");
                    ooLine.put("DEBIT", "");
                    ooLine.put("CREDIT", "");
                    ooLine.put("SOLDE", "");
                    setTitle = false;
                    setLine = true;
                    if (rowFirstEcr != null) continue;
                    rowFirstEcr = rowEcr;
                    idCptFirstEcr = rowEcr.getInt("ID_COMPTE_PCE");
                    numCptFirstEcr = rowEcr.getString("COMPTE_NUMERO");
                    continue;
                }
                style.put(tableauVals.size() - 1, "Normal");
                setLine = false;
                continue;
            }
            if (rowFirstEcr != null && idCptFirstEcr != idCpt) {
                rowFirstEcr = rowEcr;
                idCptFirstEcr = rowFirstEcr.getInt("ID_COMPTE_PCE");
                numCptFirstEcr = rowEcr.getString("COMPTE_NUMERO");
                this.makeSousTotal(ooLine, style, tableauVals.size() - 1, sousTotalDebit, sousTotalCredit);
                sousTotalCredit = 0L;
                sousTotalDebit = 0L;
                setTitle = true;
                setCumuls = true;
                continue;
            }
            long l = sqlRowValuesAnalytique.getLong("MONTANT");
            long cred = l >= 0L ? 0L : -l;
            long deb = l <= 0L ? 0L : l;
            ooLine.put("DATE", dateFormatEcr.format((Date)rowEcr.getObject("DATE")));
            ooLine.put("CODE_JOURNAL", rowEcr.getString("JOURNAL_CODE"));
            ooLine.put("JOURNAL", rowEcr.getString("JOURNAL_NOM"));
            ooLine.put("NUMERO_MOUVEMENT", rowEcr.getForeign("ID_MOUVEMENT").getObject("NUMERO"));
            ooLine.put("LIBELLE", rowEcr.getObject("NOM"));
            ooLine.put("CODE_LETTRAGE", rowEcr.getObject("LETTRAGE"));
            ooLine.put("CODE_POINTAGE", rowEcr.getObject("POINTEE"));
            ooLine.put("DATE_LETTRAGE", rowEcr.getObject("DATE_LETTRAGE"));
            ooLine.put("DATE_POINTAGE", rowEcr.getObject("DATE_LETTRAGE"));
            totalCredit += cred;
            totalDebit += deb;
            long solde = (sousTotalDebit += deb) - (sousTotalCredit += cred);
            ooLine.put("DEBIT", deb == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(deb, false)));
            ooLine.put("CREDIT", cred == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(cred, false)));
            ooLine.put("SOLDE", solde == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(solde, false)));
            style.put(tableauVals.size() - 1, "Normal");
            ++i;
        }
        HashMap<String, Object> sheetVals = new HashMap<String, Object>();
        this.mapAllSheetValues.put(0, sheetVals);
        if (this.size > 0) {
            HashMap<String, Object> ooLine = new HashMap<String, Object>();
            tableauVals.add(ooLine);
            this.makeSousTotal(ooLine, style, tableauVals.size() - 1, sousTotalDebit, sousTotalCredit);
            sheetVals.put("TOTAL_DEBIT", totalDebit == 0L ? 0.0 : new Double(GestionDevise.currencyToString(totalDebit, false)));
            sheetVals.put("TOTAL_CREDIT", totalCredit == 0L ? 0.0 : new Double(GestionDevise.currencyToString(totalCredit, false)));
            sheetVals.put("TOTAL_SOLDE", totalDebit - totalCredit == 0L ? 0.0 : new Double(GestionDevise.currencyToString(totalDebit - totalCredit, false)));
        }
        sheetVals.put("TITRE_1", "Ventilation analytique " + this.rowSociete.getString("TYPE") + " " + this.rowSociete.getString("NOM"));
        sheetVals.put("DATE_EDITION", new Date());
        sheetVals.put("TITRE_2", "Poste analytique : " + this.rowPoste.getString("NOM") + ". P\u00e9riode du " + dateFormatEcr.format(this.dateDu) + " au " + dateFormatEcr.format(this.dateAu) + ".");
    }

    @Override
    public String getTemplateId() {
        return TEMPLATE_ID;
    }

    public int getSize() {
        return this.size;
    }
}

