/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.report.PdfGenerator;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;

public class PdfGenerator_2033A
extends PdfGenerator {
    public PdfGenerator_2033A() {
        super("2033A.pdf", "result_2033A.pdf", TemplateNXProps.getInstance().getStringProperty("Location2033APDF"));
        this.setTemplateOffset(0, 0);
        this.setOffset(0, 0);
        this.setMargin(32, 32);
    }

    @Override
    public void generate() {
        this.setFontBold(14);
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        this.addText("NOM", String.valueOf(rowSociete.getString("TYPE")) + " " + rowSociete.getString("NOM"), 120, 794);
        this.setFontRoman(12);
        SQLRow rowAdresse = Configuration.getInstance().getBase().getTable("ADRESSE_COMMON").getRow(rowSociete.getInt("ID_ADRESSE_COMMON"));
        String ville = rowAdresse.getString("VILLE");
        Object cedex = rowAdresse.getObject("CEDEX");
        boolean hasCedex = rowAdresse.getBoolean("HAS_CEDEX");
        if (hasCedex) {
            ville = String.valueOf(ville) + " CEDEX";
            if (cedex != null && cedex.toString().trim().length() > 0) {
                ville = String.valueOf(ville) + " " + cedex.toString().trim();
            }
        }
        String adresse = String.valueOf(rowAdresse.getString("RUE")) + ", " + rowAdresse.getString("CODE_POSTAL") + " " + ville;
        System.err.println(adresse);
        this.addText("ADRESSE", adresse, 120, 776);
        this.addSplittedText("SIRET", rowSociete.getString("NUM_SIRET"), 83, 758, 17.0);
        this.addSplittedText("APE", rowSociete.getString("NUM_APE"), 366, 758, 16.0);
        this.addSplittedText("CLOS1", "08202006", 416, 707, 9.7);
        this.addSplittedText("CLOS2", "08202006", 502, 707, 9.7);
        this.addSplittedText("DUREE1", "12", 183, 741, 14.0);
        this.addSplittedText("DUREE2", "88", 366, 741, 14.0);
        this.setFontRoman(9);
        String cc = "Document g\u00e9n\u00e9r\u00e9 par le logiciel Bloc, (c) Front Software 2006";
        this.addText("", cc, this.getWidth() - 2, 16, 90);
        this.setFontRoman(10);
        long t = 53L;
        int yy = 0;
        int y = 671;
        y = 671;
        while (y > 410) {
            t *= (long)(y / 100);
            this.addTextRight("ACTIF1." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + (t += (long)y)), 306, y);
            this.addTextRight("ACTIF2." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 407, y);
            this.addTextRight("ACTIF3." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 493, y);
            this.addTextRight("ACTIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 580, y);
            ++yy;
            y -= 18;
        }
        y -= 18;
        while (y > 330) {
            this.addTextRight("PASSIF3." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + (t += (long)y)), 493, y);
            this.addTextRight("PASSIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 580, y);
            ++yy;
            y -= 18;
        }
        while (y > 300) {
            this.addTextRight("PASSIF2." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t / 10000L), 379, y);
            this.addTextRight("PASSIF3." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 493, y);
            this.addTextRight("PASSIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 580, y);
            ++yy;
            y -= 18;
        }
        while (y > 160) {
            this.addTextRight("PASSIF3." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 493, y);
            this.addTextRight("PASSIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 580, y);
            ++yy;
            y -= 18;
        }
        while (y > 140) {
            this.addTextRight("PASSIF2." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t / 10000L), 379, y);
            this.addTextRight("PASSIF3." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 493, y);
            this.addTextRight("PASSIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 580, y);
            ++yy;
            y -= 18;
        }
        while (y > 90) {
            this.addTextRight("PASSIF3." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 493, y);
            this.addTextRight("PASSIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 580, y);
            ++yy;
            y -= 18;
        }
        while (y > 30) {
            this.addTextRight("PASSIF1." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 294, y);
            this.addTextRight("PASSIF4." + yy, PdfGenerator_2033A.insertCurrencySpaces("" + t), 580, y);
            ++yy;
            y -= 18;
        }
    }
}

