/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.model;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.Order;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.DecimalUtils;

public class CurrencyConverter {
    private String companyCurrencyCode;
    private final DBRoot root;
    private String baseCurrencyCode;

    public CurrencyConverter(DBRoot rootSociete, String companyCurrencyCode, String baseCurrencyCode) {
        this.companyCurrencyCode = companyCurrencyCode == null || companyCurrencyCode.isEmpty() ? "EUR" : companyCurrencyCode.trim().toUpperCase();
        this.baseCurrencyCode = baseCurrencyCode;
        this.root = rootSociete;
    }

    public CurrencyConverter() {
        this(ComptaPropsConfiguration.getInstanceCompta().getRootSociete(), ComptaPropsConfiguration.getInstanceCompta().getRowSociete().getForeign("ID_DEVISE").getString("CODE"), "EUR");
    }

    public String getCompanyCurrencyCode() {
        return this.companyCurrencyCode;
    }

    public String getBaseCurrencyCode() {
        return this.baseCurrencyCode;
    }

    public BigDecimal convert(BigDecimal amount, String from, String to) {
        return this.convert(amount, from, to, Calendar.getInstance().getTime());
    }

    public BigDecimal convert(BigDecimal amount, String from, String to, Date date) {
        return this.convert(amount, from, to, date, false);
    }

    public BigDecimal convert(BigDecimal amount, String from, String to, Date date, boolean useBiased) {
        if (from.equalsIgnoreCase(to)) {
            return amount;
        }
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.setTimeInMillis(date.getTime());
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date d = c.getTime();
        SQLSelect select = new SQLSelect();
        SQLTable t = this.root.getTable("DEVISE_HISTORIQUE");
        select.addAllSelect(t, Arrays.asList("ID", "DATE", "SRC", "DST", "TAUX", "TAUX_COMMERCIAL"));
        Where w = new Where((FieldRef)t.getField("SRC"), "=", (Object)this.baseCurrencyCode);
        w = w.and(new Where((FieldRef)t.getField("DST"), true, Arrays.asList(from, to)));
        w = w.and(new Where((FieldRef)t.getField("DATE"), "<=", (Object)d));
        select.setWhere(w);
        select.addFieldOrder(t.getField("DATE"), Order.desc());
        select.setLimit(2);
        List<SQLRow> rows = SQLRowListRSH.execute(select);
        if (rows.isEmpty()) {
            System.err.println("CurrencyConverter.convert() no data to convert " + amount + " " + from + " to " + to + " at " + date + " biased:" + useBiased);
            return null;
        }
        BigDecimal r1 = null;
        BigDecimal r2 = null;
        for (SQLRow sqlRow : rows) {
            if (sqlRow.getString("DST").equals(from)) {
                r1 = useBiased ? sqlRow.getBigDecimal("TAUX_COMMERCIAL") : sqlRow.getBigDecimal("TAUX");
            }
            if (!sqlRow.getString("DST").equals(to)) continue;
            r2 = useBiased ? sqlRow.getBigDecimal("TAUX_COMMERCIAL") : sqlRow.getBigDecimal("TAUX");
        }
        if (from.equals(this.baseCurrencyCode)) {
            r1 = BigDecimal.ONE;
        }
        if (to.equals(this.baseCurrencyCode)) {
            r2 = BigDecimal.ONE;
        }
        if (r1 == null) {
            throw new IllegalStateException("No conversion rate for " + from);
        }
        if (r2 == null) {
            throw new IllegalStateException("No conversion rate for " + to);
        }
        BigDecimal result = amount.multiply(r2, DecimalUtils.HIGH_PRECISION).divide(r1, DecimalUtils.HIGH_PRECISION);
        return result;
    }
}

