/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.model;

import java.util.HashMap;
import java.util.Map;

public class Currency {
    public static String[] ISO_CODES = new String[]{"AED", "AFN", "ALL", "AMD", "ANG", "AOA", "ARS", "AUD", "AWG", "AZN", "BAM", "BBD", "BDT", "BGN", "BHD", "BIF", "BMD", "BND", "BOB", "BRL", "BSD", "BTN", "BWP", "BYR", "BZD", "CAD", "CDF", "CHF", "CLP", "CNY", "COP", "CRC", "CUC", "CUP", "CVE", "CZK", "DJF", "DKK", "DOP", "DZD", "EGP", "ERN", "ETB", "EUR", "FJD", "FKP", "GBP", "GEL", "GGP", "GHS", "GIP", "GMD", "GNF", "GTQ", "GYD", "HKD", "HNL", "HRK", "HTG", "HUF", "IDR", "ILS", "IMP", "INR", "IQD", "IRR", "ISK", "JEP", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LYD", "MAD", "MDL", "MGA", "MKD", "MMK", "MNT", "MOP", "MRO", "MUR", "MVR", "MWK", "MXN", "MYR", "MZN", "NAD", "NGN", "NIO", "NOK", "NPR", "NZD", "OMR", "PAB", "PEN", "PGK", "PHP", "PKR", "PLN", "PYG", "QAR", "RON", "RSD", "RUB", "RWF", "SAR", "SBD", "SCR", "SDG", "SEK", "SGD", "SHP", "SLL", "SOS", "SPL", "SRD", "STD", "SVC", "SYP", "SZL", "THB", "TJS", "TMT", "TND", "TOP", "TRY", "TTD", "TVD", "TWD", "TZS", "UAH", "UGX", "USD", "UYU", "UZS", "VEF", "VND", "VUV", "WST", "XAF", "XCD", "XDR", "XOF", "XPF", "YER", "ZAR", "ZMW", "ZWD"};
    private static final Map<String, String> mapSymbol = new HashMap<String, String>();

    static {
        mapSymbol.put("ALL", "Lek");
        mapSymbol.put("AFN", "\u060b");
        mapSymbol.put("ARS", "$");
        mapSymbol.put("AWG", "\u0192");
        mapSymbol.put("AUD", "$");
        mapSymbol.put("AZN", "\u043c\u0430\u043d");
        mapSymbol.put("BSD", "$");
        mapSymbol.put("BBD", "$");
        mapSymbol.put("BYR", "p.");
        mapSymbol.put("BZD", "BZ$");
        mapSymbol.put("BMD", "$");
        mapSymbol.put("BOB", "$b");
        mapSymbol.put("BAM", "KM");
        mapSymbol.put("BWP", "P");
        mapSymbol.put("BGN", "\u043b\u0432");
        mapSymbol.put("BRL", "R$");
        mapSymbol.put("BND", "$");
        mapSymbol.put("KHR", "\u17db");
        mapSymbol.put("CAD", "$");
        mapSymbol.put("KYD", "$");
        mapSymbol.put("CLP", "$");
        mapSymbol.put("CNY", "\u00a5");
        mapSymbol.put("COP", "$");
        mapSymbol.put("CRC", "\u20a1");
        mapSymbol.put("HRK", "kn");
        mapSymbol.put("CUP", "\u20b1");
        mapSymbol.put("CZK", "K\u010d");
        mapSymbol.put("DKK", "kr");
        mapSymbol.put("DOP", "RD$");
        mapSymbol.put("XCD", "$");
        mapSymbol.put("EGP", "\u00a3");
        mapSymbol.put("SVC", "$");
        mapSymbol.put("EEK", "kr");
        mapSymbol.put("EUR", "\u20ac");
        mapSymbol.put("FKP", "\u00a3");
        mapSymbol.put("FJD", "$");
        mapSymbol.put("GHC", "\u00a2");
        mapSymbol.put("GIP", "\u00a3");
        mapSymbol.put("GTQ", "Q");
        mapSymbol.put("GGP", "\u00a3");
        mapSymbol.put("GYD", "$");
        mapSymbol.put("HNL", "L");
        mapSymbol.put("HKD", "$");
        mapSymbol.put("HUF", "Ft");
        mapSymbol.put("ISK", "kr");
        mapSymbol.put("INR", "");
        mapSymbol.put("IDR", "Rp");
        mapSymbol.put("IRR", "\ufdfc");
        mapSymbol.put("IMP", "\u00a3");
        mapSymbol.put("ILS", "\u20aa");
        mapSymbol.put("JMD", "J$");
        mapSymbol.put("JPY", "\u00a5");
        mapSymbol.put("JEP", "\u00a3");
        mapSymbol.put("KZT", "\u043b\u0432");
        mapSymbol.put("KPW", "\u20a9");
        mapSymbol.put("KRW", "\u20a9");
        mapSymbol.put("KGS", "\u043b\u0432");
        mapSymbol.put("LAK", "\u20ad");
        mapSymbol.put("LVL", "Ls");
        mapSymbol.put("LBP", "\u00a3");
        mapSymbol.put("LRD", "$");
        mapSymbol.put("LTL", "Lt");
        mapSymbol.put("MKD", "\u0434\u0435\u043d");
        mapSymbol.put("MYR", "RM");
        mapSymbol.put("MUR", "\u20a8");
        mapSymbol.put("MXN", "$");
        mapSymbol.put("MNT", "\u20ae");
        mapSymbol.put("MZN", "MT");
        mapSymbol.put("NAD", "$");
        mapSymbol.put("NPR", "\u20a8");
        mapSymbol.put("ANG", "\u0192");
        mapSymbol.put("NZD", "$");
        mapSymbol.put("NIO", "C$");
        mapSymbol.put("NGN", "\u20a6");
        mapSymbol.put("KPW", "\u20a9");
        mapSymbol.put("NOK", "kr");
        mapSymbol.put("OMR", "\ufdfc");
        mapSymbol.put("PKR", "\u20a8");
        mapSymbol.put("PAB", "B/.");
        mapSymbol.put("PYG", "Gs");
        mapSymbol.put("PEN", "S/.");
        mapSymbol.put("PHP", "\u20b1");
        mapSymbol.put("PLN", "z\u0142");
        mapSymbol.put("QAR", "\ufdfc");
        mapSymbol.put("RON", "lei");
        mapSymbol.put("RUB", "\u0440\u0443\u0431");
        mapSymbol.put("SHP", "\u00a3");
        mapSymbol.put("SAR", "\ufdfc");
        mapSymbol.put("RSD", "\u0414\u0438\u043d.");
        mapSymbol.put("SCR", "\u20a8");
        mapSymbol.put("SGD", "$");
        mapSymbol.put("SBD", "$");
        mapSymbol.put("SOS", "S");
        mapSymbol.put("ZAR", "R");
        mapSymbol.put("KRW", "\u20a9");
        mapSymbol.put("LKR", "\u20a8");
        mapSymbol.put("SEK", "kr");
        mapSymbol.put("CHF", "CHF");
        mapSymbol.put("SRD", "$");
        mapSymbol.put("SYP", "\u00a3");
        mapSymbol.put("TWD", "NT$");
        mapSymbol.put("THB", "\u0e3f");
        mapSymbol.put("TTD", "TT$");
        mapSymbol.put("TRY", "");
        mapSymbol.put("TRL", "\u20a4");
        mapSymbol.put("TVD", "$");
        mapSymbol.put("UAH", "\u20b4");
        mapSymbol.put("GBP", "\u00a3");
        mapSymbol.put("USD", "$");
        mapSymbol.put("UYU", "$U");
        mapSymbol.put("UZS", "\u043b\u0432");
        mapSymbol.put("VEF", "Bs");
        mapSymbol.put("VND", "\u20ab");
        mapSymbol.put("YER", "\ufdfc");
        mapSymbol.put("ZWD", "Z$");
    }

    public static String getSymbol(String code) {
        String symbol = mapSymbol.get(code);
        if (symbol == null) {
            symbol = "???";
        }
        return symbol;
    }
}

