/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.Acompte;
import org.openconcerto.erp.core.common.ui.AcompteCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNumericCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNumericHTConvertorCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseTableCellRenderer;
import org.openconcerto.erp.core.common.ui.NiveauTableCellEditor;
import org.openconcerto.erp.core.common.ui.NiveauTableCellRender;
import org.openconcerto.erp.core.common.ui.QteCellEditor;
import org.openconcerto.erp.core.common.ui.Remise;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.ui.ArticleRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteMultipleRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteUnitRowValuesRenderer;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ITextArticleWithCompletionCellEditor;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.SQLTextComboTableCellEditor;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.i18n.TranslationManager;

public abstract class AbstractVenteArticleItemTable
extends AbstractArticleItemTable {
    public static final String ARTICLE_SHOW_DEVISE = "ArticleShowDevise";
    public static final String ARTICLE_SERVICE = "ArticleService";
    SQLTableElement tableElementFacturable;
    SQLTableElement tableElementRemise;
    private static Map<String, Boolean> visibilityMap = new HashMap<String, Boolean>();
    private SQLTable tableArticleTarif = Configuration.getInstance().getBase().getTable("ARTICLE_TARIF");
    private SQLTable tableArticle = Configuration.getInstance().getBase().getTable("ARTICLE");

    public AbstractVenteArticleItemTable() {
    }

    public AbstractVenteArticleItemTable(List<JButton> buttons) {
        super(buttons);
    }

    protected boolean isCellNiveauEditable(SQLRowValues vals) {
        RowValuesTableModel model = this.getModel();
        int index = model.row2index(vals);
        int niveau = vals.getInt("NIVEAU");
        return index + 1 == model.getRowCount() || niveau >= model.getRowValuesAt(index + 1).getInt("NIVEAU");
    }

    public void calculPourcentage(final Acompte a, final TypeCalcul type) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SQLTableElement tableElement = type == TypeCalcul.CALCUL_FACTURABLE ? (this).AbstractVenteArticleItemTable.this.tableElementFacturable : (this).AbstractVenteArticleItemTable.this.tableElementRemise;
                        RowValuesTableModel model = AbstractVenteArticleItemTable.this.getModel();
                        if (a == null) {
                            int i = 0;
                            while (i < model.getRowCount()) {
                                model.putValue(null, i, type.getFieldMontant());
                                model.putValue(null, i, type.getFieldPourcent());
                                tableElement.fireModification(model.getRowValuesAt(i));
                                ++i;
                            }
                        } else if (a.getPercent() != null) {
                            int i = 0;
                            while (i < model.getRowCount()) {
                                model.putValue(a.getPercent(), i, type.getFieldPourcent());
                                model.putValue(null, i, type.getFieldMontant());
                                tableElement.fireModification(model.getRowValuesAt(i));
                                ++i;
                            }
                        } else {
                            Remise remise;
                            BigDecimal acompteMontant;
                            BigDecimal acomptePercent;
                            BigDecimal totalLine;
                            BigDecimal pU;
                            BigDecimal qteU;
                            int qte;
                            BigDecimal totalHT = BigDecimal.ZERO;
                            for (SQLRowValues rowVals : AbstractVenteArticleItemTable.this.getRowValuesAtLevel(1)) {
                                qte = rowVals.getInt("QTE");
                                qteU = rowVals.getBigDecimal("QTE_UNITAIRE");
                                pU = rowVals.getBigDecimal("PV_HT");
                                totalLine = pU.multiply(qteU, DecimalUtils.HIGH_PRECISION).multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION).setScale(2, RoundingMode.HALF_UP);
                                if (type == TypeCalcul.CALCUL_FACTURABLE && rowVals.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                                    acomptePercent = rowVals.getBigDecimal("POURCENT_REMISE");
                                    acompteMontant = rowVals.getBigDecimal("MONTANT_REMISE");
                                    remise = new Remise(acomptePercent, acompteMontant);
                                    totalLine = remise.getResultFrom(totalLine);
                                }
                                totalHT = totalHT.add(totalLine);
                            }
                            int i = 0;
                            while (i < model.getRowCount()) {
                                if (model.getRowValuesAt(i).getInt("NIVEAU") == 1) {
                                    model.putValue(null, i, type.getFieldPourcent());
                                    SQLRowValues rowVals = model.getRowValuesAt(i);
                                    qte = rowVals.getInt("QTE");
                                    qteU = rowVals.getBigDecimal("QTE_UNITAIRE");
                                    pU = rowVals.getBigDecimal("PV_HT");
                                    totalLine = pU.multiply(qteU, DecimalUtils.HIGH_PRECISION).multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION).setScale(2, RoundingMode.HALF_UP);
                                    if (rowVals.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                                        acomptePercent = rowVals.getBigDecimal("POURCENT_REMISE");
                                        acompteMontant = rowVals.getBigDecimal("MONTANT_REMISE");
                                        remise = new Remise(acomptePercent, acompteMontant);
                                        totalLine = remise.getResultFrom(totalLine);
                                    }
                                    BigDecimal percent = totalHT.signum() != 0 ? totalLine.divide(totalHT, DecimalUtils.HIGH_PRECISION) : BigDecimal.ZERO;
                                    model.putValue(a.getMontant().multiply(percent, DecimalUtils.HIGH_PRECISION).setScale(6, RoundingMode.HALF_UP), i, type.getFieldMontant());
                                    tableElement.fireModification(model.getRowValuesAt(i));
                                }
                                ++i;
                            }
                        }
                        model.fireTableDataChanged();
                    }
                });
            }
        };
        this.getModel().submit(r);
    }

    public static Map<String, Boolean> getVisibilityMap() {
        return visibilityMap;
    }

    @Override
    protected void init() {
        SQLTableElement marge;
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getSQLElement().getTable().getDBRoot());
        boolean selectArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.USE_CREATED_ARTICLE, false);
        final boolean filterFamilleArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.FILTER_BY_FAMILY, false);
        boolean createAuto = prefs.getBoolean(GestionArticleGlobalPreferencePanel.CREATE_ARTICLE_AUTO, true);
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement eNiveau = new SQLTableElement(e.getTable().getField("NIVEAU")){

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                super.setValueFrom(row, value);
            }
        };
        eNiveau.setRenderer(new NiveauTableCellRender());
        eNiveau.setEditor(new NiveauTableCellEditor());
        list.add(eNiveau);
        list.add(new SQLTableElement(e.getTable().getField("ID_STYLE")));
        SQLTableElement tableFamille = new SQLTableElement(e.getTable().getField("ID_FAMILLE_ARTICLE"));
        list.add(tableFamille);
        SQLTableElement tableElementArticle = new SQLTableElement(e.getTable().getField("ID_ARTICLE"), true, true, true);
        list.add(tableElementArticle);
        SQLTableElement tableElementCode = new SQLTableElement(e.getTable().getField("CODE"), String.class, new ITextArticleWithCompletionCellEditor(e.getTable().getTable("ARTICLE"), e.getTable().getTable("ARTICLE_FOURNISSEUR")));
        list.add(tableElementCode);
        SQLTableElement tableElementNom = new SQLTableElement(e.getTable().getField("NOM"));
        list.add(tableElementNom);
        if (e.getTable().getFieldsName().contains("COLORIS")) {
            SQLTableElement tableElementColoris = new SQLTableElement(e.getTable().getField("COLORIS"));
            list.add(tableElementColoris);
        }
        if (e.getTable().getFieldsName().contains("DESCRIPTIF")) {
            SQLTableElement tableElementDesc = new SQLTableElement(e.getTable().getField("DESCRIPTIF"));
            list.add(tableElementDesc);
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            SQLTableElement tableElementCodeDouane = new SQLTableElement(e.getTable().getField("CODE_DOUANIER"));
            list.add(tableElementCodeDouane);
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            SQLTableElement tableElementPays = new SQLTableElement(e.getTable().getField("ID_PAYS"));
            list.add(tableElementPays);
        }
        SQLTableElement tableElement_ValeurMetrique2 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_2"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 2)) {
                    return false;
                }
                return super.isCellEditable(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique2);
        SQLTableElement tableElement_ValeurMetrique3 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_3"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && modeNumber.intValue() != 4) {
                    return false;
                }
                return super.isCellEditable(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique3);
        SQLTableElement tableElement_ValeurMetrique1 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_1"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 6)) {
                    return false;
                }
                return super.isCellEditable(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique1);
        if (e.getTable().getFieldsName().contains("PREBILAN")) {
            this.prebilan = new SQLTableElement(e.getTable().getField("PREBILAN"), BigDecimal.class){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }

                @Override
                public boolean isCellEditable(SQLRowValues vals) {
                    return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals);
                }
            };
            this.prebilan.setRenderer(new DeviseTableCellRenderer());
            list.add(this.prebilan);
        }
        SQLTableElement tableElement_PrixMetrique1_AchatHT = new SQLTableElement(e.getTable().getField("PRIX_METRIQUE_HA_1"), BigDecimal.class){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals);
            }
        };
        tableElement_PrixMetrique1_AchatHT.setRenderer(new DeviseTableCellRenderer());
        list.add(tableElement_PrixMetrique1_AchatHT);
        SQLTableElement eltDevise = null;
        SQLTableElement eltUnitDevise = null;
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            eltDevise = new SQLTableElement(e.getTable().getField("ID_DEVISE"));
            list.add(eltDevise);
            eltUnitDevise = new SQLTableElement(e.getTable().getField("PV_U_DEVISE"), BigDecimal.class){

                @Override
                public boolean isCellEditable(SQLRowValues vals) {
                    return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals);
                }
            };
            eltUnitDevise.setRenderer(new DeviseTableCellRenderer());
            list.add(eltUnitDevise);
        }
        SQLField field = e.getTable().getField("PRIX_METRIQUE_VT_1");
        final DeviseNumericHTConvertorCellEditor editorPVHT = new DeviseNumericHTConvertorCellEditor(field);
        SQLTableElement tableElement_PrixMetrique1_VenteHT = new SQLTableElement(field, BigDecimal.class, editorPVHT){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals);
            }
        };
        tableElement_PrixMetrique1_VenteHT.setRenderer(new DeviseTableCellRenderer());
        list.add(tableElement_PrixMetrique1_VenteHT);
        SQLTableElement qteU = new SQLTableElement(e.getTable().getField("QTE_UNITAIRE"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                SQLRowAccessor row = vals.getForeign("ID_UNITE_VENTE");
                if (row != null && !row.isUndefined() && row.getBoolean("A_LA_PIECE").booleanValue()) {
                    return false;
                }
                return super.isCellEditable(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }
        };
        list.add(qteU);
        SQLTableElement uniteVente = new SQLTableElement(e.getTable().getField("ID_UNITE_VENTE"));
        list.add(uniteVente);
        this.qte = new SQLTableElement(e.getTable().getField("QTE"), Integer.class, new QteCellEditor()){

            @Override
            protected Object getDefaultNullValue() {
                return 0;
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                if (AbstractVenteArticleItemTable.this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT")) {
                    return new QteMultipleRowValuesRenderer();
                }
                return super.getTableCellRenderer();
            }
        };
        this.qte.setPreferredSize(20);
        list.add(this.qte);
        SQLTableElement tableElement_ModeVente = new SQLTableElement(e.getTable().getField("ID_MODE_VENTE_ARTICLE"));
        list.add(tableElement_ModeVente);
        SQLField prixAchatHTField = e.getTable().getField("PA_HT");
        DeviseNumericCellEditor editorPAchatHT = new DeviseNumericCellEditor(prixAchatHTField);
        this.ha = new SQLTableElement(e.getTable().getField("PA_HT"), BigDecimal.class, editorPAchatHT){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals);
            }
        };
        this.ha = new SQLTableElement(prixAchatHTField, BigDecimal.class, editorPAchatHT){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals);
            }
        };
        this.ha.setRenderer(new DeviseTableCellRenderer());
        list.add(this.ha);
        SQLField prixVenteHTField = e.getTable().getField("PV_HT");
        DeviseNumericCellEditor editorPVenteHT = new DeviseNumericCellEditor(prixAchatHTField);
        final SQLTableElement tableElement_PrixVente_HT = new SQLTableElement(prixVenteHTField, BigDecimal.class, editorPVenteHT){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals);
            }
        };
        tableElement_PrixVente_HT.setRenderer(new DeviseTableCellRenderer());
        list.add(tableElement_PrixVente_HT);
        this.tableElementTVA = new SQLTableElement(e.getTable().getField("ID_TAXE"));
        this.tableElementTVA.setPreferredSize(20);
        list.add(this.tableElementTVA);
        SQLTableElement tableElementPoids = new SQLTableElement(e.getTable().getField("POIDS"), Float.class){

            @Override
            protected Object getDefaultNullValue() {
                return Float.valueOf(0.0f);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }
        };
        tableElementPoids.setPreferredSize(20);
        list.add(tableElementPoids);
        this.tableElementPoidsTotal = new SQLTableElement(e.getTable().getField("T_POIDS"), Float.class){

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }
        };
        this.tableElementPoidsTotal.setEditable(false);
        list.add(this.tableElementPoidsTotal);
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ITEM_PACKAGING, false)) {
            SQLTableElement poidsColis = new SQLTableElement(e.getTable().getField("POIDS_COLIS_NET"), BigDecimal.class){

                @Override
                public TableCellRenderer getTableCellRenderer() {
                    return new QteUnitRowValuesRenderer();
                }
            };
            list.add(poidsColis);
            SQLTableElement nbColis = new SQLTableElement(e.getTable().getField("NB_COLIS"), Integer.class);
            list.add(nbColis);
            final SQLTableElement totalPoidsColis = new SQLTableElement(e.getTable().getField("T_POIDS_COLIS_NET"), BigDecimal.class){

                @Override
                public TableCellRenderer getTableCellRenderer() {
                    return new QteUnitRowValuesRenderer();
                }
            };
            list.add(totalPoidsColis);
            poidsColis.addModificationListener(totalPoidsColis);
            nbColis.addModificationListener(totalPoidsColis);
            totalPoidsColis.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    Object o2 = row.getObject("POIDS_COLIS_NET");
                    Object o3 = row.getObject("NB_COLIS");
                    if (o2 != null && o3 != null) {
                        BigDecimal poids = (BigDecimal)o2;
                        int nb = (Integer)o3;
                        return poids.multiply(new BigDecimal(nb), DecimalUtils.HIGH_PRECISION).setScale(totalPoidsColis.getDecimalDigits(), RoundingMode.HALF_UP);
                    }
                    return row.getObject("T_POIDS_COLIS_NET");
                }
            });
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SERVICE, false)) {
            this.service = new SQLTableElement(e.getTable().getField("SERVICE"), Boolean.class);
            list.add(this.service);
        }
        this.totalHT = new SQLTableElement(e.getTable().getField("T_PV_HT"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals);
            }
        };
        this.totalHT.setRenderer(new DeviseTableCellRenderer());
        this.totalHT.setEditable(false);
        if (e.getTable().getFieldsName().contains("MONTANT_FACTURABLE")) {
            this.tableElementFacturable = new SQLTableElement(e.getTable().getField("POURCENT_FACTURABLE"), Acompte.class, new AcompteCellEditor("POURCENT_FACTURABLE", "MONTANT_FACTURABLE")){

                @Override
                public void setValueFrom(SQLRowValues row, Object value) {
                    if (value != null) {
                        Acompte a = (Acompte)value;
                        row.put("MONTANT_FACTURABLE", a.getMontant());
                        row.put("POURCENT_FACTURABLE", a.getPercent());
                    } else {
                        row.put("MONTANT_FACTURABLE", null);
                        row.put("POURCENT_FACTURABLE", BigDecimal.ONE.movePointRight(2));
                    }
                    this.fireModification(row);
                }
            };
            this.tableElementFacturable.setRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    SQLRowValues rowVals = ((RowValuesTable)table).getRowValuesTableModel().getRowValuesAt(row);
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    BigDecimal percent = rowVals.getBigDecimal("POURCENT_FACTURABLE");
                    BigDecimal amount = rowVals.getBigDecimal("MONTANT_FACTURABLE");
                    Acompte a = new Acompte(percent, amount);
                    label.setText(a.toString());
                    return label;
                }
            });
            this.tableElementFacturable.addModificationListener(this.totalHT);
            list.add(this.tableElementFacturable);
        }
        SQLField fieldRemise = e.getTable().getField("POURCENT_REMISE");
        if (e.getTable().getFieldsName().contains("MONTANT_REMISE")) {
            this.tableElementRemise = new SQLTableElement(e.getTable().getField("POURCENT_REMISE"), Acompte.class, new AcompteCellEditor("POURCENT_REMISE", "MONTANT_REMISE")){

                @Override
                public void setValueFrom(SQLRowValues row, Object value) {
                    if (value != null) {
                        Acompte a = (Acompte)value;
                        row.put("MONTANT_REMISE", a.getMontant());
                        row.put("POURCENT_REMISE", a.getPercent());
                    } else {
                        row.put("MONTANT_REMISE", null);
                        row.put("POURCENT_REMISE", BigDecimal.ZERO);
                    }
                    this.fireModification(row);
                }
            };
            this.tableElementRemise.setRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    SQLRowValues rowVals = ((RowValuesTable)table).getRowValuesTableModel().getRowValuesAt(row);
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    BigDecimal percent = rowVals.getBigDecimal("POURCENT_REMISE");
                    BigDecimal amount = rowVals.getBigDecimal("MONTANT_REMISE");
                    Remise a = new Remise(percent, amount);
                    label.setText(a.toPlainString());
                    return label;
                }
            });
        } else {
            this.tableElementRemise = new SQLTableElement(fieldRemise){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }
            };
        }
        list.add(this.tableElementRemise);
        SQLTableElement tableElementRG = null;
        if (e.getTable().getFieldsName().contains("POURCENT_RG")) {
            tableElementRG = new SQLTableElement(e.getTable().getField("POURCENT_RG"));
            list.add(tableElementRG);
        }
        this.totalHA = new SQLTableElement(e.getTable().getField("T_PA_HT"), BigDecimal.class);
        this.totalHA.setRenderer(new DeviseTableCellRenderer());
        this.totalHA.setEditable(false);
        list.add(this.totalHA);
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            this.tableElementTotalDevise = new SQLTableElement(e.getTable().getField("PV_T_DEVISE"), BigDecimal.class){

                @Override
                public boolean isCellEditable(SQLRowValues vals) {
                    return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals);
                }
            };
            this.tableElementTotalDevise.setRenderer(new DeviseTableCellRenderer());
            list.add(this.tableElementTotalDevise);
        }
        if (e.getTable().getFieldsName().contains("MARGE_HT")) {
            marge = new SQLTableElement(e.getTable().getField("MARGE_HT"), BigDecimal.class){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }

                @Override
                public boolean isCellEditable(SQLRowValues vals) {
                    return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals);
                }
            };
            marge.setRenderer(new DeviseTableCellRenderer());
            marge.setEditable(false);
            list.add(marge);
            this.totalHT.addModificationListener(marge);
            this.totalHA.addModificationListener(marge);
            marge.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    BigDecimal vt = (BigDecimal)row.getObject("T_PV_HT");
                    BigDecimal ha = (BigDecimal)row.getObject("T_PA_HT");
                    BigDecimal acomptePercent = row.getBigDecimal("POURCENT_FACTURABLE");
                    BigDecimal acompteMontant = row.getBigDecimal("MONTANT_FACTURABLE");
                    Acompte acompte = new Acompte(acomptePercent, acompteMontant);
                    ha = acompte.getResultFrom(ha);
                    vt = acompte.getResultFrom(vt);
                    return vt.subtract(ha).setScale(marge.getDecimalDigits(), RoundingMode.HALF_UP);
                }
            });
        }
        if (e.getTable().getFieldsName().contains("MARGE_PREBILAN_HT")) {
            marge = new SQLTableElement(e.getTable().getField("MARGE_PREBILAN_HT"), BigDecimal.class){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }
            };
            marge.setRenderer(new DeviseTableCellRenderer());
            marge.setEditable(false);
            list.add(marge);
            this.totalHT.addModificationListener(marge);
            this.prebilan.addModificationListener(marge);
            marge.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    BigDecimal vt = (BigDecimal)row.getObject("T_PV_HT");
                    BigDecimal ha = row.getObject("PREBILAN") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PREBILAN");
                    BigDecimal acomptePercent = row.getBigDecimal("POURCENT_FACTURABLE");
                    BigDecimal acompteMontant = row.getBigDecimal("MONTANT_FACTURABLE");
                    Acompte acompte = new Acompte(acomptePercent, acompteMontant);
                    ha = acompte.getResultFrom(ha);
                    vt = acompte.getResultFrom(vt);
                    return vt.subtract(ha).setScale(marge.getDecimalDigits(), RoundingMode.HALF_UP);
                }
            });
        }
        this.totalHT.setEditable(false);
        list.add(this.totalHT);
        this.tableElementTotalTTC = new SQLTableElement(e.getTable().getField("T_PV_TTC"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals);
            }
        };
        this.tableElementTotalTTC.setRenderer(new DeviseTableCellRenderer());
        this.tableElementTotalTTC.setEditable(false);
        list.add(this.tableElementTotalTTC);
        SQLRowValues defautRow = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable()));
        defautRow.put("ID_TAXE", TaxeCache.getCache().getFirstTaxe().getID());
        defautRow.put("CODE", "");
        defautRow.put("NOM", "");
        RowValuesTableModel model = new RowValuesTableModel(e, list, e.getTable().getField("NOM"), false, defautRow);
        this.setModel(model);
        this.table = new RowValuesTable(model, this.getConfigurationFile());
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        if (filterFamilleArticle) {
            ((SQLTextComboTableCellEditor)tableElementArticle.getTableCellEditor(this.table)).setDynamicWhere(e.getTable().getTable("ARTICLE").getField("ID_FAMILLE_ARTICLE"));
        }
        final SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        ArrayList<String> completionField = new ArrayList<String>();
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            completionField.add("CODE_DOUANIER");
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            completionField.add("ID_PAYS");
        }
        completionField.add("ID_UNITE_VENTE");
        completionField.add("PA_HT");
        completionField.add("PV_HT");
        completionField.add("ID_TAXE");
        completionField.add("POIDS");
        completionField.add("PRIX_METRIQUE_HA_1");
        completionField.add("PRIX_METRIQUE_HA_2");
        completionField.add("PRIX_METRIQUE_HA_3");
        completionField.add("VALEUR_METRIQUE_1");
        completionField.add("VALEUR_METRIQUE_2");
        completionField.add("VALEUR_METRIQUE_3");
        completionField.add("ID_MODE_VENTE_ARTICLE");
        completionField.add("PRIX_METRIQUE_VT_1");
        completionField.add("PRIX_METRIQUE_VT_2");
        completionField.add("PRIX_METRIQUE_VT_3");
        completionField.add("SERVICE");
        completionField.add("ID_FAMILLE_ARTICLE");
        if (this.getSQLElement().getTable().getFieldsName().contains("DESCRIPTIF")) {
            completionField.add("DESCRIPTIF");
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            completionField.add("ID_DEVISE");
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            completionField.add("PV_U_DEVISE");
        }
        if (this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT") && sqlTableArticle.getTable().getFieldsName().contains("QTE_ACHAT")) {
            completionField.add("QTE_ACHAT");
        }
        final AutoCompletionManager m = new AutoCompletionManager(tableElementCode, sqlTableArticle.getField("CODE"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = AbstractVenteArticleItemTable.this.tarifCompletion(row, field, rowDest, true);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        m.fill("NOM", "NOM");
        m.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            m.fill(string, string);
        }
        final Where w = new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
        m.setWhere(w);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                final int rowindex = AbstractVenteArticleItemTable.this.table.getSelectedRow();
                if (rowindex < 0) {
                    return;
                }
                if (e.isPopupTrigger() && e.getComponent() instanceof JTable) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.expand")){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            AbstractVenteArticleItemTable.this.expandNomenclature(rowindex, m, false);
                        }
                    });
                    popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.expose")){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            AbstractVenteArticleItemTable.this.expandNomenclature(rowindex, m, true);
                        }
                    });
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        final AutoCompletionManager m2 = new AutoCompletionManager(tableElementNom, sqlTableArticle.getField("NOM"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = AbstractVenteArticleItemTable.this.tarifCompletion(row, field, rowDest, true);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        m2.fill("CODE", "CODE");
        m2.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            m2.fill(string, string);
        }
        m2.setWhere(w);
        AutoCompletionManager m3 = new AutoCompletionManager(tableElementArticle, sqlTableArticle.getField("NOM"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = AbstractVenteArticleItemTable.this.tarifCompletion(row, field, rowDest, true);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        m3.fill("CODE", "CODE");
        m3.fill("NOM", "NOM");
        for (String string : completionField) {
            m3.fill(string, string);
        }
        m3.setWhere(w);
        tableFamille.addModificationListener(tableElementArticle);
        tableElementCode.addModificationListener(tableElementArticle);
        tableElementArticle.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                try {
                    SQLRowAccessor foreign;
                    if (filterFamilleArticle) {
                        if (row.isForeignEmpty("ID_FAMILLE_ARTICLE")) {
                            m.setWhere(w);
                            m2.setWhere(w);
                        } else {
                            m.setWhere(w.and(new Where((FieldRef)sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", row.getForeignID("ID_FAMILLE_ARTICLE"))));
                            m2.setWhere(w.and(new Where((FieldRef)sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", row.getForeignID("ID_FAMILLE_ARTICLE"))));
                        }
                    }
                    if ((foreign = row.getForeign("ID_ARTICLE")) != null && !foreign.isUndefined() && foreign.getObject("CODE") != null && foreign.getString("CODE").equals(row.getString("CODE"))) {
                        return foreign.getID();
                    }
                    return AbstractVenteArticleItemTable.this.tableArticle.getUndefinedID();
                }
                catch (Exception e) {
                    return AbstractVenteArticleItemTable.this.tableArticle.getUndefinedID();
                }
            }
        });
        this.qte.addModificationListener(tableElement_PrixMetrique1_VenteHT);
        this.qte.addModificationListener(this.totalHT);
        this.qte.addModificationListener(this.totalHA);
        qteU.addModificationListener(this.totalHT);
        qteU.addModificationListener(this.totalHA);
        if (tableElementRG != null) {
            tableElementRG.addModificationListener(this.totalHT);
        }
        this.tableElementRemise.addModificationListener(this.totalHT);
        tableElement_PrixVente_HT.addModificationListener(this.totalHT);
        this.ha.addModificationListener(this.totalHA);
        this.totalHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                BigDecimal acompteMontant;
                BigDecimal acomptePercent;
                Object o3;
                BigDecimal lremise = BigDecimal.ZERO;
                if (row.getTable().getFieldsName().contains("POURCENT_RG") && (o3 = row.getObject("POURCENT_RG")) != null) {
                    lremise = lremise.add((BigDecimal)o3);
                }
                int qte = row.getObject("QTE") == null ? 0 : Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal f = (BigDecimal)row.getObject("PV_HT");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                if (lremise.compareTo(BigDecimal.ZERO) > 0 && lremise.compareTo(BigDecimal.valueOf(100L)) < 100) {
                    r = r.multiply(BigDecimal.valueOf(100L).subtract(lremise), DecimalUtils.HIGH_PRECISION).movePointLeft(2);
                }
                if (row.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                    acomptePercent = row.getBigDecimal("POURCENT_REMISE");
                    acompteMontant = row.getBigDecimal("MONTANT_REMISE");
                    Remise remise = new Remise(acomptePercent, acompteMontant);
                    r = remise.getResultFrom(r);
                }
                if (row.getTable().getFieldsName().contains("POURCENT_FACTURABLE")) {
                    acomptePercent = row.getBigDecimal("POURCENT_FACTURABLE");
                    acompteMontant = row.getBigDecimal("MONTANT_FACTURABLE");
                    Acompte acompte = new Acompte(acomptePercent, acompteMontant);
                    r = acompte.getResultFrom(r);
                }
                return r.setScale(AbstractVenteArticleItemTable.this.totalHT.getDecimalDigits(), 4);
            }
        });
        this.totalHA.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal f = (BigDecimal)row.getObject("PA_HT");
                BigDecimal r = b.multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION).multiply(f, DecimalUtils.HIGH_PRECISION).setScale(6, 4);
                return r.setScale(AbstractVenteArticleItemTable.this.totalHA.getDecimalDigits(), 4);
            }

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                super.setValueFrom(row, value);
            }
        });
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            this.qte.addModificationListener(this.tableElementTotalDevise);
            qteU.addModificationListener(this.tableElementTotalDevise);
            if (eltUnitDevise != null) {
                eltUnitDevise.addModificationListener(this.tableElementTotalDevise);
            }
            this.tableElementRemise.addModificationListener(this.tableElementTotalDevise);
            this.tableElementTotalDevise.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    int qte = row.getInt("QTE");
                    BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                    BigDecimal qUnitaire = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                    System.err.println("AbstractVenteArticleItemTable.init() qte:" + qte + " pvUnitaireDevise:" + prixDeVenteUnitaireDevise + " qUnitaire:" + qUnitaire);
                    BigDecimal prixVente = qUnitaire.multiply(prixDeVenteUnitaireDevise.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                    if (row.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                        BigDecimal acomptePercent = row.getBigDecimal("POURCENT_REMISE");
                        BigDecimal acompteMontant = row.getBigDecimal("MONTANT_REMISE");
                        Remise remise = new Remise(acomptePercent, acompteMontant);
                        prixVente = remise.getResultFrom(prixVente);
                    }
                    return prixVente.setScale(AbstractVenteArticleItemTable.this.tableElementTotalDevise.getDecimalDigits(), 4);
                }
            });
        }
        this.totalHT.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTVA.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTotalTTC.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                BigDecimal ht = (BigDecimal)row.getObject("T_PV_HT");
                int idTaux = row.getForeignID("ID_TAXE");
                Float resultTaux = TaxeCache.getCache().getTauxFromId(idTaux);
                if (resultTaux == null) {
                    SQLRow rowTax = TaxeCache.getCache().getFirstTaxe();
                    row.put("ID_TAXE", rowTax.getID());
                    resultTaux = Float.valueOf(rowTax.getFloat("TAUX"));
                }
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                editorPVHT.setTaxe(taux);
                BigDecimal r = ht.multiply(BigDecimal.valueOf(taux).movePointLeft(2).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION);
                BigDecimal resultTTC = r.setScale(AbstractVenteArticleItemTable.this.tableElementTotalTTC.getDecimalDigits(), 4);
                return resultTTC;
            }

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                super.setValueFrom(row, value);
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique2.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique3.addModificationListener(tableElementPoids);
        tableElementPoids.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                return new Float(ReferenceArticleSQLElement.getPoidsFromDetails(row));
            }
        });
        tableElementPoids.addModificationListener(this.tableElementPoidsTotal);
        qteU.addModificationListener(this.tableElementPoidsTotal);
        this.qte.addModificationListener(this.tableElementPoidsTotal);
        this.tableElementPoidsTotal.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                Number f = (Number)row.getObject("POIDS");
                if (f == null) {
                    f = 0;
                }
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                return Float.valueOf(b.multiply(new BigDecimal(f.floatValue() * (float)qte)).floatValue());
            }
        });
        uniteVente.addModificationListener(qteU);
        qteU.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                SQLRowAccessor rowUnite = row.getForeign("ID_UNITE_VENTE");
                if (rowUnite != null && !rowUnite.isUndefined() && rowUnite.getBoolean("A_LA_PIECE").booleanValue()) {
                    return BigDecimal.ONE;
                }
                return row.getObject("QTE_UNITAIRE");
            }
        });
        tableElement_PrixMetrique1_VenteHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (source != null && source.getField().getName().equals("PRIX_METRIQUE_VT_1")) {
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                if (source != null && source.getField().getName().equals("PV_U_DEVISE")) {
                    if (!row.isForeignEmpty("ID_DEVISE")) {
                        String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                        CurrencyConverter c = new CurrencyConverter();
                        BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                        BigDecimal result = c.convert(prixDeVenteUnitaireDevise, devCode, c.getCompanyCurrencyCode(), AbstractVenteArticleItemTable.this.getDateDevise(), AbstractVenteArticleItemTable.this.isUsedBiasedDevise());
                        if (result == null) {
                            result = prixDeVenteUnitaireDevise;
                        }
                        return result.setScale((int)row.getTable().getField("PRIX_METRIQUE_VT_1").getType().getDecimalDigits(), RoundingMode.HALF_UP);
                    }
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                return AbstractVenteArticleItemTable.this.tarifCompletion(row.getForeign("ID_ARTICLE"), "PRIX_METRIQUE_VT_1", row);
            }
        });
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            if (eltUnitDevise != null) {
                eltUnitDevise.addModificationListener(tableElement_PrixMetrique1_VenteHT);
            }
            if (eltUnitDevise != null) {
                tableElement_PrixMetrique1_VenteHT.addModificationListener(eltUnitDevise);
                eltUnitDevise.setModifier(new CellDynamicModifier(){

                    @Override
                    public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                        if (source != null && source.getField().getName().equals("PV_U_DEVISE")) {
                            BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                            return prixDeVenteUnitaireDevise;
                        }
                        if (!row.isForeignEmpty("ID_DEVISE")) {
                            String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                            CurrencyConverter c = new CurrencyConverter();
                            BigDecimal bigDecimal = (BigDecimal)row.getObject("PRIX_METRIQUE_VT_1");
                            BigDecimal result = c.convert(bigDecimal, c.getCompanyCurrencyCode(), devCode, AbstractVenteArticleItemTable.this.getDateDevise(), AbstractVenteArticleItemTable.this.isUsedBiasedDevise());
                            if (result == null) {
                                result = bigDecimal;
                            }
                            return result.setScale((int)row.getTable().getField("PRIX_METRIQUE_VT_1").getType().getDecimalDigits(), RoundingMode.HALF_UP);
                        }
                        if (source != null && source.getField().getName().equalsIgnoreCase("PRIX_METRIQUE_VT_1")) {
                            return row.getObject("PRIX_METRIQUE_VT_1");
                        }
                        BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                        return prixDeVenteUnitaireDevise;
                    }
                });
            }
        }
        tableElement_ValeurMetrique1.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique2.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique3.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixMetrique1_VenteHT.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixVente_HT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                BigDecimal prixVTFromDetails = ReferenceArticleSQLElement.getPrixVTFromDetails(row);
                return prixVTFromDetails.setScale(tableElement_PrixVente_HT.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(this.ha);
        tableElement_ValeurMetrique2.addModificationListener(this.ha);
        tableElement_ValeurMetrique3.addModificationListener(this.ha);
        tableElement_PrixMetrique1_AchatHT.addModificationListener(this.ha);
        this.ha.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return row.getObject("PRIX_METRIQUE_HA_1");
                }
                BigDecimal prixHAFromDetails = ReferenceArticleSQLElement.getPrixHAFromDetails(row);
                return prixHAFromDetails.setScale(AbstractVenteArticleItemTable.this.ha.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        this.table.readState();
        this.setColumnVisible(model.getColumnForField("T_PA_HT"), true);
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ITEM_PACKAGING, false)) {
            this.setColumnVisible(model.getColumnForField("T_POIDS_COLIS_NET"), false);
        }
        boolean modeAvance = DefaultNXProps.getInstance().getBooleanValue("ArticleModeVenteAvance", false);
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_1"), modeAvance);
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_2"), modeAvance);
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_3"), modeAvance);
        this.setColumnVisible(model.getColumnForField("PV_HT"), modeAvance);
        this.setColumnVisible(model.getColumnForField("PA_HT"), modeAvance);
        this.setColumnVisible(model.getColumnForField("ID_MODE_VENTE_ARTICLE"), modeAvance);
        boolean gestionUV = prefs.getBoolean(GestionArticleGlobalPreferencePanel.UNITE_VENTE, true);
        this.setColumnVisible(model.getColumnForField("QTE_UNITAIRE"), gestionUV);
        this.setColumnVisible(model.getColumnForField("ID_UNITE_VENTE"), gestionUV);
        this.setColumnVisible(model.getColumnForField("ID_ARTICLE"), selectArticle);
        this.setColumnVisible(model.getColumnForField("CODE"), !selectArticle || selectArticle && createAuto);
        this.setColumnVisible(model.getColumnForField("NOM"), !selectArticle || selectArticle && createAuto);
        boolean showPoids = DefaultNXProps.getInstance().getBooleanValue("ArticleShowPoids", false);
        this.setColumnVisible(model.getColumnForField("POIDS"), showPoids);
        this.setColumnVisible(model.getColumnForField("T_POIDS"), showPoids);
        this.setColumnVisible(model.getColumnForField("ID_STYLE"), DefaultNXProps.getInstance().getBooleanValue("ArticleShowStyle", true));
        this.setColumnVisible(model.getColumnForField("POURCENT_FACTURABLE"), false);
        this.setColumnVisible(this.getModel().getColumnForField("ID_FAMILLE_ARTICLE"), filterFamilleArticle);
        for (String string : visibilityMap.keySet()) {
            this.setColumnVisible(model.getColumnForField(string), visibilityMap.get(string));
        }
        Map<String, Boolean> mapCustom = this.getCustomVisibilityMap();
        if (mapCustom != null) {
            for (String string : mapCustom.keySet()) {
                this.setColumnVisible(model.getColumnForField(string), mapCustom.get(string));
            }
        }
        this.table.writeState();
    }

    @Override
    protected void refreshDeviseAmount() {
        int count = this.getRowValuesTable().getRowCount();
        int columnForField = this.getRowValuesTable().getRowValuesTableModel().getColumnForField("PV_U_DEVISE");
        if (columnForField >= 0) {
            SQLTableElement eltDevise = this.getRowValuesTable().getRowValuesTableModel().getSQLTableElementAt(columnForField);
            int i = 0;
            while (i < count) {
                SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
                BigDecimal prixDeVenteUnitaireDevise = rowVals.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)rowVals.getObject("PV_U_DEVISE");
                eltDevise.setValueFrom(rowVals, prixDeVenteUnitaireDevise);
                this.getRowValuesTable().getRowValuesTableModel().fireTableChanged(new TableModelEvent(this.getRowValuesTable().getRowValuesTableModel(), i, i, columnForField));
                ++i;
            }
        }
    }

    protected Map<String, Boolean> getCustomVisibilityMap() {
        return null;
    }

    protected Object tarifCompletion(SQLRowAccessor row, String field, SQLRowAccessor rowDest) {
        return this.tarifCompletion(row, field, rowDest, false);
    }

    protected Object tarifCompletion(SQLRowAccessor row, String field, SQLRowAccessor rowDest, boolean fromCompletion) {
        if (this.getTarif() != null && !this.getTarif().isUndefined()) {
            Collection<? extends SQLRowAccessor> rows = row.getReferentRows(this.tableArticleTarif);
            int quantite = 0;
            BigDecimal b = rowDest.getBigDecimal("QTE_UNITAIRE");
            int q = rowDest.getInt("QTE");
            BigDecimal qteTotal = b.multiply(new BigDecimal(q), DecimalUtils.HIGH_PRECISION);
            SQLRowAccessor rowTarif = null;
            for (SQLRowAccessor sQLRowAccessor : rows) {
                if (sQLRowAccessor.getTable().contains("OBSOLETE") && sQLRowAccessor.getBoolean("OBSOLETE").booleanValue()) continue;
                int qteTarif = sQLRowAccessor.getInt("QTE");
                if (sQLRowAccessor.getForeignID("ID_TARIF") != this.getTarif().getID() || CompareUtils.compare(qteTarif, qteTotal) > 0 || CompareUtils.compare(qteTarif, quantite) <= 0) continue;
                quantite = qteTarif;
                rowTarif = sQLRowAccessor;
            }
            if (rowTarif == null) {
                if (!this.getTarif().isForeignEmpty("ID_DEVISE")) {
                    if (field.equalsIgnoreCase("ID_DEVISE")) {
                        return this.getTarif().getObject("ID_DEVISE");
                    }
                    if (field.equalsIgnoreCase("PV_U_DEVISE")) {
                        return row.getBigDecimal("PRIX_METRIQUE_VT_1");
                    }
                }
                if (field.equalsIgnoreCase("ID_TAXE") && !this.getTarif().isForeignEmpty("ID_TAXE")) {
                    return this.getTarif().getForeignID("ID_TAXE");
                }
            } else {
                if (field.equalsIgnoreCase("PRIX_METRIQUE_VT_1")) {
                    if (rowTarif.isForeignEmpty("ID_DEVISE")) {
                        return rowTarif.getObject(field);
                    }
                    String string = this.getTarif().getForeign("ID_DEVISE").getString("CODE");
                    CurrencyConverter c = new CurrencyConverter();
                    BigDecimal result = c.convert(rowTarif.getBigDecimal(field), string, c.getCompanyCurrencyCode(), new Date(), true);
                    return result.setScale((int)row.getTable().getField(field).getType().getDecimalDigits(), RoundingMode.HALF_UP);
                }
                if (field.equalsIgnoreCase("ID_DEVISE")) {
                    return rowTarif.getObject("ID_DEVISE");
                }
                if (field.equalsIgnoreCase("PV_U_DEVISE")) {
                    return rowTarif.getObject("PRIX_METRIQUE_VT_1");
                }
                if (field.equalsIgnoreCase("ID_TAXE") && !rowTarif.isForeignEmpty("ID_TAXE")) {
                    return rowTarif.getObject("ID_TAXE");
                }
            }
        }
        if (field.equalsIgnoreCase("PRIX_METRIQUE_VT_1")) {
            return this.getQtyTarifPvM1(rowDest, fromCompletion);
        }
        return null;
    }

    @Override
    public void setTarif(SQLRowAccessor rowValuesTarif, boolean ask) {
        if (rowValuesTarif == null || this.getTarif() == null || rowValuesTarif.getID() != this.getTarif().getID()) {
            super.setTarif(rowValuesTarif, ask);
            if (ask && this.getRowValuesTable().getRowCount() > 0 && JOptionPane.showConfirmDialog(null, "Appliquer les tarifs associ\u00e9s au client sur les lignes d\u00e9j\u00e0 pr\u00e9sentes?") == 0) {
                int nbRows = this.table.getRowCount();
                int i = 0;
                while (i < nbRows) {
                    SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
                    if (!rowVals.isForeignEmpty("ID_ARTICLE")) {
                        Object deviseValue;
                        SQLRowAccessor rowValsArt = rowVals.getForeign("ID_ARTICLE");
                        Object taxeValue = this.tarifCompletion(rowValsArt, "ID_TAXE", rowVals);
                        if (taxeValue != null) {
                            this.getRowValuesTable().getRowValuesTableModel().putValue(taxeValue, i, "ID_TAXE");
                        }
                        if ((deviseValue = this.tarifCompletion(rowValsArt, "ID_DEVISE", rowVals)) != null) {
                            this.getRowValuesTable().getRowValuesTableModel().putValue(deviseValue, i, "ID_DEVISE");
                        }
                        this.getRowValuesTable().getRowValuesTableModel().putValue(this.tarifCompletion(rowValsArt, "PV_U_DEVISE", rowVals), i, "PV_U_DEVISE");
                        this.getRowValuesTable().getRowValuesTableModel().putValue(this.tarifCompletion(rowValsArt, "PRIX_METRIQUE_VT_1", rowVals), i, "PRIX_METRIQUE_VT_1");
                    }
                    ++i;
                }
            }
        }
    }

    protected Object getQtyTarifPvM1(SQLRowAccessor row, boolean fromCompletion) {
        SQLRowAccessor rowA = row.getForeign("ID_ARTICLE");
        BigDecimal result = null;
        if (rowA != null && !rowA.isUndefined() && rowA.getTable().getDBRoot().contains("ARTICLE_PRIX_PUBLIC")) {
            Collection<? extends SQLRowAccessor> col = rowA.getReferentRows(rowA.getTable().getTable("ARTICLE_PRIX_PUBLIC"));
            int quantite = 0;
            BigDecimal b = row.getBigDecimal("QTE_UNITAIRE");
            int q = row.getInt("QTE");
            BigDecimal qteTotal = b.multiply(new BigDecimal(q), DecimalUtils.HIGH_PRECISION);
            for (SQLRowAccessor sQLRowAccessor : col) {
                int qtePublic = sQLRowAccessor.getInt("QTE");
                if (CompareUtils.compare(qtePublic, qteTotal) > 0 || CompareUtils.compare(qtePublic, quantite) <= 0) continue;
                quantite = qtePublic;
                if (sQLRowAccessor.getBigDecimal("PRIX") == null) continue;
                result = sQLRowAccessor.getBigDecimal("PRIX");
            }
        }
        if (result == null) {
            return fromCompletion ? null : row.getObject("PRIX_METRIQUE_VT_1");
        }
        if (result != null) {
            return result;
        }
        return row.getBigDecimal("PRIX_METRIQUE_VT_1");
    }

    @Override
    protected void setModel(RowValuesTableModel model) {
        super.setModel(model);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AbstractVenteArticleItemTable.this.calculTarifNomenclature();
            }
        });
    }

    public static enum TypeCalcul {
        CALCUL_FACTURABLE("MONTANT_FACTURABLE", "POURCENT_FACTURABLE"),
        CALCUL_REMISE("MONTANT_REMISE", "POURCENT_REMISE");

        String fieldMontant;
        String fieldPourcent;

        private TypeCalcul(String fieldMontant, String fieldPourcent) {
            this.fieldMontant = fieldMontant;
            this.fieldPourcent = fieldPourcent;
        }

        public String getFieldMontant() {
            return this.fieldMontant;
        }

        public String getFieldPourcent() {
            return this.fieldPourcent;
        }
    }
}

