/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.config.ServerFinderConfig;
import org.openconcerto.erp.config.ServerFinderPanel;
import org.openconcerto.erp.core.sales.order.ui.EtatCommandeClient;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.sql.changer.convert.AddFK;
import org.openconcerto.sql.changer.convert.ChangeIDToInt;
import org.openconcerto.sql.changer.correct.CorrectOrder;
import org.openconcerto.sql.changer.correct.FixSerial;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.SQLKey;
import org.openconcerto.sql.request.Inserter;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.sql.utils.SQLCreateMoveableTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.cc.ITransformer;

public class InstallationPanel
extends JPanel {
    private static final boolean DEBUG_FK = false;
    JProgressBar bar = new JProgressBar();
    boolean error;

    private static void insertUndef(SQLCreateTable ct) throws SQLException {
        if (ct.getPrimaryKey().size() != 1) {
            throw new IllegalStateException("Not one and only one field in the PK : " + ct.getPrimaryKey());
        }
        Inserter.Insertion<?> insertion = new Inserter(ct).insertReturnFirstField("(" + SQLBase.quoteIdentifier("ORDRE") + ") VALUES(" + ReOrder.MIN_ORDER + ")", false);
        assert (insertion.getCount() == 1);
        if (insertion.getRows().size() != 1) {
            throw new IllegalStateException("Missing ID " + insertion.getRows());
        }
        SQLTable.setUndefID(ct.getRoot().getSchema(), ct.getName(), ((Number)insertion.getRows().get(0)).intValue());
    }

    private static SQLName getTableName(SQLCreateTable ct) {
        return new SQLName(ct.getRoot().getName(), ct.getName());
    }

    public InstallationPanel(final ServerFinderPanel finderPanel) {
        super(new GridBagLayout());
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JButton user = new JButton("Cr\u00e9er l'utilisateur");
        user.setOpaque(false);
        final JButton up = new JButton("Mise \u00e0 niveau de la base");
        up.setOpaque(false);
        up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                finderPanel.saveConfigFile();
                InstallationPanel.this.bar.setIndeterminate(true);
                up.setEnabled(false);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        System.setProperty("org.openconcerto.sql.noautoCreateMetadata", "false");
                        final ComptaPropsConfiguration conf = ComptaPropsConfiguration.create(true);
                        try {
                            final SQLDataSource ds = conf.getSystemRoot().getDataSource();
                            System.err.println("SystemRoot:" + conf.getSystemRoot());
                            System.err.println("Root:" + conf.getRoot());
                            InstallationPanel.this.fixUnboundedVarchar(conf.getRoot());
                            final SQLTable table = conf.getRoot().getTable("VARIABLE_PAYE");
                            System.out.println("InstallationPanel.InstallationPanel() UPDATE PAYE");
                            InstallationPanel.this.updateVariablePaye(table, "SMIC", 9.0);
                            InstallationPanel.this.updateVariablePaye(table, "TRANCHE_A", 2946.0);
                            InstallationPanel.this.updateVariablePaye(table, "PART_SAL_GarantieMP", 23.83);
                            InstallationPanel.this.updateVariablePaye(table, "PART_PAT_GarantieMP", 38.98);
                            InstallationPanel.this.updateSocieteTable(conf.getRoot());
                            InstallationPanel.this.updateVille(conf.getRoot().getTable("ADRESSE"));
                            InstallationPanel.this.checkRights(conf.getRoot());
                            if (!table.getDBRoot().contains("DEVISE")) {
                                System.out.println("InstallationPanel.InstallationPanel() ADD DEVISE");
                                try {
                                    SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                                        @Override
                                        public Object create() throws SQLException {
                                            SQLCreateTable createDevise = new SQLCreateTable(table.getDBRoot(), "DEVISE");
                                            createDevise.addVarCharColumn("CODE", 128);
                                            createDevise.addVarCharColumn("NOM", 128);
                                            createDevise.addVarCharColumn("LIBELLE", 128);
                                            createDevise.addVarCharColumn("LIBELLE_CENT", 128);
                                            createDevise.addDecimalColumn("TAUX", 16, 8, BigDecimal.ONE, false);
                                            createDevise.addDecimalColumn("TAUX_COMMERCIAL", 16, 8, BigDecimal.ONE, false);
                                            ds.execute(createDevise.asString());
                                            InstallationPanel.insertUndef(createDevise);
                                            conf.getRoot().getSchema().updateVersion();
                                            return null;
                                        }
                                    });
                                }
                                catch (Exception ex) {
                                    throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table DEVISE", ex);
                                }
                            } else if (!table.getDBRoot().getTable("DEVISE").contains("TAUX_COMMERCIAL")) {
                                SQLTable tDevise = conf.getRoot().getTable("DEVISE");
                                AlterTable alterDevise = new AlterTable(tDevise);
                                alterDevise.addDecimalColumn("TAUX_COMMERCIAL", 16, 8, BigDecimal.ONE, false);
                                ds.execute(alterDevise.asString());
                                tDevise.getSchema().updateVersion();
                            }
                            if (!table.getDBRoot().contains("TYPE_MODELE")) {
                                System.out.println("InstallationPanel.InstallationPanel() ADD TYPE_MODELE");
                                try {
                                    SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                                        @Override
                                        public Object create() throws SQLException {
                                            SQLCreateTable createTypeModele = new SQLCreateTable(table.getDBRoot(), "TYPE_MODELE");
                                            createTypeModele.addVarCharColumn("NOM", 128);
                                            createTypeModele.addVarCharColumn("TABLE", 128);
                                            createTypeModele.addVarCharColumn("DEFAULT_MODELE", 128);
                                            ds.execute(createTypeModele.asString());
                                            InstallationPanel.insertUndef(createTypeModele);
                                            conf.getRoot().getSchema().updateVersion();
                                            conf.getRoot().refetch();
                                            return null;
                                        }
                                    });
                                    String[] type = new String[]{"Avoir client", "AVOIR_CLIENT", "Avoir", "Bon de livraison", "BON_DE_LIVRAISON", "BonLivraison", "Commande Client", "COMMANDE_CLIENT", "CommandeClient", "Devis", "DEVIS", "Devis", "Facture", "SAISIE_VENTE_FACTURE", "VenteFacture"};
                                    ArrayList<String> values = new ArrayList<String>();
                                    SQLBase base = table.getDBRoot().getBase();
                                    int i = 0;
                                    while (i < type.length) {
                                        int order = values.size() + 1;
                                        values.add("(" + base.quoteString(type[i]) + ", " + base.quoteString(type[i + 1]) + ", " + base.quoteString(type[i + 2]) + ", " + order + ")");
                                        i += 3;
                                    }
                                    String valuesStr = CollectionUtils.join(values, ", ");
                                    String insertVals = "INSERT INTO " + conf.getRoot().getTable("TYPE_MODELE").getSQLName().quote() + "(" + SQLBase.quoteIdentifier("NOM") + ", " + SQLBase.quoteIdentifier("TABLE") + ", " + SQLBase.quoteIdentifier("DEFAULT_MODELE") + ", " + SQLBase.quoteIdentifier("ORDRE") + ") VALUES" + valuesStr;
                                    ds.execute(insertVals);
                                }
                                catch (Exception ex) {
                                    throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TYPE_MODELE", ex);
                                }
                            }
                            SQLTable.setUndefID(conf.getRoot().getSchema(), "DEVISE", 1);
                            SQLTable.setUndefID(conf.getRoot().getSchema(), "TYPE_MODELE", 1);
                            conf.getSystemRoot().mapAllRoots();
                            conf.getSystemRoot().refetch();
                            final Set<String> childrenNames = conf.getSystemRoot().getChildrenNames();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((this).this).InstallationPanel.this.bar.setIndeterminate(false);
                                    ((this).this).InstallationPanel.this.bar.setMaximum(childrenNames.size() + 1);
                                }
                            });
                            int i = 1;
                            for (String childName : childrenNames) {
                                System.out.println("InstallationPanel.InstallationPanel() UPDATE SCHEMA " + childName);
                                final int barValue = i++;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((this).this).InstallationPanel.this.bar.setValue(barValue);
                                    }
                                });
                                final DBRoot root = conf.getSystemRoot().getRoot(childName);
                                try {
                                    conf.getSystemRoot().getDataSource().execute("CREATE LANGUAGE plpgsql;");
                                }
                                catch (Exception e) {
                                    System.err.println("Warning: cannot add language plpgsql" + e.getMessage());
                                }
                                SQLTable tableUndef = root.getTable("FWK_UNDEFINED_IDS");
                                if (tableUndef != null && tableUndef.getField("UNDEFINED_ID").isNullable() == Boolean.FALSE) {
                                    AlterTable alterUndef = new AlterTable(tableUndef);
                                    alterUndef.alterColumn("TABLENAME", EnumSet.allOf(SQLField.Properties.class), "varchar(250)", "''", false);
                                    alterUndef.alterColumn("UNDEFINED_ID", EnumSet.allOf(SQLField.Properties.class), "int", null, true);
                                    try {
                                        ds.execute(alterUndef.asString());
                                        tableUndef.getSchema().updateVersion();
                                    }
                                    catch (SQLException ex) {
                                        throw new IllegalStateException("Erreur lors de la modification de UNDEFINED_ID", ex);
                                    }
                                }
                                if (childName.equalsIgnoreCase("Common")) {
                                    InstallationPanel.this.updateCommon(root);
                                    continue;
                                }
                                if (!childName.startsWith(conf.getAppName()) && !childName.equalsIgnoreCase("Default")) continue;
                                SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                                    @Override
                                    public Object create() throws SQLException {
                                        InstallationPanel.this.fixUnboundedVarchar(root);
                                        InstallationPanel.this.fixUnboundedNumeric(root);
                                        InstallationPanel.this.fixCompletion(root);
                                        try {
                                            InstallationPanel.this.updateSocieteSchema(root);
                                        }
                                        catch (Exception e) {
                                            throw new SQLException(e);
                                        }
                                        InstallationPanel.this.updateToV1Dot2(root);
                                        InstallationPanel.this.updateToV1Dot3(root);
                                        InstallationPanel.this.updateToV1Dot4(root);
                                        InstallationPanel.this.updateStyle(root);
                                        InstallationPanel.this.createBanque(root);
                                        InstallationPanel.this.createAssocAnalytique(root, conf);
                                        InstallationPanel.this.updateStock(root);
                                        InstallationPanel.this.updateVille(root.getTable("ADRESSE"));
                                        return null;
                                    }
                                });
                            }
                            (this).InstallationPanel.this.error = false;
                        }
                        catch (Throwable e1) {
                            ExceptionHandler.handle("Echec de mise \u00e0 jour", e1);
                            (this).InstallationPanel.this.error = true;
                        }
                        conf.destroy();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                up.setEnabled(true);
                                ((this).this).InstallationPanel.this.bar.setValue(((this).this).InstallationPanel.this.bar.getMaximum());
                                if (!((this).this).InstallationPanel.this.error) {
                                    JOptionPane.showMessageDialog(InstallationPanel.this, "Mise \u00e0 niveau r\u00e9ussie");
                                }
                            }
                        });
                        System.setProperty("org.openconcerto.sql.noautoCreateMetadata", "true");
                    }
                }, "Database structure updater").start();
            }
        });
        if (finderPanel.getToken() == null) {
            c.weightx = 1.0;
            c.gridwidth = 0;
            this.add((Component)new JLabelBold("Cr\u00e9ation de l'utilisateur openconcerto dans la base"), c);
            ++c.gridy;
            c.weightx = 1.0;
            this.add((Component)new JLabel("Identifiant de connexion de votre base "), c);
            ++c.gridy;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Login"), c);
            ++c.gridx;
            final JTextField login = new JTextField();
            c.weightx = 1.0;
            this.add((Component)login, c);
            ++c.gridx;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Mot de passe"), c);
            ++c.gridx;
            final JTextField mdp = new JTextField();
            c.weightx = 1.0;
            this.add((Component)mdp, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.anchor = 13;
            c.gridwidth = 0;
            c.fill = 0;
            this.add((Component)user, c);
            c.anchor = 17;
            c.fill = 2;
            c.gridwidth = 1;
            user.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (finderPanel.getServerConfig().createUserIfNeeded(login.getText(), mdp.getText())) {
                            JOptionPane.showMessageDialog(InstallationPanel.this, "L'utilisateur openconcerto a \u00e9t\u00e9 correctement ajout\u00e9.");
                        } else {
                            JOptionPane.showMessageDialog(InstallationPanel.this, "L'utilisateur openconcerto existe d\u00e9j\u00e0 dans la base.");
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(InstallationPanel.this, "Une erreur est survenue pendant la connexion au serveur, v\u00e9rifiez vos param\u00e8tres de connexion.");
                    }
                }
            });
            ++c.gridy;
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.insets = new Insets(10, 3, 2, 2);
            this.add((Component)new JLabelBold("Param\u00e8trages de la base de donn\u00e9es"), c);
            ++c.gridy;
            c.insets = DefaultGridBagConstraints.getDefaultInsets();
            this.add((Component)new JLabel("Cr\u00e9ation des fonctions SQL n\u00e9cessaires (plpgsql)."), c);
            ++c.gridy;
            c.weightx = 0.0;
            c.anchor = 13;
            c.gridwidth = 0;
            c.fill = 0;
            JButton buttonPL = new JButton("Lancer");
            buttonPL.setOpaque(false);
            buttonPL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (finderPanel.getServerConfig().getType().equals((Object)ServerFinderConfig.POSTGRESQL)) {
                        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create(true);
                        try {
                            SQLDataSource ds = conf.getSystemRoot().getDataSource();
                            ds.execute("CREATE LANGUAGE plpgsql;");
                        }
                        catch (Exception ex) {
                            System.err.println("Impossible d'ajouter le langage PLPGSQL. Peut etre est il d\u00e9j\u00e0 install\u00e9.");
                        }
                    }
                    JOptionPane.showMessageDialog(null, "Param\u00e8trage termin\u00e9.");
                }
            });
            this.add((Component)buttonPL, c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets = new Insets(10, 3, 2, 2);
        this.add((Component)new JLabelBold("Mise \u00e0 niveau de la base OpenConcerto"), c);
        ++c.gridy;
        c.insets = DefaultGridBagConstraints.getDefaultInsets();
        this.add((Component)new JLabel("Cette op\u00e9ration est n\u00e9cessaire \u00e0 chaque mise \u00e0 jour du logiciel."), c);
        ++c.gridy;
        this.add((Component)new JLabel("La mise \u00e0 niveau peut prendre plusieurs minutes."), c);
        ++c.gridy;
        this.add((Component)this.bar, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.anchor = 13;
        c.gridwidth = 0;
        c.fill = 0;
        this.add((Component)up, c);
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.weighty = 1.0;
        ++c.gridy;
        JPanel comp = new JPanel();
        comp.setOpaque(false);
        this.add((Component)comp, c);
    }

    private void addArticleFournisseur(DBRoot root) {
        if (!root.contains("ARTICLE_FOURNISSEUR")) {
            SQLCreateTable createBaseFamille = new SQLCreateTable(root, "FAMILLE_ARTICLE_FOURNISSEUR");
            createBaseFamille.addVarCharColumn("CODE", 45);
            createBaseFamille.addVarCharColumn("NOM", 2048);
            createBaseFamille.addForeignColumn("ID_FAMILLE_ARTICLE_FOURNISSEUR_PERE", createBaseFamille);
            SQLDataSource ds = root.getDBSystemRoot().getDataSource();
            try {
                ds.execute(createBaseFamille.asString());
                InstallationPanel.insertUndef(createBaseFamille);
                root.refetchTable("FAMILLE_ARTICLE_FOURNISSEUR");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table FAMILLE_ARTICLE_FOURNISSEUR", ex);
            }
            SQLCreateTable createBase = new SQLCreateTable(root, "ARTICLE_FOURNISSEUR");
            createBase.addVarCharColumn("CODE", 45);
            createBase.addVarCharColumn("CODE_BARRE", 45);
            createBase.addVarCharColumn("CODE_DOUANIER", 45);
            createBase.addVarCharColumn("NOM", 2048);
            createBase.addVarCharColumn("DESCRIPTIF", 2048);
            createBase.addVarCharColumn("INFOS", 2048);
            createBase.addColumn("PRIX_METRIQUE_HA_1", "numeric (16,6) DEFAULT 0");
            createBase.addColumn("PRIX_METRIQUE_HA_2", "numeric (16,8) DEFAULT 0");
            createBase.addColumn("PRIX_METRIQUE_HA_3", "numeric (16,8) DEFAULT 0");
            createBase.addColumn("PRIX_METRIQUE_VT_1", "numeric (16,8) DEFAULT 0");
            createBase.addColumn("PRIX_METRIQUE_VT_2", "numeric (16,8) DEFAULT 0");
            createBase.addColumn("PRIX_METRIQUE_VT_3", "numeric (16,8) DEFAULT 0");
            createBase.addForeignColumn("ID_METRIQUE_1", root.findTable("METRIQUE", true));
            createBase.addForeignColumn("ID_METRIQUE_2", root.findTable("METRIQUE", true));
            createBase.addForeignColumn("ID_METRIQUE_3", root.findTable("METRIQUE", true));
            createBase.addColumn("PA_DEVISE", "numeric (16,8) DEFAULT 0");
            createBase.addColumn("PV_U_DEVISE", "numeric (16,8) DEFAULT 0");
            createBase.addColumn("PA_HT", "numeric (16,8) DEFAULT 0");
            createBase.addColumn("PV_HT", "numeric (16,8) DEFAULT 0");
            createBase.addColumn("PV_TTC", "numeric (16,2) DEFAULT 0");
            createBase.addForeignColumn("ID_TAXE", root.findTable("TAXE", true));
            createBase.addForeignColumn("ID_FAMILLE_ARTICLE_FOURNISSEUR", root.findTable("FAMILLE_ARTICLE_FOURNISSEUR", true));
            createBase.addForeignColumn("ID_MODE_VENTE_ARTICLE", root.findTable("MODE_VENTE_ARTICLE", true));
            createBase.addForeignColumn("ID_FOURNISSEUR", root.findTable("FOURNISSEUR", true));
            createBase.addForeignColumn("ID_PAYS", root.findTable("PAYS", true));
            createBase.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            createBase.addForeignColumn("ID_DEVISE_HA", root.findTable("DEVISE", true));
            createBase.addForeignColumn("ID_UNITE_VENTE", root.findTable("UNITE_VENTE", true));
            createBase.addForeignColumn("ID_COMPTE_PCE", root.findTable("COMPTE_PCE", true));
            createBase.addForeignColumn("ID_COMPTE_PCE_ACHAT", root.findTable("COMPTE_PCE", true));
            createBase.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE", true));
            createBase.addColumn("POIDS", "real DEFAULT 0");
            createBase.addColumn("VALEUR_METRIQUE_1", "real DEFAULT 0");
            createBase.addColumn("VALEUR_METRIQUE_2", "real DEFAULT 0");
            createBase.addColumn("VALEUR_METRIQUE_3", "real DEFAULT 0");
            createBase.addBooleanColumn("SERVICE", Boolean.FALSE, false);
            createBase.addBooleanColumn("OBSOLETE", Boolean.FALSE, false);
            createBase.addBooleanColumn("GESTION_STOCK", Boolean.FALSE, false);
            createBase.addIntegerColumn("QTE_ACHAT", 1);
            createBase.addIntegerColumn("QTE_MIN", 1);
            try {
                ds.execute(createBase.asString());
                InstallationPanel.insertUndef(createBase);
                root.refetchTable("ARTICLE_FOURNISSEUR");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ARTICLE_FOURNISSEUR", ex);
            }
        }
    }

    private void addContact(DBRoot root) throws SQLException {
        List<String> tables = Arrays.asList("AVOIR_CLIENT", "DEVIS", "BON_DE_LIVRAISON", "COMMANDE_CLIENT", "SAISIE_VENTE_FACTURE");
        SQLTable tableContact = root.findTable("CONTACT");
        SQLTable tableDpt = root.findTable("CLIENT_DEPARTEMENT");
        SQLDataSource dataSource = root.getDBSystemRoot().getDataSource();
        for (String tableName : tables) {
            boolean update = false;
            SQLTable table = root.getTable(tableName);
            AlterTable alterEcheance = new AlterTable(table);
            if (!table.contains("ID_CONTACT")) {
                alterEcheance.addForeignColumn("ID_CONTACT", tableContact);
                update = true;
            }
            if (!table.contains("ID_CLIENT_DEPARTEMENT")) {
                alterEcheance.addForeignColumn("ID_CLIENT_DEPARTEMENT", tableDpt);
                update = true;
            }
            if (!update) continue;
            dataSource.execute(alterEcheance.asString());
            table.getSchema().updateVersion();
        }
    }

    private void addForeignKeyFactureOnEcheance(DBRoot root) {
        SQLTable tableEch = root.getTable("ECHEANCE_CLIENT");
        if (!tableEch.contains("ID_SAISIE_VENTE_FACTURE")) {
            SQLTable tableFacture = root.getTable("SAISIE_VENTE_FACTURE");
            SQLTable tableMvt = root.getTable("MOUVEMENT");
            String query = "no query";
            try {
                SQLDataSource dataSource = root.getDBSystemRoot().getDataSource();
                AlterTable alterEcheance = new AlterTable(tableEch);
                alterEcheance.addForeignColumn("ID_SAISIE_VENTE_FACTURE", tableFacture);
                dataSource.execute(alterEcheance.asString());
                tableEch.getSchema().updateVersion();
                tableEch.fetchFields();
                SQLSelect selMvt = new SQLSelect();
                AliasedTable refChild = new AliasedTable(tableMvt, "m1");
                AliasedTable refParent = new AliasedTable(tableMvt, "m2");
                selMvt.addSelect(refParent.getField("IDSOURCE"));
                selMvt.addBackwardJoin("INNER", refChild.getField("ID_MOUVEMENT_PERE"), refParent.getAlias());
                selMvt.addSelect(refChild.getKey());
                selMvt.setWhere(new Where((FieldRef)refParent.getField("SOURCE"), "=", (Object)tableFacture.getName()));
                UpdateBuilder build = new UpdateBuilder(tableEch);
                build.addVirtualJoin("( " + selMvt.asString() + " )", "mvt", false, tableMvt.getKey().getName(), "ID_MOUVEMENT");
                build.setFromVirtualJoinField("ID_SAISIE_VENTE_FACTURE", "mvt", "IDSOURCE");
                query = build.asString();
                dataSource.execute(query);
            }
            catch (SQLException ex) {
                Log.get().severe("Error on query :" + query);
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table ECHEANCE_CLIENT", ex);
            }
        }
    }

    private void addFieldForPartialInvoice(DBRoot root) throws SQLException {
        SQLTable tableVF = root.getTable("SAISIE_VENTE_FACTURE");
        AlterTable alter = new AlterTable(tableVF);
        boolean doAlter = false;
        if (!tableVF.contains("POURCENT_FACTURABLE")) {
            alter.addColumn("POURCENT_FACTURABLE", "numeric (16,8)");
            doAlter = true;
        }
        if (!tableVF.contains("MONTANT_FACTURABLE")) {
            alter.addColumn("MONTANT_FACTURABLE", "numeric (16,8)");
            doAlter = true;
        }
        if (!tableVF.contains("SOLDE")) {
            alter.addColumn("SOLDE", "boolean DEFAULT false");
            doAlter = true;
        }
        if (!tableVF.contains("PARTIAL")) {
            alter.addColumn("PARTIAL", "boolean DEFAULT false");
            doAlter = true;
        }
        if (doAlter) {
            root.getDBSystemRoot().getDataSource().execute(alter.asString());
            root.refetchTable(tableVF.getName());
        }
        SQLTable tableVFElt = root.getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        AlterTable alterElt = new AlterTable(tableVFElt);
        boolean doAlterElt = false;
        if (!tableVFElt.contains("MONTANT_FACTURABLE")) {
            alterElt.addColumn("MONTANT_FACTURABLE", "numeric (16,8)");
            doAlterElt = true;
        }
        if (!tableVFElt.contains("POURCENT_FACTURABLE")) {
            alterElt.addColumn("POURCENT_FACTURABLE", "numeric (16,8)");
            doAlterElt = true;
        }
        if (doAlterElt) {
            root.getDBSystemRoot().getDataSource().execute(alterElt.asString());
            root.refetchTable(tableVFElt.getName());
        }
    }

    private void createAssocAnalytique(DBRoot root, ComptaPropsConfiguration conf) {
        SQLTable tablePoste;
        if (!root.contains("ASSOCIATION_ANALYTIQUE")) {
            SQLCreateTable createAssoc = new SQLCreateTable(root, "ASSOCIATION_ANALYTIQUE");
            createAssoc.addForeignColumn("ID_ECRITURE", root.findTable("ECRITURE", true));
            createAssoc.addForeignColumn("ID_SAISIE_KM_ELEMENT", root.findTable("SAISIE_KM_ELEMENT", true));
            createAssoc.addForeignColumn("ID_POSTE_ANALYTIQUE", root.findTable("POSTE_ANALYTIQUE", true));
            createAssoc.addColumn("POURCENT", "numeric (16,8) DEFAULT 100");
            createAssoc.addColumn("MONTANT", "bigInt DEFAULT 0");
            createAssoc.addBooleanColumn("GESTION_AUTO", false, false);
            SQLDataSource ds = root.getDBSystemRoot().getDataSource();
            try {
                ds.execute(createAssoc.asString());
                InstallationPanel.insertUndef(createAssoc);
                root.refetchTable("ASSOCIATION_ANALYTIQUE");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ASSOCIATION_ANALYTIQUE", ex);
            }
        }
        if (!(tablePoste = root.getTable("POSTE_ANALYTIQUE")).contains("DEFAULT")) {
            AlterTable a = new AlterTable(tablePoste);
            a.addBooleanColumn("DEFAULT", Boolean.FALSE, false);
            SQLDataSource ds = root.getDBSystemRoot().getDataSource();
            try {
                ds.execute(a.asString());
                root.refetchTable("POSTE_ANALYTIQUE");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation du DEFAULT sur la table POSTE_ANALYTIQUE", ex);
            }
        }
    }

    private void updateStock(DBRoot root) throws SQLException {
        SQLTable tableStock = root.getTable("STOCK");
        SQLDataSource ds = root.getDBSystemRoot().getDataSource();
        if (!tableStock.contains("QTE_RECEPT_ATTENTE")) {
            try {
                AlterTable alterElt = new AlterTable(root.getTable("STOCK"));
                alterElt.addColumn("QTE_RECEPT_ATTENTE", "real DEFAULT 0");
                alterElt.addColumn("QTE_LIV_ATTENTE", "real DEFAULT 0");
                ds.execute(alterElt.asString());
                AlterTable alterMvt = new AlterTable(root.getTable("MOUVEMENT_STOCK"));
                alterMvt.addBooleanColumn("REEL", Boolean.TRUE, false);
                ds.execute(alterMvt.asString());
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la mise \u00e0 jour des tables de stock", ex);
            }
        }
    }

    private void createBanque(DBRoot root) throws SQLException {
        if (!root.contains("BANQUE") && !root.contains("BANQUE_POLE_PRODUIT")) {
            SQLCreateTable createBanque = new SQLCreateTable(root, "BANQUE");
            createBanque.addForeignColumn("ID_JOURNAL", root.findTable("JOURNAL", true));
            createBanque.addVarCharColumn("INFOS", 2048);
            createBanque.addVarCharColumn("NUMERO_RUE", 45);
            createBanque.addVarCharColumn("RUE", 256);
            createBanque.addVarCharColumn("IBAN", 256);
            createBanque.addVarCharColumn("BIC", 256);
            createBanque.addVarCharColumn("VOIE", 256);
            createBanque.addVarCharColumn("VILLE", 256);
            createBanque.addVarCharColumn("NOM", 256);
            createBanque.addVarCharColumn("DOMICILIATION", 256);
            createBanque.addVarCharColumn("CODE", 256);
            createBanque.addBooleanColumn("AFFACTURAGE", Boolean.FALSE, false);
            createBanque.addForeignColumn("ID_COMPTE_PCE", root.findTable("COMPTE_PCE", true));
            SQLDataSource ds = root.getDBSystemRoot().getDataSource();
            try {
                ds.execute(createBanque.asString());
                InstallationPanel.insertUndef(createBanque);
                root.refetchTable("BANQUE");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table BANQUE", ex);
            }
        }
        SQLDataSource ds = root.getDBSystemRoot().getDataSource();
        List<String> tablesWithBanque = Arrays.asList("MODE_REGLEMENT", "CHEQUE_A_ENCAISSER", "CHEQUE_FOURNISSEUR");
        for (String string : tablesWithBanque) {
            SQLTable table = root.getTable(string);
            if (table.contains("ID_BANQUE") || table.contains("ID_BANQUE_POLE_PRODUIT")) continue;
            String tableName = table.contains("ID_BANQUE_PRODUIT") ? "BANQUE_POLE_PRODUIT" : "BANQUE";
            AlterTable alterElt = new AlterTable(table);
            alterElt.addForeignColumn("ID_" + tableName, root.getTable(tableName));
            ds.execute(alterElt.asString());
            root.refetchTable(string);
            root.getSchema().updateVersion();
        }
    }

    private void createFactureFournisseur(DBRoot root) throws SQLException {
        SQLDataSource ds;
        SQLCreateTable createFactureF;
        boolean refetchRoot = false;
        if (!root.contains("FACTURE_FOURNISSEUR")) {
            createFactureF = new SQLCreateTable(root, "FACTURE_FOURNISSEUR");
            createFactureF.addVarCharColumn("NOM", 256);
            createFactureF.addVarCharColumn("NUMERO", 45);
            createFactureF.addVarCharColumn("INFOS", 2048);
            createFactureF.addColumn("DATE", "date");
            createFactureF.addForeignColumn("FOURNISSEUR");
            createFactureF.addForeignColumn("AVOIR_FOURNISSEUR");
            createFactureF.addForeignColumn("COMPTE_PCE");
            createFactureF.addForeignColumn("COMMERCIAL");
            createFactureF.addForeignColumn("MODE_REGLEMENT");
            createFactureF.addForeignColumn("MOUVEMENT");
            createFactureF.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            createFactureF.addColumn("T_HT", "bigint DEFAULT 0");
            createFactureF.addColumn("T_TVA", "bigint DEFAULT 0");
            createFactureF.addColumn("T_TTC", "bigint DEFAULT 0");
            createFactureF.addColumn("T_SERVICE", "bigint DEFAULT 0");
            createFactureF.addColumn("T_DEVISE", "bigint DEFAULT 0");
            createFactureF.addColumn("T_POIDS", "real DEFAULT 0");
            ds = root.getDBSystemRoot().getDataSource();
            try {
                ds.execute(createFactureF.asString());
                InstallationPanel.insertUndef(createFactureF);
                root.getSchema().updateVersion();
                root.refetchTable("FACTURE_FOURNISSEUR");
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table FACTURE_FOURNISSEUR", ex);
            }
        }
        if (!root.contains("FACTURE_FOURNISSEUR_ELEMENT")) {
            createFactureF = new SQLCreateTable(root, "FACTURE_FOURNISSEUR_ELEMENT");
            createFactureF.addDecimalColumn("PRIX_METRIQUE_HA_1", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("PRIX_METRIQUE_HA_2", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("PRIX_METRIQUE_HA_3", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("PRIX_METRIQUE_VT_1", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("PRIX_METRIQUE_VT_2", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("PRIX_METRIQUE_VT_3", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("T_PV_HT", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("T_PA_HT", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("PV_HT", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("PA_HT", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("T_PV_TTC", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("T_PA_TTC", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("QTE_UNITAIRE", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("PA_DEVISE_T", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addDecimalColumn("PA_DEVISE", 16, 6, BigDecimal.ZERO, false);
            createFactureF.addIntegerColumn("QTE", 1);
            createFactureF.addIntegerColumn("QTE_ACHAT", 1);
            createFactureF.addColumn("VALEUR_METRIQUE_1", "real DEFAULT 0");
            createFactureF.addColumn("VALEUR_METRIQUE_2", "real DEFAULT 0");
            createFactureF.addColumn("VALEUR_METRIQUE_3", "real DEFAULT 0");
            createFactureF.addColumn("T_POIDS", "real DEFAULT 0");
            createFactureF.addColumn("POIDS", "real DEFAULT 0");
            createFactureF.addBooleanColumn("SERVICE", Boolean.FALSE, true);
            createFactureF.addVarCharColumn("CODE", 45);
            createFactureF.addVarCharColumn("NOM", 256);
            createFactureF.addColumn("DATE", "date");
            createFactureF.addForeignColumn("STYLE");
            createFactureF.addForeignColumn("METRIQUE", "3");
            createFactureF.addForeignColumn("METRIQUE", "2");
            createFactureF.addForeignColumn("METRIQUE", "1");
            createFactureF.addForeignColumn("FACTURE_FOURNISSEUR");
            createFactureF.addForeignColumn("TAXE");
            createFactureF.addForeignColumn("ID_MODE_VENTE_ARTICLE", root.findTable("MODE_VENTE_ARTICLE").getSQLName(), "ID", "5");
            createFactureF.addForeignColumn("UNITE_VENTE");
            createFactureF.addForeignColumn("ARTICLE");
            createFactureF.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            createFactureF.addForeignColumn("CODE_FOURNISSEUR");
            ds = root.getDBSystemRoot().getDataSource();
            try {
                ds.execute(createFactureF.asString());
                InstallationPanel.insertUndef(createFactureF);
                root.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table FACTURE_FOURNISSEUR_ELEMENT", ex);
            }
        }
        if (!root.contains("REGLER_MONTANT_ELEMENT")) {
            SQLCreateTable createReglerElt = new SQLCreateTable(root, "REGLER_MONTANT_ELEMENT");
            createReglerElt.addForeignColumn("ECHEANCE_FOURNISSEUR");
            createReglerElt.addForeignColumn("REGLER_MONTANT");
            createReglerElt.addForeignColumn("MOUVEMENT", "ECHEANCE");
            createReglerElt.addColumn("DATE", "date");
            createReglerElt.addColumn("MONTANT_REGLE", "bigint DEFAULT 0");
            createReglerElt.addColumn("MONTANT_A_REGLER", "bigint DEFAULT 0");
            ds = root.getDBSystemRoot().getDataSource();
            try {
                ds.execute(createReglerElt.asString());
                InstallationPanel.insertUndef(createReglerElt);
                root.getSchema().updateVersion();
                root.refetchTable("REGLER_MONTANT_ELEMENT");
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table REGLER_MONTANT_ELEMENT", ex);
            }
        }
        SQLTable tableReglerMontant = root.getTable("REGLER_MONTANT");
        boolean updateRegler = false;
        AlterTable alterElt = new AlterTable(tableReglerMontant);
        if (!tableReglerMontant.contains("ID_FOURNISSEUR")) {
            alterElt.addForeignColumn("ID_FOURNISSEUR", root.getTable("FOURNISSEUR"));
            updateRegler = true;
        }
        if (!tableReglerMontant.contains("NOM")) {
            alterElt.addVarCharColumn("NOM", 256);
            updateRegler = true;
        }
        if (updateRegler) {
            root.getDBSystemRoot().getDataSource().execute(alterElt.asString());
            root.refetchTable(tableReglerMontant.getName());
        }
        if (refetchRoot) {
            root.refetch();
        }
    }

    private void fixUnboundedNumeric(DBRoot root) throws SQLException {
        SQLField fieldRepFacture;
        SQLField fieldRemiseFacture;
        SQLField fieldAcompteFacture;
        SQLField fieldRemiseAvoir;
        UpdateBuilder build;
        String fName;
        SQLField fieldAcompteAvoir;
        ArrayList<AlterTable> alters = new ArrayList<AlterTable>();
        ArrayList<UpdateBuilder> builds = new ArrayList<UpdateBuilder>();
        SQLTable tableAvoir = root.getTable("AVOIR_CLIENT_ELEMENT");
        AlterTable alter = new AlterTable(tableAvoir);
        if (tableAvoir.contains("POURCENT_ACOMPTE") && (fieldAcompteAvoir = tableAvoir.getField("POURCENT_ACOMPTE")).getType().getSize() > 500) {
            fName = fieldAcompteAvoir.getName();
            alter.alterColumn(fName, EnumSet.allOf(SQLField.Properties.class), "numeric(6,2)", "100", false);
            build = new UpdateBuilder(tableAvoir);
            build.set(fieldAcompteAvoir.getName(), "100");
            build.setWhere(new Where((FieldRef)fieldAcompteAvoir, "=", (Object)null));
            builds.add(build);
        }
        if (tableAvoir.contains("POURCENT_REMISE") && (fieldRemiseAvoir = tableAvoir.getField("POURCENT_REMISE")).getType().getSize() > 500) {
            fName = fieldRemiseAvoir.getName();
            alter.alterColumn(fName, EnumSet.allOf(SQLField.Properties.class), "numeric(6,2)", "0", false);
            build = new UpdateBuilder(tableAvoir);
            build.set(fieldRemiseAvoir.getName(), "0");
            build.setWhere(new Where((FieldRef)fieldRemiseAvoir, "=", (Object)null));
            builds.add(build);
        }
        if (!alter.isEmpty()) {
            alters.add(alter);
        }
        SQLTable tableFacture = root.getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        alter = new AlterTable(tableFacture);
        if (tableFacture.contains("POURCENT_ACOMPTE") && (fieldAcompteFacture = tableFacture.getField("POURCENT_ACOMPTE")).getType().getSize() > 500) {
            fName = fieldAcompteFacture.getName();
            alter.alterColumn(fName, EnumSet.allOf(SQLField.Properties.class), "numeric(6,2)", "100", false);
            build = new UpdateBuilder(tableFacture);
            build.set(fieldAcompteFacture.getName(), "100");
            build.setWhere(new Where((FieldRef)fieldAcompteFacture, "=", (Object)null));
            builds.add(build);
        }
        if (tableFacture.contains("POURCENT_REMISE") && (fieldRemiseFacture = tableFacture.getField("POURCENT_REMISE")).getType().getSize() > 500) {
            fName = fieldRemiseFacture.getName();
            alter.alterColumn(fName, EnumSet.allOf(SQLField.Properties.class), "numeric(6,2)", "0", false);
            build = new UpdateBuilder(tableFacture);
            build.set(fieldRemiseFacture.getName(), "0");
            build.setWhere(new Where((FieldRef)fieldRemiseFacture, "=", (Object)null));
            builds.add(build);
        }
        if (tableFacture.getFieldsName().contains("REPARTITION_POURCENT") && (fieldRepFacture = tableFacture.getField("REPARTITION_POURCENT")).getType().getSize() > 500) {
            fName = fieldRepFacture.getName();
            alter.alterColumn(fName, EnumSet.allOf(SQLField.Properties.class), "numeric(6,2)", "0", false);
            build = new UpdateBuilder(tableFacture);
            build.set(fieldRepFacture.getName(), "0");
            build.setWhere(new Where((FieldRef)fieldRepFacture, "=", (Object)null));
            builds.add(build);
        }
        if (!alter.isEmpty()) {
            alters.add(alter);
        }
        if (alters.size() > 0) {
            SQLDataSource ds = root.getDBSystemRoot().getDataSource();
            for (UpdateBuilder updateBuilder : builds) {
                ds.execute(updateBuilder.asString());
            }
            for (String sql : ChangeTable.cat(alters, root.getName())) {
                ds.execute(sql);
            }
            root.refetch();
        }
    }

    private void fixUnboundedVarchar(DBRoot root) throws SQLException {
        Set<String> namesSet = CollectionUtils.createSet("NOM", "PRENOM", "SURNOM", "LOGIN", "PASSWORD");
        ArrayList<AlterTable> alters = new ArrayList<AlterTable>();
        ArrayList<UpdateBuilder> builds = new ArrayList<UpdateBuilder>();
        for (SQLTable t : root.getTables()) {
            AlterTable alter = new AlterTable(t);
            for (SQLField f : t.getFields()) {
                if (f.getType().getType() != 12 || f.getType().getSize() != Integer.MAX_VALUE) continue;
                UpdateBuilder build = new UpdateBuilder(t);
                build.set(f.getName(), "''");
                build.setWhere(new Where((FieldRef)f, "=", (Object)null));
                builds.add(build);
                String fName = f.getName();
                int size = t.getName().contains("USER") && namesSet.contains(fName) ? 128 : (fName.equals("TEL") || fName.startsWith("TEL_") ? 32 : (fName.contains("INFO") ? 4096 : (fName.contains("FORMULE") ? 1024 : (fName.equals("CONTENU") ? 2048 : 512))));
                alter.alterColumn(fName, EnumSet.allOf(SQLField.Properties.class), "varchar(" + size + ")", "''", false);
            }
            if (alter.isEmpty()) continue;
            alters.add(alter);
        }
        if (alters.size() > 0) {
            SQLDataSource ds = root.getDBSystemRoot().getDataSource();
            for (UpdateBuilder build : builds) {
                ds.execute(build.asString());
            }
            for (String sql : ChangeTable.cat(alters, root.getName())) {
                ds.execute(sql);
            }
            root.refetch();
        }
    }

    private void updateToV1Dot3(DBRoot root) throws SQLException {
        SQLTable tableTaxe;
        boolean containsTaxeDefault;
        SQLDataSource ds = root.getDBSystemRoot().getDataSource();
        this.addForeignKeyFactureOnEcheance(root);
        this.addFieldForPartialInvoice(root);
        SQLTable tableNum = root.getTable("NUMEROTATION_AUTO");
        boolean alterNum = false;
        AlterTable t = new AlterTable(tableNum);
        if (!tableNum.getFieldsName().contains("CLIENT_START")) {
            t.addColumn("CLIENT_START", "integer DEFAULT 0");
            alterNum = true;
        }
        if (!tableNum.getFieldsName().contains("CLIENT_FORMAT")) {
            t.addVarCharColumn("CLIENT_FORMAT", 48);
            alterNum = true;
        }
        if (alterNum) {
            try {
                ds.execute(t.asString());
                tableNum.getSchema().updateVersion();
                tableNum.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table NUMEROTATION_AUTO", ex);
            }
        }
        SQLTable tableEchF = root.getTable("ECHEANCE_FOURNISSEUR");
        AlterTable t2 = new AlterTable(tableEchF);
        if (!tableEchF.getFieldsName().contains("REG_COMPTA")) {
            t2.addColumn("REG_COMPTA", "boolean DEFAULT false");
            try {
                ds.execute(t2.asString());
                tableEchF.getSchema().updateVersion();
                tableEchF.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout du champ REG_COMPTA sur la table ECHEANCE_FOUNISSEUR", ex);
            }
        }
        if (!(containsTaxeDefault = (tableTaxe = root.getTable("TAXE")).contains("DEFAULT"))) {
            t = new AlterTable(tableTaxe);
            t.addColumn("DEFAULT", "boolean DEFAULT false");
            try {
                ds.execute(t.asString());
                tableTaxe.getSchema().updateVersion();
                tableTaxe.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table TAXE", ex);
            }
        }
        SQLSelect selTVA = new SQLSelect();
        selTVA.addSelect(tableTaxe.getKey(), "COUNT");
        selTVA.setWhere(new Where((FieldRef)tableTaxe.getField("TAUX"), "=", 20));
        Object result = root.getBase().getDataSource().executeScalar(selTVA.asString());
        if (result == null || ((Number)result).longValue() == 0L) {
            SQLRowValues rowVals = new SQLRowValues(tableTaxe);
            rowVals.put("NOM", "TVA 20%");
            rowVals.put("TAUX", Float.valueOf(20.0f));
            rowVals.put("DEFAULT", Boolean.TRUE);
            rowVals.commit();
        } else if (!containsTaxeDefault) {
            SQLSelect selTVA20 = new SQLSelect();
            selTVA20.addSelectStar(tableTaxe);
            selTVA20.setWhere(new Where((FieldRef)tableTaxe.getField("TAUX"), "=", 20));
            List<SQLRow> lTVA = SQLRowListRSH.execute(selTVA20);
            if (lTVA != null && lTVA.size() > 0) {
                SQLRowValues rowVals = lTVA.get(0).asRowValues();
                rowVals.put("DEFAULT", Boolean.TRUE);
                rowVals.update();
            }
        }
        SQLTable tableProduct = root.getTable("ARTICLE");
        boolean alterTableProduct = false;
        AlterTable t3 = new AlterTable(tableProduct);
        if (!tableProduct.getFieldsName().contains("ID_COMPTE_PCE")) {
            t3.addForeignColumn("ID_COMPTE_PCE", root.getTable("COMPTE_PCE"));
            alterTableProduct = true;
        }
        if (!tableProduct.getFieldsName().contains("ID_COMPTE_PCE_ACHAT")) {
            t3.addForeignColumn("ID_COMPTE_PCE_ACHAT", root.getTable("COMPTE_PCE"));
            alterTableProduct = true;
        }
        if (alterTableProduct) {
            try {
                ds.execute(t3.asString());
                tableProduct.getSchema().updateVersion();
                tableProduct.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table ARTICLE", ex);
            }
        }
        SQLTable tableArticleFamily = root.getTable("FAMILLE_ARTICLE");
        boolean alterArticleFamily = false;
        t3 = new AlterTable(tableArticleFamily);
        if (!tableArticleFamily.getFieldsName().contains("ID_COMPTE_PCE")) {
            t3.addForeignColumn("ID_COMPTE_PCE", root.getTable("COMPTE_PCE"));
            alterArticleFamily = true;
        }
        if (!tableArticleFamily.getFieldsName().contains("ID_COMPTE_PCE_ACHAT")) {
            t3.addForeignColumn("ID_COMPTE_PCE_ACHAT", root.getTable("COMPTE_PCE"));
            alterArticleFamily = true;
        }
        if (alterArticleFamily) {
            try {
                ds.execute(t3.asString());
                tableArticleFamily.getSchema().updateVersion();
                tableArticleFamily.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table FAMILLE_ARTICLE", ex);
            }
        }
        SQLTable tableRecords = root.getTable("ECRITURE");
        boolean alterRecords = false;
        t3 = new AlterTable(tableRecords);
        if (!tableRecords.getFieldsName().contains("DATE_EXPORT")) {
            t3.addColumn("DATE_EXPORT", "date");
            alterRecords = true;
        }
        if (!tableRecords.getFieldsName().contains("CODE_CLIENT")) {
            t3.addVarCharColumn("CODE_CLIENT", 256);
            alterRecords = true;
        }
        if (alterRecords) {
            try {
                ds.execute(t3.asString());
                tableRecords.getSchema().updateVersion();
                tableRecords.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table ECRITURE", ex);
            }
        }
        this.addInfoField(root, ds, "AVOIR_FOURNISSEUR");
        this.addInfoField(root, ds, "AVOIR_CLIENT");
        boolean refetchRoot = false;
        if (!root.contains("CODE_FOURNISSEUR")) {
            SQLCreateTable createCode = new SQLCreateTable(root, "CODE_FOURNISSEUR");
            createCode.addVarCharColumn("CODE", 256);
            createCode.addForeignColumn("FOURNISSEUR");
            createCode.addForeignColumn("ARTICLE");
            try {
                ds.execute(createCode.asString());
                InstallationPanel.insertUndef(createCode);
                root.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_FOURNISSEUR", ex);
            }
        }
        if (refetchRoot) {
            root.refetch();
        }
        this.createFactureFournisseur(root);
        this.addSupplierCode(root, ds, "BON_RECEPTION_ELEMENT");
        this.addSupplierCode(root, ds, "COMMANDE_ELEMENT");
        SQLTable.setUndefID(root.getSchema(), "ARTICLE_DESIGNATION", 1);
        SQLTable.setUndefID(root.getSchema(), "ARTICLE_TARIF", 1);
        SQLTable.setUndefID(root.getSchema(), "CODE_STATUT_CAT_CONV", 1);
        SQLTable.setUndefID(root.getSchema(), "CONTACT_ADMINISTRATIF", 1);
        SQLTable.setUndefID(root.getSchema(), "CONTACT_FOURNISSEUR", 1);
        SQLTable.setUndefID(root.getSchema(), "LANGUE", 1);
        SQLTable.setUndefID(root.getSchema(), "MODELE", 1);
        SQLTable.setUndefID(root.getSchema(), "OBJECTIF_COMMERCIAL", 1);
        SQLTable.setUndefID(root.getSchema(), "TARIF", 1);
        SQLTable.setUndefID(root.getSchema(), "UNITE_VENTE", 1);
        ComptaPropsConfiguration.setSocieteSQLInjector(root);
        SQLInjector.createTransferTables(root);
        this.convertTransfer(root, Arrays.asList("COMMANDE_CLIENT", "DEVIS", "BON_DE_LIVRAISON"), "SAISIE_VENTE_FACTURE");
        if (root.getServer().getSQLSystem().equals((Object)SQLSystem.H2)) {
            ChangeIDToInt c = new ChangeIDToInt(root.getDBSystemRoot());
            c.changeAll(root);
            root.getDBSystemRoot().reload(Collections.singleton(root.getName()));
        }
    }

    private void convertTransfer(DBRoot root, List<String> tablesSrc, String tableDest) throws SQLException {
        SQLTable tableDestination = root.getTable(tableDest);
        if (tableDestination.contains("SOURCE") && tableDestination.contains("IDSOURCE")) {
            for (String tableSrc : tablesSrc) {
                this.convertTransfer(root.getTable(tableSrc), tableDestination);
            }
            AlterTable alter = new AlterTable(tableDestination);
            alter.dropColumn("SOURCE");
            alter.dropColumn("IDSOURCE");
            String req = alter.asString();
            root.getDBSystemRoot().getDataSource().execute(req);
            root.refetchTable(tableDest);
        }
    }

    private void convertTransfer(final SQLTable tableSource, final SQLTable tableDest) throws SQLException {
        SQLInjector inj = SQLInjector.getInjector(tableSource, tableDest);
        SQLRowValues vals = new SQLRowValues(tableDest);
        vals.putNulls("SOURCE", "IDSOURCE");
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(vals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where((FieldRef)tableDest.getField("SOURCE"), "=", (Object)tableSource.getName());
                w = w.and(new Where((FieldRef)tableDest.getField("IDSOURCE"), "!=", (Object)tableSource.getUndefinedIDNumber()));
                w = w.and(new Where((FieldRef)tableDest.getField("IDSOURCE"), "=", tableSource.getKey()));
                input.setWhere(w);
                return input;
            }
        });
        List<SQLRowValues> rows = fetcher.fetch();
        for (SQLRowValues sqlRowValues : rows) {
            inj.addTransfert(sqlRowValues.getInt("IDSOURCE"), sqlRowValues.getID());
        }
    }

    private void addInfoField(DBRoot root, SQLDataSource ds, String tableName) {
        SQLTable tableBL = root.getTable(tableName);
        boolean alterBL = false;
        AlterTable t = new AlterTable(tableBL);
        if (!tableBL.getFieldsName().contains("INFOS")) {
            t.addVarCharColumn("INFOS", 1024);
            alterBL = true;
        }
        if (alterBL) {
            try {
                ds.execute(t.asString());
                tableBL.getSchema().updateVersion();
                tableBL.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table AVOIR FOURNISSEUR", ex);
            }
        }
    }

    private void addSupplierCode(DBRoot root, SQLDataSource ds, String tableName) {
        SQLTable tableBL = root.getTable(tableName);
        boolean alterBL = false;
        AlterTable t = new AlterTable(tableBL);
        if (!tableBL.contains("ID_CODE_FOURNISSEUR")) {
            t.addForeignColumn("ID_CODE_FOURNISSEUR", root.getTable("CODE_FOURNISSEUR"));
            alterBL = true;
        }
        if (alterBL) {
            try {
                ds.execute(t.asString());
                tableBL.getSchema().updateVersion();
                tableBL.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table " + tableName, ex);
            }
        }
    }

    private void updateToV1Dot4(DBRoot root) throws SQLException {
        SQLTable tableContact;
        AlterTable a;
        SQLTable articleTable;
        SQLTable tableAssoc;
        SQLTable tableClient;
        SQLTable tableAdresse;
        SQLTable tableKmElt;
        SQLTable tableDevis = root.getTable("DEVIS");
        this.addAdresseField(tableDevis, root);
        this.addRemiseField(tableDevis, root);
        SQLTable tableVF = root.getTable("SAISIE_VENTE_FACTURE");
        this.addAdresseField(tableVF, root);
        this.addRemiseField(tableVF, root);
        SQLTable tableCmd = root.getTable("COMMANDE_CLIENT");
        this.addAdresseField(tableCmd, root);
        this.addRemiseField(tableCmd, root);
        SQLTable tableBon = root.getTable("BON_DE_LIVRAISON");
        this.addAdresseField(tableBon, root);
        this.addRemiseField(tableBon, root);
        SQLTable tableAvoir = root.getTable("AVOIR_CLIENT");
        this.addAdresseField(tableAvoir, root);
        this.addRemiseField(tableAvoir, root);
        if (root.getTable("CLIENT_DEPARTEMENT") == null) {
            SQLCreateTable createTableDpt = new SQLCreateTable(root, "CLIENT_DEPARTEMENT");
            createTableDpt.addForeignColumn("CLIENT");
            if (root.contains("ADRESSE")) {
                createTableDpt.addForeignColumn("ADRESSE");
            } else {
                createTableDpt.addForeignColumn("ID_ADRESSE", root.findTable("ADRESSE"));
            }
            createTableDpt.addVarCharColumn("INFOS", 2048);
            createTableDpt.addVarCharColumn("NOM", 256);
            try {
                root.getBase().getDataSource().execute(createTableDpt.asString());
                InstallationPanel.insertUndef(createTableDpt);
                root.refetchTable("CLIENT_DEPARTEMENT");
                root.getSchema().updateVersion();
            }
            catch (SQLException ex2) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CLIENT_DEPARTEMENT", ex2);
            }
        }
        SQLTable tableVFElt = root.getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        this.patchFieldElt1Dot4(tableVFElt, root);
        SQLTable tableDevisElt = root.getTable("DEVIS_ELEMENT");
        this.patchFieldElt1Dot4(tableDevisElt, root);
        SQLTable tableCmdElt = root.getTable("COMMANDE_CLIENT_ELEMENT");
        this.patchFieldElt1Dot4(tableCmdElt, root);
        SQLTable tableBonElt = root.getTable("BON_DE_LIVRAISON_ELEMENT");
        this.patchFieldElt1Dot4(tableBonElt, root);
        SQLTable tableAvoirElt = root.getTable("AVOIR_CLIENT_ELEMENT");
        this.patchFieldElt1Dot4(tableAvoirElt, root);
        this.addNiveauElementField(root.getTable("COMMANDE_ELEMENT"));
        this.addNiveauElementField(root.getTable("BON_RECEPTION_ELEMENT"));
        this.addNiveauElementField(root.getTable("FACTURE_FOURNISSEUR_ELEMENT"));
        this.addContact(root);
        SQLTable tableCommandeClient = root.getTable("COMMANDE_CLIENT");
        AlterTable tCommandeClient = new AlterTable(tableCommandeClient);
        boolean updateCmdCli = false;
        if (!tableCommandeClient.contains("ETAT_COMMANDE")) {
            updateCmdCli = true;
            tCommandeClient.addIntegerColumn("ETAT_COMMANDE", EtatCommandeClient.A_PREPARER.getId());
        }
        if (!tableCommandeClient.contains("EMBALLAGE")) {
            updateCmdCli = true;
            tCommandeClient.addVarCharColumn("EMBALLAGE", 256);
        }
        if (!tableCommandeClient.contains("NUMERO_EXPEDITION")) {
            updateCmdCli = true;
            tCommandeClient.addVarCharColumn("NUMERO_EXPEDITION", 256);
        }
        if (!tableCommandeClient.contains("ID_TAXE_PORT")) {
            updateCmdCli = true;
            tCommandeClient.addForeignColumn("ID_TAXE_PORT", root.getTable("TAXE"));
        }
        if (!tableCommandeClient.contains("PORT_HT")) {
            updateCmdCli = true;
            tCommandeClient.addLongColumn("PORT_HT", 0L, false);
        }
        if (!tableCommandeClient.contains("REMISE_HT")) {
            updateCmdCli = true;
            tCommandeClient.addLongColumn("REMISE_HT", 0L, false);
        }
        if (updateCmdCli) {
            tableCommandeClient.getBase().getDataSource().execute(tCommandeClient.asString());
            tableCommandeClient.getSchema().updateVersion();
            tableCommandeClient.fetchFields();
        }
        SQLTable tableBonL = root.getTable("BON_DE_LIVRAISON");
        AlterTable tBonL = new AlterTable(tableBonL);
        boolean updateBonL = false;
        if (!tableBonL.contains("TOTAL_DEVISE")) {
            updateBonL = true;
            tBonL.addLongColumn("TOTAL_DEVISE", 0L, false);
        }
        if (!tableBonL.contains("TOTAL_SERVICE")) {
            updateBonL = true;
            tBonL.addLongColumn("TOTAL_SERVICE", 0L, false);
        }
        if (!tableBonL.contains("ID_TAXE_PORT")) {
            updateBonL = true;
            tBonL.addForeignColumn("ID_TAXE_PORT", root.getTable("TAXE"));
        }
        if (!tableBonL.contains("PORT_HT")) {
            updateBonL = true;
            tBonL.addLongColumn("PORT_HT", 0L, false);
        }
        if (!tableBonL.contains("REMISE_HT")) {
            updateBonL = true;
            tBonL.addLongColumn("REMISE_HT", 0L, false);
        }
        if (updateBonL) {
            tableBonL.getBase().getDataSource().execute(tBonL.asString());
            tableBonL.getSchema().updateVersion();
            tableBonL.fetchFields();
        }
        List<String> asList = Arrays.asList("SAISIE_VENTE_FACTURE", "BON_RECEPTION", "BON_DE_LIVRAISON");
        for (String tableVirtualStockName : asList) {
            SQLTable tableVirtualStock = root.getTable(tableVirtualStockName);
            if (tableVirtualStock.contains("CREATE_VIRTUAL_STOCK")) continue;
            AlterTable t = new AlterTable(tableVirtualStock);
            t.addBooleanColumn("CREATE_VIRTUAL_STOCK", Boolean.TRUE, false);
            tableVirtualStock.getBase().getDataSource().execute(t.asString());
            tableVirtualStock.getSchema().updateVersion();
            tableVirtualStock.fetchFields();
        }
        SQLTable tableDevis2 = root.getTable("DEVIS");
        AlterTable tDevis = new AlterTable(tableDevis2);
        boolean updateDevis = false;
        if (!tableDevis2.contains("POURCENT_REMISE")) {
            updateDevis = true;
            tDevis.addColumn("POURCENT_REMISE", "numeric (12,8)");
        }
        if (!tableDevis2.contains("MONTANT_REMISE")) {
            updateDevis = true;
            tDevis.addColumn("MONTANT_REMISE", "numeric (16,8)");
        }
        if (!tableDevis2.contains("T_HA")) {
            updateDevis = true;
            tDevis.addColumn("T_HA", "bigint", "0", false);
        }
        if (!tableDevis2.contains("DUNNING_DATE")) {
            updateDevis = true;
            tDevis.addColumn("DUNNING_DATE", "date");
        }
        if (updateDevis) {
            tableDevis2.getBase().getDataSource().execute(tDevis.asString());
            tableDevis2.getSchema().updateVersion();
            tableDevis2.fetchFields();
        }
        if (!(tableKmElt = root.getTable("SAISIE_KM_ELEMENT")).contains("ANALYTIQUE")) {
            AlterTable t = new AlterTable(tableKmElt);
            t.addVarCharColumn("ANALYTIQUE", 256);
            tableKmElt.getBase().getDataSource().execute(t.asString());
            tableKmElt.getSchema().updateVersion();
            tableKmElt.fetchFields();
        }
        if ((tableAdresse = root.getTable("ADRESSE")) != null) {
            AlterTable t = new AlterTable(tableAdresse);
            boolean updateADr = false;
            if (!tableAdresse.contains("PROVINCE")) {
                t.addVarCharColumn("PROVINCE", 256);
                updateADr = true;
            }
            if (!tableAdresse.contains("LIBELLE")) {
                t.addVarCharColumn("LIBELLE", 256);
                updateADr = true;
            }
            if (!tableAdresse.contains("TYPE")) {
                t.addVarCharColumn("TYPE", 256);
                updateADr = true;
            }
            if (!tableAdresse.contains("EMAIL_CONTACT")) {
                t.addVarCharColumn("EMAIL_CONTACT", 256);
                updateADr = true;
            }
            if (updateADr) {
                tableAdresse.getBase().getDataSource().execute(t.asString());
                tableAdresse.getSchema().updateVersion();
                tableAdresse.fetchFields();
            }
        }
        if ((tableClient = root.getTable("CLIENT")) != null) {
            AlterTable t = new AlterTable(tableClient);
            boolean upClient = false;
            if (!tableClient.contains("BLOQUE_LIVRAISON")) {
                t.addBooleanColumn("BLOQUE_LIVRAISON", false, false);
                upClient = true;
            }
            if (!tableClient.contains("BLOQUE")) {
                upClient = true;
                t.addBooleanColumn("BLOQUE", false, false);
            }
            if (!tableClient.contains("ID_COMPTE_PCE_SERVICE")) {
                upClient = true;
                t.addForeignColumn("ID_COMPTE_PCE_SERVICE", tableClient.getTable("COMPTE_PCE"));
            }
            if (!tableClient.contains("ID_COMPTE_PCE_PRODUIT")) {
                upClient = true;
                t.addForeignColumn("ID_COMPTE_PCE_PRODUIT", tableClient.getTable("COMPTE_PCE"));
            }
            if (!tableClient.contains("ENCOURS_MAX")) {
                upClient = true;
                t.addDecimalColumn("ENCOURS_MAX", 16, 2, BigDecimal.valueOf(0L), false);
            }
            if (!tableClient.contains("CATEGORIES")) {
                upClient = true;
                t.addVarCharColumn("CATEGORIES", 2048);
            }
            if (!tableClient.contains("NOTE_FINANCIERE")) {
                upClient = true;
                t.addVarCharColumn("NOTE_FINANCIERE", 1024);
            }
            if (!tableClient.contains("CENTRE_GESTION")) {
                upClient = true;
                t.addVarCharColumn("CENTRE_GESTION", 1024);
            }
            if (!tableClient.contains("METHODE_RELANCE")) {
                upClient = true;
                t.addVarCharColumn("METHODE_RELANCE", 1024);
            }
            if (!tableClient.contains("SITE_INTERNET")) {
                upClient = true;
                t.addVarCharColumn("SITE_INTERNET", 2048);
            }
            if (!tableClient.contains("GROUPE")) {
                upClient = true;
                t.addVarCharColumn("GROUPE", 1024);
            }
            if (!tableClient.contains("ID_COMMERCIAL")) {
                upClient = true;
                t.addForeignColumn("ID_COMMERCIAL", tableClient.getTable("COMMERCIAL"));
            }
            if (upClient) {
                tableClient.getBase().getDataSource().execute(t.asString());
                tableClient.getSchema().updateVersion();
                tableClient.fetchFields();
            }
        }
        if (!root.contains("CATEGORIE_CLIENT")) {
            SQLCreateTable createCategorieClientTable = new SQLCreateTable(root, "CATEGORIE_CLIENT");
            createCategorieClientTable.addVarCharColumn("NOM", 1024);
            try {
                root.getDBSystemRoot().getDataSource().execute(createCategorieClientTable.asString());
                InstallationPanel.insertUndef(createCategorieClientTable);
                tableDevis2.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CATEGORIE_CLIENT", ex);
            }
        }
        if ((tableAssoc = root.getTable("ASSOCIATION_ANALYTIQUE")) != null && !tableAssoc.contains("GESTION_AUTO")) {
            AlterTable t = new AlterTable(tableAssoc);
            t.addBooleanColumn("GESTION_AUTO", false, false);
            tableAssoc.getBase().getDataSource().execute(t.asString());
            tableAssoc.getSchema().updateVersion();
            tableAssoc.fetchFields();
        }
        if (!root.contains("CALENDAR_ITEM")) {
            SQLCreateTable createTaskGroupTable = new SQLCreateTable(root, "CALENDAR_ITEM_GROUP");
            createTaskGroupTable.addVarCharColumn("NAME", 1024);
            createTaskGroupTable.addVarCharColumn("DESCRIPTION", 8192);
            SQLCreateTable createTaskTable = new SQLCreateTable(root, "CALENDAR_ITEM");
            createTaskTable.addDateAndTimeColumn("START");
            createTaskTable.addDateAndTimeColumn("END");
            createTaskTable.addLongColumn("DURATION_S", 0L, false);
            createTaskTable.addVarCharColumn("SUMMARY", 1024);
            createTaskTable.addVarCharColumn("DESCRIPTION", 8192);
            createTaskTable.addVarCharColumn("FLAGS", 1024);
            createTaskTable.addVarCharColumn("STATUS", 128);
            createTaskTable.addForeignColumn(createTaskGroupTable);
            createTaskTable.addLongColumn("SOURCE_ID", null, true);
            createTaskTable.addVarCharColumn("SOURCE_TABLE", 256);
            try {
                root.getDBSystemRoot().getDataSource().execute(createTaskGroupTable.asString());
                InstallationPanel.insertUndef(createTaskGroupTable);
                root.getDBSystemRoot().getDataSource().execute(createTaskTable.asString());
                InstallationPanel.insertUndef(createTaskTable);
                tableDevis2.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TASK", ex);
            }
        }
        this.addArticleFournisseur(root);
        if (root.contains("ARTICLE_TARIF") && !root.getTable("ARTICLE_TARIF").contains("POURCENT_REMISE")) {
            AlterTable t = new AlterTable(root.getTable("ARTICLE_TARIF"));
            t.addDecimalColumn("POURCENT_REMISE", 16, 6, BigDecimal.valueOf(0L), false);
            root.getTable("ARTICLE_TARIF").getBase().getDataSource().execute(t.asString());
            root.getTable("ARTICLE_TARIF").fetchFields();
            root.getTable("ARTICLE").getSchema().updateVersion();
        }
        if (!(articleTable = root.getTable("ARTICLE")).contains("SKU")) {
            AlterTable a2 = new AlterTable(articleTable);
            a2.addVarCharColumn("SKU", 256);
            try {
                articleTable.getBase().getDataSource().execute(a2.asString());
                articleTable.getSchema().updateVersion();
                articleTable.fetchFields();
            }
            catch (SQLException ex2) {
                throw new IllegalStateException("Erreur lors de l'ajout du champs SKU sur la table ARTICLE", ex2);
            }
        }
        try {
            SQLTable cmdClientTable = root.getTable("COMMANDE_CLIENT");
            if (!cmdClientTable.contains("TYPE_EXPEDITION")) {
                a = new AlterTable(cmdClientTable);
                a.addVarCharColumn("TYPE_EXPEDITION", 256);
                cmdClientTable.getBase().getDataSource().execute(a.asString());
                cmdClientTable.getSchema().updateVersion();
                cmdClientTable.fetchFields();
            }
        }
        catch (SQLException ex2) {
            throw new IllegalStateException("Erreur lors de l'ajout du champs TYPE_EXPEDITION sur la table COMMANDE_CLIENT", ex2);
        }
        try {
            SQLTable axeTable = root.getTable("AXE_ANALYTIQUE");
            if (!axeTable.contains("TYPE")) {
                a = new AlterTable(axeTable);
                a.addVarCharColumn("TYPE", 256);
                axeTable.getBase().getDataSource().execute(a.asString());
                axeTable.getSchema().updateVersion();
                axeTable.fetchFields();
            }
        }
        catch (SQLException ex2) {
            throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table AXE_ANALYTIQUE", ex2);
        }
        if (!root.contains("DEVISE_HISTORIQUE")) {
            SQLCreateTable createTable = new SQLCreateTable(root, "DEVISE_HISTORIQUE");
            createTable.addDateAndTimeColumn("DATE");
            createTable.addVarCharColumn("SRC", 8);
            createTable.addVarCharColumn("DST", 8);
            createTable.addDecimalColumn("TAUX", 12, 6, new BigDecimal(1), false);
            createTable.addDecimalColumn("TAUX_COMMERCIAL", 12, 6, new BigDecimal(1), false);
            try {
                root.getDBSystemRoot().getDataSource().execute(createTable.asString());
                InstallationPanel.insertUndef(createTable);
                tableDevis2.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TASK", ex);
            }
        }
        if ((tableContact = root.getTable("CONTACT")) != null && !tableContact.contains("NO_MAILING")) {
            AlterTable t = new AlterTable(tableContact);
            t.addBooleanColumn("NO_MAILING", false, false);
            tableContact.getBase().getDataSource().execute(t.asString());
            tableContact.getSchema().updateVersion();
            tableContact.fetchFields();
        }
    }

    private void updateStyle(DBRoot root) throws SQLException {
        SQLTable style = root.getTable("STYLE");
        SQLRowValues rowVals = new SQLRowValues(style);
        rowVals.put("NOM", null);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        List<SQLRowValues> list = fetcher.fetch();
        boolean containsInvisible = false;
        for (SQLRowValues sqlRowValues : list) {
            if (!sqlRowValues.getString("NOM").equals("Invisible")) continue;
            containsInvisible = true;
        }
        if (!containsInvisible) {
            SQLRowValues rowValsStyle = new SQLRowValues(style);
            rowValsStyle.put("NOM", "Invisible");
            rowValsStyle.put("CODE", "INV");
            rowValsStyle.insert();
        }
    }

    private void updateToV1Dot2(DBRoot root) throws SQLException {
        AlterTable alterCmd;
        SQLCreateTable createTarif;
        SQLCreateTable createModele;
        AlterTable t;
        SQLTable tableLivraisonElement = root.getTable("BON_DE_LIVRAISON_ELEMENT");
        AlterTable alter = new AlterTable(tableLivraisonElement);
        alter.alterColumn("ID_METRIQUE_2", EnumSet.of(SQLField.Properties.TYPE), "integer", null, null);
        String req3 = alter.asString();
        root.getDBSystemRoot().getDataSource().execute(req3);
        SQLTable tableDevis = root.getTable("DEVIS");
        SQLDataSource ds = root.getDBSystemRoot().getDataSource();
        if (!tableDevis.getFieldsName().contains("DATE_VALIDITE")) {
            t = new AlterTable(tableDevis);
            t.addColumn("DATE_VALIDITE", "date");
            try {
                ds.execute(t.asString());
                tableDevis.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout du champ DATE_VALIDITE \u00e0 la table DEVIS", ex);
            }
        }
        t = new AlterTable(tableDevis);
        t.alterColumn("DATE_VALIDITE", EnumSet.allOf(SQLField.Properties.class), "date", null, true);
        try {
            ds.execute(t.asString());
            tableDevis.getSchema().updateVersion();
        }
        catch (SQLException ex) {
            throw new IllegalStateException("Erreur lors de l'ajout du champ DATE_VALIDITE \u00e0 la table DEVIS", ex);
        }
        SQLTable tableEtatDevis = root.getTable("ETAT_DEVIS");
        if (tableEtatDevis.getRow(5) == null && tableEtatDevis.getRowCount() <= 4) {
            SQLRowValues rowVals = new SQLRowValues(tableEtatDevis);
            rowVals.put("NOM", "En cours de r\u00e9daction");
            rowVals.commit();
        }
        SQLRowValues rowValsOrdre = new SQLRowValues(tableEtatDevis);
        rowValsOrdre.put("ORDRE", new BigDecimal("1.505"));
        rowValsOrdre.update(2);
        rowValsOrdre.put("ORDRE", new BigDecimal("2.505"));
        rowValsOrdre.update(4);
        rowValsOrdre.put("ORDRE", new BigDecimal("3.505"));
        rowValsOrdre.update(3);
        rowValsOrdre.put("ORDRE", new BigDecimal("4.505"));
        rowValsOrdre.update(5);
        SQLSelect selTVA = new SQLSelect();
        SQLTable tableTaxe = root.getTable("TAXE");
        selTVA.addSelect(tableTaxe.getKey(), "COUNT");
        selTVA.setWhere(new Where((FieldRef)tableTaxe.getField("TAUX"), "=", 0));
        Object result = root.getBase().getDataSource().executeScalar(selTVA.asString());
        if (result == null || ((Number)result).longValue() == 0L) {
            SQLRowValues rowVals = new SQLRowValues(tableTaxe);
            rowVals.put("NOM", "Non applicable");
            rowVals.put("TAUX", Float.valueOf(0.0f));
            rowVals.commit();
        }
        SQLTable tableBL = root.getTable("BON_DE_LIVRAISON");
        boolean alterBL = false;
        AlterTable t2 = new AlterTable(tableBL);
        if (!tableBL.getFieldsName().contains("SOURCE")) {
            t2.addVarCharColumn("SOURCE", 512);
            alterBL = true;
        }
        if (!tableBL.getFieldsName().contains("IDSOURCE")) {
            t2.addColumn("IDSOURCE", "integer DEFAULT 1");
            alterBL = true;
        }
        if (!tableBL.getFieldsName().contains("DATE_LIVRAISON")) {
            t2.addColumn("DATE_LIVRAISON", "date");
            alterBL = true;
        }
        if (alterBL) {
            try {
                ds.execute(t2.asString());
                tableBL.getSchema().updateVersion();
                tableBL.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table BON_DE_LIVRAISON", ex);
            }
        }
        tableBL = root.getTable("FOURNISSEUR");
        alterBL = false;
        t2 = new AlterTable(tableBL);
        if (!tableBL.getFieldsName().contains("ID_COMPTE_PCE_CHARGE")) {
            t2.addForeignColumn("ID_COMPTE_PCE_CHARGE", root.getTable("COMPTE_PCE"));
            alterBL = true;
        }
        if (alterBL) {
            try {
                ds.execute(t2.asString());
                tableBL.getSchema().updateVersion();
                tableBL.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table FOURNISSEUR", ex);
            }
        }
        SQLTable tableNum = root.getTable("NUMEROTATION_AUTO");
        boolean alterNum = false;
        t2 = new AlterTable(tableNum);
        if (!tableNum.getFieldsName().contains("AVOIR_F_START")) {
            t2.addColumn("AVOIR_F_START", "integer DEFAULT 0");
            alterNum = true;
        }
        if (!tableNum.getFieldsName().contains("AVOIR_F_FORMAT")) {
            t2.addVarCharColumn("AVOIR_F_FORMAT", 48);
            alterNum = true;
        }
        if (alterNum) {
            try {
                ds.execute(t2.asString());
                tableNum.getSchema().updateVersion();
                tableNum.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table NUMEROTATION_AUTO", ex);
            }
        }
        SQLTable tableArticle = root.getTable("ARTICLE");
        AlterTable t3 = new AlterTable(tableArticle);
        boolean alterArticle = false;
        if (!tableArticle.getFieldsName().contains("QTE_ACHAT")) {
            t3.addColumn("QTE_ACHAT", "integer DEFAULT 1");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("DESCRIPTIF")) {
            t3.addVarCharColumn("DESCRIPTIF", 2048);
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("CODE_BARRE")) {
            t3.addVarCharColumn("CODE_BARRE", 256);
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("GESTION_STOCK")) {
            t3.addColumn("GESTION_STOCK", "boolean DEFAULT true");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("CODE_DOUANIER")) {
            t3.addVarCharColumn("CODE_DOUANIER", 256);
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("QTE_MIN")) {
            t3.addColumn("QTE_MIN", "integer DEFAULT 1");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("ID_DEVISE")) {
            t3.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("ID_FOURNISSEUR")) {
            t3.addForeignColumn("ID_FOURNISSEUR", root.findTable("FOURNISSEUR", true));
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("PV_U_DEVISE")) {
            t3.addColumn("PV_U_DEVISE", "bigint default 0");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("ID_DEVISE_HA")) {
            t3.addForeignColumn("ID_DEVISE_HA", root.findTable("DEVISE", true));
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("PA_DEVISE")) {
            t3.addColumn("PA_DEVISE", "bigint default 0");
            alterArticle = true;
        }
        if (!tableArticle.getFieldsName().contains("ID_PAYS")) {
            t3.addForeignColumn("ID_PAYS", root.findTable("PAYS", true));
            alterArticle = true;
        }
        if (alterArticle) {
            try {
                ds.execute(t3.asString());
                tableArticle.getSchema().updateVersion();
                tableArticle.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table ARTICLE", ex);
            }
        }
        boolean refetchRoot = false;
        if (!root.contains("OBJECTIF_COMMERCIAL")) {
            SQLCreateTable createObjectif = new SQLCreateTable(root, "OBJECTIF_COMMERCIAL");
            createObjectif.addVarCharColumn("MOIS", 32);
            createObjectif.addColumn("ANNEE", "integer");
            createObjectif.addColumn("MARGE_HT", "bigint DEFAULT 0");
            createObjectif.addColumn("POURCENT_MARGE", "numeric (16,8)");
            createObjectif.addColumn("CHIFFRE_AFFAIRE", "bigint DeFAULT 0");
            createObjectif.addForeignColumn("COMMERCIAL");
            try {
                ds.execute(createObjectif.asString());
                InstallationPanel.insertUndef(createObjectif);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table OBJECTIF_COMMERCIAL", ex);
            }
        }
        if (!root.contains("LANGUE")) {
            SQLCreateTable createLangue = new SQLCreateTable(root, "LANGUE");
            createLangue.addVarCharColumn("CODE", 256);
            createLangue.addVarCharColumn("NOM", 256);
            createLangue.addVarCharColumn("CHEMIN", 256);
            try {
                ds.execute(createLangue.asString());
                InstallationPanel.insertUndef(createLangue);
                tableDevis.getSchema().updateVersion();
                root.refetchTable(createLangue.getName());
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table LANGUE", ex);
            }
            String[] langs = new String[]{"FR", "Fran\u00e7ais", "EN", "Anglais", "SP", "Espagnol", "DE", "Allemand", "NL", "N\u00e9erlandais", "IT", "Italien"};
            ArrayList<String> values = new ArrayList<String>();
            SQLBase base = root.getBase();
            int i = 0;
            while (i < langs.length) {
                int order = values.size() + 1;
                values.add("(" + base.quoteString(langs[i]) + ", " + base.quoteString(langs[i + 1]) + ", " + order + ")");
                i += 2;
            }
            String valuesStr = CollectionUtils.join(values, ", ");
            String insertVals = "INSERT INTO " + InstallationPanel.getTableName(createLangue).quote() + "(" + SQLBase.quoteIdentifier("CODE") + ", " + SQLBase.quoteIdentifier("NOM") + ", " + SQLBase.quoteIdentifier("ORDRE") + ") VALUES" + valuesStr;
            ds.execute(insertVals);
        }
        if (!root.contains("MODELE")) {
            createModele = new SQLCreateTable(root, "MODELE");
            createModele.addVarCharColumn("NOM", 256);
            createModele.addForeignColumn("ID_TYPE_MODELE", root.findTable("TYPE_MODELE", true));
            try {
                ds.execute(createModele.asString());
                InstallationPanel.insertUndef(createModele);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MODELE", ex);
            }
        }
        if (!root.contains("CONTACT_FOURNISSEUR")) {
            createModele = new SQLCreateTable(root, "CONTACT_FOURNISSEUR");
            createModele.addVarCharColumn("NOM", 256);
            createModele.addVarCharColumn("PRENOM", 256);
            createModele.addVarCharColumn("TEL_DIRECT", 256);
            createModele.addVarCharColumn("TEL_MOBILE", 256);
            createModele.addVarCharColumn("EMAIL", 256);
            createModele.addVarCharColumn("FAX", 256);
            createModele.addVarCharColumn("FONCTION", 256);
            createModele.addVarCharColumn("TEL_PERSONEL", 256);
            createModele.addVarCharColumn("TEL_STANDARD", 256);
            createModele.addForeignColumn("ID_TITRE_PERSONNEL", root.findTable("TITRE_PERSONNEL"));
            createModele.addForeignColumn("ID_FOURNISSEUR", root.findTable("FOURNISSEUR"));
            try {
                ds.execute(createModele.asString());
                InstallationPanel.insertUndef(createModele);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MODELE", ex);
            }
        }
        if (!root.contains("TARIF")) {
            createTarif = new SQLCreateTable(root, "TARIF");
            createTarif.addVarCharColumn("NOM", 256);
            createTarif.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            createTarif.addForeignColumn("ID_TAXE", root.findTable("TAXE", true));
            createTarif.asString();
            try {
                ds.execute(createTarif.asString());
                InstallationPanel.insertUndef(createTarif);
                tableDevis.getSchema().updateVersion();
                root.refetchTable(createTarif.getName());
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table TARIF", ex);
            }
        }
        if (!root.contains("ARTICLE_TARIF")) {
            createTarif = new SQLCreateTable(root, "ARTICLE_TARIF");
            createTarif.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            createTarif.addForeignColumn("ID_TAXE", root.findTable("TAXE", true));
            createTarif.addForeignColumn("ID_TARIF", root.findTable("TARIF", true));
            createTarif.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE", true));
            createTarif.addColumn("PV_HT", "bigint DEFAULT 0");
            createTarif.addColumn("PV_TTC", "bigint DEFAULT 0");
            createTarif.addColumn("PRIX_METRIQUE_VT_1", "bigint DEFAULT 0");
            createTarif.addColumn("PRIX_METRIQUE_VT_2", "bigint DEFAULT 0");
            createTarif.addColumn("PRIX_METRIQUE_VT_3", "bigint DEFAULT 0");
            createTarif.asString();
            try {
                ds.execute(createTarif.asString());
                InstallationPanel.insertUndef(createTarif);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ARTICLE_TARIF", ex);
            }
        }
        if (!root.contains("ARTICLE_DESIGNATION")) {
            createTarif = new SQLCreateTable(root, "ARTICLE_DESIGNATION");
            createTarif.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE", true));
            createTarif.addForeignColumn("ID_LANGUE", root.findTable("LANGUE", true));
            createTarif.addVarCharColumn("NOM", 1024);
            createTarif.asString();
            try {
                ds.execute(createTarif.asString());
                InstallationPanel.insertUndef(createTarif);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table ARTICLE_DESIGNATION", ex);
            }
        }
        if (!root.contains("UNITE_VENTE")) {
            SQLCreateTable createUnite = new SQLCreateTable(root, "UNITE_VENTE");
            createUnite.addVarCharColumn("CODE", 32);
            createUnite.addVarCharColumn("NOM", 256);
            createUnite.addColumn("A_LA_PIECE", "boolean DEFAULT false");
            createUnite.addVarCharColumn("INFOS", 256);
            try {
                ds.execute(createUnite.asString());
                InstallationPanel.insertUndef(createUnite);
                String insert = "INSERT into " + InstallationPanel.getTableName(createUnite).quote() + "(\"CODE\",\"NOM\",\"A_LA_PIECE\",\"ORDRE\") VALUES('pi\u00e8ce','\u00e0 la pi\u00e8ce',true,1),('m','m\u00e8tres',false,2),('m\u00b2','m\u00e8tres carr\u00e9',false,3),('m3','m\u00e8tres cube',false,4),('l','litres',false,5),('kg','kilos',false,6),('h','heures',false,7),('j','jours',false,8),('mois','mois',false,9)";
                root.getDBSystemRoot().getDataSource().execute(insert);
                tableDevis.getSchema().updateVersion();
                refetchRoot = true;
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table UNITE_VENTE", ex);
            }
        }
        if (refetchRoot) {
            root.refetch();
        }
        if (!tableArticle.getFieldsName().contains("ID_UNITE_VENTE")) {
            AlterTable alterTableArticle = new AlterTable(tableArticle);
            alterTableArticle.addForeignColumn("ID_UNITE_VENTE", root.findTable("UNITE_VENTE", true).getSQLName(), "ID", "2");
            try {
                ds.execute(alterTableArticle.asString());
                tableArticle.getSchema().updateVersion();
                tableArticle.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout du champ UNITE_VENTE sur la table ARTICLE", ex);
            }
        }
        SQLTable tableVFElt = root.getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        this.addVenteEltField(tableVFElt, root);
        SQLTable tableDevisElt = root.getTable("DEVIS_ELEMENT");
        this.addVenteEltField(tableDevisElt, root);
        SQLTable tableCmdElt = root.getTable("COMMANDE_CLIENT_ELEMENT");
        this.addVenteEltField(tableCmdElt, root);
        SQLTable tableBonElt = root.getTable("BON_DE_LIVRAISON_ELEMENT");
        this.addVenteEltField(tableBonElt, root);
        SQLTable tableAvoirElt = root.getTable("AVOIR_CLIENT_ELEMENT");
        this.addVenteEltField(tableAvoirElt, root);
        SQLTable tableCmdFournElt = root.getTable("COMMANDE_ELEMENT");
        this.addHAElementField(tableCmdFournElt, root);
        if (root.contains("DEMANDE_PRIX_ELEMENT")) {
            SQLTable tableDmdFournElt = root.getTable("DEMANDE_PRIX_ELEMENT");
            this.addHAElementField(tableDmdFournElt, root);
        }
        SQLTable tableBonRecptElt = root.getTable("BON_RECEPTION_ELEMENT");
        this.addHAElementField(tableBonRecptElt, root);
        SQLTable tableBonRecpt = root.getTable("BON_RECEPTION");
        this.addDeviseHAField(tableBonRecpt, root);
        SQLTable tableCommande = root.getTable("COMMANDE");
        this.addDeviseHAField(tableCommande, root);
        this.patchFieldElt1Dot3(root.getTable("ARTICLE"), root);
        this.patchFieldElt1Dot3(root.getTable("ARTICLE_TARIF"), root);
        if (!tableCommande.getFieldsName().contains("ID_ADRESSE")) {
            alterCmd = new AlterTable(tableCommande);
            alterCmd.addForeignColumn("ID_ADRESSE", root.findTable("ADRESSE", true));
            try {
                ds.execute(alterCmd.asString());
                tableCommande.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table COMMANDE", ex);
            }
        }
        if (!tableCommande.getFieldsName().contains("ID_CLIENT")) {
            alterCmd = new AlterTable(tableCommande);
            alterCmd.addForeignColumn("ID_CLIENT", root.findTable("CLIENT"));
            try {
                ds.execute(alterCmd.asString());
                tableCommande.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table COMMANDE", ex);
            }
        }
        this.addTotalDeviseField(tableDevis, root);
        this.addModeleField(tableDevis, root);
        SQLTable tableVF = root.getTable("SAISIE_VENTE_FACTURE");
        this.addTotalDeviseField(tableVF, root);
        this.addModeleField(tableVF, root);
        this.addTotalDeviseField(tableDevis, root);
        this.addModeleField(tableDevis, root);
        SQLTable tableCmd = root.getTable("COMMANDE_CLIENT");
        this.addTotalDeviseField(tableCmd, root);
        this.addModeleField(tableCmd, root);
        SQLTable tableBon = root.getTable("BON_DE_LIVRAISON");
        this.addTotalDeviseField(tableBon, root);
        this.addModeleField(tableBon, root);
        SQLTable tableAvoir = root.getTable("AVOIR_CLIENT");
        this.addTotalDeviseField(tableAvoir, root);
        this.addModeleField(tableAvoir, root);
        SQLTable tableClient = root.getTable("CLIENT");
        AlterTable tClient = new AlterTable(tableClient);
        boolean alterClient = false;
        if (!tableClient.getFieldsName().contains("ID_TARIF")) {
            tClient.addForeignColumn("ID_TARIF", root.findTable("TARIF", true));
            alterClient = true;
        }
        if (!tableClient.getFieldsName().contains("ID_PAYS")) {
            tClient.addForeignColumn("ID_PAYS", root.findTable("PAYS", true));
            alterClient = true;
        }
        if (!tableClient.getFieldsName().contains("ID_LANGUE")) {
            tClient.addForeignColumn("ID_LANGUE", root.findTable("LANGUE", true));
            alterClient = true;
        }
        if (!tableClient.getFieldsName().contains("ID_DEVISE")) {
            tClient.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            alterClient = true;
        }
        if (alterClient) {
            try {
                ds.execute(tClient.asString());
                tableClient.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table CLIENT", ex);
            }
        }
        SQLTable tablePays = root.getTable("PAYS");
        AlterTable tPays = new AlterTable(tablePays);
        boolean alterPays = false;
        if (!tablePays.getFieldsName().contains("ID_TARIF")) {
            tPays.addForeignColumn("ID_TARIF", root.findTable("TARIF", true));
            alterPays = true;
        }
        if (!tablePays.getFieldsName().contains("ID_LANGUE")) {
            tPays.addForeignColumn("ID_LANGUE", root.findTable("LANGUE", true));
            alterPays = true;
        }
        if (alterPays) {
            try {
                ds.execute(tPays.asString());
                tablePays.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table PAYS", ex);
            }
        }
        SQLTable tableCmd2 = root.getTable("COMMANDE");
        AlterTable tCmd = new AlterTable(tableCmd2);
        boolean alterCmd2 = false;
        if (!tableCmd2.getFieldsName().contains("EN_COURS")) {
            tCmd.addColumn("EN_COURS", "boolean default true");
            alterCmd2 = true;
        }
        if (alterCmd2) {
            try {
                ds.execute(tCmd.asString());
                tableCmd2.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table COMMANDE", ex);
            }
        }
        SQLTable tableVenteFacture = root.getTable("SAISIE_VENTE_FACTURE");
        AlterTable tVF = new AlterTable(tableVenteFacture);
        boolean alterVF = false;
        if (!tableVenteFacture.getFieldsName().contains("ID_TAXE_PORT")) {
            tVF.addForeignColumn("ID_TAXE_PORT", root.findTable("TAXE"));
            alterVF = true;
        }
        if (alterVF) {
            try {
                ds.execute(tVF.asString());
                tableVenteFacture.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table SAISIE_VENTE_FACTURE", ex);
            }
        }
        SQLTable tableFournisseur = root.getTable("FOURNISSEUR");
        AlterTable tFourn = new AlterTable(tableFournisseur);
        boolean alterFourn = false;
        if (!tableFournisseur.getFieldsName().contains("ID_LANGUE")) {
            tFourn.addForeignColumn("ID_LANGUE", root.findTable("LANGUE", true));
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("ID_DEVISE")) {
            tFourn.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("RESPONSABLE")) {
            tFourn.addVarCharColumn("RESPONSABLE", 256);
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("TEL_P")) {
            tFourn.addVarCharColumn("TEL_P", 256);
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("MAIL")) {
            tFourn.addVarCharColumn("MAIL", 256);
            alterFourn = true;
        }
        if (!tableFournisseur.getFieldsName().contains("INFOS")) {
            tFourn.addVarCharColumn("INFOS", 2048);
            alterFourn = true;
        }
        if (alterFourn) {
            try {
                ds.execute(tFourn.asString());
                tableFournisseur.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs sur la table FOURNISSEUR", ex);
            }
        }
        this.updateN4DS(root);
        root.refetch();
    }

    private void updateN4DS(DBRoot root) throws SQLException {
        SQLTable table = root.findTable("INFOS_SALARIE_PAYE");
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("CODE_AT")) {
            t.addVarCharColumn("CODE_AT", 18);
            alter = true;
        }
        if (!table.getFieldsName().contains("CODE_SECTION_AT")) {
            t.addVarCharColumn("CODE_SECTION_AT", 18);
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
        if (!root.contains("CODE_STATUT_CAT_CONV")) {
            SQLCreateTable createTarif = new SQLCreateTable(root, "CODE_STATUT_CAT_CONV");
            createTarif.addVarCharColumn("CODE", 6);
            createTarif.addVarCharColumn("NOM", 256);
            createTarif.asString();
            try {
                root.getBase().getDataSource().execute(createTarif.asString());
                InstallationPanel.insertUndef(createTarif);
                String insert = "INSERT into " + InstallationPanel.getTableName(createTarif).quote() + "(\"CODE\",\"NOM\") VALUES ";
                insert = String.valueOf(insert) + " ('01','agriculteur salari\u00e9 de son exploitation')";
                insert = String.valueOf(insert) + ", ('02','artisan ou commer\u00e7ant salari\u00e9 de son entreprise')";
                insert = String.valueOf(insert) + ", ('03','cadre dirigeant (votant au coll\u00e8ge employeur des \u00e9lections prud''''hommales)')";
                insert = String.valueOf(insert) + ", ('04','autres cadres au sens de la convention collective (ou du statut pour les r\u00e9gimes sp\u00e9ciaux)')";
                insert = String.valueOf(insert) + ", ('05','profession interm\u00e9diaire (technicien, contrema\u00eetre, agent de ma\u00eetrise, clerg\u00e9)')";
                insert = String.valueOf(insert) + ", ('06','employ\u00e9 administratif d''''entreprise, de commerce, agent de service')";
                insert = String.valueOf(insert) + ", ('07','ouvriers qualifi\u00e9s et non qualifi\u00e9s y compris ouvriers agricoles');";
                createTarif.getRoot().getDBSystemRoot().getDataSource().execute(insert);
                root.getSchema().updateVersion();
                root.refetch();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table CODE_STATUT_CAT_CONV", ex);
            }
        }
        if (!root.contains("CONTACT_ADMINISTRATIF")) {
            SQLCreateTable createModele = new SQLCreateTable(root, "CONTACT_ADMINISTRATIF");
            createModele.addVarCharColumn("NOM", 256);
            createModele.addVarCharColumn("PRENOM", 256);
            createModele.addVarCharColumn("TEL_DIRECT", 256);
            createModele.addVarCharColumn("TEL_MOBILE", 256);
            createModele.addVarCharColumn("EMAIL", 256);
            createModele.addVarCharColumn("FAX", 256);
            createModele.addVarCharColumn("FONCTION", 256);
            createModele.addVarCharColumn("TEL_PERSONEL", 256);
            createModele.addVarCharColumn("TEL_STANDARD", 256);
            createModele.addForeignColumn("ID_TITRE_PERSONNEL", root.findTable("TITRE_PERSONNEL"));
            createModele.addColumn("N4DS", "boolean DEFAULT false");
            try {
                root.getBase().getDataSource().execute(createModele.asString());
                InstallationPanel.insertUndef(createModele);
                root.getSchema().updateVersion();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de la cr\u00e9ation de la table MODELE", ex);
            }
        }
        SQLTable tableContrat = root.findTable("CONTRAT_SALARIE", true);
        boolean alter2 = false;
        AlterTable t2 = new AlterTable(tableContrat);
        if (!tableContrat.getFieldsName().contains("CODE_IRC_UGRR")) {
            t2.addVarCharColumn("CODE_IRC_UGRR", 18);
            alter2 = true;
        }
        if (!tableContrat.getFieldsName().contains("NUMERO_RATTACHEMENT_UGRR")) {
            t2.addVarCharColumn("NUMERO_RATTACHEMENT_UGRR", 64);
            alter2 = true;
        }
        if (!tableContrat.getFieldsName().contains("CODE_IRC_UGRC")) {
            t2.addVarCharColumn("CODE_IRC_UGRC", 18);
            alter2 = true;
        }
        if (!tableContrat.getFieldsName().contains("NUMERO_RATTACHEMENT_UGRC")) {
            t2.addVarCharColumn("NUMERO_RATTACHEMENT_UGRC", 64);
            alter2 = true;
        }
        if (!tableContrat.getFieldsName().contains("CODE_IRC_RETRAITE")) {
            t2.addVarCharColumn("CODE_IRC_RETRAITE", 18);
            alter2 = true;
        }
        if (!tableContrat.getFieldsName().contains("NUMERO_RATTACHEMENT_RETRAITE")) {
            t2.addVarCharColumn("NUMERO_RATTACHEMENT_RETRAITE", 64);
            alter2 = true;
        }
        if (!tableContrat.getFieldsName().contains("ID_CODE_STATUT_CAT_CONV")) {
            t2.addForeignColumn("ID_CODE_STATUT_CAT_CONV", root.findTable("CODE_STATUT_CAT_CONV", true));
            alter2 = true;
        }
        if (alter2) {
            try {
                tableContrat.getBase().getDataSource().execute(t2.asString());
                tableContrat.getSchema().updateVersion();
                tableContrat.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + tableContrat.getName(), ex);
            }
        }
    }

    private void addDeviseHAField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("ID_DEVISE")) {
            t.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            alter = true;
        }
        if (!table.getFieldsName().contains("T_DEVISE")) {
            t.addColumn("T_DEVISE", "bigint default 0");
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void patchFieldElt1Dot3(SQLTable table, DBRoot root) {
        List<String> cols = Arrays.asList("PV_HT", "PA_DEVISE_T", "T_PV_HT", "T_PA_TTC", "T_PA_HT", "PA_HT", "T_PV_TTC", "PRIX_METRIQUE_HA_2", "PRIX_METRIQUE_HA_1", "PRIX_METRIQUE_HA_3", "PRIX_METRIQUE_VT_2", "PRIX_METRIQUE_VT_1", "MONTANT_HT", "MONTANT_INITIAL", "PRIX_METRIQUE_VT_3", "MARGE_HT", "PA_DEVISE", "PV_U_DEVISE", "PV_T_DEVISE", "PV_TTC", "TARIF_Q18_HT", "T_PRIX_FINAL_TTC", "PRIX_FINAL_TTC", "PV_UNIT_HT", "PREBILAN", "MARGE_PREBILAN_HT");
        if (table.contains("PV_HT") && table.getField("PV_HT").getType().getDecimalDigits() == 0 || table.contains("PV_UNIT_HT") && table.getField("PV_UNIT_HT").getType().getDecimalDigits() == 0) {
            AlterTable t = new AlterTable(table);
            UpdateBuilder builder = new UpdateBuilder(table);
            ArrayList<UpdateBuilder> builds = new ArrayList<UpdateBuilder>();
            for (String field : cols) {
                if (!table.contains(field)) continue;
                UpdateBuilder builderNonNull = new UpdateBuilder(table);
                builderNonNull.set(field, "0");
                builderNonNull.setWhere(new Where((FieldRef)table.getField(field), "=", (Object)null));
                builds.add(builderNonNull);
                builder.set(field, String.valueOf(table.getField(field).getSQLName().getRest().quote()) + "/100");
                if (field.contains("TTC")) {
                    t.alterColumn(field, EnumSet.allOf(SQLField.Properties.class), "numeric(16,2)", "0", false);
                    continue;
                }
                t.alterColumn(field, EnumSet.allOf(SQLField.Properties.class), "numeric(16,6)", "0", false);
            }
            try {
                for (UpdateBuilder updateBuilder : builds) {
                    table.getBase().getDataSource().execute(updateBuilder.asString());
                }
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
            String req2 = builder.asString();
            root.getDBSystemRoot().getDataSource().execute(req2);
        }
    }

    private void patchFieldElt1Dot4(SQLTable table, DBRoot root) throws SQLException {
        AlterTable t;
        if (!table.contains("MONTANT_REMISE")) {
            t = new AlterTable(table);
            t.alterColumn("POURCENT_REMISE", EnumSet.allOf(SQLField.Properties.class), "numeric(12,8)", "0", true);
            t.addColumn("MONTANT_REMISE", "numeric (16,8)");
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
        if (!table.contains("ID_FAMILLE_ARTICLE")) {
            t = new AlterTable(table);
            t.addForeignColumn("ID_FAMILLE_ARTICLE", root.getTable("FAMILLE_ARTICLE"));
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout du champs ID_FAMILLE_ARTICLE \u00e0 la table " + table.getName(), ex);
            }
        }
        this.addNiveauElementField(table);
    }

    private void addNiveauElementField(SQLTable table) throws SQLException {
        if (!table.contains("NIVEAU")) {
            AlterTable t = new AlterTable(table);
            t.addIntegerColumn("NIVEAU", 1);
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout du niveau \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void addHAElementField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("QTE_ACHAT")) {
            t.addColumn("QTE_ACHAT", "integer DEFAULT 1");
            alter = true;
        }
        if (!table.getFieldsName().contains("QTE_UNITAIRE")) {
            t.addColumn("QTE_UNITAIRE", "numeric(16,6) DEFAULT 1");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_UNITE_VENTE")) {
            t.addForeignColumn("ID_UNITE_VENTE", root.findTable("UNITE_VENTE", true).getSQLName(), "ID", "2");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_ARTICLE")) {
            t.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE", true));
            alter = true;
        }
        if (!table.getFieldsName().contains("PA_DEVISE")) {
            t.addColumn("PA_DEVISE", "bigint default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_DEVISE")) {
            t.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            alter = true;
        }
        if (!table.getFieldsName().contains("PA_DEVISE_T")) {
            t.addColumn("PA_DEVISE_T", "bigint default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("DESCRIPTIF")) {
            t.addVarCharColumn("DESCRIPTIF", 2048);
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
        this.patchFieldElt1Dot3(table, root);
    }

    private void addRemiseField(SQLTable table, DBRoot root) throws SQLException {
        AlterTable t = new AlterTable(table);
        boolean alter = false;
        if (!table.contains("POURCENT_REMISE")) {
            t.addColumn("POURCENT_REMISE", "numeric (12,8)");
            alter = true;
        }
        if (!table.contains("MONTANT_REMISE")) {
            t.addColumn("MONTANT_REMISE", "numeric (16,8)");
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs remise \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void addAdresseField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("ID_ADRESSE")) {
            t.addForeignColumn("ID_ADRESSE", root.findTable("ADRESSE"));
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_ADRESSE_LIVRAISON")) {
            t.addForeignColumn("ID_ADRESSE_LIVRAISON", root.findTable("ADRESSE"));
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void addModeleField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("ID_MODELE")) {
            t.addForeignColumn("ID_MODELE", root.findTable("MODELE"));
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void addTotalDeviseField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("T_DEVISE")) {
            t.addColumn("T_DEVISE", "bigint default 0");
            alter = true;
        } else {
            table.getBase().getDataSource().execute("UPDATE " + table.getSQLName().quote() + " SET \"T_DEVISE\"=0 WHERE \"T_DEVISE\" IS NULL");
            t.alterColumn("T_DEVISE", EnumSet.allOf(SQLField.Properties.class), "bigint", "0", false);
        }
        if (!table.getFieldsName().contains("T_POIDS")) {
            t.addColumn("T_POIDS", "real default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_TARIF")) {
            t.addForeignColumn("ID_TARIF", root.findTable("TARIF", true));
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void addVenteEltField(SQLTable table, DBRoot root) throws SQLException {
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("QTE_ACHAT")) {
            t.addColumn("QTE_ACHAT", "integer DEFAULT 1");
            alter = true;
        }
        if (!table.getFieldsName().contains("QTE_UNITAIRE")) {
            t.addColumn("QTE_UNITAIRE", "numeric(16,6) DEFAULT 1");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_UNITE_VENTE")) {
            t.addForeignColumn("ID_UNITE_VENTE", root.findTable("UNITE_VENTE", true).getSQLName(), "ID", "2");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_ARTICLE")) {
            t.addForeignColumn("ID_ARTICLE", root.findTable("ARTICLE", true));
            alter = true;
        }
        if (!table.getFieldsName().contains("CODE_DOUANIER")) {
            t.addVarCharColumn("CODE_DOUANIER", 256);
            alter = true;
        }
        if (!table.getFieldsName().contains("DESCRIPTIF")) {
            t.addVarCharColumn("DESCRIPTIF", 2048);
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_PAYS")) {
            t.addForeignColumn("ID_PAYS", root.findTable("PAYS", true));
            alter = true;
        }
        if (!table.getFieldsName().contains("MARGE_HT")) {
            t.addColumn("MARGE_HT", "bigint default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_DEVISE")) {
            t.addForeignColumn("ID_DEVISE", root.findTable("DEVISE", true));
            alter = true;
        }
        if (!table.getFieldsName().contains("PV_U_DEVISE")) {
            t.addColumn("PV_U_DEVISE", "bigint default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("POURCENT_REMISE")) {
            t.addColumn("POURCENT_REMISE", "numeric(6,2) default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("PV_T_DEVISE")) {
            t.addColumn("PV_T_DEVISE", "bigint default 0");
            alter = true;
        }
        if (!table.getFieldsName().contains("TAUX_DEVISE")) {
            t.addColumn("TAUX_DEVISE", "numeric (16,8) DEFAULT 1");
            alter = true;
        }
        if (!table.getFieldsName().contains("POIDS_COLIS_NET")) {
            t.addColumn("POIDS_COLIS_NET", "numeric (16,8) DEFAULT 1");
            alter = true;
        }
        if (!table.getFieldsName().contains("T_POIDS_COLIS_NET")) {
            t.addColumn("T_POIDS_COLIS_NET", "numeric (16,8) DEFAULT 1");
            alter = true;
        }
        if (!table.getFieldsName().contains("NB_COLIS")) {
            t.addColumn("NB_COLIS", "integer DEFAULT 0");
            alter = true;
        }
        if (alter) {
            try {
                root.getDBSystemRoot().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
        this.patchFieldElt1Dot3(table, root);
    }

    private void updateSocieteSchema(DBRoot root) throws IOException, Exception {
        DBSystemRoot sysRoot = root.getDBSystemRoot();
        SQLDataSource ds = sysRoot.getDataSource();
        System.out.println("InstallationPanel.InstallationPanel() UPDATE COMMERCIAL " + root);
        SQLTable tableCommercial = root.getTable("COMMERCIAL");
        CorrectOrder orderCorrect = new CorrectOrder(sysRoot);
        orderCorrect.change(tableCommercial);
        new AddFK(sysRoot).changeAll(root);
        sysRoot.reload(Collections.singleton(root.getName()));
        try {
            try {
                SQLTable tableArticle = root.getTable("ARTICLE");
                if (!tableArticle.getFieldsName().contains("INFOS")) {
                    AlterTable t = new AlterTable(tableArticle);
                    t.addVarCharColumn("INFOS", 2048);
                    try {
                        ds.execute(t.asString());
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Erreur lors de l'ajout du champ INFO \u00e0 la table ARTICLE", ex);
                    }
                }
                if (sysRoot.getServer().getSQLSystem().equals((Object)SQLSystem.POSTGRESQL)) {
                    SQLTable tableCaisse = root.getTable("CAISSE");
                    FixSerial f = new FixSerial(sysRoot);
                    try {
                        f.change(tableCaisse);
                    }
                    catch (SQLException e2) {
                        throw new IllegalStateException("Erreur lors la mise \u00e0 jours des sequences de la table CAISSE", e2);
                    }
                }
                System.out.println("InstallationPanel.InstallationPanel() UPDATE TICKET_CAISSE " + root);
                SQLTable tableTicket = root.getTable("TICKET_CAISSE");
                if (!tableTicket.getFieldsName().contains("ID_MOUVEMENT")) {
                    AlterTable t = new AlterTable(tableTicket);
                    t.addForeignColumn("ID_MOUVEMENT", root.getTable("MOUVEMENT"));
                    try {
                        ds.execute(t.asString());
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Erreur lors de l'ajout du champ ID_MOUVEMENT \u00e0 la table TICKET_CAISSE", ex);
                    }
                }
                System.out.println("InstallationPanel.InstallationPanel() UPDATE TYPE_REGLEMENT " + root);
                SQLTable tableReglmt = root.getTable("TYPE_REGLEMENT");
                SQLSelect sel = new SQLSelect(tableReglmt.getBase());
                sel.addSelect(tableReglmt.getKey());
                sel.setWhere(new Where((FieldRef)tableReglmt.getField("NOM"), "=", (Object)"Virement"));
                List l = ds.executeCol(sel.asString());
                if (l.size() == 0) {
                    SQLRowValues rowVals = new SQLRowValues(tableReglmt);
                    rowVals.put("NOM", "Virement");
                    rowVals.put("COMPTANT", Boolean.FALSE);
                    rowVals.put("ECHEANCE", Boolean.FALSE);
                    try {
                        rowVals.commit();
                    }
                    catch (SQLException e) {
                        throw new IllegalStateException("Erreur lors de l'ajout du type de paiement par virement", e);
                    }
                }
                SQLSelect sel2 = new SQLSelect();
                sel2.addSelect(tableReglmt.getKey());
                sel2.setWhere(new Where((FieldRef)tableReglmt.getField("NOM"), "=", (Object)"CESU"));
                List l2 = ds.executeCol(sel2.asString());
                if (l2.size() == 0) {
                    SQLRowValues rowVals = new SQLRowValues(tableReglmt);
                    rowVals.put("NOM", "CESU");
                    rowVals.put("COMPTANT", Boolean.FALSE);
                    rowVals.put("ECHEANCE", Boolean.FALSE);
                    try {
                        rowVals.commit();
                    }
                    catch (SQLException e) {
                        throw new IllegalStateException("Erreur lors de l'ajout du type CESU", e);
                    }
                }
                System.out.println("InstallationPanel.InstallationPanel() UPDATE FAMILLE_ARTICLE " + root);
                SQLTable tableFam = root.getTable("FAMILLE_ARTICLE");
                int nomSize = 256;
                if (tableFam.getField("NOM").getType().getSize() < 256) {
                    AlterTable t = new AlterTable(tableFam);
                    t.alterColumn("NOM", EnumSet.allOf(SQLField.Properties.class), "varchar(256)", "''", false);
                    try {
                        ds.execute(t.asString());
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Erreur lors de la modification du champs NOM sur la table FAMILLE_ARTICLE", ex);
                    }
                }
                System.out.println("InstallationPanel.InstallationPanel() UPDATE FROM 1.0 " + root);
                ArrayList changes = new ArrayList();
                ModuleManager instance = new ModuleManager();
                instance.setRoot(root);
                Set<ModuleReference> refs = instance.getModulesInstalledRemotely();
                HashSet<String> allUsedTable = new HashSet<String>();
                for (ModuleReference ref : refs) {
                    Set<String> tableNames = instance.getCreatedItems(ref.getID()).get0();
                    allUsedTable.addAll(tableNames);
                }
                System.out.println("Tables created by modules:" + allUsedTable);
                List<String> alterRequests = ChangeTable.cat(changes, root.getName());
                try {
                    for (String req : alterRequests) {
                        ds.execute(req);
                    }
                }
                catch (Exception e1) {
                    throw new IllegalStateException("Erreur lors de la mise \u00e0 jour des tables v1.0", e1);
                }
                System.out.println("InstallationPanel.InstallationPanel() UPDATE CAISSE " + root);
                try {
                    SQLTable.setUndefID(tableTicket.getSchema(), tableTicket.getName(), 1);
                    SQLTable.setUndefID(tableTicket.getSchema(), "CAISSE", 1);
                }
                catch (SQLException e1) {
                    throw new IllegalStateException("Erreur lors de la mise \u00e0 jour des ind\u00e9finis de la table CAISSE", e1);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle("updateSocieteSchema on root " + root + " failed", e);
                root.getSchema().updateVersion();
                root.refetch();
            }
        }
        finally {
            root.getSchema().updateVersion();
            root.refetch();
        }
    }

    private void checkRights(DBRoot root) throws SQLException {
        SQLRowValues rowValsUserRight;
        SQLRow row;
        String desc;
        SQLRowValues rowVals;
        SQLTable table = root.findTable("RIGHT");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(table.getKey());
        sel.addSelect(table.getField("CODE"));
        List<SQLRow> rows = SQLRowListRSH.execute(sel);
        HashSet<String> codes = new HashSet<String>();
        for (SQLRow row2 : rows) {
            codes.add(row2.getString("CODE"));
        }
        if (!codes.contains("UPDATE_ROW")) {
            rowVals = new SQLRowValues(table);
            rowVals.put("CODE", "UPDATE_ROW");
            rowVals.put("NOM", "Modification d'une ligne");
            desc = "Autorise un utilisateur \u00e0 modifier les \u00e9l\u00e9ments de la table sp\u00e9cifi\u00e9e en objet.";
            rowVals.put("DESCRIPTION", desc);
            rowVals.commit();
        }
        if (!codes.contains("DELETE_ROW")) {
            rowVals = new SQLRowValues(table);
            rowVals.put("CODE", "DELETE_ROW");
            rowVals.put("NOM", "Suppression d'une ligne");
            desc = "Autorise un utilisateur \u00e0 supprimer les \u00e9l\u00e9ments de la table sp\u00e9cifi\u00e9e en objet.";
            rowVals.put("DESCRIPTION", desc);
            rowVals.commit();
        }
        if (!codes.contains("INSERT_ROW")) {
            rowVals = new SQLRowValues(table);
            rowVals.put("CODE", "INSERT_ROW");
            rowVals.put("NOM", "Ajout d'une ligne");
            desc = "Autorise un utilisateur \u00e0 ajouter un \u00e9l\u00e9ment dans la table sp\u00e9cifi\u00e9e en objet.";
            rowVals.put("DESCRIPTION", desc);
            rowVals.commit();
        }
        if (!codes.contains("SAVE_ROW")) {
            rowVals = new SQLRowValues(table);
            rowVals.put("CODE", "SAVE_ROW");
            rowVals.put("NOM", "Export des listes");
            desc = "Autorise un utilisateur \u00e0 exporter le contenu des listes via le bouton repr\u00e9sentant une disquette.";
            rowVals.put("DESCRIPTION", desc);
            row = rowVals.commit();
            rowValsUserRight = new SQLRowValues(table.getTable("USER_RIGHT"));
            rowValsUserRight.put("ID_RIGHT", row.getID());
            rowValsUserRight.put("HAVE_RIGHT", Boolean.TRUE);
            rowValsUserRight.commit();
        }
        if (!codes.contains("MENU_ACCESS")) {
            rowVals = new SQLRowValues(table);
            rowVals.put("CODE", "MENU_ACCESS");
            rowVals.put("NOM", "Autoriser l'acc\u00e9s \u00e0 un menu");
            desc = "Autorise un utilisateur \u00e0 visualiser le menu sp\u00e9cifi\u00e9 en objet.";
            rowVals.put("DESCRIPTION", desc);
            row = rowVals.commit();
            rowValsUserRight = new SQLRowValues(table.getTable("USER_RIGHT"));
            rowValsUserRight.put("ID_RIGHT", row.getID());
            rowValsUserRight.put("HAVE_RIGHT", Boolean.TRUE);
            rowValsUserRight.commit();
        }
        if (!codes.contains("GROUP_ITEM_SHOW")) {
            rowVals = new SQLRowValues(table);
            rowVals.put("CODE", "GROUP_ITEM_SHOW");
            rowVals.put("NOM", "Autoriser \u00e0 visualiser un champ");
            desc = "Autorise un utilisateur \u00e0 visualiser le champ sp\u00e9cifi\u00e9 en objet dans une interface.";
            rowVals.put("DESCRIPTION", desc);
            row = rowVals.commit();
            rowValsUserRight = new SQLRowValues(table.getTable("USER_RIGHT"));
            rowValsUserRight.put("ID_RIGHT", row.getID());
            rowValsUserRight.put("HAVE_RIGHT", Boolean.TRUE);
            rowValsUserRight.commit();
        }
    }

    private void findBadForeignKey(DBRoot root) {
        Set<SQLTable> tables = root.getTables();
        for (SQLTable table : tables) {
            this.findBadForeignKey(root, table);
        }
    }

    private void findBadForeignKey(DBRoot root, SQLTable table) {
        System.out.println("====================================== " + table.getName());
        Set<SQLField> ffields = table.getForeignKeys();
        Set<String> keysString = SQLKey.foreignKeys(table);
        for (String string : keysString) {
            ffields.add(table.getField(string));
        }
        if (ffields.size() == 0) {
            System.out.println("No foreign fields");
        }
        System.out.println("Foreign field for table " + table.getName() + ":" + ffields);
        HashMap<SQLField, SQLTable> map = new HashMap<SQLField, SQLTable>();
        HashSet<SQLTable> extTables = new HashSet<SQLTable>();
        for (SQLField sqlField : ffields) {
            SQLTable t = null;
            try {
                t = SQLKey.keyToTable(sqlField);
            }
            catch (Exception e) {
                System.out.println("Ignoring field:" + sqlField.getName());
            }
            if (t == null) {
                System.out.println("Unable to find table for ff " + sqlField.getName());
                continue;
            }
            extTables.add(t);
            map.put(sqlField, t);
        }
        System.out.println("Foreign table for table " + table.getName() + ":" + extTables);
        Map<SQLTable, Set<Number>> ids = this.getIdsForTables(extTables);
        SQLSelect s = new SQLSelect(true);
        if (table.getPrimaryKeys().size() != 1) {
            return;
        }
        s.addSelect(table.getKey());
        for (SQLField sqlField : map.keySet()) {
            s.addSelect(sqlField);
        }
        List result = root.getDBSystemRoot().getDataSource().execute(s.asString());
        for (Map resultRow : result) {
            Set fields = resultRow.keySet();
            for (String field : fields) {
                SQLField fField = table.getField(field);
                if (table.getPrimaryKeys().contains(fField)) continue;
                SQLTable fTable = (SQLTable)map.get(fField);
                if (fTable == null) {
                    System.out.println("Error: null table for field" + field);
                    continue;
                }
                Set<Number> values = ids.get(fTable);
                Object id = resultRow.get(field);
                if (id == null || values.contains((Number)id)) continue;
                System.out.println("Checking row " + resultRow);
                System.out.println("Error: No id found in table " + fTable.getName() + " for row " + field + "in table " + table.getName() + " " + resultRow + " knowns id:" + values);
            }
        }
        System.out.println("======================================\n");
    }

    private Map<SQLTable, Set<Number>> getIdsForTables(Set<SQLTable> extTables) {
        HashMap<SQLTable, Set<Number>> result = new HashMap<SQLTable, Set<Number>>();
        for (SQLTable sqlTable : extTables) {
            result.put(sqlTable, this.getIdsForTable(sqlTable));
        }
        return result;
    }

    private Set<Number> getIdsForTable(SQLTable table) {
        DBRoot dbRoot = table.getDBRoot();
        SQLSelect s = new SQLSelect(true);
        s.addSelect(table.getKey());
        List result = dbRoot.getDBSystemRoot().getDataSource().executeCol(s.asString());
        return new HashSet<Number>(result);
    }

    private void updateCommon(final DBRoot root) throws SQLException {
        SQLTable tableObjet;
        SQLUtils.executeAtomic(root.getDBSystemRoot().getDataSource(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                InstallationPanel.this.fixCompletion(root);
                return null;
            }
        });
        if (ProductInfo.getInstance().getName().equalsIgnoreCase("OpenConcerto")) {
            SQLTable tableExercice = root.getTable("EXERCICE_COMMON");
            String reqUp = "UPDATE " + tableExercice.getSQLName().quote() + " SET \"ID_SOCIETE_COMMON\"=1 WHERE ";
            reqUp = String.valueOf(reqUp) + new Where((FieldRef)tableExercice.getKey(), 3, (Object)49).getClause();
            root.getDBSystemRoot().getDataSource().execute(reqUp);
            String reqUp2 = "UPDATE " + tableExercice.getSQLName().quote() + " SET \"ID_SOCIETE_COMMON\"=1 WHERE ";
            reqUp2 = String.valueOf(reqUp2) + new Where((FieldRef)tableExercice.getKey(), 53, (Object)57).getClause();
            root.getDBSystemRoot().getDataSource().execute(reqUp2);
            SQLTable tableSociete = root.getTable("SOCIETE_COMMON");
            String req3 = "DELETE FROM " + tableSociete.getSQLName().quote() + " WHERE ";
            req3 = String.valueOf(req3) + new Where((FieldRef)tableSociete.getKey(), 43, (Object)47).getClause();
            root.getDBSystemRoot().getDataSource().execute(req3);
            String req1a = "DELETE FROM " + tableExercice.getSQLName().quote() + " WHERE ";
            req1a = String.valueOf(req1a) + new Where((FieldRef)tableExercice.getKey(), 3, (Object)49).getClause();
            root.getDBSystemRoot().getDataSource().execute(req1a);
            root.getDBSystemRoot().getDataSource().execute(req1a);
            String req1b = "DELETE FROM " + tableExercice.getSQLName().quote() + " WHERE ";
            req1b = String.valueOf(req1b) + new Where((FieldRef)tableExercice.getKey(), 53, (Object)57).getClause();
            root.getDBSystemRoot().getDataSource().execute(req1b);
            for (String f : Arrays.asList("ID_USER_COMMON_TO", "ID_USER_COMMON_CREATE", "ID_USER_COMMON_ASSIGN_BY")) {
                SQLTable tableTache = root.getTable("TACHE_COMMON");
                UpdateBuilder updateBuilder = new UpdateBuilder(tableTache);
                updateBuilder.set(f, "1").setWhere(new Where((FieldRef)tableTache.getField(f), "=", 0));
                String req2 = updateBuilder.asString();
                root.getDBSystemRoot().getDataSource().execute(req2);
            }
        }
        if ((tableObjet = root.getTable("OBJET")) != null && root.getTable("DOMAINE") == null && tableObjet.contains("ID_DOMAINE")) {
            AlterTable alter = new AlterTable(tableObjet);
            alter.dropColumn("ID_DOMAINE");
            String req = alter.asString();
            root.getDBSystemRoot().getDataSource().execute(req);
            root.refetchTable(tableObjet.getName());
        }
        new AddFK(root.getDBSystemRoot()).changeAll(root);
    }

    protected void fixCompletion(DBRoot root) throws SQLException {
        SQLTable completionT = root.getTable(SQLTextCombo.getTableName());
        if (completionT != null && completionT.getPrimaryKeys().size() == 0) {
            SQLDataSource ds = root.getDBSystemRoot().getDataSource();
            Number oldCount = (Number)ds.executeScalar(new SQLSelect().addSelectFunctionStar("count").addFrom(completionT).asString());
            SQLCreateMoveableTable createTable = SQLTextCombo.getCreateTable(SQLSyntax.get(root));
            createTable.setName(String.valueOf(completionT.getName()) + "TMP");
            ds.execute(createTable.asString(root.getName()));
            SQLField refF = completionT.getField(SQLTextCombo.getRefFieldName());
            SQLField valueF = completionT.getField(SQLTextCombo.getValueFieldName());
            SQLSelect sel = new SQLSelect();
            sel.addSelect(refF).addSelect(valueF);
            sel.addGroupBy(refF).addGroupBy(valueF);
            int newCount = new Inserter(createTable, root).insertCount(" ( " + sel.asString() + " )");
            ds.execute("DROP TABLE " + completionT.getSQL());
            ds.execute("ALTER TABLE " + new SQLName(root.getName(), createTable.getName()).quote() + " RENAME to " + completionT.getQuotedName());
            root.getSchema().updateVersion();
            root.refetchTable(completionT.getName());
            System.out.println("Added primary key to " + completionT.getSQL() + " (row count : from " + oldCount + " to " + newCount + ")");
        }
    }

    private void updateSocieteTable(DBRoot root) throws SQLException {
        SQLTable table = root.findTable("SOCIETE_COMMON");
        boolean alter = false;
        AlterTable t = new AlterTable(table);
        if (!table.getFieldsName().contains("RCS")) {
            t.addVarCharColumn("RCS", 256);
            alter = true;
        }
        if (!table.getFieldsName().contains("ID_DEVISE")) {
            t.addForeignColumn("ID_DEVISE", root.getTable("DEVISE"));
            alter = true;
        }
        if (!table.getFieldsName().contains("CAPITAL")) {
            t.addColumn("CAPITAL", "bigint DEFAULT 0");
            alter = true;
        }
        if (alter) {
            try {
                table.getBase().getDataSource().execute(t.asString());
                table.getSchema().updateVersion();
                table.fetchFields();
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Erreur lors de l'ajout des champs \u00e0 la table " + table.getName(), ex);
            }
        }
    }

    private void updateVille(SQLTable tableAdresse) throws SQLException {
        if (tableAdresse != null && tableAdresse.getField("CODE_POSTAL").getType().getJavaType() == Integer.class) {
            String reqRemoveField = "ALTER TABLE " + tableAdresse.getSQLName().quote() + " DROP COLUMN \"CODE_POSTAL\"";
            tableAdresse.getBase().getDataSource().execute(reqRemoveField);
            tableAdresse.getSchema().updateVersion();
            tableAdresse.fetchFields();
            String reqAddVarCharField = "ALTER TABLE " + tableAdresse.getSQLName().quote() + " ADD COLUMN \"CODE_POSTAL\" character varying(256) DEFAULT ''::character varying";
            tableAdresse.getBase().getDataSource().execute(reqAddVarCharField);
            tableAdresse.getSchema().updateVersion();
            tableAdresse.fetchFields();
            String req = "UPDATE " + tableAdresse.getSQLName().quote() + " SET \"VILLE\"= trim (both ' ' from substring(\"VILLE\" from 0 for (position('(' in \"VILLE\")))) ";
            req = String.valueOf(req) + ", \"CODE_POSTAL\"=substring(\"VILLE\" from (position('(' in \"VILLE\")+1) for length(\"VILLE\")-position('(' in \"VILLE\")-1) WHERE \"VILLE\" LIKE '% (%)'";
            tableAdresse.getDBRoot().getDBSystemRoot().getDataSource().execute(req);
        }
    }

    private void updateVariablePaye(SQLTable table, String var, double value) throws SQLException {
        if (table == null) {
            throw new IllegalArgumentException("null table");
        }
        SQLSelect sel = new SQLSelect();
        sel.addSelectStar(table);
        sel.setWhere(new Where((FieldRef)table.getField("NOM"), "=", (Object)var));
        List l = (List)table.getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        for (SQLRow sqlRow : l) {
            SQLRowValues rowVals = sqlRow.asRowValues();
            rowVals.put("VALEUR", value);
            rowVals.update();
        }
    }
}

