/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.fastpath;

import java.sql.SQLException;
import org.postgresql.core.ParameterList;

public class FastpathArg {
    private final byte[] bytes;
    private final int bytesStart;
    private final int bytesLength;

    public FastpathArg(int value) {
        this.bytes = new byte[4];
        this.bytes[3] = (byte)value;
        this.bytes[2] = (byte)(value >> 8);
        this.bytes[1] = (byte)(value >> 16);
        this.bytes[0] = (byte)(value >> 24);
        this.bytesStart = 0;
        this.bytesLength = 4;
    }

    public FastpathArg(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public FastpathArg(byte[] buf, int off, int len) {
        this.bytes = buf;
        this.bytesStart = off;
        this.bytesLength = len;
    }

    void populateParameter(ParameterList params, int index) throws SQLException {
        if (this.bytes == null) {
            params.setNull(index, 0);
        } else {
            params.setBytea(index, this.bytes, this.bytesStart, this.bytesLength);
        }
    }
}

