/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import org.postgresql.core.Oid;

public class Field {
    private final int length;
    private final int oid;
    private final int mod;
    private final String columnLabel;
    private String columnName;
    private int format = 0;
    private final int tableOid;
    private final int positionInTable;
    private String tableName = "";
    private String schemaName = "";
    private int nullable = 2;
    private boolean autoIncrement = false;

    public Field(String name, int oid, int length, int mod) {
        this(name, name, oid, length, mod, 0, 0);
    }

    public Field(String name, int oid) {
        this(name, oid, 0, -1);
    }

    public Field(String columnLabel, String columnName, int oid, int length, int mod, int tableOid, int positionInTable) {
        this.columnLabel = columnLabel;
        this.columnName = columnName;
        this.oid = oid;
        this.length = length;
        this.mod = mod;
        this.tableOid = tableOid;
        this.positionInTable = positionInTable;
    }

    public int getOID() {
        return this.oid;
    }

    public int getMod() {
        return this.mod;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public int getTableOid() {
        return this.tableOid;
    }

    public int getPositionInTable() {
        return this.positionInTable;
    }

    public void setNullable(int nullable) {
        this.nullable = nullable;
    }

    public int getNullable() {
        return this.nullable;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public boolean getAutoIncrement() {
        return this.autoIncrement;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String toString() {
        return "Field(" + (this.columnName != null ? this.columnName : "") + "," + Oid.toString(this.oid) + "," + this.length + "," + (this.format == 0 ? (char)'T' : 'B') + ")";
    }
}

