/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.copy;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.postgresql.copy.CopyIn;
import org.postgresql.copy.CopyOperation;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.Encoding;
import org.postgresql.core.QueryExecutor;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class CopyManager {
    private final Encoding encoding;
    private final QueryExecutor queryExecutor;
    private final BaseConnection connection;

    public CopyManager(BaseConnection connection) throws SQLException {
        this.encoding = connection.getEncoding();
        this.queryExecutor = connection.getQueryExecutor();
        this.connection = connection;
    }

    public CopyIn copyIn(String sql) throws SQLException {
        CopyOperation op = null;
        try {
            op = this.queryExecutor.startCopy(sql, this.connection.getAutoCommit());
            return (CopyIn)op;
        }
        catch (ClassCastException cce) {
            op.cancelCopy();
            throw new PSQLException(GT.tr("Requested CopyIn but got {0}", op.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE, (Throwable)cce);
        }
    }

    public long copyIn(String sql, InputStream from) throws SQLException, IOException {
        return this.copyIn(sql, from, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyIn(String sql, InputStream from, int bufferSize) throws SQLException, IOException {
        byte[] buf = new byte[bufferSize];
        CopyIn cp = this.copyIn(sql);
        try {
            int len;
            while ((len = from.read(buf)) > 0) {
                cp.writeToCopy(buf, 0, len);
            }
            long l = cp.endCopy();
            return l;
        }
        finally {
            if (cp.isActive()) {
                cp.cancelCopy();
            }
        }
    }
}

