/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Stack;
import org.jdom2.Element;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cache.ICache;
import org.openconcerto.utils.cc.ExnTransformer;
import org.openconcerto.xml.JDOM2Utils;
import org.openconcerto.xml.JDOMUtils;

public class XMLCodecUtils {
    private static final ICache<Object, Method, Object> cache = new ICache(60, -1, "methods for " + XMLCodecUtils.class);
    private static final ICache<Object, Constructor<?>, Object> cacheCtor = new ICache(60, -1, "constructors for " + XMLCodecUtils.class);
    private static final Charset CS = Charset.forName("UTF-8");
    private static final Encoder bogus = new Encoder();
    private static PersistenceDelegate defaultPersistenceDelegate = new DefaultPersistenceDelegate();
    private static final Map<Class, PersistenceDelegate> persDelegates = new HashMap<Class, PersistenceDelegate>();
    public static final ExceptionListener EXCEPTION_LISTENER = new ExceptionListener(){

        @Override
        public void exceptionThrown(Exception e) {
            throw new IllegalStateException(e);
        }
    };
    private static final Map<String, Class> primitiveNames = new HashMap<String, Class>();

    static {
        primitiveNames.put("boolean", Boolean.TYPE);
        primitiveNames.put("byte", Byte.TYPE);
        primitiveNames.put("char", Character.TYPE);
        primitiveNames.put("short", Short.TYPE);
        primitiveNames.put("int", Integer.TYPE);
        primitiveNames.put("long", Long.TYPE);
        primitiveNames.put("float", Float.TYPE);
        primitiveNames.put("double", Double.TYPE);
    }

    public static final String encodeSimple(Object o) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<java version=\"1.6.0\" class=\"java.beans.XMLDecoder\">");
        XMLCodecUtils.encodeSimpleRec(o, sb);
        sb.append("</java>");
        return sb.toString();
    }

    private static final void createElemEscaped(String elemName, Object o, StringBuilder sb) {
        XMLCodecUtils.createElem(elemName, JDOMUtils.OUTPUTTER.escapeElementEntities(o.toString()), sb);
    }

    private static final void createElem(String elemName, Object o, StringBuilder sb) {
        assert (o != null);
        sb.append('<');
        sb.append(elemName);
        sb.append('>');
        sb.append(o.toString());
        sb.append("</");
        sb.append(elemName);
        sb.append('>');
    }

    private static final void encodeSimpleRec(Object o, StringBuilder sb) {
        if (o == null) {
            sb.append("<null/>");
            return;
        }
        Class<?> c = o.getClass();
        if (c == Boolean.class) {
            XMLCodecUtils.createElem("boolean", o, sb);
        } else if (c == String.class) {
            XMLCodecUtils.createElemEscaped("string", o, sb);
        } else if (c == Character.class) {
            XMLCodecUtils.createElemEscaped("char", o, sb);
        } else if (c == Integer.class) {
            XMLCodecUtils.createElem("int", o, sb);
        } else if (c == Long.class) {
            XMLCodecUtils.createElem("long", o, sb);
        } else if (c == Float.class) {
            XMLCodecUtils.createElem("float", o, sb);
        } else if (c == Double.class) {
            XMLCodecUtils.createElem("double", o, sb);
        } else if (c == Class.class) {
            XMLCodecUtils.createElem("class", ((Class)o).getName(), sb);
        } else if (c == Short.class) {
            XMLCodecUtils.createElem("short", o, sb);
        } else if (c == Byte.class) {
            XMLCodecUtils.createElem("byte", o, sb);
        } else if (o instanceof Enum) {
            sb.append("<object class=\"");
            sb.append(c.getName());
            sb.append("\" method=\"valueOf\"><string>");
            sb.append(((Enum)o).name());
            sb.append("</string></object>");
        } else if (c.isArray()) {
            sb.append("<array class=\"");
            sb.append(c.getComponentType().getName());
            sb.append("\">");
            int stop = Array.getLength(o);
            int j = 0;
            while (j < stop) {
                XMLCodecUtils.encodeSimpleRec(Array.get(o, j), sb);
                ++j;
            }
            sb.append("</array>");
        } else if (o instanceof Map) {
            sb.append("<object class=\"");
            if (c.getName().startsWith("java.util.Collections$")) {
                sb.append("java.util.HashMap");
            } else {
                sb.append(c.getName());
            }
            sb.append("\">");
            Map m = (Map)o;
            for (Map.Entry e : m.entrySet()) {
                sb.append("<void method=\"put\" >");
                XMLCodecUtils.encodeSimpleRec(e.getKey(), sb);
                XMLCodecUtils.encodeSimpleRec(e.getValue(), sb);
                sb.append("</void>");
            }
            sb.append("</object>");
        } else if (o instanceof Collection) {
            sb.append("<object class=\"");
            if (c.getName().startsWith("java.util.Arrays$")) {
                sb.append("java.util.ArrayList");
            } else if (c.getName().startsWith("java.util.Collections$")) {
                if (o instanceof Set) {
                    sb.append("java.util.HashSet");
                } else {
                    sb.append("java.util.ArrayList");
                }
            } else {
                sb.append(c.getName());
            }
            sb.append("\">");
            if (o instanceof RandomAccess && o instanceof List) {
                List list = (List)o;
                int stop = list.size();
                int i = 0;
                while (i < stop) {
                    sb.append("<void method=\"add\" >");
                    XMLCodecUtils.encodeSimpleRec(list.get(i), sb);
                    sb.append("</void>");
                    ++i;
                }
            } else {
                for (Object item : (Collection)o) {
                    sb.append("<void method=\"add\" >");
                    XMLCodecUtils.encodeSimpleRec(item, sb);
                    sb.append("</void>");
                }
            }
            sb.append("</object>");
        } else if (o instanceof Point) {
            Point p = (Point)o;
            sb.append("<object class=\"java.awt.Point\">");
            XMLCodecUtils.encodeSimpleRec(p.x, sb);
            XMLCodecUtils.encodeSimpleRec(p.y, sb);
            sb.append("</object>");
        } else if (o instanceof Dimension) {
            Dimension p = (Dimension)o;
            sb.append("<object class=\"java.awt.Dimension\">");
            XMLCodecUtils.encodeSimpleRec(p.width, sb);
            XMLCodecUtils.encodeSimpleRec(p.height, sb);
            sb.append("</object>");
        } else if (o instanceof Rectangle) {
            Rectangle p = (Rectangle)o;
            sb.append("<object class=\"java.awt.Rectangle\">");
            XMLCodecUtils.encodeSimpleRec(p.x, sb);
            XMLCodecUtils.encodeSimpleRec(p.y, sb);
            XMLCodecUtils.encodeSimpleRec(p.width, sb);
            XMLCodecUtils.encodeSimpleRec(p.height, sb);
            sb.append("</object>");
        } else {
            BeanInfo info;
            try {
                info = Introspector.getBeanInfo(c);
            }
            catch (IntrospectionException e) {
                throw new IllegalStateException("Couldn't inspect " + o, e);
            }
            sb.append("<object class=\"");
            sb.append(c.getName());
            sb.append("\">");
            PropertyDescriptor[] propertyDescriptorArray = info.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                Method getter = pd.getReadMethod();
                Method setter = pd.getWriteMethod();
                if (getter != null && setter != null && pd.getValue("transient") != Boolean.TRUE) {
                    try {
                        sb.append("<void method=\"" + setter.getName() + "\">");
                        XMLCodecUtils.encodeSimpleRec(getter.invoke(o, new Object[0]), sb);
                        sb.append("</void>");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Couldn't get the value of the '" + pd.getDisplayName() + "' property for " + o, e);
                    }
                }
                ++n2;
            }
            sb.append("</object>");
        }
    }

    public static final Object decode1(Element javaElem) {
        Element elem = javaElem.getChildren().get(0);
        try {
            return XMLCodecUtils.eval(elem, new Stack<Object>(), new HashMap<String, Object>());
        }
        catch (Exception e) {
            throw new IllegalStateException("error decoding " + JDOM2Utils.output(javaElem), e);
        }
    }

    private static final Object eval(Element elem, Stack<Object> context, Map<String, Object> ids) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String n = elem.getName();
        if (n.equals("null")) {
            return null;
        }
        if (n.equals("boolean")) {
            return Boolean.valueOf(elem.getText());
        }
        if (n.equals("byte")) {
            return Byte.valueOf(elem.getText());
        }
        if (n.equals("char")) {
            return Character.valueOf(elem.getText().charAt(0));
        }
        if (n.equals("string")) {
            return elem.getText();
        }
        if (n.equals("short")) {
            return Short.valueOf(elem.getText());
        }
        if (n.equals("int")) {
            return Integer.valueOf(elem.getText());
        }
        if (n.equals("long")) {
            return Long.valueOf(elem.getText());
        }
        if (n.equals("float")) {
            return Float.valueOf(elem.getText());
        }
        if (n.equals("double")) {
            return Double.valueOf(elem.getText());
        }
        if (n.equals("array")) {
            String classAttr = elem.getAttributeValue("class");
            String lengthAttr = elem.getAttributeValue("length");
            final Class<?> componentClass = XMLCodecUtils.parseClassName(classAttr);
            if (lengthAttr != null) {
                context.push(Array.newInstance(componentClass, Integer.parseInt(lengthAttr)));
                for (Element child : elem.getChildren()) {
                    XMLCodecUtils.eval(child, context, ids);
                }
                return context.pop();
            }
            return XMLCodecUtils.evalContainer(elem, context, ids, (ExnTransformer<List<Object>, Object, ? extends Exception>)new ExnTransformer<List<Object>, Object, RuntimeException>(){

                public Object transformChecked(List<Object> args) {
                    Object res = Array.newInstance(componentClass, args.size());
                    int j = 0;
                    while (j < args.size()) {
                        Array.set(res, j, args.get(j));
                        ++j;
                    }
                    return res;
                }
            });
        }
        if (n.equals("void") || n.equals("object")) {
            String idref = elem.getAttributeValue("idref");
            if (idref != null) {
                if (!ids.containsKey(idref)) {
                    throw new IllegalStateException("id '" + idref + "' wasn't defined");
                }
                return ids.get(idref);
            }
            String id = elem.getAttributeValue("id");
            String targetClass = elem.getAttributeValue("class");
            final Class<?> target = targetClass == null ? context.peek() : Class.forName(targetClass);
            final String propAttr = elem.getAttributeValue("property");
            final String indexAttr = elem.getAttributeValue("index");
            final String methodAttr = elem.getAttributeValue("method");
            Object res = XMLCodecUtils.evalContainer(elem, context, ids, (ExnTransformer<List<Object>, Object, ? extends Exception>)new ExnTransformer<List<Object>, Object, Exception>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Object transformChecked(List<Object> args) throws Exception {
                    if (propAttr != null) {
                        String methodName = String.valueOf(args.size() == 0 ? "get" : "set") + StringUtils.firstUp(propAttr);
                        return XMLCodecUtils.invoke(target, methodName, args);
                    }
                    if (indexAttr != null) {
                        if (target instanceof List) {
                            String methodName = args.size() == 0 ? "get" : "set";
                            args.add(0, Integer.valueOf(indexAttr));
                            return XMLCodecUtils.invoke(target, methodName, args);
                        }
                        if (!target.getClass().isArray()) throw new IllegalStateException("use index with neither List nor array: " + target);
                        Class<?> componentType = target.getClass().getComponentType();
                        String methodName = String.valueOf(args.size() == 0 ? "get" : "set") + (componentType.isPrimitive() ? StringUtils.firstUp(componentType.getSimpleName()) : "");
                        args.add(0, target);
                        args.add(1, Integer.valueOf(indexAttr));
                        return XMLCodecUtils.invoke(Array.class, methodName, args);
                    }
                    if (methodAttr == null) return XMLCodecUtils.getCtor((Class)target, args).newInstance(args.toArray());
                    return XMLCodecUtils.invoke(target, methodAttr, args);
                }
            });
            if (id != null) {
                ids.put(id, res);
            }
            return res;
        }
        if (n.equals("class")) {
            return Class.forName(elem.getText());
        }
        throw new UnsupportedOperationException("doesn't yet support " + n);
    }

    private static final Object evalContainer(Element parent, Stack<Object> context, Map<String, Object> ids, ExnTransformer<List<Object>, Object, ? extends Exception> transf) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList<Object> args = new ArrayList<Object>();
        List<Element> children = parent.getChildren();
        int i = 0;
        boolean noVoid = true;
        while (i < children.size() && noVoid) {
            Element child = children.get(i);
            if (child.getName().equals("void")) {
                noVoid = false;
                continue;
            }
            args.add(XMLCodecUtils.eval(child, context, ids));
            ++i;
        }
        Object res = transf.transformCheckedWithExn(args, false, InvocationTargetException.class, InstantiationException.class, IllegalAccessException.class);
        context.push(res);
        while (i < children.size()) {
            Element child = children.get(i);
            XMLCodecUtils.eval(child, context, ids);
            ++i;
        }
        return context.pop();
    }

    private static final Object invoke(Object target, String methodName, List<Object> args) throws IllegalAccessException, InvocationTargetException {
        Class<?> clazz = target instanceof Class ? (Class<?>)target : target.getClass();
        Method m = XMLCodecUtils.getMethod(clazz, methodName, args);
        return m.invoke(target, args.toArray());
    }

    private static final Method getMethod(Class<?> clazz, String name, List<Object> actualArgs) {
        List<Class<?>> actualClasses = XMLCodecUtils.objectsToClasses(actualArgs);
        ArrayList<Object> key = new ArrayList<Object>(3);
        key.add(clazz);
        key.add(name);
        key.add(actualClasses);
        CacheResult<Method> cacheRes = cache.check(key);
        if (cacheRes.getState() == CacheResult.State.VALID) {
            return cacheRes.getRes();
        }
        Method res = XMLCodecUtils.findMethod(clazz, name, actualClasses);
        cache.put(key, res);
        return res;
    }

    private static final Constructor getCtor(Class<?> clazz, List<Object> actualArgs) {
        List<Class<?>> actualClasses = XMLCodecUtils.objectsToClasses(actualArgs);
        ArrayList<Object> key = new ArrayList<Object>(3);
        key.add(clazz);
        key.add(actualClasses);
        CacheResult<Constructor<?>> cacheRes = cacheCtor.check(key);
        if (cacheRes.getState() == CacheResult.State.VALID) {
            return cacheRes.getRes();
        }
        Constructor res = XMLCodecUtils.findCtor(clazz, actualClasses);
        cacheCtor.put(key, res);
        return res;
    }

    private static final List<Class<?>> objectsToClasses(List<Object> actualArgs) {
        ArrayList actualClasses = new ArrayList(actualArgs.size());
        for (Object actualArg : actualArgs) {
            actualClasses.add(actualArg == null ? null : actualArg.getClass());
        }
        return actualClasses;
    }

    private static final Method findMethod(Class<?> clazz, String name, List<Class<?>> actualArgs) {
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(name) && XMLCodecUtils.callableWith(m.getParameterTypes(), actualArgs)) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    private static final Constructor findCtor(Class<?> clazz, List<Class<?>> actualArgs) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> m = constructorArray[n2];
            if (XMLCodecUtils.callableWith(m.getParameterTypes(), actualArgs)) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    private static final boolean callableWith(Class<?>[] formalArgs, List<Class<?>> actualArgs) {
        if (formalArgs.length != actualArgs.size()) {
            return false;
        }
        int i = 0;
        Class<?>[] classArray = formalArgs;
        int n = formalArgs.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> argClass = classArray[n2];
            Class<?> actualArg = actualArgs.get(i);
            if (actualArg != null && !argClass.isAssignableFrom(actualArg) && argClass != XMLCodecUtils.getPrimitive(actualArg)) {
                return false;
            }
            ++i;
            ++n2;
        }
        return true;
    }

    private static Class<?> getPrimitive(Class<?> argClass) {
        if (argClass == Boolean.class) {
            return Boolean.TYPE;
        }
        if (argClass == Character.class) {
            return Character.TYPE;
        }
        if (argClass == Byte.class) {
            return Byte.TYPE;
        }
        if (argClass == Short.class) {
            return Short.TYPE;
        }
        if (argClass == Integer.class) {
            return Integer.TYPE;
        }
        if (argClass == Long.class) {
            return Long.TYPE;
        }
        if (argClass == Float.class) {
            return Float.TYPE;
        }
        if (argClass == Double.class) {
            return Double.TYPE;
        }
        return null;
    }

    private static Class<?> parseClassName(String className) throws ClassNotFoundException {
        Class primitive = primitiveNames.get(className);
        if (primitive != null) {
            return primitive;
        }
        return Class.forName(className);
    }

    private XMLCodecUtils() {
    }
}

