/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.text;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public final class DocumentFilterList
extends DocumentFilter {
    private final List<DocumentFilter> filters = new ArrayList<DocumentFilter>();

    public static void add(AbstractDocument doc, DocumentFilter df) {
        DocumentFilterList.add(doc, df, FilterType.ARBITRARY_CHANGE);
    }

    public static void add(AbstractDocument doc, DocumentFilter df, FilterType t) {
        if (df == null) {
            return;
        }
        if (t == FilterType.SIMPLE_FILTER) {
            DocumentFilterList.get(doc).getFilters().add(0, df);
        } else {
            DocumentFilterList.get(doc).getFilters().add(df);
        }
    }

    public static void remove(AbstractDocument doc, DocumentFilter df) {
        if (df == null) {
            return;
        }
        DocumentFilter filter = doc.getDocumentFilter();
        if (filter == null) {
            return;
        }
        if (filter.equals(df)) {
            doc.setDocumentFilter(null);
        } else if (filter instanceof DocumentFilterList) {
            ((DocumentFilterList)filter).getFilters().remove(df);
        }
    }

    public static DocumentFilterList get(AbstractDocument doc) {
        DocumentFilterList res;
        DocumentFilter currentFilter = doc.getDocumentFilter();
        if (currentFilter instanceof DocumentFilterList) {
            res = (DocumentFilterList)currentFilter;
        } else {
            res = currentFilter == null ? new DocumentFilterList() : new DocumentFilterList(currentFilter);
            doc.setDocumentFilter(res);
        }
        return res;
    }

    public DocumentFilterList() {
    }

    public DocumentFilterList(DocumentFilter filter) {
        this();
        this.getFilters().add(filter);
    }

    public List<DocumentFilter> getFilters() {
        return this.filters;
    }

    DocumentFilter getNext(DocumentFilter filter) {
        int nextIndex = this.filters.indexOf(filter) + 1;
        if (nextIndex >= this.filters.size()) {
            return null;
        }
        return this.filters.get(nextIndex);
    }

    private ChainedFilterBypass createInitial(DocumentFilter.FilterBypass fb) {
        return new ChainedFilterBypass(this, null, fb);
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        this.createInitial(fb).insertString(offset, string, attr);
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        this.createInitial(fb).remove(offset, length);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        this.createInitial(fb).replace(offset, length, text, attrs);
    }

    private static final class ChainedFilterBypass
    extends DocumentFilter.FilterBypass {
        private final DocumentFilterList parent;
        private final DocumentFilter.FilterBypass orig;
        private final DocumentFilter nextFilter;
        private final DocumentFilter.FilterBypass next;

        public ChainedFilterBypass(DocumentFilterList parent, DocumentFilter filter, DocumentFilter.FilterBypass orig) {
            this.parent = parent;
            this.orig = orig;
            this.nextFilter = this.parent.getNext(filter);
            this.next = this.nextFilter == null ? orig : new ChainedFilterBypass(parent, this.nextFilter, orig);
        }

        @Override
        public Document getDocument() {
            return this.orig.getDocument();
        }

        @Override
        public void insertString(int offset, String string, AttributeSet attr) throws BadLocationException {
            if (this.nextFilter == null) {
                this.orig.insertString(offset, string, attr);
            } else {
                this.nextFilter.insertString(this.next, offset, string, attr);
            }
        }

        @Override
        public void remove(int offset, int length) throws BadLocationException {
            if (this.nextFilter == null) {
                this.orig.remove(offset, length);
            } else {
                this.nextFilter.remove(this.next, offset, length);
            }
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (this.nextFilter == null) {
                String str = this.orig.getDocument().getText(offset, length);
                if (!str.equals(text)) {
                    this.orig.replace(offset, length, text, attrs);
                }
            } else {
                this.nextFilter.replace(this.next, offset, length, text, attrs);
            }
        }
    }

    public static enum FilterType {
        SIMPLE_FILTER,
        ARBITRARY_CHANGE;

    }
}

