/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ReflectUtils {
    private static Map<Type, Type> resolveTypes(Class<?> c, Class<?> raw) {
        HashMap<Type, Type> res = new HashMap<Type, Type>();
        if (!raw.isAssignableFrom(c)) {
            return res;
        }
        ArrayList<Type> types = new ArrayList<Type>(Arrays.asList(c.getGenericInterfaces()));
        types.add(c.getGenericSuperclass());
        for (Type t : types) {
            Class<?> tc;
            ParameterizedType pt;
            if (t instanceof ParameterizedType && raw.isAssignableFrom((Class)(pt = (ParameterizedType)t).getRawType())) {
                Class rawType = (Class)pt.getRawType();
                Type[] actualTypeArguments = pt.getActualTypeArguments();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                int i = 0;
                while (i < actualTypeArguments.length) {
                    res.put(typeParameters[i], actualTypeArguments[i]);
                    ++i;
                }
            }
            if ((tc = ReflectUtils.getClass(t)) == null) continue;
            res.putAll(ReflectUtils.resolveTypes(tc, raw));
        }
        return res;
    }

    public static <T> Map<TypeVariable<Class<T>>, Class<?>> getTypeArgumentsMap(Class<? extends T> childClass, Class<T> baseClass) {
        TypeVariable<Class<T>>[] actualTypeArguments = baseClass.getTypeParameters();
        if (actualTypeArguments.length == 0) {
            throw new IllegalArgumentException(baseClass + " is not generic");
        }
        LinkedHashMap res = new LinkedHashMap();
        Map<Type, Type> resolvedTypes = ReflectUtils.resolveTypes(childClass, baseClass);
        TypeVariable<Class<T>>[] typeVariableArray = actualTypeArguments;
        int n = actualTypeArguments.length;
        int n2 = 0;
        while (n2 < n) {
            TypeVariable<Class<T>> baseType;
            Type currentType = baseType = typeVariableArray[n2];
            while (resolvedTypes.containsKey(currentType)) {
                currentType = resolvedTypes.get(currentType);
            }
            res.put(baseType, ReflectUtils.getClass(currentType));
            ++n2;
        }
        return res;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<? extends T> childClass, Class<T> baseClass) {
        ArrayList res = new ArrayList();
        for (Class<?> c : ReflectUtils.getTypeArgumentsMap(childClass, baseClass).values()) {
            if (c == null) continue;
            res.add(c);
        }
        return res;
    }

    public static <U> List<Class<?>> getTypeArguments(U o, Class<U> raw) {
        return ReflectUtils.getTypeArguments(o.getClass().asSubclass(raw), raw);
    }

    private static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ReflectUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }
}

