/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CompareUtils {
    private static final Comparator<Comparable<Object>> NATURAL_COMPARATOR = new Comparator<Comparable<Object>>(){

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            return o1.compareTo(o2);
        }
    };
    public static final Equalizer<Object> OBJECT_EQ = new Equalizer<Object>(){};

    public static final int compareInt(int int1, int int2) {
        if (int1 < int2) {
            return -1;
        }
        if (int1 == int2) {
            return 0;
        }
        return 1;
    }

    public static final int compareLong(long int1, long int2) {
        if (int1 < int2) {
            return -1;
        }
        if (int1 == int2) {
            return 0;
        }
        return 1;
    }

    public static final <T extends Comparable<? super T>> Comparator<T> naturalOrder() {
        return NATURAL_COMPARATOR;
    }

    public static final <T> Comparator<T> createComparator(final List<? extends Comparator<T>> comparators) {
        return new Comparator<T>(){

            public String toString() {
                return "CompareUtils comparator with " + comparators;
            }

            @Override
            public int compare(T o1, T o2) {
                int result = 0;
                int i = 0;
                while (i < comparators.size() && result == 0) {
                    Comparator transf = (Comparator)comparators.get(i);
                    result = transf.compare(o1, o2);
                    ++i;
                }
                return result;
            }
        };
    }

    public static final boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static final boolean equalsUsingIterator(Collection<?> c1, Collection<?> c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        int size = c1.size();
        if (size != c2.size()) {
            return false;
        }
        if (size == 0) {
            return true;
        }
        Iterator<?> iter1 = c1.iterator();
        Iterator<?> iter2 = c2.iterator();
        while (iter1.hasNext()) {
            Object o2;
            Object o1 = iter1.next();
            if (CompareUtils.equals(o1, o2 = iter2.next())) continue;
            return false;
        }
        assert (!iter1.hasNext() && !iter2.hasNext());
        return true;
    }

    public static interface Equalizer<T> {
    }
}

