/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.openconcerto.ui.Log;
import org.openconcerto.ui.TM;

public abstract class AbstractProps {
    private final Properties props = new Properties();
    private final PropertyChangeSupport propSupp = new PropertyChangeSupport(this);

    protected AbstractProps() {
        this.load();
    }

    public final void addListener(String name, PropertyChangeListener l) {
        this.propSupp.addPropertyChangeListener(name, l);
    }

    protected abstract String getPropsFileName();

    public String getPropertySuffix() {
        return "";
    }

    public final String getProperty(String name) {
        String key = String.valueOf(name) + this.getPropertySuffix();
        String property = this.props.getProperty(key);
        return property;
    }

    public void load() {
        block13: {
            File file = new File(this.getPropsFileName());
            Log.get().config("Loading properties from " + file.getAbsolutePath() + " for " + this);
            if (!file.exists()) {
                Log.get().info(String.valueOf(file.getAbsolutePath()) + " does not exist for " + this);
                return;
            }
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    bufferedInputStream = new BufferedInputStream(fileInputStream);
                    this.props.load(bufferedInputStream);
                    this.propSupp.firePropertyChange(null, null, null);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, TM.tr("abstractProps.cannotRead", file.getAbsolutePath()));
                    e.printStackTrace();
                    if (bufferedInputStream == null) break block13;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

