/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.LayoutHints;
import org.openconcerto.utils.Tuple2;

public class Group
extends Item {
    private static final Comparator<Tuple2<Item, Integer>> COMPARATOR = new Comparator<Tuple2<Item, Integer>>(){

        @Override
        public int compare(Tuple2<Item, Integer> o1, Tuple2<Item, Integer> o2) {
            int c = o1.get1().compareTo(o2.get1());
            if (c == 0) {
                c = o1.get0().getId().compareTo(o2.get0().getId());
            }
            return c;
        }
    };
    private int order = 100;
    private final List<Tuple2<Item, Integer>> list = new ArrayList<Tuple2<Item, Integer>>();

    public Group(String id) {
        this(id, LayoutHints.DEFAULT_GROUP_HINTS);
    }

    public Group(String id, LayoutHints hint) {
        super(id, hint);
    }

    public Item addItem(String string) {
        Item res = new Item(string);
        this.add(res);
        return res;
    }

    public Item addItem(String string, LayoutHints hint) {
        Item res = new Item(string, hint);
        this.add(res);
        return res;
    }

    public void add(Item item) {
        this.add(item, this.order);
    }

    public void add(Item item, int order) {
        this.checkFrozen("add");
        item.setParent(this);
        this.list.add(new Tuple2<Item, Integer>(item, order));
        Collections.sort(this.list, COMPARATOR);
        if (this.order <= order) {
            this.order = order / 100 * 100 + 100;
        }
    }
}

