/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.PartialUniqueTrigger;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.ReflectUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.cc.ITransformer;

public abstract class ChangeTable<T extends ChangeTable<T>> {
    protected static final String[] TRIGGER_EVENTS = new String[]{"INSERT", "UPDATE"};
    public static final Pattern H2_UNIQUE_TRIGGER_PATTERN = Pattern.compile("\\snew " + PartialUniqueTrigger.class.getName() + "\\(\\s*java.util.Arrays.asList\\((.+)\\)\\s*,(.+)\\)");
    public static final Pattern H2_LIST_PATTERN = Pattern.compile("\\s*,\\s*");
    public static final String MYSQL_TRIGGER_SUFFIX_1 = ChangeTable.getTriggerSuffix(TRIGGER_EVENTS[0]);
    public static final String MYSQL_TRIGGER_SUFFIX_2 = ChangeTable.getTriggerSuffix(TRIGGER_EVENTS[1]);
    public static final String MYSQL_TRIGGER_EXCEPTION = "call " + SQLBase.quoteIdentifier("Unique constraint violation");
    public static final Pattern MYSQL_UNIQUE_TRIGGER_PATTERN = Pattern.compile("IF\\s*\\(\\s*" + Pattern.quote("SELECT COUNT(*)") + "\\s+FROM\\s+(.+)\\s+where\\s+(.+)\\)\\s*>\\s*1\\s+then\\s+" + Pattern.quote(MYSQL_TRIGGER_EXCEPTION), 2);
    public static final Pattern MYSQL_WHERE_PATTERN = Pattern.compile("\\s+and\\s+", 2);
    public static final Pattern MYSQL_WHERE_EQ_PATTERN = Pattern.compile("(NEW.)?(.+)\\s*=\\s*(NEW.)?\\2");
    public static final Set<ClauseType> ORDERED_TYPES;
    private String rootName;
    private String name;
    private final SQLSyntax syntax;
    private final List<FCSpec> fks;
    private final ListMap<ClauseType, String> clauses;
    private final ListMap<ClauseType, DeferredClause> inClauses;
    private final ListMap<ClauseType, DeferredClause> outClauses;

    static {
        LinkedHashSet<ClauseType> tmp = new LinkedHashSet<ClauseType>(ClauseType.values().length);
        ConcatStep[] concatStepArray = ConcatStep.values();
        int n = concatStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConcatStep step = concatStepArray[n2];
            tmp.addAll(step.getTypes());
            ++n2;
        }
        assert (tmp.equals(EnumSet.allOf(ClauseType.class))) : "ConcatStep is missing some types : " + tmp;
        ORDERED_TYPES = Collections.unmodifiableSet(tmp);
    }

    public static final String getIndexName(String triggerName, SQLSystem system) {
        if (system == SQLSystem.MYSQL && triggerName.endsWith(MYSQL_TRIGGER_SUFFIX_1)) {
            return triggerName.substring(0, triggerName.length() - MYSQL_TRIGGER_SUFFIX_1.length());
        }
        if (system == SQLSystem.H2 && triggerName.endsWith("_trigger")) {
            return triggerName.substring(0, triggerName.length() - "_trigger".length());
        }
        return null;
    }

    private static String getTriggerSuffix(String event) {
        return String.valueOf(event == null ? "" : String.valueOf('_') + event.toLowerCase()) + "_trigger";
    }

    public static List<String> cat(List<? extends ChangeTable<?>> cts, String r) {
        return ChangeTable.cat(cts, new ChangeRootNameTransformer(r));
    }

    public static List<String> cat(List<? extends ChangeTable<?>> cts) {
        return ChangeTable.cat(cts, NameTransformer.NOP);
    }

    public static List<String> cat(List<? extends ChangeTable<?>> cts, NameTransformer transf) {
        return ChangeTable.cat(cts, transf, false);
    }

    public static List<List<String>> cat(Collection<? extends ChangeTable<?>> cts, String r, EnumSet<ConcatStep> boundaries) {
        if (r == null) {
            throw new NullPointerException("r is null");
        }
        return ChangeTable.cat(cts, (NameTransformer)new ChangeRootNameTransformer(r), boundaries);
    }

    public static List<List<String>> cat(Collection<? extends ChangeTable<?>> cts, NameTransformer transf, EnumSet<ConcatStep> boundaries) {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        ArrayList<String> current = null;
        ConcatStep[] concatStepArray = ConcatStep.values();
        int n = concatStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConcatStep step = concatStepArray[n2];
            if (current == null || boundaries.contains((Object)step)) {
                current = new ArrayList<String>();
                res.add(current);
            }
            for (ChangeTable<?> ct : cts) {
                String asString = ct.asString(transf, step);
                if (asString == null || asString.length() <= 0) continue;
                current.add(asString);
            }
            ++n2;
        }
        assert (res.size() == boundaries.size() + 1);
        return res;
    }

    private static List<String> cat(List<? extends ChangeTable<?>> cts, NameTransformer transf, boolean forceCat) {
        List<String> res = ChangeTable.cat(cts, transf, EnumSet.noneOf(ConcatStep.class)).get(0);
        if (!(forceCat || cts.size() != 0 && cts.get(0).getSyntax().getSystem() != SQLSystem.MYSQL)) {
            return res;
        }
        return Collections.singletonList(CollectionUtils.join(res, "\n"));
    }

    public ChangeTable(SQLSyntax syntax, String rootName, String name) {
        this.syntax = syntax;
        this.rootName = rootName;
        this.name = name;
        this.fks = new ArrayList<FCSpec>();
        this.clauses = new ListMap();
        this.inClauses = new ListMap();
        this.outClauses = new ListMap();
        if (this.getClass() != ReflectUtils.getTypeArguments(this, ChangeTable.class).get(0)) {
            throw new IllegalStateException("illegal subclass: " + this.getClass());
        }
    }

    protected final T thisAsT() {
        return (T)this;
    }

    public final SQLSyntax getSyntax() {
        return this.syntax;
    }

    public void reset() {
        this.fks.clear();
        this.clauses.clear();
        this.inClauses.clear();
        this.outClauses.clear();
    }

    public boolean isEmpty() {
        return this.fks.isEmpty() && this.clauses.isEmpty() && this.inClauses.isEmpty() && this.outClauses.isEmpty();
    }

    protected T mutateTo(ChangeTable<?> ct) {
        if (this.getSyntax() != ct.getSyntax()) {
            throw new IllegalArgumentException("not same syntax: " + this.getSyntax() + " != " + ct.getSyntax());
        }
        this.setName(ct.getName());
        for (Map.Entry e : ct.clauses.entrySet()) {
            for (String s : (Collection)e.getValue()) {
                this.addClause(s, (ClauseType)((Object)e.getKey()));
            }
        }
        for (DeferredClause c : ct.inClauses.allValues()) {
            this.addClause(c);
        }
        for (DeferredClause c : ct.outClauses.allValues()) {
            this.addOutsideClause(c);
        }
        for (FCSpec fk : ct.fks) {
            this.addForeignConstraint(fk, false);
        }
        return this.thisAsT();
    }

    public final T addVarCharColumn(String name, int count) {
        return this.addVarCharColumn(name, count, false);
    }

    public final T addVarCharColumn(String name, int count, boolean lenient) throws IllegalArgumentException {
        int max = this.getSyntax().getMaximumVarCharLength();
        if (count > max) {
            if (lenient) {
                Log.get().fine("Truncated " + name + " from " + count + " to " + max);
                count = max;
            } else {
                throw new IllegalArgumentException("Count too high : " + count + " > " + max);
            }
        }
        return this.addColumn(name, "varchar(" + count + ") default '' NOT NULL");
    }

    public final T addDateAndTimeColumn(String name) {
        return this.addColumn(name, this.getSyntax().getDateAndTimeType());
    }

    public final T addIntegerColumn(String name, int defaultVal) {
        return this.addIntegerColumn(name, defaultVal, false);
    }

    public final T addIntegerColumn(String name, Integer defaultVal, boolean nullable) {
        return this.addNumberColumn(name, Integer.class, defaultVal, nullable);
    }

    public final T addLongColumn(String name, Long defaultVal, boolean nullable) {
        return this.addNumberColumn(name, Long.class, defaultVal, nullable);
    }

    public final <N extends Number> T addNumberColumn(String name, Class<N> javaType, N defaultVal, boolean nullable) {
        Collection<String> typeNames = this.getSyntax().getTypeNames(javaType);
        if (typeNames.size() == 0) {
            throw new IllegalArgumentException(javaType + " isn't supported by " + this.getSyntax());
        }
        return this.addColumn(name, typeNames.iterator().next(), this.getNumberDefault(defaultVal), nullable);
    }

    final String getNumberDefault(Number defaultVal) {
        return defaultVal == null ? null : defaultVal.toString();
    }

    public final T addDecimalColumn(String name, int precision, int scale, BigDecimal defaultVal, boolean nullable) {
        return this.addColumn(name, this.getSyntax().getDecimal(precision, scale), this.getNumberDefault(defaultVal), nullable);
    }

    public final T addBooleanColumn(String name, Boolean defaultVal, boolean nullable) {
        return this.addColumn(name, this.getSyntax().getBooleanType(), SQLType.getBoolean(this.getSyntax()).toString(defaultVal), nullable);
    }

    public final T addColumn(String name, String sqlType, String defaultVal, boolean nullable) {
        return this.addColumn(name, this.getSyntax().getFieldDecl(sqlType, defaultVal, nullable));
    }

    public abstract T addColumn(String var1, String var2);

    public final T addForeignConstraint(List<String> fieldName, SQLName refTable, boolean createIndex, List<String> refCols) {
        return this.addForeignConstraint(new FCSpec(fieldName, refTable, refCols, null, null), createIndex);
    }

    public final T addForeignConstraint(final FCSpec fkSpec, boolean createIndex) {
        this.fks.add(fkSpec);
        if (createIndex) {
            this.addOutsideClause(new OutsideClause(){

                @Override
                public ClauseType getType() {
                    return ClauseType.ADD_INDEX;
                }

                @Override
                public String asString(SQLName tableName) {
                    return ChangeTable.this.getSyntax().getCreateIndex("_fki", tableName, fkSpec.getCols());
                }
            });
        }
        return this.thisAsT();
    }

    public final List<FCSpec> getForeignConstraints() {
        return Collections.unmodifiableList(this.fks);
    }

    public T addForeignColumn(SQLCreateTableBase<?> createTable) {
        return this.addForeignColumn(ForeignColSpec.fromCreateTable(createTable));
    }

    public T addForeignColumn(String fk, SQLCreateTableBase<?> createTable) {
        return this.addForeignColumn(ForeignColSpec.fromCreateTable(createTable).setColumnName(fk));
    }

    public T addForeignColumn(String fk, SQLName table, String pk, String defaultVal) {
        return this.addForeignColumn(new ForeignColSpec(fk, table, pk, defaultVal));
    }

    public T addForeignColumn(ForeignColSpec spec) {
        return this.addForeignColumn(spec, null, null);
    }

    public T addForeignColumn(ForeignColSpec spec, Link.Rule updateRule, Link.Rule deleteRule) {
        this.addColumn(spec.getColumnName(), String.valueOf(this.getSyntax().getIDType()) + " DEFAULT " + spec.getDefaultVal());
        return this.addForeignConstraint(spec.createFCSpec(updateRule, deleteRule), true);
    }

    public T addForeignColumn(String fk, SQLTable foreignTable) {
        return this.addForeignColumn(fk, foreignTable, true);
    }

    public T addForeignColumn(String fk, SQLTable foreignTable, boolean absolute) {
        return this.addForeignColumn(ForeignColSpec.fromTable(foreignTable, absolute).setColumnName(fk));
    }

    public T addUniqueConstraint(String name, List<String> cols) {
        return this.addUniqueConstraint(name, cols, null);
    }

    public T addUniqueConstraint(final String name, final List<String> cols, final String where) {
        int size = cols.size();
        if (size == 0) {
            throw new IllegalArgumentException("No cols");
        }
        SQLSystem system = this.getSyntax().getSystem();
        if (system == SQLSystem.MSSQL) {
            return this.addOutsideClause(this.createUniquePartialIndex(name, cols, where));
        }
        if (where == null) {
            return this.addClause(new DeferredClause(){

                @Override
                public String asString(ChangeTable<?> ct, SQLName tableName) {
                    return String.valueOf(ct.getConstraintPrefix()) + "CONSTRAINT " + ChangeTable.getQuotedConstraintName(tableName, name) + " UNIQUE (" + SQLSyntax.quoteIdentifiers(cols) + ")";
                }

                @Override
                public ClauseType getType() {
                    return ClauseType.ADD_CONSTRAINT;
                }
            });
        }
        if (system == SQLSystem.POSTGRESQL) {
            return this.addOutsideClause(this.createUniquePartialIndex(name, cols, where));
        }
        if (system == SQLSystem.H2) {
            if (this instanceof AlterTable) {
                this.addOutsideClause(new DeferredClause(){

                    @Override
                    public ClauseType getType() {
                        return ClauseType.OTHER;
                    }

                    @Override
                    public String asString(ChangeTable<?> ct, SQLName tableName) {
                        String select = ChangeTable.this.getInitialCheckSelect(cols, where, tableName);
                        return "SELECT CASE WHEN (" + select + ") > 0 then CSVREAD('Unique constraint violation') else 'OK' end case;";
                    }
                });
            }
            String javaWhere = StringUtils.doubleQuote(where);
            String javaCols = "java.util.Arrays.asList(" + CollectionUtils.join(cols, ", ", new ITransformer<String, String>(){

                public String transformChecked(String col) {
                    return StringUtils.doubleQuote(col);
                }
            }) + ")";
            final String body = "AS $$ org.h2.api.Trigger create(){ return new " + PartialUniqueTrigger.class.getName() + "(" + javaCols + ", " + javaWhere + "); } $$";
            assert (H2_UNIQUE_TRIGGER_PATTERN.matcher(body).find());
            return this.addOutsideClause(new UniqueTrigger(name, Arrays.asList(TRIGGER_EVENTS)){

                @Override
                protected String getBody(SQLName tableName) {
                    return body;
                }
            });
        }
        if (system == SQLSystem.MYSQL) {
            if (this instanceof AlterTable) {
                this.addOutsideClause(new DeferredClause(){

                    @Override
                    public ClauseType getType() {
                        return ClauseType.OTHER;
                    }

                    @Override
                    public String asString(ChangeTable<?> ct, SQLName tableName) {
                        String procName = SQLBase.quoteIdentifier("checkUniqueness_" + tableName.getName());
                        String res = "DROP PROCEDURE IF EXISTS " + procName + ";\n";
                        res = String.valueOf(res) + "CREATE PROCEDURE " + procName + "() BEGIN\n";
                        String select = ChangeTable.this.getInitialCheckSelect(cols, where, tableName);
                        res = String.valueOf(res) + "IF (" + select + ") > 0 THEN " + MYSQL_TRIGGER_EXCEPTION + "; END IF; \n";
                        res = String.valueOf(res) + "END;\n";
                        res = String.valueOf(res) + "CALL " + procName + ";";
                        return res;
                    }
                });
            }
            final UniqueTrigger trigger = new UniqueTrigger(name, Arrays.asList(TRIGGER_EVENTS[0])){

                @Override
                protected String getBody(SQLName tableName) {
                    String body = "BEGIN IF " + ChangeTable.getNotNullWhere(cols, "NEW.") + " THEN\n" + "IF ( SELECT COUNT(*) from " + tableName + " where " + where + " and " + CollectionUtils.join(cols, " and ", new ITransformer<String, String>(){

                        public String transformChecked(String col) {
                            return String.valueOf(SQLBase.quoteIdentifier(col)) + " = NEW." + SQLBase.quoteIdentifier(col);
                        }
                    }) + ") > 1 then\n" + MYSQL_TRIGGER_EXCEPTION + "; END IF; \n" + "END IF; \n" + "END";
                    return body;
                }
            };
            this.addOutsideClause(trigger);
            int i = 1;
            while (i < TRIGGER_EVENTS.length) {
                this.addOutsideClause(new UniqueTrigger(name, Arrays.asList(TRIGGER_EVENTS[i])){

                    @Override
                    protected String getBody(SQLName tableName) {
                        return trigger.getBody(tableName);
                    }
                });
                ++i;
            }
            return this.thisAsT();
        }
        throw new UnsupportedOperationException("System isn't supported : " + (Object)((Object)system));
    }

    protected final DeferredClause createUniquePartialIndex(String name, List<String> cols, String userWhere) {
        Where notNullWhere = this.getSyntax().getSystem() == SQLSystem.MSSQL ? Where.createRaw(ChangeTable.getNotNullWhere(cols), new FieldRef[0]) : null;
        Where w = Where.and(notNullWhere, Where.createRaw(userWhere, new FieldRef[0]));
        return this.getSyntax().getCreateIndex(new SQLTable.SQLIndex(name, cols, true, true, w.toString()));
    }

    private static String getNotNullWhere(List<String> cols) {
        return ChangeTable.getNotNullWhere(cols, "");
    }

    private static String getNotNullWhere(List<String> cols, final String prefix) {
        return CollectionUtils.join(cols, " and ", new ITransformer<String, String>(){

            public String transformChecked(String col) {
                return String.valueOf(prefix) + SQLBase.quoteIdentifier(col) + " IS NOT NULL";
            }
        });
    }

    private String getInitialCheckSelect(List<String> cols, String where, SQLName tableName) {
        Where notNullWhere = Where.createRaw(ChangeTable.getNotNullWhere(cols), new FieldRef[0]);
        Where w = Where.and(notNullWhere, Where.createRaw(where, new FieldRef[0]));
        return "SELECT count(*) FROM " + tableName + " where " + w + " group by " + SQLSyntax.quoteIdentifiers(cols) + " having count(*)>1";
    }

    protected static final String getQuotedConstraintName(SQLName tableName, String name) {
        return SQLBase.quoteIdentifier(ChangeTable.getIndexName(tableName, name));
    }

    protected static final String getIndexName(SQLName tableName, String name) {
        return SQLSyntax.getSchemaUniqueName(tableName.getName(), name);
    }

    private static SQLName getTriggerName(SQLName tableName, String indexName, String event) {
        return new SQLName(tableName.getItem(-2), SQLSyntax.getSchemaUniqueName(tableName.getName(), String.valueOf(indexName) + ChangeTable.getTriggerSuffix(event)));
    }

    protected abstract String getConstraintPrefix();

    public final T addClause(String s, ClauseType type) {
        this.clauses.add(type, s);
        return this.thisAsT();
    }

    protected final List<String> getClauses(SQLName tableName, ClauseType type) {
        if (this.inClauses.size() == 0) {
            return (List)this.clauses.getNonNull(type);
        }
        ArrayList<String> res = new ArrayList<String>((Collection<String>)this.clauses.getNonNull(type));
        for (DeferredClause c : (List)this.inClauses.getNonNull(type)) {
            res.add(c.asString(this, tableName));
        }
        return res;
    }

    protected final List<String> getClauses(SQLName tableName, Collection<ClauseType> types) {
        ArrayList<String> res = new ArrayList<String>();
        for (ClauseType type : types) {
            res.addAll(this.getClauses(tableName, type));
        }
        return res;
    }

    public final T addClause(DeferredClause s) {
        this.inClauses.add(s.getType(), s);
        return this.thisAsT();
    }

    public final T addOutsideClause(DeferredClause s) {
        if (s != null) {
            this.outClauses.add(s.getType(), s);
        }
        return this.thisAsT();
    }

    protected final void outClausesAsString(StringBuffer res, final SQLName tableName, Set<ClauseType> types) {
        ArrayList<DeferredClause> clauses = new ArrayList<DeferredClause>();
        for (ClauseType type : types) {
            clauses.addAll((Collection<DeferredClause>)this.outClauses.getNonNull(type));
        }
        this.modifyOutClauses(clauses);
        if (clauses.size() > 0) {
            res.append("\n\n");
            res.append(CollectionUtils.join(clauses, "\n", new ITransformer<DeferredClause, String>(){

                public String transformChecked(DeferredClause input) {
                    return input.asString(ChangeTable.this, tableName);
                }
            }));
        }
    }

    protected void modifyOutClauses(List<DeferredClause> clauses) {
    }

    public final String asString() {
        return this.asString(NameTransformer.NOP);
    }

    public final String asString(String rootName) {
        return this.asString(new ChangeRootNameTransformer(rootName));
    }

    public abstract String asString(NameTransformer var1);

    protected abstract String asString(NameTransformer var1, ConcatStep var2);

    protected final List<String> getForeignConstraints(NameTransformer transf) {
        ArrayList<String> res = new ArrayList<String>(this.fks.size());
        for (FCSpec fk : this.fks) {
            SQLName relRefTable = fk.getRefTable();
            SQLName refTable = transf.transformLinkDestTableName(this.getRootName(), this.getName(), relRefTable);
            res.add(String.valueOf(this.getConstraintPrefix()) + this.getSyntax().getFK(String.valueOf(this.name) + "_", fk.getCols(), refTable, fk.getRefCols(), fk.getUpdateRule(), fk.getDeleteRule()));
        }
        return res;
    }

    public String toString() {
        return this.asString();
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getRootName() {
        return this.rootName;
    }

    public static class ChangeRootNameTransformer
    extends NameTransformer {
        private final String r;

        public ChangeRootNameTransformer(String r) {
            this.r = r;
        }

        @Override
        public SQLName transformTableName(SQLName tableName) {
            return new SQLName(this.r, tableName.getName());
        }

        @Override
        public SQLName transformLinkDestTableName(String rootName, String tableName, SQLName linkDest) {
            return linkDest.getItemCount() == 1 ? this.transformTableName(new SQLName(rootName, linkDest.getName())) : linkDest;
        }
    }

    public static enum ClauseType {
        ADD_COL,
        ADD_CONSTRAINT,
        ADD_INDEX,
        DROP_COL,
        DROP_CONSTRAINT,
        DROP_INDEX,
        ALTER_COL,
        OTHER;

    }

    public static enum ConcatStep {
        DROP_FOREIGN(ClauseType.DROP_CONSTRAINT),
        DROP_INDEX(ClauseType.DROP_INDEX),
        ALTER_TABLE(ClauseType.ADD_COL, ClauseType.DROP_COL, ClauseType.ALTER_COL, ClauseType.OTHER),
        ADD_INDEX(ClauseType.ADD_INDEX),
        ADD_FOREIGN(ClauseType.ADD_CONSTRAINT);

        private final Set<ClauseType> types = new HashSet<ClauseType>();

        private ConcatStep(ClauseType ... types) {
            ClauseType[] clauseTypeArray = types;
            int n2 = types.length;
            int n3 = 0;
            while (n3 < n2) {
                ClauseType t = clauseTypeArray[n3];
                this.types.add(t);
                ++n3;
            }
        }

        public final Set<ClauseType> getTypes() {
            return this.types;
        }
    }

    public static interface DeferredClause {
        public String asString(ChangeTable<?> var1, SQLName var2);

        public ClauseType getType();
    }

    public static final class FCSpec {
        private final List<String> cols;
        private final SQLName refTable;
        private final List<String> refCols;
        private final Link.Rule updateRule;
        private final Link.Rule deleteRule;

        public FCSpec(List<String> cols, SQLName refTable, List<String> refCols, Link.Rule updateRule, Link.Rule deleteRule) {
            if (refTable.getItemCount() == 0) {
                throw new IllegalArgumentException(refTable + " is empty.");
            }
            this.cols = Collections.unmodifiableList(new ArrayList<String>(cols));
            this.refTable = refTable;
            this.refCols = Collections.unmodifiableList(new ArrayList<String>(refCols));
            this.updateRule = updateRule;
            this.deleteRule = deleteRule;
        }

        public final List<String> getCols() {
            return this.cols;
        }

        public final SQLName getRefTable() {
            return this.refTable;
        }

        public final List<String> getRefCols() {
            return this.refCols;
        }

        public final Link.Rule getUpdateRule() {
            return this.updateRule;
        }

        public final Link.Rule getDeleteRule() {
            return this.deleteRule;
        }
    }

    public static final class ForeignColSpec {
        private String fk;
        private final SQLName table;
        private final String pk;
        private final String defaultVal;

        public static ForeignColSpec fromCreateTable(SQLCreateTableBase<?> createTable) {
            List<String> primaryKey = createTable.getPrimaryKey();
            if (primaryKey.size() != 1) {
                throw new IllegalArgumentException("Not exactly one field in the foreign primary key : " + primaryKey);
            }
            return new ForeignColSpec(null, new SQLName(createTable.getName()), primaryKey.get(0), null);
        }

        public static ForeignColSpec fromTable(SQLTable foreignTable) {
            return ForeignColSpec.fromTable(foreignTable, true);
        }

        public static ForeignColSpec fromTable(SQLTable foreignTable, boolean absolute) {
            if (foreignTable == null) {
                throw new NullPointerException("null table");
            }
            String defaultVal = foreignTable.getKey().getType().toString(foreignTable.getUndefinedIDNumber());
            SQLName n = absolute ? foreignTable.getSQLName() : new SQLName(foreignTable.getName());
            return new ForeignColSpec(null, n, foreignTable.getKey().getName(), defaultVal);
        }

        public ForeignColSpec(String fk, SQLName table, String pk, String defaultVal) {
            this.table = table;
            this.setColumnName(fk);
            this.pk = pk;
            this.defaultVal = defaultVal;
        }

        public final ForeignColSpec setColumnNameFromTable() {
            return this.setColumnNameWithSuffix("");
        }

        public final ForeignColSpec setColumnNameWithSuffix(String suffix) {
            return this.setColumnName("ID_" + this.getTable().getName() + (suffix.length() == 0 ? "" : "_" + suffix));
        }

        public final ForeignColSpec setColumnName(String fk) {
            if (fk == null) {
                this.setColumnNameFromTable();
            } else {
                this.fk = fk;
            }
            return this;
        }

        public final String getColumnName() {
            return this.fk;
        }

        public final SQLName getTable() {
            return this.table;
        }

        public final String getPrimaryKeyName() {
            return this.pk;
        }

        public final String getDefaultVal() {
            return this.defaultVal;
        }

        public final FCSpec createFCSpec(Link.Rule updateRule, Link.Rule deleteRule) {
            return new FCSpec(Collections.singletonList(this.getColumnName()), this.getTable(), Collections.singletonList(this.getPrimaryKeyName()), updateRule, deleteRule);
        }
    }

    public static class NameTransformer {
        public static final NameTransformer NOP = new NameTransformer();

        public SQLName transformTableName(SQLName tableName) {
            return tableName;
        }

        public SQLName transformLinkDestTableName(String rootName, String tableName, SQLName linkDest) {
            return this.transformTableName(linkDest.getItemCount() == 1 ? new SQLName(rootName, linkDest.getName()) : linkDest);
        }
    }

    public static abstract class OutsideClause
    implements DeferredClause {
        public abstract String asString(SQLName var1);

        @Override
        public String asString(ChangeTable<?> ct, SQLName tableName) {
            return this.asString(tableName);
        }
    }

    private static abstract class UniqueTrigger
    implements DeferredClause {
        private final String indexName;
        private final List<String> events;

        public UniqueTrigger(String indexName, List<String> events) {
            this.indexName = indexName;
            this.events = events;
        }

        @Override
        public final ClauseType getType() {
            return ClauseType.OTHER;
        }

        @Override
        public final String asString(ChangeTable<?> ct, SQLName tableName) {
            SQLName triggerName = ChangeTable.getTriggerName(tableName, this.indexName, CollectionUtils.getSole(this.events));
            return "CREATE TRIGGER " + triggerName + " AFTER " + CollectionUtils.join(this.events, ", ") + " on " + tableName + " FOR EACH ROW " + this.getBody(tableName) + ';';
        }

        protected abstract String getBody(SQLName var1);
    }
}

