/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.List;
import org.openconcerto.sql.FieldExpander;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.FilteredFillSQLRequest;

public class ListSQLRequest
extends FilteredFillSQLRequest {
    private final List<SQLField> listFields;
    private final FieldExpander showAs;

    protected ListSQLRequest(ListSQLRequest req, boolean freeze) {
        super(req, freeze);
        this.listFields = req.listFields;
        this.showAs = req.showAs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSQLRequest clone() {
        ListSQLRequest listSQLRequest = this;
        synchronized (listSQLRequest) {
            return this.clone(false);
        }
    }

    @Override
    protected ListSQLRequest clone(boolean forFreeze) {
        return new ListSQLRequest(this, forFreeze);
    }

    @Override
    protected FieldExpander getShowAs() {
        return this.showAs;
    }

    public final List<SQLField> getFields() {
        return this.listFields;
    }

    @Override
    protected void customizeToFetch(SQLRowValues graphToFetch) {
        super.customizeToFetch(graphToFetch);
        this.addField(graphToFetch, this.getPrimaryTable().getCreationDateField());
        this.addField(graphToFetch, this.getPrimaryTable().getCreationUserField());
        this.addField(graphToFetch, this.getPrimaryTable().getModifDateField());
        this.addField(graphToFetch, this.getPrimaryTable().getModifUserField());
        this.addField(graphToFetch, this.getPrimaryTable().getFieldRaw("UI_LOCK"));
        this.addField(graphToFetch, this.getPrimaryTable().getFieldRaw("ID_USER_UI_LOCK"));
    }

    private void addField(SQLRowValues graphToFetch, SQLField f) {
        if (f != null && !graphToFetch.getFields().contains(f.getName())) {
            if (f.isKey()) {
                graphToFetch.putRowValues(f.getName()).putNulls("NOM", "PRENOM");
            } else {
                graphToFetch.put(f.getName(), null);
            }
        }
    }
}

