/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.HashSet;
import java.util.Set;
import org.openconcerto.sql.model.SQLFilter;
import org.openconcerto.sql.model.SQLFilterListener;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.BaseFillSQLRequest;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Tuple2;

public abstract class FilteredFillSQLRequest
extends BaseFillSQLRequest {
    private Tuple2<Set<SQLRow>, Path> filterInfo;
    private final SQLFilter filter;
    private boolean filterEnabled = false;
    private final SQLFilterListener filterListener = new SQLFilterListener(){};

    protected FilteredFillSQLRequest(FilteredFillSQLRequest req, boolean freeze) {
        super(req);
        assert (Thread.holdsLock(req));
        this.filter = req.filter;
        this.filterInfo = req.filterInfo;
        if (freeze) {
            this.filterEnabled = req.filterEnabled;
        } else {
            this.setFilterEnabled(req.filterEnabled);
        }
    }

    protected final SQLFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFilterEnabled(boolean b) {
        boolean changed;
        SQLFilter filter = this.getFilter();
        b = filter == null ? false : b;
        FilteredFillSQLRequest filteredFillSQLRequest = this;
        synchronized (filteredFillSQLRequest) {
            this.checkFrozen();
            if (this.filterEnabled != b) {
                assert (filter != null);
                this.filterEnabled = b;
                if (this.filterEnabled) {
                    filter.addWeakListener(this.filterListener);
                } else {
                    filter.rmListener(this.filterListener);
                }
                changed = this.updateFilterWhere(false);
            } else {
                changed = false;
            }
        }
        if (changed) {
            this.fireWhereChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateFilterWhere(boolean fire) {
        boolean changed;
        FilteredFillSQLRequest filteredFillSQLRequest = this;
        synchronized (filteredFillSQLRequest) {
            changed = this.filterEnabled ? this.setFilterWhere(this.getFilter().getLeaf(), this.getFilter().getPath(this.getPrimaryTable())) : this.setFilterWhere(null, null);
        }
        if (fire && changed) {
            this.fireWhereChange();
        }
        return changed;
    }

    private synchronized boolean setFilterWhere(Set<SQLRow> w, Path p) {
        boolean changed;
        this.checkFrozen();
        boolean bl = changed = !CompareUtils.equals(this.filterInfo.get0(), w) || !CompareUtils.equals(this.filterInfo.get1(), p);
        if (changed) {
            this.filterInfo = w == null || p == null ? Tuple2.create(null, null) : Tuple2.create(new HashSet<SQLRow>(w), p);
        }
        return changed;
    }
}

