/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.TransfFieldExpander;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.FilteredFillSQLRequest;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.sql.sqlobject.ElementComboBoxUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;

public final class ComboSQLRequest
extends FilteredFillSQLRequest {
    private static final SQLCache cache = new SQLCache(60, -1, "items of " + ComboSQLRequest.class);
    private static String SEP_FIELD;
    private static Comparator DEFAULT_COMPARATOR;
    private List<SQLField> comboFields;
    private final TransfFieldExpander exp;
    private String fieldSeparator = ComboSQLRequest.getDefaultFieldSeparator();
    private String undefLabel;
    private KeepMode keepRows;
    private IClosure customizeItem;
    private List<Path> order;
    private Comparator itemsOrder;

    static {
        ComboSQLRequest.setDefaultFieldSeparator(" | ");
        ComboSQLRequest.setDefaultItemsOrder(null);
    }

    public static synchronized void setDefaultFieldSeparator(String separator) {
        SEP_FIELD = separator;
    }

    public static synchronized String getDefaultFieldSeparator() {
        return SEP_FIELD;
    }

    public static synchronized void setDefaultItemsOrder(Comparator comp) {
        DEFAULT_COMPARATOR = comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ComboSQLRequest(ComboSQLRequest c, boolean freeze) {
        super(c, freeze);
        this.exp = new TransfFieldExpander(c.exp);
        ComboSQLRequest comboSQLRequest = c;
        synchronized (comboSQLRequest) {
            this.comboFields = c.comboFields;
            this.order = c.order == null ? null : new ArrayList<Path>(c.order);
            this.itemsOrder = c.itemsOrder;
            this.fieldSeparator = c.fieldSeparator;
            this.undefLabel = c.undefLabel;
            this.keepRows = c.keepRows;
            this.customizeItem = c.customizeItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComboSQLRequest clone() {
        ComboSQLRequest comboSQLRequest = this;
        synchronized (comboSQLRequest) {
            return this.clone(false);
        }
    }

    @Override
    protected ComboSQLRequest clone(boolean forFreeze) {
        return new ComboSQLRequest(this, forFreeze);
    }

    @Override
    protected final synchronized List<Path> getOrder() {
        if (this.order != null) {
            return this.order;
        }
        List<Tuple2<Path, List<FieldPath>>> expandGroupBy = ElementComboBoxUtils.expandGroupBy(this.getGraph(), Configuration.getInstance().getDirectory());
        ArrayList<Path> res = new ArrayList<Path>(expandGroupBy.size());
        for (Tuple2<Path, List<FieldPath>> ancestor : expandGroupBy) {
            res.add(0, ancestor.get0());
        }
        return res;
    }

    @Override
    protected final TransfFieldExpander getShowAs() {
        return this.exp;
    }

    public final synchronized List<SQLField> getFields() {
        return this.comboFields;
    }

    public static enum KeepMode {
        NONE,
        ROW,
        GRAPH;

    }
}

