/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openconcerto.sql.FieldExpander;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.BaseSQLRequest;
import org.openconcerto.utils.cc.ITransformer;

public abstract class BaseFillSQLRequest
extends BaseSQLRequest
implements Cloneable {
    private static final Pattern QUERY_SPLIT_PATTERN = Pattern.compile("\\s+");
    private static boolean DEFAULT_SELECT_LOCK = true;
    private final SQLTable primaryTable;
    private Where where;
    private Map searchFields;
    private List<String> searchQuery;
    private ITransformer<SQLSelect, SQLSelect> selTransf;
    private boolean lockSelect;
    private SQLRowValues graph;
    private SQLRowValues graphToFetch;
    private SQLRowValuesListFetcher frozen = null;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFillSQLRequest(BaseFillSQLRequest req) {
        this.primaryTable = req.getPrimaryTable();
        BaseFillSQLRequest baseFillSQLRequest = req;
        synchronized (baseFillSQLRequest) {
            this.where = req.where;
            this.searchFields = req.searchFields;
            this.searchQuery = req.searchQuery;
            this.selTransf = req.selTransf;
            this.lockSelect = req.lockSelect;
            this.graph = req.getGraph();
            this.graphToFetch = req.getGraphToFetch();
        }
    }

    public final synchronized boolean isFrozen() {
        return this.frozen != null;
    }

    protected final void checkFrozen() {
        if (this.isFrozen()) {
            throw new IllegalStateException("this has been frozen: " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFillSQLRequest clone() {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            return this.clone(false);
        }
    }

    protected abstract BaseFillSQLRequest clone(boolean var1);

    private final SQLRowValues computeGraph() {
        if (this.getFields() == null) {
            return null;
        }
        SQLRowValues vals = new SQLRowValues(this.getPrimaryTable());
        for (SQLField f : this.getFields()) {
            vals.put(f.getName(), null);
        }
        this.getShowAs().expand(vals);
        return vals.toImmutable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SQLRowValues getGraph() {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            if (this.graph == null) {
                assert (!this.isFrozen()) : "no computation should take place after frozen()";
                this.graph = this.computeGraph();
            }
            return this.graph;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SQLRowValues getGraphToFetch() {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            if (this.graphToFetch == null && this.getGraph() != null) {
                assert (!this.isFrozen()) : "no computation should take place after frozen()";
                SQLRowValues tmp = this.getGraph().deepCopy();
                this.customizeToFetch(tmp);
                for (Path orderP : this.getOrder()) {
                    SQLRowValues orderVals = tmp.followPath(orderP);
                    if (orderVals == null || !orderVals.getTable().isOrdered()) continue;
                    orderVals.put(orderVals.getTable().getOrderField().getName(), null);
                }
                this.graphToFetch = tmp.toImmutable();
            }
            return this.graphToFetch;
        }
    }

    protected void customizeToFetch(SQLRowValues graphToFetch) {
    }

    protected List<Path> getOrder() {
        return Collections.singletonList(Path.get(this.getPrimaryTable()));
    }

    protected abstract Collection<SQLField> getFields();

    protected abstract FieldExpander getShowAs();

    public final SQLTable getPrimaryTable() {
        return this.primaryTable;
    }

    protected final void fireWhereChange() {
        assert (!Thread.holdsLock(this));
        this.supp.firePropertyChange("where", null, null);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " on " + this.getPrimaryTable();
    }
}

