/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DirectedMultigraph;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.LoadingListener;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.BaseGraph;
import org.openconcerto.sql.model.graph.DirectedEdge;
import org.openconcerto.sql.model.graph.LabelPredicate;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.SQLKey;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.model.graph.ToRefreshSpec;
import org.openconcerto.utils.ArrayComparator;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.SetMap;
import org.openconcerto.xml.JDOMUtils;

public class DatabaseGraph
extends BaseGraph {
    static final Comparator<Object[]> IMPORTED_KEYS_COMP;
    private final DBSystemRoot base;
    private Map<String, Set<String>> mappedFromFile;
    private final Map<SQLTable, Set<Link>> foreignLinks = new HashMap<SQLTable, Set<Link>>();
    private final Map<List<SQLField>, Link> foreignLink = new HashMap<List<SQLField>, Link>();
    private final ThreadLocal<Integer> atomicRefreshDepth = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private final ThreadLocal<ToRefreshSpec> atomicRefreshItems = new ThreadLocal<ToRefreshSpec>(){

        @Override
        protected ToRefreshSpec initialValue() {
            return new ToRefreshSpec();
        }
    };

    static {
        ArrayList<ArrayComparator<Object>> comps = new ArrayList<ArrayComparator<Object>>();
        comps.add(ArrayComparator.createNatural(0, String.class));
        comps.add(ArrayComparator.createNatural(1, String.class));
        comps.add(ArrayComparator.createNatural(2, String.class));
        comps.add(ArrayComparator.createNatural(11, String.class));
        comps.add(ArrayComparator.createNatural(8, Short.class));
        IMPORTED_KEYS_COMP = CompareUtils.createComparator(comps);
    }

    public static SQLTable getTableFromJDBCMetaData(SQLBase passedBase, String jdbcCat, String jdbcSchem, String jdbcName) {
        SQLSchema schema;
        SQLServer server = passedBase.getServer();
        String correctedCat = server.getSQLSystem().isInterBaseSupported() ? jdbcCat : passedBase.getName();
        SQLBase base = server.getBase(correctedCat);
        SQLSchema sQLSchema = schema = base == null ? null : base.getSchema(jdbcSchem);
        if (schema == null) {
            throw new IllegalStateException("Schema " + correctedCat + "." + jdbcSchem + " does not exist (probably filtered by DBSystemRoot.getRootsToMap())");
        }
        SQLTable res = server.getSQLSystem() == SQLSystem.MYSQL ? DatabaseGraph.getTableIgnoringCase(schema, jdbcName) : (SQLTable)schema.getCheckedChild(jdbcName);
        return res;
    }

    public DatabaseGraph(DBSystemRoot root) {
        super(new DirectedMultigraph<SQLTable, Link>(Link.class));
        this.base = root;
        this.mappedFromFile = null;
    }

    public final void refresh(TablesMap tablesRefreshed, boolean readCache) throws SQLException {
        if (this.inAtomicRefresh()) {
            this.atomicRefreshItems.get().add(tablesRefreshed, readCache);
        } else {
            this.refresh(new ToRefreshSpec().add(tablesRefreshed, readCache));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refresh(final ToRefreshSpec toRefresh) throws SQLException {
        Object object = this.base.getTreeMutex();
        synchronized (object) {
            DatabaseGraph databaseGraph = this;
            synchronized (databaseGraph) {
                LoadingListener.GraphLoadingEvent evt = new LoadingListener.GraphLoadingEvent(this.base).fireEvent();
                try {
                    try {
                        this.mappedFromFile = Collections.unmodifiableMap(AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, Set<String>>>(){

                            @Override
                            public Map<String, Set<String>> run() throws SQLException {
                                return DatabaseGraph.this.mapTables(toRefresh);
                            }
                        }));
                    }
                    catch (PrivilegedActionException e) {
                        throw (SQLException)e.getCause();
                    }
                }
                finally {
                    evt.fireFinishingEvent();
                }
            }
        }
    }

    public final boolean inAtomicRefresh() {
        return this.atomicRefreshDepth.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <V> V atomicRefresh(Callable<V> callable) throws SQLException {
        V res;
        this.atomicRefreshDepth.set(this.atomicRefreshDepth.get() + 1);
        Object object = this.base.getTreeMutex();
        synchronized (object) {
            int newVal;
            try {
                try {
                    res = callable.call();
                }
                catch (Exception e) {
                    throw new SQLException("Call failed", e);
                }
            }
            finally {
                newVal = this.atomicRefreshDepth.get() - 1;
                this.atomicRefreshDepth.set(newVal);
                assert (newVal >= 0);
            }
            if (newVal == 0) {
                ToRefreshSpec itemsToRefresh = this.atomicRefreshItems.get();
                this.atomicRefreshItems.remove();
                this.atomicRefreshDepth.remove();
                this.refresh(itemsToRefresh);
            }
        }
        return res;
    }

    private final SQLServer getServer() {
        return this.base.getAnc(SQLServer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Map<String, Set<String>> mapTables(ToRefreshSpec toRefreshSpec) throws SQLException {
        assert (Thread.holdsLock(this.base.getTreeMutex())) : "Cannot graph a changing object";
        TablesMap res = new TablesMap();
        Set<SQLTable> currentTables = this.getAllTables();
        ToRefreshSpec.ToRefreshActual toRefresh = toRefreshSpec.getActual(this.base, currentTables);
        Set<SQLTable> newTablesInScope = toRefresh.getNewTablesInScope();
        Set<SQLTable> oldTablesInScope = toRefresh.getOldTablesInScope();
        boolean clearGraph = oldTablesInScope.equals(currentTables);
        DatabaseGraph databaseGraph = this;
        synchronized (databaseGraph) {
            if (clearGraph) {
                this.foreignLink.clear();
                this.foreignLinks.clear();
            } else {
                SQLTable linkTable;
                Map.Entry<Object, Object> e;
                Iterator<Map.Entry<Object, Object>> iter = this.foreignLink.entrySet().iterator();
                while (iter.hasNext()) {
                    e = iter.next();
                    linkTable = e.getKey().get(0).getTable();
                    if (!oldTablesInScope.contains(linkTable)) continue;
                    iter.remove();
                }
                iter = this.foreignLinks.entrySet().iterator();
                while (iter.hasNext()) {
                    e = iter.next();
                    linkTable = ((SQLTable)e.getKey()).getTable();
                    if (!oldTablesInScope.contains(linkTable)) continue;
                    iter.remove();
                }
            }
        }
        if (clearGraph) {
            this.getGraphP().removeAllVertices(oldTablesInScope);
            assert (this.getGraphP().vertexSet().size() == 0 && this.getGraphP().edgeSet().size() == 0);
        } else {
            Collection<SQLTable> removedTables = CollectionUtils.subtract(oldTablesInScope, newTablesInScope);
            for (SQLTable removedTable : removedTables) {
                Set<SQLTable> referentTables = this.getReferentTables(removedTable);
                if (oldTablesInScope.containsAll(referentTables)) continue;
                throw new IllegalStateException(removedTable + " has been removed but some of its referents won't be refreshed : " + CollectionUtils.subtract(referentTables, oldTablesInScope));
            }
            this.getGraphP().removeAllVertices(removedTables);
            HashSet linksToRemove = new HashSet();
            for (SQLTable t : CollectionUtils.intersection(oldTablesInScope, newTablesInScope)) {
                linksToRemove.addAll(this.getGraphP().outgoingEdgesOf(t));
            }
            this.getGraphP().removeAllEdges(linksToRemove);
        }
        Graphs.addAllVertices(this.getGraphP(), newTablesInScope);
        TablesMap fromXML = toRefresh.getFromXML();
        TablesMap fromJDBC = toRefresh.getFromJDBC();
        if (fromXML.size() > 0) {
            DBItemFileCache dir = this.getFileCache();
            try {
                if (dir != null) {
                    Log.get().config("for mapping " + this + " trying xmls in " + dir);
                    long t1 = System.currentTimeMillis();
                    res = this.mapFromXML(fromXML);
                    fromXML.removeAll(res);
                    long t2 = System.currentTimeMillis();
                    Log.get().config("XML took " + (t2 - t1) + "ms for mapping the graph of " + this.base.getName() + "." + res);
                }
            }
            catch (Exception e) {
                SQLBase.logCacheError(dir, e);
                this.deleteGraphFiles();
            }
            fromJDBC.merge(fromXML);
        }
        if (!fromJDBC.isEmpty()) {
            long t1 = System.currentTimeMillis();
            for (Map.Entry e : fromJDBC.entrySet()) {
                String rootName = (String)e.getKey();
                Set tableNames = (Set)e.getValue();
                DBRoot r = this.base.getRoot(rootName);
                if (!this.map(r, tableNames)) {
                    for (String table : tableNames) {
                        this.map(r, table, null);
                    }
                }
                this.save(r);
            }
            long t2 = System.currentTimeMillis();
            Log.get().config("JDBC took " + (t2 - t1) + "ms for mapping the graph of " + this.base + "." + fromJDBC);
        }
        return res;
    }

    private final void addLink(List<SQLField> from, List<SQLField> to, String foreignKeyName, Link.Rule updateRule, Link.Rule deleteRule) {
        this.addLink(new Link(from, to, foreignKeyName, updateRule, deleteRule));
    }

    private final void addLink(Link l) {
        DirectedEdge.addEdge(this.getGraphP(), l);
    }

    private boolean map(DBRoot r, Set<String> tableNames) throws SQLException {
        if (tableNames.size() <= 1) {
            return false;
        }
        if (r.getServer().getSQLSystem() == SQLSystem.POSTGRESQL) {
            this.map(r, null, tableNames);
            return true;
        }
        return false;
    }

    private Link.Rule getRule(Number n, SQLSystem sys) {
        Link.Rule res = Link.Rule.fromShort(n.shortValue());
        return sys == SQLSystem.MSSQL && Link.Rule.RESTRICT.equals((Object)res) ? Link.Rule.NO_ACTION : res;
    }

    private void map(final DBRoot r, final String tableName, Set<String> tableNames) throws SQLException {
        assert (tableName == null ^ tableNames == null);
        SetMap<String, String> metadataFKs = new SetMap<String, String>();
        List importedKeys = this.base.getDataSource().useConnection(new ConnectionHandlerNoSetup<List, SQLException>(){

            @Override
            public List handle(SQLDataSource ds) throws SQLException {
                DatabaseMetaData metaData = ds.getConnection().getMetaData();
                return (List)SQLDataSource.ARRAY_LIST_HANDLER.handle(metaData.getImportedKeys(r.getBase().getMDName(), r.getSchema().getName(), tableName));
            }
        });
        ArrayList<SQLField> from = new ArrayList<SQLField>();
        ArrayList<SQLField> to = new ArrayList<SQLField>();
        SQLSystem sys = this.base.getServer().getSQLSystem();
        Link.Rule updateRule = null;
        Link.Rule deleteRule = null;
        String name = null;
        if (sys == SQLSystem.MSSQL) {
            Collections.sort(importedKeys, IMPORTED_KEYS_COMP);
        }
        for (Object[] m : importedKeys) {
            SQLTable foreignTable;
            assert (CompareUtils.equals(m[5], r.getSchema().getName()));
            String fkTableName = (String)m[6];
            assert (tableName == null || tableName.equals(fkTableName));
            if (tableNames != null && !tableNames.contains(fkTableName)) continue;
            String keyName = (String)m[7];
            short seq = ((Number)m[8]).shortValue();
            String foreignTableColName = (String)m[3];
            String foreignKeyName = (String)m[11];
            SQLField key = r.getTable(fkTableName).getField(keyName);
            try {
                foreignTable = DatabaseGraph.getTableFromJDBCMetaData(r.getBase(), (String)m[0], (String)m[1], (String)m[2]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not find what " + key.getSQLName() + " references", e);
            }
            metadataFKs.add(fkTableName, keyName);
            if (seq == 1) {
                if (from.size() > 0) {
                    this.addLink(from, to, name, updateRule, deleteRule);
                }
                from.clear();
                to.clear();
            }
            from.add(key);
            assert (seq == 1 || ((SQLField)from.get(from.size() - 2)).getTable() == ((SQLField)from.get(from.size() - 1)).getTable());
            to.add(foreignTable.getField(foreignTableColName));
            assert (seq == 1 || ((SQLField)to.get(to.size() - 2)).getTable() == ((SQLField)to.get(to.size() - 1)).getTable());
            Link.Rule prevUpdateRule = updateRule;
            Link.Rule prevDeleteRule = deleteRule;
            updateRule = this.getRule((Number)m[9], sys);
            deleteRule = this.getRule((Number)m[10], sys);
            if (seq > 1) {
                if (prevUpdateRule != updateRule) {
                    throw new IllegalStateException("Incoherent update rules " + (Object)((Object)prevUpdateRule) + " != " + (Object)((Object)updateRule));
                }
                if (prevDeleteRule != deleteRule) {
                    throw new IllegalStateException("Incoherent delete rules " + (Object)((Object)prevDeleteRule) + " != " + (Object)((Object)deleteRule));
                }
            }
            name = foreignKeyName;
        }
        if (from.size() > 0) {
            this.addLink(from, to, name, updateRule, deleteRule);
        }
        if (Boolean.getBoolean("org.openconcerto.sql.graph.inferFK")) {
            Set<String> tables = tableName != null ? Collections.singleton(tableName) : tableNames;
            for (String tableToInfer : tables) {
                SQLTable table = r.getTable(tableToInfer);
                Set<String> lexicalFKs = SQLKey.foreignKeys(table);
                lexicalFKs.removeAll((Collection<?>)metadataFKs.getNonNull(table.getName()));
                for (String keyName : lexicalFKs) {
                    SQLField key = table.getField(keyName);
                    this.addLink(Collections.singletonList(key), Collections.singletonList(SQLKey.keyToTable(key).getKey()), null, null, null);
                }
            }
        }
    }

    private static final SQLTable getTableIgnoringCase(SQLSchema s, String tablename) {
        ArrayList<SQLTable> matchingTables = new ArrayList<SQLTable>(4);
        for (String tname : s.getTableNames()) {
            if (!tname.equalsIgnoreCase(tablename)) continue;
            matchingTables.add(s.getTable(tname));
        }
        if (matchingTables.size() == 0) {
            return (SQLTable)s.getCheckedChild(tablename);
        }
        if (matchingTables.size() == 1) {
            return (SQLTable)matchingTables.get(0);
        }
        throw new IllegalStateException("More than one table matches " + tablename + " : " + matchingTables);
    }

    private DBItemFileCache getFileCache() {
        boolean useXML = this.base.useCache();
        DBFileCache d = this.getServer().getFileCache();
        if (!useXML || d == null) {
            return null;
        }
        return d.getChild(this.base);
    }

    private final File getRootFile(String root) {
        DBItemFileCache saveDir = this.getFileCache();
        if (saveDir == null) {
            return null;
        }
        return this.getGraphFile(saveDir.getChild(root));
    }

    private final List<DBItemFileCache> getSavedCaches(boolean withFile) {
        DBItemFileCache item = this.getFileCache();
        if (item == null) {
            return Collections.emptyList();
        }
        return item.getSavedDesc(DBRoot.class, withFile ? "graph.xml" : null);
    }

    final void deleteGraphFiles() {
        for (DBItemFileCache i : this.getSavedCaches(true)) {
            this.getGraphFile(i).delete();
        }
    }

    private File getGraphFile(DBItemFileCache i) {
        return i.getFile("graph.xml");
    }

    boolean save(DBRoot r) {
        String rootName = r.getName();
        File rootFile = this.getRootFile(rootName);
        if (rootFile == null) {
            return false;
        }
        assert (Thread.holdsLock(this.base.getTreeMutex())) : "Might save garbage if two threads open the same file";
        BufferedWriter pWriter = null;
        try {
            FileUtils.mkdir_p(rootFile.getParentFile());
            pWriter = FileUtils.createXMLWriter(rootFile);
            pWriter.write("<root codecVersion=\"");
            pWriter.write("20121024-1614");
            pWriter.write("\"");
            SQLSchema.getVersionAttr(r.getSchema(), pWriter);
            pWriter.write(" >\n");
            for (SQLTable t : r.getDescs(SQLTable.class)) {
                Set<Link> flinks = this.getForeignLinks(t);
                pWriter.write("<table name=\"");
                pWriter.write(JDOMUtils.OUTPUTTER.escapeAttributeEntities(t.getName()));
                pWriter.write("\">\n");
                for (Link l : flinks) {
                    l.toXML(pWriter);
                }
                pWriter.write("</table>\n");
            }
            pWriter.write("\n</root>\n");
            return true;
        }
        catch (Exception e) {
            Log.get().log(Level.WARNING, "unable to save files in " + rootFile, e);
            return false;
        }
        finally {
            if (pWriter != null) {
                try {
                    pWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private TablesMap mapFromXML(TablesMap fromXML) throws JDOMException, IOException {
        TablesMap res = new TablesMap();
        for (DBItemFileCache cache : this.getSavedCaches(true)) {
            String actualVersion;
            String rootName = cache.getName();
            if (!fromXML.containsKey(rootName)) continue;
            Document doc = new SAXBuilder().build(this.getGraphFile(cache));
            String fileVersion = doc.getRootElement().getAttributeValue("codecVersion");
            if (!"20121024-1614".equals(fileVersion)) {
                throw new IOException("wrong format version, expected 20121024-1614 got: " + fileVersion);
            }
            if (!this.base.contains(rootName)) continue;
            DBRoot r = (DBRoot)this.base.getCheckedChild(rootName);
            String xmlVersion = SQLSchema.getVersion(doc.getRootElement());
            if (!CompareUtils.equals(xmlVersion, actualVersion = r.getSchema().getVersion())) {
                throw new IOException("wrong DB version, expected " + actualVersion + " got: " + xmlVersion);
            }
            Set fromXMLTableNames = (Set)fromXML.get(rootName);
            for (Element tableElem : doc.getRootElement().getChildren()) {
                SQLTable t = r.getTable(tableElem.getAttributeValue("name"));
                if (!fromXMLTableNames.contains(t.getName())) continue;
                for (Element linkElem : tableElem.getChildren()) {
                    this.addLink(Link.fromXML(t, linkElem));
                }
                res.add(rootName, t.getName());
            }
            if (res.containsKey(rootName)) continue;
            res.put(rootName, Collections.emptySet());
        }
        return res;
    }

    public synchronized Set<Link> getForeignLinks(SQLTable table) {
        Set<Link> res = this.foreignLinks.get(table);
        if (res == null) {
            res = Collections.unmodifiableSet(this.getGraphP().outgoingEdgesOf(table));
            this.foreignLinks.put(table, res);
        }
        return res;
    }

    public Set<SQLField> getForeignKeys(SQLTable table) {
        return DatabaseGraph.getLabels(this.getForeignLinks(table));
    }

    public Link getForeignLink(SQLField fk) {
        return this.getForeignLink(Collections.singletonList(fk));
    }

    public Link getForeignLink(SQLTable t, List<String> fields) {
        ArrayList<SQLField> fks = new ArrayList<SQLField>(fields.size());
        for (String s : fields) {
            fks.add(t.getField(s));
        }
        return this.getForeignLink(fks);
    }

    public synchronized Link getForeignLink(List<SQLField> fk) {
        if (fk.size() == 0) {
            throw new IllegalArgumentException("empty list");
        }
        if (!this.foreignLink.containsKey(fk)) {
            this.foreignLink.put(fk, (Link)org.apache.commons.collections.CollectionUtils.find(this.getForeignLinks(fk.get(0).getTable()), new LabelPredicate(fk)));
        }
        return this.foreignLink.get(fk);
    }

    public SQLTable getForeignTable(SQLField fk) {
        Link l = this.getForeignLink(fk);
        if (l != null) {
            return (SQLTable)l.getTarget();
        }
        return null;
    }

    public synchronized Set<Link> getForeignLinks(SQLTable t1, SQLTable t2) {
        if (t1 == null || t2 == null) {
            throw new NullPointerException("t1: " + t1 + ", t2: " + t2);
        }
        return this.getGraphP().getAllEdges(t1, t2);
    }

    public Set<SQLField> getForeignFields(SQLTable t1, SQLTable t2) {
        return DatabaseGraph.getLabels(this.getForeignLinks(t1, t2));
    }

    public synchronized Set<Link> getReferentLinks(SQLTable table) {
        return this.getGraphP().incomingEdgesOf(table);
    }

    public Set<SQLField> getReferentKeys(SQLTable table) {
        return DatabaseGraph.getLabels(this.getReferentLinks(table));
    }

    public Set<SQLTable> getReferentTables(SQLTable table) {
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        for (Link l : this.getReferentLinks(table)) {
            res.add((SQLTable)l.getSource());
        }
        return res;
    }

    public Set<Link> getLinks(SQLTable t1, SQLTable t2) {
        HashSet<Link> res = new HashSet<Link>(this.getForeignLinks(t1, t2));
        res.addAll(this.getForeignLinks(t2, t1));
        return res;
    }

    public Where getWhereClause(TableRef t1, TableRef t2, Step fields) {
        return Where.or(this.getStraightWhereClause(t1, t2, fields));
    }

    public Set<Where> getStraightWhereClause(TableRef t1, TableRef t2, Step step) {
        if (step == null) {
            step = Step.create(t1.getTable(), t2.getTable());
        } else {
            if (t1 == null) {
                t1 = step.getFrom();
            } else if (step.getFrom() != t1.getTable()) {
                throw new IllegalArgumentException("step isn't from t1 " + step);
            }
            if (t2 == null) {
                t2 = step.getTo();
            } else if (step.getTo() != t2.getTable()) {
                throw new IllegalArgumentException("step isn'ts to t2 " + step);
            }
        }
        HashSet<Where> res = new HashSet<Where>();
        for (Link l : step.getLinks()) {
            Link.Direction dir = step.getDirection(l);
            res.add(this.getWhereClause(t1, t2, l, dir));
        }
        return res;
    }

    public Where getWhereClause(TableRef t1, TableRef t2, Link l, Link.Direction dir) {
        TableRef dest;
        TableRef src;
        if (l == null) {
            throw new NullPointerException("Null link");
        }
        if (dir == Link.Direction.FOREIGN) {
            src = t1;
            dest = t2;
        } else if (dir == Link.Direction.REFERENT) {
            src = t2;
            dest = t1;
        } else {
            throw new IllegalArgumentException("Invalid direction : " + (Object)((Object)dir));
        }
        if (src == null) {
            src = (TableRef)l.getSource();
        } else if (src.getTable() != l.getSource()) {
            throw new IllegalArgumentException("Wrong source table " + src.getTable() + " != " + l.getSource());
        }
        if (dest == null) {
            dest = (TableRef)l.getTarget();
        } else if (dest.getTable() != l.getTarget()) {
            throw new IllegalArgumentException("Wrong target table " + dest.getTable() + " != " + l.getTarget());
        }
        Iterator<SQLField> primaryKeys = dest.getTable().getPrimaryKeys().iterator();
        Where w = null;
        for (SQLField f : l.getFields()) {
            assert (f.getTable() == src.getTable());
            FieldRef f1 = src.getField(f.getName());
            FieldRef f2 = dest.getField(primaryKeys.next().getName());
            w = new Where(f1, "=", f2).and(w);
        }
        assert (w != null) : "Empty fields for " + l;
        assert (!primaryKeys.hasNext()) : "Mismatch";
        return w;
    }

    protected DirectedMultigraph<SQLTable, Link> getGraphP() {
        return (DirectedMultigraph)this.getGraph();
    }

    public static <C extends Collection<SQLField>> C getLabels(Collection<Link> links, C fields) {
        for (Link l : links) {
            fields.add((SQLField)l.getLabel());
        }
        return fields;
    }

    public static Set<SQLField> getLabels(Collection<Link> links) {
        return DatabaseGraph.getLabels(links, new HashSet());
    }
}

