/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.StructureSource;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.cc.IncludeExclude;

public class XMLStructureSource
extends StructureSource<IOException> {
    public static final DateFormat XMLDATE_FMT = new SimpleDateFormat("yyyyMMdd-HHmmss.SSSZ");
    private final Map<String, Element> xmlSchemas = new HashMap<String, Element>();
    private final Set<String> schemas = new HashSet<String>();
    private final Set<String> outOfDateSchemas = new HashSet<String>();
    private final Set<SQLName> tableNames;
    private final Set<String> allSchemas = new HashSet<String>();
    private final DBItemFileCache dir;

    public XMLStructureSource(SQLBase b, TablesMap scope, DBItemFileCache dir) {
        super(b, scope);
        this.tableNames = new HashSet<SQLName>();
        if (dir == null) {
            throw new NullPointerException("Null dir");
        }
        this.dir = dir;
        this.setPreVerify(true);
    }

    @Override
    protected void getNames(Connection conn) throws IOException {
        this.schemas.clear();
        this.tableNames.clear();
        try {
            this.allSchemas.addAll(this.getJDBCSchemas(conn.getMetaData()));
        }
        catch (SQLException exn) {
            throw new IOException("could not get schemas", exn);
        }
        String problems = "";
        TablesMap outOfDateTables = new TablesMap();
        SAXBuilder sxb = new SAXBuilder();
        HashSet<String> schemaNamesToLoad = new HashSet<String>();
        ArrayList<DBItemFileCache> schemaFilesToLoad = new ArrayList<DBItemFileCache>();
        for (DBItemFileCache savedSchema : this.dir.getSavedDesc(SQLSchema.class, "structure.xml")) {
            String schemaName = savedSchema.getName();
            if (!this.allSchemas.contains(schemaName) || !this.isInScope(schemaName)) continue;
            schemaFilesToLoad.add(savedSchema);
            schemaNamesToLoad.add(schemaName);
        }
        Map<String, String> schemaDBVersions = SQLSchema.getVersions(this.getBase(), schemaNamesToLoad);
        for (DBItemFileCache savedSchema : schemaFilesToLoad) {
            String schemaName = savedSchema.getName();
            String schemaDBVersion = schemaDBVersions.get(schemaName);
            File schemaFile = savedSchema.getFile("structure.xml");
            String schemaProblem = "";
            Element schemaElem = null;
            try {
                Document document;
                try {
                    document = sxb.build(schemaFile);
                }
                catch (Exception e1) {
                    throw new IOException("couldn't parse " + schemaFile, e1);
                }
                Element rootElem = document.getRootElement();
                schemaElem = rootElem.getChild("schema");
                String schemaNameAttr = schemaElem.getAttributeValue("name");
                if (!CompareUtils.equals(schemaName, schemaNameAttr)) {
                    throw new IOException("name attr: " + schemaNameAttr + " != " + schemaName + " :file name");
                }
                String codecVersion = rootElem.getAttributeValue("codecVersion");
                schemaProblem = String.valueOf(schemaProblem) + this.isVersionBad(codecVersion, "20141001-1155");
                if (this.isVersionBad(SQLSchema.getVersion(schemaElem), schemaDBVersion).length() > 0) {
                    this.outOfDateSchemas.add(schemaName);
                }
            }
            catch (Exception e) {
                schemaProblem = String.valueOf(schemaProblem) + ExceptionUtils.getStackTrace(e);
            }
            if ((schemaProblem = schemaProblem.trim()).length() > 0) {
                savedSchema.delete(Boolean.getBoolean("org.openconcerto.sql.structure.keepInvalidXML"));
                problems = String.valueOf(problems) + schemaProblem;
                continue;
            }
            assert (schemaElem != null);
            this.xmlSchemas.put(schemaName, schemaElem);
            this.schemas.add(schemaName);
            IncludeExclude<String> tablesToRefresh = this.getTablesInScope(schemaName);
            for (Element elementTable : schemaElem.getChildren("table")) {
                String tableName = elementTable.getAttributeValue("name");
                if (!tablesToRefresh.isIncluded(tableName)) continue;
                if (this.isVersionBad(SQLSchema.getVersion(elementTable), schemaDBVersion).length() == 0) {
                    this.tableNames.add(new SQLName(schemaName, tableName));
                    continue;
                }
                outOfDateTables.add(schemaName, tableName);
            }
        }
        if (problems.length() > 0) {
            SQLBase.logCacheError(this.dir, new IllegalStateException("invalid files : " + problems));
        }
        if (outOfDateTables.size() > 0) {
            Log.get().config("Ignoring out of date tables : " + outOfDateTables);
        }
    }

    private String isVersionBad(String xmlVersion, String actualVersion) {
        if (xmlVersion == null || !xmlVersion.equals(actualVersion)) {
            return "version mismatch " + xmlVersion + " != " + actualVersion + '\n';
        }
        return "";
    }

    @Override
    public Set<String> getSchemas() {
        return this.schemas;
    }

    @Override
    public Set<SQLName> getTablesNames() {
        return this.tableNames;
    }

    @Override
    final Set<String> getOutOfDateSchemas() {
        return Collections.unmodifiableSet(this.outOfDateSchemas);
    }

    @Override
    protected void fillTables(TablesMap newSchemas) {
        for (Map.Entry e : newSchemas.entrySet()) {
            String schemaName = (String)e.getKey();
            Element schemaElem = this.xmlSchemas.get(schemaName);
            this.getNewSchema(schemaName).load(schemaElem, (Set)e.getValue());
        }
    }

    @Override
    public void save() {
    }
}

