/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.TransactionListener;
import org.openconcerto.utils.CompareUtils;

public class TransactionPoint {
    private Boolean committed = null;
    private final Connection conn;
    private final Savepoint savepoint;
    private final boolean namedSavePoint;
    private final String savePointID;
    private final List<TransactionListener> listeners;

    public TransactionPoint(Connection conn) throws SQLException {
        this(conn, null, false);
    }

    public TransactionPoint(Connection conn, Savepoint savepoint, boolean namedSavePoint) throws SQLException {
        if (conn == null) {
            throw new NullPointerException("Null connection");
        }
        this.conn = conn;
        this.savepoint = savepoint;
        this.namedSavePoint = namedSavePoint;
        this.savePointID = savepoint == null ? null : (namedSavePoint ? savepoint.getSavepointName() : String.valueOf(savepoint.getSavepointId()));
        this.listeners = new ArrayList<TransactionListener>();
    }

    public final synchronized Boolean getCommitted() {
        return this.committed;
    }

    final Connection getConn() {
        return this.conn;
    }

    public final Savepoint getSavePoint() {
        return this.savepoint;
    }

    public final synchronized void addListener(TransactionListener l) {
        this.checkActive();
        this.listeners.add(l);
    }

    private synchronized void checkActive() {
        if (this.committed != null) {
            throw new IllegalStateException("Transaction point inactive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fire(boolean committed) {
        List<TransactionListener> ls;
        TransactionPoint transactionPoint = this;
        synchronized (transactionPoint) {
            this.committed = committed;
            ls = this.listeners;
        }
        for (TransactionListener l : ls) {
            l.transactionEnded(this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conn == null ? 0 : this.conn.hashCode());
        result = 31 * result + (this.namedSavePoint ? 1231 : 1237);
        result = 31 * result + (this.savePointID == null ? 0 : this.savePointID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionPoint other = (TransactionPoint)obj;
        return this.conn == other.conn && this.namedSavePoint == other.namedSavePoint && CompareUtils.equals(this.savePointID, other.savePointID);
    }
}

