/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.Constraint;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.MSSQLBase;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSyntaxMySQL;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.ProcessStreams;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;

class SQLSyntaxMS
extends SQLSyntax {
    SQLSyntaxMS() {
        super(SQLSystem.MSSQL);
        this.typeNames.addAll(Boolean.class, "bit");
        this.typeNames.addAll(Short.class, "smallint", "tinyint");
        this.typeNames.addAll(Integer.class, "int");
        this.typeNames.addAll(Long.class, "bigint");
        this.typeNames.addAll(BigDecimal.class, "decimal", "numeric", "smallmoney", "money");
        this.typeNames.addAll(Float.class, "real");
        this.typeNames.addAll(Double.class, "float");
        this.typeNames.addAll(Timestamp.class, "smalldatetime", "datetime");
        this.typeNames.addAll(Date.class, "date");
        this.typeNames.addAll(Time.class, "time");
        this.typeNames.addAll(Blob.class, "image", "varbinary", "binary");
        this.typeNames.addAll(Clob.class, "text", "ntext", "unitext");
        this.typeNames.addAll(String.class, "char", "varchar", "nchar", "nvarchar", "unichar", "univarchar");
    }

    @Override
    SQLBase createBase(SQLServer server, String name, IClosure<? super DBSystemRoot> systemRootInit, String login, String pass, IClosure<? super SQLDataSource> dsInit) {
        return new MSSQLBase(server, name, systemRootInit, login, pass, dsInit);
    }

    @Override
    public String getAuto() {
        return " int IDENTITY";
    }

    @Override
    public String getDateAndTimeType() {
        return "datetime2";
    }

    @Override
    public String getBooleanType() {
        return "bit";
    }

    @Override
    public int getMaximumVarCharLength() {
        return 8000;
    }

    @Override
    public String transfDefaultJDBC2SQL(SQLField f) {
        String def = f.getDefaultValue();
        if (def == null) {
            return null;
        }
        String stringDef = def.toString();
        while (stringDef.charAt(0) == '(' && stringDef.charAt(stringDef.length() - 1) == ')') {
            stringDef = stringDef.substring(1, stringDef.length() - 1);
        }
        if (f.getType().getJavaType() == Boolean.class) {
            return stringDef.equals("'true'") ? "true" : "false";
        }
        return stringDef;
    }

    @Override
    protected String transfDefault(SQLField f, String castless) {
        if (castless != null && f.getType().getJavaType() == Boolean.class) {
            return castless.equals("TRUE") ? "'true'" : "'false'";
        }
        return castless;
    }

    @Override
    protected String getRuleSQL(Link.Rule r) {
        return (r.equals((Object)Link.Rule.RESTRICT) ? Link.Rule.NO_ACTION : r).asString();
    }

    @Override
    public List<Map<String, Object>> getIndexInfo(SQLTable t) throws SQLException {
        String query = "SELECT NULL AS \"TABLE_CAT\", schema_name(t.schema_id) as \"TABLE_SCHEM\", t.name as \"TABLE_NAME\",\n~idx.is_unique as \"NON_UNIQUE\", NULL AS \"INDEX_QUALIFIER\", idx.name as \"INDEX_NAME\", NULL as \"TYPE\",\nindexCols.key_ordinal as \"ORDINAL_POSITION\", cols.name as \"COLUMN_NAME\",\ncase when indexCols.is_descending_key = 1 then 'D' else 'A' end as \"ASC_OR_DESC\", null as \"CARDINALITY\", null as \"PAGES\",\nfilter_definition as \"FILTER_CONDITION\"\n  FROM [test].[sys].[objects] t\n  join [test].[sys].[indexes] idx on idx.object_id = t.object_id\n  join [test].[sys].[index_columns] indexCols on idx.index_id = indexCols.index_id and idx.object_id = indexCols.object_id\n  join [test].[sys].[columns] cols on t.object_id = cols.object_id and cols.column_id = indexCols.column_id \n  where schema_name(t.schema_id) = " + t.getBase().quoteString(t.getSchema().getName()) + " and t.name = " + t.getBase().quoteString(t.getName()) + "\n" + "ORDER BY \"NON_UNIQUE\", \"TYPE\", \"INDEX_NAME\", \"ORDINAL_POSITION\";";
        return (List)t.getDBSystemRoot().getDataSource().execute(query, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
    }

    public Map<String, Object> normalizeIndexInfo(Map m) {
        if (this.getSystem().getJDBCName().equals("sqlserver")) {
            m.put("NON_UNIQUE", ((Number)m.get("NON_UNIQUE")).intValue() != 0);
        }
        return m;
    }

    @Override
    public Map<ChangeTable.ClauseType, List<String>> getAlterField(SQLField f, Set<SQLField.Properties> toAlter, String type, String defaultVal, Boolean nullable) {
        ListMap<ChangeTable.ClauseType, String> res = new ListMap<ChangeTable.ClauseType, String>();
        if (toAlter.contains((Object)SQLField.Properties.TYPE) || toAlter.contains((Object)SQLField.Properties.NULLABLE)) {
            String newType = toAlter.contains((Object)SQLField.Properties.TYPE) ? type : this.getType(f);
            boolean newNullable = toAlter.contains((Object)SQLField.Properties.NULLABLE) ? nullable.booleanValue() : this.getNullable(f);
            res.add(ChangeTable.ClauseType.ALTER_COL, "ALTER COLUMN " + f.getQuotedName() + " " + this.getFieldDecl(newType, null, newNullable));
        }
        if (toAlter.contains((Object)SQLField.Properties.DEFAULT)) {
            Constraint existingConstraint = f.getTable().getConstraint(SQLSyntax.ConstraintType.DEFAULT, Arrays.asList(f.getName()));
            if (existingConstraint != null) {
                res.add(ChangeTable.ClauseType.DROP_CONSTRAINT, "DROP CONSTRAINT " + SQLBase.quoteIdentifier(existingConstraint.getName()));
            }
            if (defaultVal != null) {
                res.add(ChangeTable.ClauseType.ADD_CONSTRAINT, "ADD DEFAULT " + defaultVal + " FOR " + f.getQuotedName());
            }
        }
        return res;
    }

    @Override
    protected Tuple2<Boolean, String> getCast() {
        return null;
    }

    @Override
    public void _loadData(File f, SQLTable t) throws IOException {
        String data = FileUtils.readUTF8(f);
        File temp = File.createTempFile(FileUtils.sanitize("mssql_loadData_" + t.getName()), ".txt");
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(temp), Charset.forName("x-UTF-16LE-BOM")));
        List<SQLField> fields = t.getOrderedFields();
        int fieldsCount = fields.size();
        BitSet booleanFields = new BitSet(fieldsCount);
        int fieldIndex = 0;
        for (SQLField field : fields) {
            int type = field.getType().getType();
            booleanFields.set(fieldIndex++, type == 16 || type == -7);
        }
        fieldIndex = 0;
        try {
            int i = data.indexOf(10) + 1;
            while (i < data.length()) {
                String twoChars;
                String string = twoChars = i + 2 <= data.length() ? data.substring(i, i + 2) : null;
                if ("\\N".equals(twoChars)) {
                    i += 2;
                } else if ("\"\"".equals(twoChars)) {
                    writer.write("\u0000");
                    i += 2;
                } else {
                    Tuple2<String, Integer> unDoubleQuote = StringUtils.unDoubleQuote(data, i);
                    String unquoted = unDoubleQuote.get0();
                    if (booleanFields.get(fieldIndex)) {
                        if (unquoted.equalsIgnoreCase("false")) {
                            unquoted = "0";
                        } else if (unquoted.equalsIgnoreCase("true")) {
                            unquoted = "1";
                        }
                    }
                    writer.write(unquoted);
                    i = unDoubleQuote.get1();
                }
                ++fieldIndex;
                if (i >= data.length()) continue;
                char c = data.charAt(i);
                if (c == ',') {
                    writer.write("<|!!|>");
                    ++i;
                    continue;
                }
                if (c == '\n') {
                    writer.write("...#~\n~#...");
                    ++i;
                    if (fieldIndex != fieldsCount) {
                        throw new IOException("Expected " + fieldsCount + " fields but got : " + fieldIndex);
                    }
                    fieldIndex = 0;
                    continue;
                }
                throw new IOException("Unexpected character after field : " + c);
            }
            if (fieldIndex != 0 && fieldIndex != fieldsCount) {
                throw new IOException("Expected " + fieldsCount + " fields but got : " + fieldIndex);
            }
        }
        finally {
            writer.close();
        }
        this.execute_bcp(t, false, temp);
        temp.delete();
    }

    protected void execute_bcp(SQLTable t, boolean dump, File f) throws IOException {
        ProcessBuilder pb = new ProcessBuilder("bcp");
        pb.command().add(t.getSQLName().quote());
        pb.command().add(dump ? "out" : "in");
        pb.command().add(f.getAbsolutePath());
        pb.command().add("-w");
        pb.command().add("-t<|!!|>");
        pb.command().add("-r...#~\n~#...");
        pb.command().add("-q");
        pb.command().add("-S" + t.getServer().getName());
        pb.command().add("-U" + t.getDBSystemRoot().getDataSource().getUsername());
        pb.command().add("-P" + t.getDBSystemRoot().getDataSource().getPassword());
        if (!dump) {
            pb.command().add("-k");
            pb.command().add("-E");
        }
        Process p = pb.start();
        ProcessStreams.handle(p, ProcessStreams.Action.REDIRECT);
        try {
            int returnCode = p.waitFor();
            if (returnCode != 0) {
                throw new IOException("Did not finish correctly : " + returnCode + "\n" + pb.command());
            }
        }
        catch (InterruptedException e) {
            throw new RTInterruptedException(e);
        }
    }

    @Override
    public boolean supportMultiAlterClause() {
        return false;
    }

    @Override
    public String getNullIsDataComparison(String x, boolean eq, String y) {
        String nullSafe = String.valueOf(x) + " = " + y + " or ( " + x + " is null and " + y + " is null)";
        if (eq) {
            return nullSafe;
        }
        return String.valueOf(x) + " <> " + y + " or (" + x + " is null and " + y + " is not null) " + " or (" + x + " is not null and " + y + " is null) ";
    }

    @Override
    public String getFunctionQuery(SQLBase b, Set<String> schemas) {
        return "  select name, schema_name(schema_id) as \"schema\", cast(OBJECT_DEFINITION(object_id) as varchar(4096)) as \"src\"\n  FROM " + new SQLName(b.getName(), "sys", "objects") + "\n" + "  where type IN ('FN', 'IF', 'TF') and SCHEMA_NAME( schema_id ) in (" + SQLSyntaxMS.quoteStrings(b, schemas) + ") ";
    }

    @Override
    public String getTriggerQuery(SQLBase b, TablesMap tables) {
        return "SELECT  trig.name as \"TRIGGER_NAME\", SCHEMA_NAME( tabl.schema_id ) as \"TABLE_SCHEMA\", tabl.name as \"TABLE_NAME\",  null as \"ACTION\", cast(OBJECT_DEFINITION(trig.object_id) as varchar(4096)) as \"SQL\"\nFROM " + new SQLName(b.getName(), "sys", "triggers") + " trig\n" + "join " + new SQLName(b.getName(), "sys", "objects") + " tabl on trig.parent_id = tabl.object_id\n" + this.getTablesMapJoin(b, tables, "SCHEMA_NAME( tabl.schema_id )", "tabl.name");
    }

    @Override
    public String getColumnsQuery(SQLBase b, TablesMap tables) {
        return "SELECT TABLE_SCHEMA as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(0) + "\", TABLE_NAME as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(1) + "\", COLUMN_NAME as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(2) + "\" , CHARACTER_SET_NAME as \"CHARACTER_SET_NAME\", COLLATION_NAME as \"COLLATION_NAME\" from INFORMATION_SCHEMA.COLUMNS\n" + this.getTablesMapJoin(b, tables, "TABLE_SCHEMA", "TABLE_NAME");
    }

    @Override
    public List<Map<String, Object>> getConstraints(SQLBase b, TablesMap tables) throws SQLException {
        String where = this.getTablesMapJoin(b, tables, "SCHEMA_NAME(t.schema_id)", "t.name");
        String sel = "SELECT SCHEMA_NAME(t.schema_id) AS \"TABLE_SCHEMA\", t.name AS \"TABLE_NAME\", k.name AS \"CONSTRAINT_NAME\", case k.type when 'UQ' then 'UNIQUE' when 'PK' then 'PRIMARY KEY' end as \"CONSTRAINT_TYPE\", col_name(c.object_id, c.column_id) AS \"COLUMN_NAME\", c.key_ordinal AS \"ORDINAL_POSITION\", null AS [DEFINITION]\nFROM sys.key_constraints k\nJOIN sys.index_columns c ON c.object_id = k.parent_object_id AND c.index_id = k.unique_index_id\nJOIN sys.tables t ON t.object_id = k.parent_object_id\n" + where + "\nUNION ALL\n" + "SELECT SCHEMA_NAME(t.schema_id) AS \"TABLE_SCHEMA\", t.name AS \"TABLE_NAME\", k.name AS \"CONSTRAINT_NAME\", 'CHECK' as \"CONSTRAINT_TYPE\", col.name AS \"COLUMN_NAME\", 1 AS \"ORDINAL_POSITION\", k.[definition] AS [DEFINITION]\n" + "FROM sys.check_constraints k\n" + "join sys.tables t on k.parent_object_id = t.object_id\n" + "left join sys.columns col on k.parent_column_id = col.column_id and col.object_id = t.object_id\n" + where + "\nUNION ALL\n" + "SELECT SCHEMA_NAME(t.schema_id) AS [TABLE_SCHEMA], t.name AS [TABLE_NAME], k.name AS [CONSTRAINT_NAME], 'DEFAULT' as [CONSTRAINT_TYPE], col.name AS [COLUMN_NAME], 1 AS [ORDINAL_POSITION], k.[definition] AS [DEFINITION]\n" + "FROM sys.[default_constraints] k\n" + "JOIN sys.tables t ON t.object_id = k.parent_object_id\n" + "left join sys.columns col on k.parent_column_id = col.column_id and col.object_id = t.object_id\n" + where;
        List res = (List)b.getDBSystemRoot().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
        SQLSyntaxMySQL.mergeColumnNames(res);
        return res;
    }

    @Override
    public String getFormatTimestamp(String sqlTS, boolean basic) {
        String extended = "CONVERT(nvarchar(30), CAST(" + sqlTS + " as datetime), 126) + '000'";
        if (basic) {
            return "replace( replace( " + extended + ", '-', ''), ':' , '' )";
        }
        return extended;
    }
}

