/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.SQLFilterListener;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.GraFFF;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.utils.CollectionUtils;

public final class SQLFilter {
    private final GraFFF filterGraph;
    private final List<Set<SQLRow>> filteredIDs;
    private List<SQLFilterListener> listeners;

    public Path getPath(SQLTable tableToDisplay) {
        Set<Path> paths;
        Path res = null;
        if (this.getDepth() > 0 && !(paths = this.getPaths(tableToDisplay, this.getLeafTable())).isEmpty()) {
            res = paths.iterator().next().reverse();
        }
        return res;
    }

    private Set<Path> getPaths(SQLTable tableToDisplay, SQLTable filterTable) {
        Path shortestPath = this.filterGraph.getShortestPath(filterTable, tableToDisplay);
        Set<Object> paths = shortestPath == null ? Collections.emptySet() : Collections.singleton(shortestPath);
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDepth() {
        List<Set<SQLRow>> list = this.filteredIDs;
        synchronized (list) {
            return this.filteredIDs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<SQLRow> getLeaf() {
        List<Set<SQLRow>> list = this.filteredIDs;
        synchronized (list) {
            return CollectionUtils.getFirst(this.filteredIDs);
        }
    }

    private final SQLTable getLeafTable() {
        Set<SQLRow> leaf = this.getLeaf();
        return leaf == null ? null : leaf.iterator().next().getTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<Set<SQLRow>> list = this.filteredIDs;
        synchronized (list) {
            return "SQLFilter on: " + this.filteredIDs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SQLFilterListener l) {
        List<SQLFilterListener> list = this.listeners;
        synchronized (list) {
            ArrayList<SQLFilterListener> newListeners = new ArrayList<SQLFilterListener>(this.listeners.size() + 1);
            newListeners.addAll(this.listeners);
            newListeners.add(l);
            this.listeners = Collections.unmodifiableList(newListeners);
        }
    }

    public void addWeakListener(SQLFilterListener l) {
        this.addListener(new WeakListener(l));
    }

    public void rmListener(SQLFilterListener lToRm) {
        assert (!(lToRm instanceof WeakListener)) : "Only expose regular listeners";
        this.rmListener_(lToRm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rmListener_(SQLFilterListener lToRm) {
        List<SQLFilterListener> list = this.listeners;
        synchronized (list) {
            int stop = this.listeners.size();
            int indexToRm = -1;
            int i = 0;
            while (i < stop && indexToRm < 0) {
                SQLFilterListener l = this.listeners.get(i);
                if (l.equals(lToRm) || l instanceof WeakListener && lToRm.equals(((WeakListener)l).get())) {
                    indexToRm = i;
                }
                ++i;
            }
            if (indexToRm >= 0) {
                ArrayList<SQLFilterListener> newListeners = new ArrayList<SQLFilterListener>(stop - 1);
                newListeners.addAll(this.listeners.subList(0, indexToRm));
                newListeners.addAll(this.listeners.subList(indexToRm + 1, stop));
                this.listeners = Collections.unmodifiableList(newListeners);
            }
        }
    }

    private final class WeakListener
    extends WeakReference<SQLFilterListener>
    implements SQLFilterListener {
        private WeakListener(SQLFilterListener referent) {
            super(referent);
        }
    }
}

