/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.utils.cc.IClosure;

public class MSSQLBase
extends SQLBase {
    MSSQLBase(SQLServer server, String name, IClosure<? super DBSystemRoot> systemRootInit, String login, String pass, IClosure<? super SQLDataSource> dsInit) {
        super(server, name, systemRootInit, login, pass, dsInit);
    }

    @Override
    public final String quoteString(String s) {
        String res = super.quoteString(s);
        if (s == null) {
            return res;
        }
        boolean simpleASCII = true;
        int l = s.length();
        int i = 0;
        while (simpleASCII && i < l) {
            char c = s.charAt(i);
            simpleASCII = c <= '\u00ff';
            ++i;
        }
        return simpleASCII ? res : "N" + res;
    }
}

