/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.StructureSource;
import org.openconcerto.sql.model.SystemQueryExecutor;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.utils.SQLCreateMoveableTable;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.IncludeExclude;

public class JDBCStructureSource
extends StructureSource<SQLException> {
    private final Set<String> schemas = new HashSet<String>();
    private final Map<SQLName, List<String>> tableNames = new HashMap<SQLName, List<String>>();

    static String getCacheError(String rootName) {
        return "Cache won't be used for " + rootName + " since there's no metadata table";
    }

    public JDBCStructureSource(SQLBase b, TablesMap scope, Map<String, SQLSchema> newStruct, Set<String> outOfDateSchemas) {
        super(b, scope, newStruct, outOfDateSchemas);
        this.setPreVerify(false);
    }

    private String getTablePattern(IncludeExclude<String> tables) {
        assert (!tables.isNoneIncluded());
        return tables.getSole("%");
    }

    @Override
    Set<String> getOutOfDateSchemas() {
        return Collections.emptySet();
    }

    @Override
    protected void getNames(Connection conn) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        HashMap<SQLName, List<String>> tableNames = new HashMap<SQLName, List<String>>();
        Set<String> schemas = this.getJDBCSchemas(metaData);
        this.filterOutOfScope(schemas);
        for (String s : new HashSet<String>(schemas)) {
            IncludeExclude<String> tablesToRefresh = this.getTablesInScope(s);
            if (tablesToRefresh.isNoneIncluded()) continue;
            ResultSet rs = metaData.getTables(this.getBase().getMDName(), s, this.getTablePattern(tablesToRefresh), new String[]{"TABLE", "SYSTEM TABLE", "VIEW"});
            while (rs.next()) {
                List<String> prev;
                String tableType = rs.getString("TABLE_TYPE");
                String schemaName = rs.getString("TABLE_SCHEM");
                if (tableType.equals("SYSTEM TABLE")) {
                    schemas.remove(schemaName);
                    continue;
                }
                String tableName = rs.getString("TABLE_NAME");
                if (!tablesToRefresh.isIncluded(tableName) || (prev = tableNames.put(new SQLName(schemaName, tableName), Arrays.asList(rs.getString("TABLE_TYPE"), rs.getString("REMARKS")))) == null) continue;
                throw new IllegalStateException(String.valueOf(tableName) + " already loaded in " + schemaName);
            }
        }
        Iterator iter = tableNames.keySet().iterator();
        while (iter.hasNext()) {
            SQLName tableName = (SQLName)iter.next();
            if (schemas.contains(tableName.getItemLenient(-2))) continue;
            iter.remove();
        }
        SQLCreateMoveableTable createMetadata = SQLSchema.getCreateMetadata(this.getBase().getServer().getSQLSystem().getSyntax());
        boolean useCache = this.getBase().getDBSystemRoot().useCache();
        Statement stmt = null;
        try {
            for (String schema : schemas) {
                String rootName;
                SQLName md;
                if (this.getTablesToRefresh(schema) != null || !this.getTablesInScope(schema).isIncluded("FWK_SCHEMA_METADATA") || tableNames.containsKey(md = new SQLName(schema, "FWK_SCHEMA_METADATA"))) continue;
                String string = rootName = schema == null ? this.getBase().getName() : schema;
                if (createMetadata != null) {
                    if (stmt == null) {
                        stmt = conn.createStatement();
                    }
                    stmt.execute(createMetadata.asString(rootName));
                    tableNames.put(md, Arrays.asList("TABLE", ""));
                    continue;
                }
                if (!useCache) continue;
                Log.get().warning(JDBCStructureSource.getCacheError(rootName));
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        this.schemas.clear();
        this.schemas.addAll(schemas);
        this.tableNames.clear();
        this.tableNames.putAll(tableNames);
    }

    @Override
    public Set<String> getSchemas() {
        return this.schemas;
    }

    @Override
    public Set<SQLName> getTablesNames() {
        return this.tableNames.keySet();
    }

    @Override
    protected void fillTables(final TablesMap newSchemas) throws SQLException {
        this.getBase().getDataSource().useConnection(new ConnectionHandlerNoSetup<Object, SQLException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException {
                JDBCStructureSource.this._fillTables(newSchemas, ds.getConnection());
                return null;
            }
        });
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void _fillTables(TablesMap newSchemas, Connection conn) throws SQLException {
        block22: {
            useCache = this.getBase().getDBSystemRoot().useCache();
            schemaVersions = SQLSchema.getVersions(this.getBase(), newSchemas.keySet());
            metaData = conn.getMetaData();
            for (String s : newSchemas.keySet()) {
                schema = this.getNewSchema(s);
                schemaVers = schemaVersions.get(s);
                if (schemaVers == null) {
                    schemaVers = schema.updateVersion(false);
                }
                if (schemaVers == null && useCache) {
                    Log.get().warning("Cache won't be used for " + schema + " since there's no version");
                }
                if (this.getTablesToRefresh(s) == null) {
                    schema.setFullyRefreshedVersion(schemaVers);
                }
                tablesToRefresh = (Set)newSchemas.get(s);
                if (!JDBCStructureSource.$assertionsDisabled && tablesToRefresh == null) {
                    throw new AssertionError((Object)"Null should have been resolved in getNames()");
                }
                if (tablesToRefresh.isEmpty()) continue;
                tablesWithColumns = new HashSet<SQLName>();
                rs = metaData.getColumns(this.getBase().getMDName(), s, this.getTablePattern(IncludeExclude.getNormalized(tablesToRefresh)), null);
                hasNext = rs.next();
                while (hasNext) {
                    schemaName = rs.getString("TABLE_SCHEM");
                    if (!JDBCStructureSource.$assertionsDisabled && !CompareUtils.equals(schemaName, s)) {
                        throw new AssertionError();
                    }
                    tableName = rs.getString("TABLE_NAME");
                    tablesWithColumns.add(new SQLName(new String[]{schemaName, tableName}));
                    moved = tablesToRefresh.contains(tableName) != false ? schema.refreshTable(metaData, rs, schemaVers) : null;
                    v0 = hasNext = moved == null ? rs.next() : moved.booleanValue();
                }
                for (String t : tablesToRefresh) {
                    if (tablesWithColumns.contains(new SQLName(new String[]{s, t}))) continue;
                    schema.getTable(t).emptyFields();
                }
            }
            for (SQLName tName : this.getTablesNames()) {
                t = this.getNewSchema(tName.getItemLenient(-2)).getTable(tName.getName());
                l = this.tableNames.get(tName);
                t.setType((String)l.get(0));
                t.setComment((String)l.get(1));
            }
            system = this.getBase().getServer().getSQLSystem();
            proceduresBySchema = new HashMap<String, HashMap<String, Object>>();
            for (String s : newSchemas.keySet()) {
                rsProc = metaData.getProcedures(this.getBase().getMDName(), s, "%");
                while (rsProc.next()) {
                    rsMap = new HashMap<String, Object>();
                    rsmd = rsProc.getMetaData();
                    cols = rsmd.getColumnCount();
                    i = 1;
                    while (i <= cols) {
                        rsMap.put(rsmd.getColumnLabel(i).toUpperCase(), rsProc.getObject(i));
                        ++i;
                    }
                    schemaName = (String)rsMap.get("PROCEDURE_SCHEM");
                    if (!newSchemas.containsKey(schemaName)) continue;
                    rawRrocName = (String)rsMap.get("PROCEDURE_NAME");
                    procName = system.equals((Object)SQLSystem.MSSQL) != false ? rawRrocName.substring(0, rawRrocName.lastIndexOf(59)) : rawRrocName;
                    map = (HashMap<String, Object>)proceduresBySchema.get(schemaName);
                    if (map == null) {
                        map = new HashMap<String, Object>();
                        proceduresBySchema.put(schemaName, map);
                    }
                    map.put(procName, null);
                }
            }
            if (proceduresBySchema.size() > 0) {
                sel = system.getSyntax().getFunctionQuery(this.getBase(), proceduresBySchema.keySet());
                if (sel != null) {
                    for (E o : (List)this.getBase().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false))) {
                        m = (Map)o;
                        schemaName = (String)m.get("schema");
                        procName = (String)m.get("name");
                        if (!JDBCStructureSource.$assertionsDisabled && !((Map)proceduresBySchema.get(schemaName)).containsKey(procName)) {
                            throw new AssertionError((Object)("metaData.getProcedures() hadn't found " + procName + " in " + schemaName));
                        }
                        ((Map)proceduresBySchema.get(schemaName)).put(procName, (String)m.get("src"));
                    }
                }
                for (Map.Entry e : proceduresBySchema.entrySet()) {
                    this.getNewSchema((String)e.getKey()).putProcedures((Map)e.getValue());
                }
            }
            sansEmpty = TablesMap.create(newSchemas);
            sansEmpty.removeAllEmptyCollections();
            if (sansEmpty.size() > 0) {
                tableFinder = new ITransformer<Tuple2<String, String>, SQLTable>(){

                    public SQLTable transformChecked(Tuple2<String, String> input) {
                        return JDBCStructureSource.this.getNewTable(input.get0(), input.get1());
                    }
                };
                new TriggerQueryExecutor(tableFinder).apply(this.getBase(), sansEmpty);
                new ColumnsQueryExecutor(tableFinder).apply(this.getBase(), sansEmpty);
                try {
                    new ConstraintsExecutor(tableFinder).apply(this.getBase(), sansEmpty);
                    break block22;
                }
                catch (SystemQueryExecutor.QueryExn e1) {
                    e1.printStackTrace();
                    ** for (tName : this.getTablesNames())
                }
lbl-1000:
                // 1 sources

                {
                    t = this.getNewSchema(tName.getItemLenient(-2)).getTable(tName.getName());
                    t.addConstraint((Map<String, Object>)null);
                    continue;
                }
            }
        }
    }

    @Override
    public void save() {
        for (String schema : this.getSchemas()) {
            this.getBase().save(schema);
        }
    }

    static final class ColumnsQueryExecutor
    extends SystemQueryExecutor {
        public ColumnsQueryExecutor(ITransformer<Tuple2<String, String>, SQLTable> tableFinder) {
            super(tableFinder);
        }

        @Override
        protected String getQuery(SQLBase b, TablesMap tables) {
            return b.getServer().getSQLSystem().getSyntax().getColumnsQuery(b, tables);
        }

        @Override
        protected void apply(SQLTable newTable, Map m) {
            newTable.getField((String)m.get("COLUMN_NAME")).setColsFromInfoSchema(m);
        }
    }

    static final class ConstraintsExecutor
    extends SystemQueryExecutor {
        public ConstraintsExecutor(ITransformer<Tuple2<String, String>, SQLTable> tableFinder) {
            super(tableFinder);
        }

        @Override
        protected Object getQuery(SQLBase b, TablesMap tables) {
            try {
                return b.getServer().getSQLSystem().getSyntax().getConstraints(b, tables);
            }
            catch (Exception e) {
                return e;
            }
        }

        @Override
        protected void apply(SQLTable newTable, Map m) {
            newTable.addConstraint(m);
        }
    }

    static final class TriggerQueryExecutor
    extends SystemQueryExecutor {
        public TriggerQueryExecutor(ITransformer<Tuple2<String, String>, SQLTable> tableFinder) {
            super(tableFinder);
        }

        @Override
        protected Object getQuery(SQLBase b, TablesMap tables) {
            try {
                return b.getServer().getSQLSystem().getSyntax().getTriggerQuery(b, tables);
            }
            catch (SQLException e) {
                return e;
            }
        }

        @Override
        protected void apply(SQLTable newTable, Map m) {
            newTable.addTrigger(m);
        }
    }
}

