/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.SQLItem;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

class FromClause
implements SQLItem {
    private static final SQLItem COMMA = new SQLItem(){

        @Override
        public String getSQL() {
            return ", ";
        }
    };
    private static final SQLItem NEWLINE = new SQLItem(){

        @Override
        public String getSQL() {
            return "\n";
        }
    };
    private final List<SQLItem> sql = new ArrayList<SQLItem>();

    public FromClause() {
    }

    public FromClause(FromClause f) {
        this();
        this.sql.addAll(f.sql);
    }

    void add(TableRef res) {
        if (!this.sql.isEmpty()) {
            this.sql.add(COMMA);
        }
        this.sql.add(res);
    }

    void add(SQLSelectJoin j) {
        if (this.sql.isEmpty()) {
            throw new IllegalArgumentException("nothing to join with " + j);
        }
        this.sql.add(NEWLINE);
        this.sql.add(j);
    }

    @Override
    public String getSQL() {
        return "FROM " + CollectionUtils.join(this.sql, "", new ITransformer<SQLItem, String>(){

            public String transformChecked(SQLItem input) {
                return input.getSQL();
            }
        });
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " <" + this.getSQL() + ">";
    }
}

