/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBStructureItemNotFound;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.ui.group.Group;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.LinkedListMap;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.change.ListChangeRecorder;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.i18n.Grammar_fr;
import org.openconcerto.utils.i18n.NounClass;
import org.openconcerto.utils.i18n.Phrase;

public abstract class SQLElement {
    private static final Set<String> computingFF = Collections.unmodifiableSet(new HashSet());
    private static final Set<SQLField> computingRF = Collections.unmodifiableSet(new HashSet());
    public static final String DEFERRED_CODE = new String("deferred code");
    private SQLElementDirectory directory;
    private String l18nPkgName;
    private Class<?> l18nClass;
    private Phrase name;
    private final SQLTable primaryTable;
    private String code;
    private ComboSQLRequest combo;
    private ListSQLRequest list;
    private final ListChangeRecorder rowActions;
    private final LinkedListMap<String, ITransformer<Tuple2<SQLElement, String>, SQLComponent>> components;
    private Set<String> normalFF;
    private String parentFF;
    private Set<String> sharedFF;
    private Map<String, SQLElement> privateFF;
    private final Map<Link, ReferenceAction> actions;
    private Set<SQLField> childRF;
    private Set<SQLField> privateParentRF;
    private Set<SQLField> otherRF;
    private SQLCache<SQLRowAccessor, Object> modelCache;
    private final Map<String, JComponent> additionalFields;
    private final List additionalListCols;
    private List<String> mdPath;
    private Group defaultGroup;

    private static Phrase createPhrase(String singular, String plural) {
        String base;
        NounClass nounClass;
        if (singular.startsWith("une ")) {
            nounClass = NounClass.FEMININE;
            base = singular.substring(4);
        } else if (singular.startsWith("un ")) {
            nounClass = NounClass.MASCULINE;
            base = singular.substring(3);
        } else {
            nounClass = null;
            base = singular;
        }
        Phrase res = new Phrase(Grammar_fr.getInstance(), base, nounClass);
        if (nounClass != null) {
            res.putVariant(Grammar.INDEFINITE_ARTICLE_SINGULAR, singular);
        }
        res.putVariant(Grammar.PLURAL, plural);
        return res;
    }

    @Deprecated
    public SQLElement(String singular, String plural, SQLTable primaryTable) {
        this(primaryTable, SQLElement.createPhrase(singular, plural));
    }

    public SQLElement(SQLTable primaryTable, Phrase name) {
        this(primaryTable, name, null);
    }

    public SQLElement(SQLTable primaryTable, Phrase name, String code) {
        if (primaryTable == null) {
            throw new DBStructureItemNotFound("table is null for " + this.getClass());
        }
        this.primaryTable = primaryTable;
        this.setL18nPackageName(null);
        this.setDefaultName(name);
        this.code = code == null ? this.createCode() : code;
        this.combo = null;
        this.list = null;
        this.rowActions = new ListChangeRecorder(new ArrayList());
        this.actions = new HashMap<Link, ReferenceAction>();
        this.resetRelationships();
        this.components = new LinkedListMap();
        this.modelCache = null;
        this.additionalFields = new LinkedHashMap<String, JComponent>();
        this.additionalListCols = new ArrayList();
        this.mdPath = Collections.emptyList();
    }

    protected String createCode() {
        return String.valueOf(this.getClass().getName()) + "-" + this.getTable().getName();
    }

    public void setDefaultGroup(Group defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public synchronized void resetRelationships() {
        this.privateFF = null;
        this.parentFF = null;
        this.normalFF = null;
        this.sharedFF = null;
        this.actions.clear();
        this.childRF = null;
        this.privateParentRF = null;
        this.otherRF = null;
    }

    protected final synchronized boolean areRelationshipsInited() {
        return this.sharedFF != null;
    }

    private void checkSelfCall(boolean check, String methodName) {
        assert (check) : this + " " + methodName + "() is calling itself, and thus the caller will only see a partial state";
    }

    private synchronized void initFF() {
        this.checkSelfCall(this.sharedFF != computingFF, "initFF");
        if (this.areRelationshipsInited()) {
            return;
        }
        this.sharedFF = computingFF;
        HashSet<String> privates = new HashSet<String>(this.getPrivateFields());
        this.privateFF = new HashMap<String, SQLElement>(privates.size());
        HashSet<String> parents = new HashSet<String>();
        this.normalFF = new HashSet<String>();
        HashSet<String> tmpSharedFF = new HashSet<String>();
        for (SQLField ff : this.getTable().getForeignKeys()) {
            String fieldName = ff.getName();
            SQLElement foreignElement = this.getForeignElement(fieldName);
            if (privates.contains(fieldName)) {
                privates.remove(fieldName);
                this.privateFF.put(fieldName, foreignElement);
                continue;
            }
            if (foreignElement.isShared()) {
                tmpSharedFF.add(fieldName);
                continue;
            }
            if (foreignElement.getChildrenReferentFields().contains(ff)) {
                parents.add(fieldName);
                continue;
            }
            this.normalFF.add(fieldName);
        }
        if (parents.size() > 1) {
            throw new IllegalStateException("for " + this + " more than one parent :" + parents);
        }
        String string = this.parentFF = parents.size() == 0 ? null : (String)parents.iterator().next();
        if (privates.size() > 0) {
            throw new IllegalStateException("for " + this + " these private foreign fields are not valid :" + privates);
        }
        assert (this.assertPrivateDefaultValues());
        this.sharedFF = tmpSharedFF;
        if (this.parentFF != null) {
            this.actions.put(this.getLinkFromFieldName(this.parentFF), ReferenceAction.CASCADE);
        }
        for (String s : this.privateFF.keySet()) {
            this.actions.put(this.getLinkFromFieldName(s), ReferenceAction.SET_EMPTY);
        }
        for (String s : this.normalFF) {
            this.actions.put(this.getLinkFromFieldName(s), ReferenceAction.SET_EMPTY);
        }
        for (String s : this.sharedFF) {
            this.actions.put(this.getLinkFromFieldName(s), ReferenceAction.RESTRICT);
        }
        this.ffInited();
    }

    private final boolean assertPrivateDefaultValues() {
        for (Map.Entry<String, SQLElement> e : this.privateFF.entrySet()) {
            String fieldName = e.getKey();
            Number privateDefault = (Number)this.getTable().getField(fieldName).getParsedDefaultValue().getValue();
            Number foreignUndef = e.getValue().getTable().getUndefinedIDNumber();
            assert (NumberUtils.areNumericallyEqual(privateDefault, foreignUndef)) : String.valueOf(fieldName) + " not empty : " + privateDefault;
        }
        return true;
    }

    protected void ffInited() {
    }

    private synchronized Set<SQLField> computeChildrenRF() {
        HashSet<SQLField> res = new HashSet<SQLField>();
        for (String child : this.getChildren()) {
            SQLField childField;
            int comma = child.indexOf(44);
            String tableName = comma < 0 ? child : child.substring(0, comma);
            SQLTable childTable = this.getTable().getTable(tableName);
            if (comma < 0) {
                Set<SQLField> keys = childTable.getForeignKeys(this.getTable());
                if (keys.size() != 1) {
                    throw new IllegalArgumentException("cannot find a foreign from " + child + " to " + this.getTable());
                }
                childField = keys.iterator().next();
            } else {
                childField = childTable.getField(child.substring(comma + 1));
                SQLTable foreignTable = childField.getDBSystemRoot().getGraph().getForeignTable(childField);
                if (!foreignTable.equals(this.getTable())) {
                    throw new IllegalArgumentException(childField + " doesn't point to " + this.getTable());
                }
            }
            res.add(childField);
        }
        return res;
    }

    private synchronized void initChildRF() {
        this.checkSelfCall(this.childRF != computingRF, "initFF");
        if (this.childRF != null) {
            return;
        }
        this.childRF = computingRF;
        Set<SQLField> children = this.computeChildrenRF();
        HashSet<SQLField> tmpChildRF = new HashSet<SQLField>();
        for (SQLField refField : this.getTable().getBase().getGraph().getReferentKeys(this.getTable())) {
            SQLField refParentFF;
            SQLElement refElem = this.getElementLenient(refField.getTable());
            SQLField sQLField = refParentFF = refElem == null ? null : refElem.getParentFF();
            if (refParentFF != null && children.contains(refField)) {
                throw new IllegalStateException(refElem + " specifies this as its parent: " + refParentFF + " and is also mentioned as our (" + this + ") child: " + refField);
            }
            if (!children.contains(refField) && refParentFF != refField) continue;
            tmpChildRF.add(refField);
        }
        this.childRF = tmpChildRF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setDirectory(SQLElementDirectory directory) {
        assert (directory == null || directory.getElement(this.getTable()) == this);
        SQLElement sQLElement = this;
        synchronized (sQLElement) {
            if (this.directory != directory) {
                if (this.areRelationshipsInited()) {
                    this.resetRelationships();
                }
                this.directory = directory;
            }
        }
    }

    public final synchronized SQLElementDirectory getDirectory() {
        return this.directory;
    }

    final SQLElement getElement(SQLTable table) {
        SQLElement res = this.getElementLenient(table);
        if (res == null) {
            throw new IllegalStateException("no element for " + table.getSQLName());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SQLElement getElementLenient(SQLTable table) {
        SQLElement sQLElement = this;
        synchronized (sQLElement) {
            return this.getDirectory().getElement(table);
        }
    }

    public final SQLElement getForeignElement(String foreignField) {
        try {
            return this.getElement(this.getForeignTable(foreignField));
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("no element for " + foreignField + " in " + this, e);
        }
    }

    private final SQLTable getForeignTable(String foreignField) {
        return this.getTable().getBase().getGraph().getForeignTable(this.getTable().getField(foreignField));
    }

    public final void setL18nPackageName(String name) {
        this.setL18nLocation(name, null);
    }

    public final synchronized void setL18nLocation(String name, Class<?> ctxt) {
        this.l18nPkgName = name;
        this.l18nClass = ctxt == null ? this.getClass() : ctxt;
    }

    public final synchronized void setDefaultName(Phrase name) {
        this.name = name != null ? name : Phrase.getInvariant(this.getTable().getName());
    }

    public CollectionMap<String, String> getShowAs() {
        return null;
    }

    public final SQLTable getTable() {
        return this.primaryTable;
    }

    public final synchronized String getCode() {
        if (this.code == DEFERRED_CODE) {
            String createCode = this.createCode();
            if (createCode == DEFERRED_CODE) {
                throw new IllegalStateException("createCode() returned DEFERRED_CODE");
            }
            this.code = createCode;
        }
        return this.code;
    }

    public boolean isShared() {
        return false;
    }

    public final synchronized Set<SQLField> getChildrenReferentFields() {
        this.initChildRF();
        return this.childRF;
    }

    protected Set<String> getChildren() {
        return Collections.emptySet();
    }

    public final synchronized Set<String> getNormalForeignFields() {
        this.initFF();
        return this.normalFF;
    }

    public final SQLField getParentForeignField() {
        return this.getOptionalField(this.getParentForeignFieldName());
    }

    public final synchronized String getParentForeignFieldName() {
        this.initFF();
        return this.parentFF;
    }

    private final SQLField getParentFF() {
        return this.getOptionalField(this.getParentFFName());
    }

    private final SQLField getOptionalField(String name) {
        return name == null ? null : this.getTable().getField(name);
    }

    protected String getParentFFName() {
        return null;
    }

    protected List<String> getPrivateFields() {
        return Collections.emptyList();
    }

    final Map<Link, ReferenceAction> getActions() {
        this.initFF();
        return this.actions;
    }

    public final void setAction(String ff, ReferenceAction action) throws IllegalArgumentException {
        if (action.compareTo(ReferenceAction.RESTRICT) < 0 && !this.getNormalForeignFields().contains(ff)) {
            throw new IllegalArgumentException(this.getTable().getField(ff).getSQLName() + " is not a normal foreign field : " + this.getNormalForeignFields());
        }
        this.getActions().put(this.getLinkFromFieldName(ff), action);
    }

    private final Link getLinkFromFieldName(String ff) {
        return this.getTable().getDBSystemRoot().getGraph().getForeignLink(this.getTable(), Arrays.asList(ff));
    }

    protected abstract List<String> getListFields();

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + this.getTable().getSQLName();
    }

    public final synchronized List<String> getMDPath() {
        return this.mdPath;
    }

    public static enum ReferenceAction {
        SET_EMPTY,
        CASCADE,
        RESTRICT;

    }
}

