/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.request.SQLRowView;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.checks.ValidState;

public abstract class BaseSQLComponent
extends SQLComponent
implements Scrollable {
    private final SQLRowView requete;
    private final Set<SQLRowItemView> required;
    private boolean displayFieldName;

    private final SQLRowView getRequest() {
        return this.requete;
    }

    @Override
    public synchronized ValidState getValidState() {
        boolean res = true;
        ArrayList<String> pbs = new ArrayList<String>();
        for (SQLRowItemView obj : this.getRequest().getViews()) {
            ValidState state = obj.getValidState();
            if (!state.isValid()) {
                String txt = state.getValidationText();
                String explanation = TM.tr("sqlComp.invalidItem", "'" + this.getDesc(obj) + "'", txt != null ? 1 : 0, txt);
                pbs.add(explanation);
                res = false;
                continue;
            }
            if (!this.getRequired().contains(obj) || !obj.isEmpty()) continue;
            pbs.add(TM.tr("sqlComp.emptyItem", "'" + this.getDesc(obj) + "'"));
            res = false;
        }
        return ValidState.create(res, CollectionUtils.join(pbs, "\n"));
    }

    protected final String getDesc(SQLRowItemView obj) {
        return this.getLabelFor(obj.getSQLName());
    }

    public final String getLabelFor(String itemName) {
        return this.getDesc(itemName, this.getRIVDesc(itemName)).get0();
    }

    protected final Tuple2<String, Boolean> getDesc(String itemName, RowItemDesc desc) {
        boolean emptyLabel;
        boolean bl = emptyLabel = desc.getLabel() == null || desc.getLabel().trim().length() == 0;
        String l = emptyLabel ? itemName : String.valueOf(this.getLabel(itemName, desc)) + (this.displayFieldName ? " [" + itemName + "]" : "");
        return Tuple2.create(l, !emptyLabel);
    }

    protected String getLabel(String itemName, RowItemDesc desc) {
        return desc.getLabel();
    }

    public int getSelectedID() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.getRequest().getSelectedID();
    }

    protected final Set<SQLRowItemView> getRequired() {
        return this.required;
    }

    @Override
    public String toString() {
        return this.getClass() + " on " + this.getTable() + " " + this.getSelectedID();
    }

    public final RowItemDesc getRIVDesc(String field) {
        Configuration conf = Configuration.getInstance();
        if (conf == null) {
            return SQLFieldTranslator.NULL_DESC;
        }
        return conf.getTranslator().getDescFor(this.getTable(), this.getCode(), this.getElement().getMDPath(), field);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() >= this.getMinimumSize().height;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 15;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        double length = orientation == 1 ? visibleRect.getHeight() : visibleRect.getWidth();
        return (int)(length - 30.0);
    }
}

