/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.IFieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.utils.Tuple2;

public abstract class FieldExpander {
    private static final FieldExpander EMPTY = new FieldExpander(){

        @Override
        protected List<SQLField> expandOnce(SQLField field) {
            return Collections.emptyList();
        }
    };
    private final Map<IFieldPath, List<FieldPath>> cache = new HashMap<IFieldPath, List<FieldPath>>();
    private final Map<List<? extends IFieldPath>, List<Tuple2<Path, List<FieldPath>>>> cacheGroupBy = new HashMap<List<? extends IFieldPath>, List<Tuple2<Path, List<FieldPath>>>>();

    protected synchronized void clearCache() {
        this.cache.clear();
        this.cacheGroupBy.clear();
    }

    protected abstract List<SQLField> expandOnce(SQLField var1);

    public final synchronized void expand(SQLRowValues vals) {
        Set<SQLField> fks = vals.getTable().getForeignKeys();
        for (String fName : vals.getFields()) {
            List<SQLField> expandedFields;
            SQLField ffield = vals.getTable().getField(fName);
            if (!fks.contains(ffield) || (expandedFields = this.expandOnce(ffield)).size() <= 0) continue;
            SQLRowValues foreignVals = new SQLRowValues(expandedFields.get(0).getTable());
            vals.put(fName, foreignVals);
            for (SQLField expandedField : expandedFields) {
                foreignVals.put(expandedField.getName(), null);
            }
            this.expand(foreignVals);
        }
    }
}

