/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.io.File;
import java.util.concurrent.ExecutorService;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.request.SQLFieldTranslator;

public abstract class Configuration {
    private static Configuration instance;
    private ExecutorService nonInteractiveSQLExecutor;

    public static File getDefaultConfDir() {
        return new File(System.getProperty("user.home"), ".java/ilm/sql-config/");
    }

    public static Configuration getInstance() {
        return instance;
    }

    public abstract ShowAs getShowAs();

    public abstract DBRoot getRoot();

    public abstract DBSystemRoot getSystemRoot();

    public abstract SQLFieldTranslator getTranslator();

    public abstract SQLElementDirectory getDirectory();

    public abstract String getAppName();

    public final String getAppID() {
        String appName = this.getAppName();
        if (appName == null || appName.length() == 0) {
            return null;
        }
        return String.valueOf(appName) + this.getAppIDSuffix();
    }

    protected String getAppIDSuffix() {
        return "";
    }

    public File getConfDir() {
        return new File(Configuration.getDefaultConfDir(), this.getAppID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Configuration configuration = this;
        synchronized (configuration) {
            if (this.nonInteractiveSQLExecutor != null) {
                this.nonInteractiveSQLExecutor.shutdown();
            }
        }
    }
}

