/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.config.InProgressFrame;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.core.common.component.SocieteCommonSQLElement;
import org.openconcerto.erp.core.common.element.AdresseCommonSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ExerciceCommonSQLElement;
import org.openconcerto.erp.core.sales.price.element.DeviseSQLElement;
import org.openconcerto.erp.generationDoc.element.TypeModeleSQLElement;
import org.openconcerto.erp.generationDoc.provider.AdresseFullClientValueProvider;
import org.openconcerto.erp.generationDoc.provider.AdresseRueClientValueProvider;
import org.openconcerto.erp.generationDoc.provider.AdresseVilleCPClientValueProvider;
import org.openconcerto.erp.generationDoc.provider.AdresseVilleClientValueProvider;
import org.openconcerto.erp.generationDoc.provider.AdresseVilleNomClientValueProvider;
import org.openconcerto.erp.generationDoc.provider.DateBLProvider;
import org.openconcerto.erp.generationDoc.provider.FacturableValueProvider;
import org.openconcerto.erp.generationDoc.provider.FormatedGlobalQtyTotalProvider;
import org.openconcerto.erp.generationDoc.provider.LabelAccountInvoiceProvider;
import org.openconcerto.erp.generationDoc.provider.MergedGlobalQtyTotalProvider;
import org.openconcerto.erp.generationDoc.provider.ModeDeReglementDetailsProvider;
import org.openconcerto.erp.generationDoc.provider.PaiementRemainedProvider;
import org.openconcerto.erp.generationDoc.provider.PrixUVProvider;
import org.openconcerto.erp.generationDoc.provider.PrixUnitaireProvider;
import org.openconcerto.erp.generationDoc.provider.PrixUnitaireRemiseProvider;
import org.openconcerto.erp.generationDoc.provider.QteTotalProvider;
import org.openconcerto.erp.generationDoc.provider.RefClientValueProvider;
import org.openconcerto.erp.generationDoc.provider.RemiseProvider;
import org.openconcerto.erp.generationDoc.provider.TotalAcompteProvider;
import org.openconcerto.erp.generationDoc.provider.TotalCommandeClientProvider;
import org.openconcerto.erp.generationDoc.provider.UserCreateInitialsValueProvider;
import org.openconcerto.erp.generationDoc.provider.UserCurrentInitialsValueProvider;
import org.openconcerto.erp.generationDoc.provider.UserModifyInitialsValueProvider;
import org.openconcerto.erp.generationEcritures.provider.SalesCreditAccountingRecordsProvider;
import org.openconcerto.erp.generationEcritures.provider.SalesInvoiceAccountingRecordsProvider;
import org.openconcerto.erp.generationEcritures.provider.SupplyOrderAccountingRecordsProvider;
import org.openconcerto.erp.injector.AchatAvoirSQLInjector;
import org.openconcerto.erp.injector.ArticleCommandeEltSQLInjector;
import org.openconcerto.erp.injector.BonFactureSQLInjector;
import org.openconcerto.erp.injector.BrFactureAchatSQLInjector;
import org.openconcerto.erp.injector.CommandeBlEltSQLInjector;
import org.openconcerto.erp.injector.CommandeBlSQLInjector;
import org.openconcerto.erp.injector.CommandeBrSQLInjector;
import org.openconcerto.erp.injector.CommandeCliCommandeSQLInjector;
import org.openconcerto.erp.injector.CommandeFactureAchatSQLInjector;
import org.openconcerto.erp.injector.CommandeFactureClientSQLInjector;
import org.openconcerto.erp.injector.DevisCommandeFournisseurSQLInjector;
import org.openconcerto.erp.injector.DevisCommandeSQLInjector;
import org.openconcerto.erp.injector.DevisEltFactureEltSQLInjector;
import org.openconcerto.erp.injector.DevisFactureSQLInjector;
import org.openconcerto.erp.injector.EcheanceEncaisseSQLInjector;
import org.openconcerto.erp.injector.EcheanceRegleSQLInjector;
import org.openconcerto.erp.injector.FactureAvoirSQLInjector;
import org.openconcerto.erp.injector.FactureBonSQLInjector;
import org.openconcerto.erp.injector.FactureCommandeSQLInjector;
import org.openconcerto.erp.storage.CloudStorageEngine;
import org.openconcerto.erp.storage.StorageEngines;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.LoadingListener;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.NetUtils;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.StringInputStream;
import org.openconcerto.utils.SwingWorker2;

public final class ComptaPropsConfiguration
extends ComptaBasePropsConfiguration {
    public static final ProductInfo productInfo = ProductInfo.getInstance();
    public static final String APP_NAME = productInfo.getName();
    private String version = "";
    private final boolean isMain;
    private final boolean inWebstart;
    private final boolean isServerless;
    private boolean isOnCloud;

    static final Properties createDefaults() {
        Properties defaults = new Properties();
        defaults.setProperty("base.root", "Common");
        return defaults;
    }

    public static File getConfFile() {
        return ComptaPropsConfiguration.getConfFile(APP_NAME);
    }

    public static ComptaPropsConfiguration create(boolean nullAllowed) {
        return ComptaPropsConfiguration.create(nullAllowed, ComptaPropsConfiguration.getConfFile());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ComptaPropsConfiguration create(boolean nullAllowed, File confFile) {
        block5: {
            System.out.println("Loading configuration from:" + (confFile == null ? "null" : confFile.getAbsolutePath()));
            boolean inWebStart = Gestion.inWebStart();
            Properties defaults = ComptaPropsConfiguration.createDefaults();
            try {
                Properties props;
                if (confFile != null && confFile.exists() && !inWebStart) {
                    props = ComptaPropsConfiguration.create(new FileInputStream(confFile), defaults);
                    return new ComptaPropsConfiguration(props, inWebStart, true);
                }
                InputStream stream = ComptaPropsConfiguration.class.getResourceAsStream("main.properties");
                if (stream != null) {
                    props = ComptaPropsConfiguration.create(stream, defaults);
                    return new ComptaPropsConfiguration(props, inWebStart, true);
                }
                if (!nullAllowed) break block5;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                String title = "Logiciel non configur\u00e9";
                String message = "Impossible de lire le fichier de configuration.\nIl est n\u00e9cessaire d'utiliser le logiciel de Configuration pour param\u00e9trer le logiciel.";
                JOptionPane.showMessageDialog(new JFrame(), message, title, 0);
                System.exit(2);
                return null;
            }
        }
        throw new IOException("found neither " + confFile + " nor embedded " + "main.properties");
    }

    ComptaPropsConfiguration(Properties props, boolean inWebstart, boolean main) {
        super(props, productInfo);
        this.isMain = main;
        this.inWebstart = inWebstart;
        this.setProperty("wd", String.valueOf(DesktopEnvironment.getDE().getDocumentsFolder().getAbsolutePath()) + File.separator + this.getAppName());
        if (this.getProperty("version.date") != null) {
            this.version = this.getProperty("version.date");
        }
        String token = this.getToken();
        SwingWorker2.setMaxWorkerThreads(4);
        if (token != null) {
            SwingWorker2.setMaxWorkerThreads(2);
            this.isServerless = false;
            this.isOnCloud = true;
            if (this.getProperty("storage.server") == null) {
                InProgressFrame progress = new InProgressFrame();
                progress.show("Connexion s\u00e9curis\u00e9e au cloud en cours");
                String result = NetUtils.getHTTPContent("https://cloud.openconcerto.org/getAuthInfo?token=" + token, false);
                if (result != null && !result.contains("ERROR")) {
                    Properties cProperty = new Properties();
                    try {
                        cProperty.loadFromXML(new StringInputStream(result));
                        this.setProperty("server.wan.only", "true");
                        this.setProperty("server.wan.port", "22");
                        this.setProperty("server.wan.addr", cProperty.getProperty("ssh.server"));
                        this.setProperty("server.wan.user", cProperty.getProperty("ssh.login"));
                        this.setProperty("server.wan.password", cProperty.getProperty("ssh.pass"));
                        this.setProperty("server.ip", "127.0.0.1:5432");
                        this.setProperty("server.driver", "postgresql");
                        this.setProperty("server.login", cProperty.getProperty("db.login"));
                        this.setProperty("server.password", cProperty.getProperty("db.pass"));
                        this.setProperty("systemRoot", cProperty.getProperty("db.name"));
                        props.put("storage.server", cProperty.getProperty("storage.server"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(new JFrame(), "Impossible r\u00e9cup\u00e9rer les informations de connexion");
                        System.exit(1);
                    }
                } else if (result != null && result.contains("not paid")) {
                    JOptionPane.showMessageDialog(new JFrame(), "Compte Cloud non cr\u00e9dit\u00e9");
                    System.exit(1);
                } else {
                    JOptionPane.showMessageDialog(new JFrame(), "Connexion impossible au Cloud");
                    System.exit(1);
                }
                progress.dispose();
            }
            StorageEngines.getInstance().addEngine(new CloudStorageEngine());
        } else {
            this.setProperty("server.login", "openconcerto");
            this.setProperty("server.password", "openconcerto");
            this.setProperty("server.ip", this.getProperty("server.ip").replace("${data.dir}", this.getDataDir().getPath()));
            SQLSystem system = this.getSystem();
            boolean bl = this.isServerless = system == SQLSystem.H2 && system.getHostname(this.getServerIp()) == null;
        }
        if (this.isMain) {
            this.setupLogging("logs");
            this.registerAccountingProvider();
            this.registerCellValueProvider();
        }
    }

    private void registerAccountingProvider() {
        SalesInvoiceAccountingRecordsProvider.register();
        SalesCreditAccountingRecordsProvider.register();
        SupplyOrderAccountingRecordsProvider.register();
    }

    private void registerCellValueProvider() {
        UserCreateInitialsValueProvider.register();
        UserModifyInitialsValueProvider.register();
        UserCurrentInitialsValueProvider.register();
        PrixUnitaireRemiseProvider.register();
        PrixUnitaireProvider.register();
        PrixUVProvider.register();
        TotalAcompteProvider.register();
        FacturableValueProvider.register();
        TotalCommandeClientProvider.register();
        LabelAccountInvoiceProvider.register();
        DateBLProvider.register();
        AdresseRueClientValueProvider.register();
        AdresseVilleClientValueProvider.register();
        AdresseVilleCPClientValueProvider.register();
        AdresseVilleNomClientValueProvider.register();
        AdresseFullClientValueProvider.register();
        QteTotalProvider.register();
        RefClientValueProvider.register();
        ModeDeReglementDetailsProvider.register();
        FormatedGlobalQtyTotalProvider.register();
        MergedGlobalQtyTotalProvider.register();
        PaiementRemainedProvider.register();
        RemiseProvider.register();
    }

    @Override
    protected void initSystemRoot(DBSystemRoot input) {
        super.initSystemRoot(input);
        if (!GraphicsEnvironment.isHeadless()) {
            final JDialog f = new JOptionPane("Mise \u00e0 jour des caches en cours...\nCette op\u00e9ration prend g\u00e9n\u00e9ralement moins d'une minute.", 1, -1, null, new Object[0]).createDialog("Veuillez patienter");
            input.addLoadingListener(new LoadingListener(){
                private int loadingCount = 0;
                private final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r, "Loading listener thread");
                        thread.setDaemon(true);
                        return thread;
                    }
                });
                private ScheduledFuture<?> future = null;

                @Override
                public synchronized void loading(LoadingListener.LoadingEvent evt) {
                    this.loadingCount += evt.isStarting() ? 1 : -1;
                    if (this.loadingCount < 0) {
                        throw new IllegalStateException();
                    }
                    if (this.loadingCount == 0) {
                        this.future.cancel(false);
                        this.future = null;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                f.setVisible(false);
                                f.dispose();
                            }
                        });
                    } else if (this.future == null) {
                        this.future = this.exec.schedule(new Runnable(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        f.setVisible(true);
                                    }
                                });
                            }
                        }, 1L, TimeUnit.SECONDS);
                    }
                }
            });
        }
    }

    @Override
    protected void initDS(SQLDataSource ds) {
        super.initDS(ds);
        ds.setInitialSize(3);
        ds.setMinIdle(2);
        ds.setMaxActive(4);
    }

    public String getToken() {
        return this.getProperty("token");
    }

    @Override
    public void destroy() {
        if (this.isMain) {
            this.tearDownLogging(true);
        }
        super.destroy();
    }

    public final boolean isServerless() {
        return this.isServerless;
    }

    @Override
    protected String getAppIDSuffix() {
        if (this.inWebstart()) {
            return String.valueOf(super.getAppIDSuffix()) + "-webstart";
        }
        return super.getAppIDSuffix();
    }

    @Override
    public File getConfDir() {
        return Gestion.MAC_OS_X ? new File(String.valueOf(System.getProperty("user.home")) + "/Library/Application Support/" + this.getAppID()) : super.getConfDir();
    }

    private boolean inWebstart() {
        return this.inWebstart;
    }

    public File getDataDir() {
        return new File(this.getConfDir(), "DBData");
    }

    private final void createDB(DBSystemRoot sysRoot) {
        block7: {
            if (!this.isServerless()) {
                return;
            }
            try {
                if (!sysRoot.shouldMap(this.getRootName()) || sysRoot.contains(this.getRootName())) break block7;
                Log.get().warning("Creating DB");
                String createScript = null;
                try {
                    createScript = this.getResource("/webstart/create.sql");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (createScript == null) {
                    throw new IllegalStateException("Couldn't find database creation script");
                }
                SQLDataSource ds = sysRoot.getDataSource();
                ds.execute("RUNSCRIPT from '" + createScript + "' CHARSET 'UTF-8' ;");
                sysRoot.refetch();
                this.setupSystemRoot(sysRoot);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException("Couldn't create database", e);
            }
        }
    }

    @Override
    protected DBSystemRoot createSystemRoot() {
        DBSystemRoot res = super.createSystemRoot();
        this.createDB(res);
        return res;
    }

    @Override
    protected ShowAs createShowAs() {
        ShowAs showAs = super.createShowAs();
        showAs.show("ADRESSE_COMMON", SQLRow.toList("RUE,VILLE"));
        showAs.show("CAISSE_COTISATION", "NOM");
        showAs.show("EXERCICE_COMMON", SQLRow.toList("NUMERO,DATE_DEB,DATE_FIN"));
        showAs.show("IMPRESSION_RUBRIQUE", "NOM");
        showAs.show("OBJET", "NOM");
        showAs.show("PERIODE_VALIDITE", "JANVIER");
        showAs.show("PROFIL_PAYE", "NOM");
        showAs.show("RUBRIQUE_COTISATION", "CODE", "NOM");
        showAs.show("RUBRIQUE_NET", "CODE", "NOM");
        showAs.show("RUBRIQUE_BRUT", "CODE", "NOM");
        showAs.show("TYPE_RUBRIQUE_BRUT", "NOM");
        showAs.show("TYPE_RUBRIQUE_NET", "NOM");
        return showAs;
    }

    @Override
    protected SQLElementDirectory createDirectory() {
        SQLElementDirectory dir = super.createDirectory();
        dir.addSQLElement(new AdresseCommonSQLElement());
        dir.addSQLElement(new ExerciceCommonSQLElement());
        dir.addSQLElement(DeviseSQLElement.class);
        dir.addSQLElement(TypeModeleSQLElement.class);
        dir.addSQLElement(new SocieteCommonSQLElement());
        return dir;
    }

    public static void setSocieteSQLInjector(DBRoot rootSociete) {
        new AchatAvoirSQLInjector(rootSociete);
        new ArticleCommandeEltSQLInjector(rootSociete);
        new CommandeCliCommandeSQLInjector(rootSociete);
        new FactureAvoirSQLInjector(rootSociete);
        new FactureBonSQLInjector(rootSociete);
        new FactureCommandeSQLInjector(rootSociete);
        new DevisFactureSQLInjector(rootSociete);
        new DevisCommandeSQLInjector(rootSociete);
        new DevisCommandeFournisseurSQLInjector(rootSociete);
        new CommandeBlEltSQLInjector(rootSociete);
        new CommandeBlSQLInjector(rootSociete);
        new BonFactureSQLInjector(rootSociete);
        new CommandeFactureClientSQLInjector(rootSociete);
        new CommandeBrSQLInjector(rootSociete);
        new CommandeFactureAchatSQLInjector(rootSociete);
        new EcheanceEncaisseSQLInjector(rootSociete);
        new EcheanceRegleSQLInjector(rootSociete);
        new BrFactureAchatSQLInjector(rootSociete);
        new DevisEltFactureEltSQLInjector(rootSociete);
    }

    public String setUpSocieteStructure(int base) {
        this.setRowSociete(base);
        String customerName = "openconcerto";
        String dbMD = this.getRootSociete().getMetadata("CUSTOMER");
        if (dbMD != null && !dbMD.equals(customerName)) {
            throw new IllegalStateException("customer is '" + customerName + "' but db says '" + dbMD + "'");
        }
        return customerName;
    }

    public String getServerIp() {
        return this.getProperty("server.ip");
    }

    @Override
    protected DateFormat getLogDateFormat() {
        return new SimpleDateFormat("yyyy-MM/dd_HH-mm EEEE");
    }

    @Override
    protected SQLServer createServer() {
        if (GraphicsEnvironment.isHeadless()) {
            SQLServer server = super.createServer();
            return server;
        }
        InProgressFrame progress = new InProgressFrame();
        progress.show("Connexion \u00e0 votre base de donn\u00e9es en cours");
        try {
            SQLServer server;
            SQLServer sQLServer = server = super.createServer();
            return sQLServer;
        }
        catch (Throwable e) {
            ExceptionHandler.die("Impossible de se connecter \u00e0 la base de donn\u00e9es.\nV\u00e9rifiez votre connexion.", e);
            return null;
        }
        finally {
            progress.dispose();
        }
    }
}

